/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.filter;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import workbench.interfaces.PropertyStorage;
import workbench.resource.Settings;
import workbench.storage.filter.FilterExpression;
import workbench.util.FixedSizeList;
import workbench.util.WbFile;
import workbench.util.WbPersistence;

public class FilterDefinitionManager {
    private List<PropertyChangeListener> listeners;
    private FixedSizeList<WbFile> filterFiles;
    private static final int DEFAULT_MAX_SIZE = 15;
    private String lastDir;

    public static FilterDefinitionManager getDefaultInstance() {
        return LazyInstanceHolder.DEFAULT_INSTANCE;
    }

    public FilterDefinitionManager() {
        int n = Settings.getInstance().getIntProperty("workbench.gui.filter.mru.maxsize", 15);
        this.filterFiles = new FixedSizeList(n);
    }

    public void loadSettings(PropertyStorage propertyStorage, String string) {
        if (!string.endsWith(".")) {
            string = string + ".";
        }
        this.lastDir = propertyStorage.getProperty(string + "filter.lastdir", Settings.getInstance().getLastFilterDir());
        this.filterFiles.clear();
        int n = propertyStorage.getIntProperty(string + "filter.mru.size", 0);
        for (int i = 0; i < n; ++i) {
            WbFile wbFile;
            String string2 = propertyStorage.getProperty(string + "filter.mru.entry." + i, null);
            if (string2 == null || !(wbFile = new WbFile(string2)).exists()) continue;
            this.filterFiles.append(wbFile);
        }
        this.firePropertyChanged();
    }

    private void removeOldSettings(PropertyStorage propertyStorage, String string) {
        int n = propertyStorage.getIntProperty(string + "filter.mru.maxsize", 15);
        for (int i = 0; i < n; ++i) {
            propertyStorage.removeProperty(string + "filter.mru.entry." + i);
        }
    }

    public void saveSettings(PropertyStorage propertyStorage) {
        this.saveSettings(propertyStorage, "workbench.gui");
    }

    public void saveSettings(PropertyStorage propertyStorage, String string) {
        if (!string.endsWith(".")) {
            string = string + ".";
        }
        this.removeOldSettings(propertyStorage, string);
        int n = 0;
        for (WbFile wbFile : this.filterFiles.getEntries()) {
            propertyStorage.setProperty(string + "filter.mru.entry." + n, wbFile.getFullPath());
            ++n;
        }
        propertyStorage.setProperty(string + "filter.mru.size", n);
        propertyStorage.setProperty(string + "filter.lastdir", this.lastDir);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners != null) {
            this.listeners.remove(propertyChangeListener);
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PropertyChangeListener>(2);
        }
        this.listeners.add(propertyChangeListener);
    }

    public synchronized void filterUsed(WbFile wbFile) {
        this.filterFiles.addEntry(wbFile);
        this.firePropertyChanged();
    }

    private synchronized void firePropertyChanged() {
        if (this.listeners == null) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "mruList", null, this.filterFiles.size());
        for (PropertyChangeListener propertyChangeListener : this.listeners) {
            if (propertyChangeListener == null) continue;
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    public List<WbFile> getEntries() {
        ArrayList<WbFile> arrayList = new ArrayList<WbFile>(this.filterFiles.getEntries());
        arrayList.removeIf(wbFile -> !wbFile.exists());
        return arrayList;
    }

    public String getLastFilterDir() {
        if (this == FilterDefinitionManager.getDefaultInstance()) {
            return Settings.getInstance().getLastFilterDir();
        }
        return this.lastDir;
    }

    public void setLastFilterDir(String string) {
        if (this == FilterDefinitionManager.getDefaultInstance()) {
            Settings.getInstance().setLastFilterDir(string);
        }
        this.lastDir = string;
    }

    public void saveFilter(FilterExpression filterExpression, WbFile wbFile) throws IOException {
        WbPersistence wbPersistence = new WbPersistence(wbFile.getFullPath());
        wbPersistence.writeObject(filterExpression);
        this.filterUsed(wbFile);
    }

    public FilterExpression loadFilter(String string) throws Exception {
        WbPersistence wbPersistence = new WbPersistence(string);
        FilterExpression filterExpression = null;
        Object object = wbPersistence.readObject();
        if (object instanceof FilterExpression) {
            filterExpression = (FilterExpression)object;
            this.filterUsed(new WbFile(string));
        }
        return filterExpression;
    }

    private static class LazyInstanceHolder {
        private static final FilterDefinitionManager DEFAULT_INSTANCE = new FilterDefinitionManager();

        private LazyInstanceHolder() {
        }

        static {
            DEFAULT_INSTANCE.loadSettings(Settings.getInstance(), "workbench.gui.");
        }
    }
}

