/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.macros;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import workbench.gui.MainWindow;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.CollapseTreeAction;
import workbench.gui.actions.DeleteListEntryAction;
import workbench.gui.actions.EditMacroAction;
import workbench.gui.actions.EscAction;
import workbench.gui.actions.ExpandTreeAction;
import workbench.gui.actions.RunMacroAction;
import workbench.gui.actions.SaveListFileAction;
import workbench.gui.actions.WbAction;
import workbench.gui.components.DividerBorder;
import workbench.gui.components.WbToolbar;
import workbench.gui.editor.MacroExpander;
import workbench.gui.macros.MacroClient;
import workbench.gui.macros.MacroRunner;
import workbench.gui.macros.MacroTree;
import workbench.gui.macros.MacroTreeQuickFilter;
import workbench.gui.sql.SqlPanel;
import workbench.interfaces.FileActions;
import workbench.interfaces.MacroChangeListener;
import workbench.interfaces.MainPanel;
import workbench.interfaces.PropertyStorage;
import workbench.resource.GuiSettings;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.macros.MacroDefinition;
import workbench.sql.macros.MacroManager;
import workbench.util.StringUtil;

public class MacroPopup
extends JDialog
implements WindowListener,
MouseListener,
TreeSelectionListener,
MacroChangeListener,
ActionListener {
    private MacroTree tree;
    private MainWindow mainWindow;
    private RunMacroAction runAction;
    private EditMacroAction editAction;
    private WbAction copyTextAction;
    private EscAction closeAction;
    private boolean isClosing;
    private final String propkey = this.getClass().getName() + ".expandedgroups";
    private final String toolkey = "macropopup";
    private MacroTreeQuickFilter filterHandler;

    public MacroPopup(MainWindow mainWindow) {
        super((Frame)mainWindow, false);
        this.mainWindow = mainWindow;
        this.setLayout(new BorderLayout(0, 0));
        this.setTitle(ResourceMgr.getString("TxtMacroManagerWindowTitle"));
        this.setDefaultCloseOperation(0);
        this.tree = new MacroTree(mainWindow.getMacroClientId(), true);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.add((Component)jScrollPane, "Center");
        if (!Settings.getInstance().restoreWindowSize(this)) {
            this.setSize(200, 400);
        }
        if (!Settings.getInstance().restoreWindowPosition(this)) {
            this.setLocation(mainWindow.getX() + mainWindow.getWidth() - this.getWidth() / 2, mainWindow.getY() + 25);
        }
        this.restoreExpandedGroups();
        this.tree.addMouseListener(this);
        if (GuiSettings.getCloseMacroPopupWithEsc()) {
            this.closeAction = new EscAction(this, this);
        }
        this.runAction = new RunMacroAction(this.mainWindow, null, -1);
        if (GuiSettings.getRunMacroWithEnter()) {
            this.runAction.setAccelerator(KeyStroke.getKeyStroke(10, 0));
            this.runAction.addToInputMap(this.tree, 0);
        }
        this.editAction = new EditMacroAction();
        this.copyTextAction = new WbAction(this, "copy-query-text");
        this.copyTextAction.setMenuTextByKey("MnuTxtCopyMacroTxt");
        this.tree.addPopupAction(this.editAction, true);
        this.tree.addPopupAction(this.copyTextAction, false);
        this.tree.addPopupActionAtTop(this.runAction);
        this.tree.addTreeSelectionListener(this);
        this.addWindowListener(this);
        FileActions fileActions = new FileActions(){

            @Override
            public void saveItem() throws Exception {
                MacroPopup.this.saveMacros(false);
            }

            @Override
            public void deleteItem() throws Exception {
                MacroPopup.this.tree.deleteSelection();
            }

            @Override
            public void newItem(boolean bl) {
            }
        };
        DeleteListEntryAction deleteListEntryAction = new DeleteListEntryAction(fileActions);
        this.tree.addPopupAction(deleteListEntryAction, false);
        SaveListFileAction saveListFileAction = new SaveListFileAction(fileActions, "LblSaveMacros");
        this.tree.addPopupAction(saveListFileAction, false);
        MacroManager.getInstance().addChangeListener(this, mainWindow.getMacroClientId());
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        if (GuiSettings.getShowToolbarInMacroPopup()) {
            int n = IconMgr.getInstance().getSizeForLabel() / 3;
            JPanel jPanel = new JPanel(new BorderLayout(n, 0));
            WbToolbar wbToolbar = new WbToolbar();
            ((JToolBar)wbToolbar).add(new ExpandTreeAction(this.tree));
            ((JToolBar)wbToolbar).add(new CollapseTreeAction(this.tree));
            this.filterHandler = new MacroTreeQuickFilter(this.tree);
            JPanel jPanel2 = this.filterHandler.createFilterPanel();
            jPanel2.setBorder(new DividerBorder(1));
            jPanel.add((Component)jPanel2, "Center");
            jPanel.add((Component)wbToolbar, "West");
            this.add((Component)jPanel, "First");
        }
    }

    private boolean useWorkspace() {
        return GuiSettings.getStoreMacroPopupInWorkspace() && this.mainWindow != null;
    }

    private void saveExpandedGroups() {
        List<String> list = this.tree.getExpandedGroupNames();
        String string = StringUtil.listToString(list, ',', true);
        PropertyStorage propertyStorage = this.getConfig();
        propertyStorage.setProperty(this.propkey, string);
    }

    public void saveWorkspaceSettings() {
        if (this.useWorkspace()) {
            this.saveExpandedGroups();
        }
    }

    public void workspaceChanged() {
        this.macroListChanged();
        if (this.useWorkspace()) {
            this.restoreExpandedGroups();
        }
    }

    private void restoreExpandedGroups() {
        this.tree.collapseAll();
        List<String> list = this.getExpandedGroups();
        this.tree.expandGroups(list);
    }

    private List<String> getExpandedGroups() {
        PropertyStorage propertyStorage = this.getConfig();
        String string = propertyStorage.getProperty(this.propkey, null);
        return StringUtil.stringToList(string, ",", true, true);
    }

    private PropertyStorage getConfig() {
        PropertyStorage propertyStorage = null;
        if (this.useWorkspace()) {
            propertyStorage = this.mainWindow.getToolProperties("macropopup");
        }
        if (propertyStorage == null) {
            propertyStorage = Settings.getInstance();
        }
        return propertyStorage;
    }

    private void closeWindow() {
        ToolTipManager.sharedInstance().unregisterComponent(this.tree);
        this.setVisible(false);
        MacroManager.getInstance().removeChangeListener(this, this.mainWindow.getMacroClientId());
        this.dispose();
    }

    public boolean isClosing() {
        return this.isClosing;
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    protected void saveMacros(boolean bl) {
        MacroManager.getInstance().removeChangeListener(this, this.mainWindow.getMacroClientId());
        if (this.tree.isModified()) {
            this.tree.saveChanges();
        }
        if (bl) {
            MacroManager.getInstance().addChangeListener(this, this.mainWindow.getMacroClientId());
        }
    }

    private void doClose() {
        this.isClosing = true;
        if (this.tree.isModified()) {
            int n = WbSwingUtilities.getYesNoCancel(this, ResourceMgr.getString("MsgConfirmUnsavedMacros"));
            if (n == 2) {
                this.isClosing = false;
                return;
            }
            if (n == 0) {
                this.saveMacros(false);
            }
        }
        this.saveExpandedGroups();
        Settings.getInstance().storeWindowPosition(this);
        Settings.getInstance().storeWindowSize(this);
        this.removeWindowListener(this);
        this.tree.removeTreeSelectionListener(this);
        EventQueue.invokeLater(this::closeWindow);
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (!this.isClosing) {
            this.doClose();
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
            SqlPanel sqlPanel;
            MacroDefinition macroDefinition = this.tree.getSelectedMacro();
            if (this.mainWindow != null && macroDefinition != null && (sqlPanel = this.mainWindow.getCurrentSqlPanel()) != null) {
                if (macroDefinition.getExpandWhileTyping()) {
                    MacroExpander macroExpander = sqlPanel.getEditor().getMacroExpander();
                    if (macroExpander != null) {
                        macroExpander.insertMacroText(macroDefinition.getText());
                    }
                } else {
                    MacroRunner macroRunner = new MacroRunner();
                    macroRunner.runMacro(macroDefinition, sqlPanel, WbAction.isShiftPressed(mouseEvent.getModifiers()));
                }
                WbSwingUtilities.requestComponentFocus(this.mainWindow, sqlPanel);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        MacroDefinition macroDefinition = this.tree.getSelectedMacro();
        if (this.mainWindow != null && macroDefinition != null) {
            MainPanel mainPanel = this.mainWindow.getCurrentPanel().get();
            if (mainPanel instanceof MacroClient) {
                this.runAction.setEnabled(true);
                this.runAction.setMacro(macroDefinition);
            }
            this.editAction.setMacro(macroDefinition);
        } else {
            this.runAction.setEnabled(false);
            this.editAction.setMacro(null);
        }
    }

    @Override
    public void macroListChanged() {
        EventQueue.invokeLater(() -> {
            List<String> list = this.tree.getExpandedGroupNames();
            this.tree.loadMacros(true);
            this.tree.expandGroups(list);
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.copyTextAction) {
            this.copyMacroText();
        } else if (actionEvent.getSource() == this.closeAction && !this.isClosing) {
            this.doClose();
        }
    }

    private void copyMacroText() {
        MacroDefinition macroDefinition = this.tree.getSelectedMacro();
        if (macroDefinition == null) {
            return;
        }
        String string = macroDefinition.getText();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(string), null);
    }
}

