/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.menu;

import java.util.Optional;
import javax.swing.JPopupMenu;
import workbench.gui.MainWindow;
import workbench.gui.actions.AddTabAction;
import workbench.gui.actions.CheckBoxAction;
import workbench.gui.actions.CloseOtherTabsAction;
import workbench.gui.actions.CopyFileNameAction;
import workbench.gui.actions.FileDiscardAction;
import workbench.gui.actions.InsertTabAction;
import workbench.gui.actions.LockPanelAction;
import workbench.gui.actions.MoveSqlTabLeft;
import workbench.gui.actions.MoveSqlTabRight;
import workbench.gui.actions.NewDbExplorerPanelAction;
import workbench.gui.actions.OpenFileAction;
import workbench.gui.actions.OpenFileDirAction;
import workbench.gui.actions.RemoveTabAction;
import workbench.gui.actions.RenameTabAction;
import workbench.gui.actions.RestoreClosedTabAction;
import workbench.gui.actions.ToggleExtraConnection;
import workbench.gui.actions.WbAction;
import workbench.gui.sql.EditorPanel;
import workbench.gui.sql.SqlPanel;
import workbench.interfaces.MainPanel;

public class SqlTabPopup
extends JPopupMenu {
    public SqlTabPopup(MainWindow mainWindow) {
        Object object;
        WbAction wbAction;
        AddTabAction addTabAction = new AddTabAction(mainWindow);
        this.add(addTabAction);
        InsertTabAction insertTabAction = new InsertTabAction(mainWindow);
        this.add(insertTabAction);
        NewDbExplorerPanelAction newDbExplorerPanelAction = new NewDbExplorerPanelAction(mainWindow, "MnuTxtAddExplorerPanel");
        newDbExplorerPanelAction.removeIcon();
        this.add(newDbExplorerPanelAction);
        this.addSeparator();
        RemoveTabAction removeTabAction = new RemoveTabAction(mainWindow);
        removeTabAction.setEnabled(mainWindow.canCloseTab());
        this.add(removeTabAction);
        Optional<MainPanel> optional = mainWindow.getCurrentPanel();
        CloseOtherTabsAction closeOtherTabsAction = new CloseOtherTabsAction(mainWindow);
        this.add(closeOtherTabsAction);
        RestoreClosedTabAction restoreClosedTabAction = new RestoreClosedTabAction(mainWindow);
        this.add(restoreClosedTabAction.getMenuItem());
        if (mainWindow.canRenameTab()) {
            wbAction = new RenameTabAction(mainWindow);
            this.add(wbAction);
        }
        wbAction = new LockPanelAction(optional);
        this.add(((CheckBoxAction)wbAction).getMenuItem());
        ((CheckBoxAction)wbAction).setSwitchedOn(optional.map(MainPanel::isLocked).orElse(false));
        this.addSeparator();
        int n = mainWindow.getCurrentPanelIndex();
        MoveSqlTabLeft moveSqlTabLeft = new MoveSqlTabLeft(mainWindow);
        moveSqlTabLeft.setEnabled(n > 0);
        this.add(moveSqlTabLeft);
        int n2 = mainWindow.getTabCount();
        MoveSqlTabRight moveSqlTabRight = new MoveSqlTabRight(mainWindow);
        moveSqlTabRight.setEnabled(n < n2);
        this.add(moveSqlTabRight);
        if (mainWindow.canUseSeparateConnection()) {
            this.addSeparator();
            object = new ToggleExtraConnection(mainWindow);
            this.add(((CheckBoxAction)object).getMenuItem());
        }
        this.addSeparator();
        object = optional.get();
        if (object instanceof SqlPanel) {
            SqlPanel sqlPanel = (SqlPanel)object;
            EditorPanel editorPanel = sqlPanel.getEditor();
            this.add(editorPanel.getFileSaveAction());
            this.add(editorPanel.getFileSaveAsAction());
            this.add(new OpenFileAction(mainWindow));
            if (editorPanel.hasFileLoaded()) {
                this.add(editorPanel.getReloadAction());
                FileDiscardAction fileDiscardAction = new FileDiscardAction(sqlPanel);
                fileDiscardAction.removeIcon();
                this.add(fileDiscardAction);
                this.addSeparator();
                this.add(new CopyFileNameAction(editorPanel, true));
                this.add(new CopyFileNameAction(editorPanel, false));
                this.add(new OpenFileDirAction(editorPanel));
            }
        } else {
            this.add(new OpenFileAction(mainWindow));
        }
    }
}

