/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.profiles;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.sql.Driver;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import workbench.db.DbDriver;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.ClassFinderGUI;
import workbench.gui.components.ClasspathEditor;
import workbench.gui.components.FlatButton;
import workbench.gui.components.TextComponentMouseListener;
import workbench.gui.components.WbStatusLabel;
import workbench.gui.profiles.LibraryElement;
import workbench.interfaces.Validator;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.ClassFinder;
import workbench.util.CollectionUtil;

public class DriverEditorPanel
extends JPanel
implements DocumentListener,
ActionListener {
    private DbDriver currentDriver;
    private Validator validator;
    private GridBagConstraints defaultErrorConstraints;
    private JLabel errorLabel;
    private ClasspathEditor classpathEditor;
    private JButton detectDriverButton;
    private JLabel lblClassName;
    private JLabel lblLibrary;
    private JLabel lblName;
    private JLabel lblSample;
    private JLabel statusLabel;
    private JTextField tfClassName;
    private JTextField tfName;
    private JTextField tfSampleUrl;

    public DriverEditorPanel() {
        this.initComponents();
        this.statusLabel.setText("");
        this.statusLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.defaultErrorConstraints = new GridBagConstraints();
        this.defaultErrorConstraints.gridx = 0;
        this.defaultErrorConstraints.gridy = 0;
        this.defaultErrorConstraints.gridwidth = 0;
        this.defaultErrorConstraints.fill = 2;
        this.defaultErrorConstraints.ipadx = 0;
        this.defaultErrorConstraints.ipady = 0;
        this.defaultErrorConstraints.anchor = 17;
        this.defaultErrorConstraints.insets = new Insets(15, 8, 0, 3);
        this.errorLabel = new JLabel(ResourceMgr.getString("ErrDrvNameNotUnique"));
        CompoundBorder compoundBorder = new CompoundBorder(new LineBorder(Color.RED.brighter(), 1), new EmptyBorder(3, 5, 3, 5));
        this.errorLabel.setBorder(compoundBorder);
        this.errorLabel.setFont(this.errorLabel.getFont().deriveFont(1));
        this.errorLabel.setBackground(new Color(255, 255, 220));
        this.errorLabel.setOpaque(true);
        this.tfName.getDocument().addDocumentListener(this);
        this.classpathEditor.setLastDirProperty("workbench.drivers.lastlibdir");
        this.classpathEditor.addActionListener(this);
        WbSwingUtilities.setMinimumSize(this.tfName, 40);
        WbSwingUtilities.setMinimumSize(this.tfClassName, 50);
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.selectClass();
    }

    protected void selectClass() {
        ClassFinder classFinder = new ClassFinder(Driver.class);
        List<String> list = Settings.getInstance().getListProperty("workbench.db.drivers.deprecated", false);
        classFinder.setExcludedClasses(list);
        List<String> list2 = this.classpathEditor.getRealJarPaths();
        this.detectDriverButton.setEnabled(CollectionUtil.isNonEmpty(list2));
        ClassFinderGUI classFinderGUI = new ClassFinderGUI(classFinder, this.tfClassName, this.statusLabel);
        classFinderGUI.setStatusBarKey("TxtSearchingDriver");
        classFinderGUI.setWindowTitleKey("TxtSelectDriver");
        classFinderGUI.setClassPath(list2.stream().map(string -> new File((String)string)).collect(Collectors.toList()));
        classFinderGUI.startCheck();
    }

    public boolean validateName() {
        boolean bl = false;
        if (this.validator.isValid(this.tfName.getText())) {
            this.remove(this.errorLabel);
            bl = true;
        } else {
            this.add((Component)this.errorLabel, this.defaultErrorConstraints);
        }
        this.doLayout();
        this.validate();
        return bl;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.validateName();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.validateName();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.validateName();
    }

    public String getCurrentName() {
        return this.tfName.getText().trim();
    }

    public void setDriver(DbDriver dbDriver) {
        this.currentDriver = dbDriver;
        this.tfName.setText(dbDriver.getName());
        this.tfClassName.setText(dbDriver.getDriverClass());
        List<String> list = dbDriver.getLibraryList();
        DefaultListModel<LibraryElement> defaultListModel = new DefaultListModel<LibraryElement>();
        for (String string : list) {
            defaultListModel.addElement(new LibraryElement(string));
        }
        this.classpathEditor.setLibraries(list);
        this.classpathEditor.setFileSelectionEnabled(!this.getCurrentName().equals("sun.jdbc.odbc.JdbcOdbcDriver"));
        this.tfSampleUrl.setText(dbDriver.getSampleUrl());
        this.detectDriverButton.setEnabled(this.classpathEditor.hasLibraries());
    }

    public void updateDriver() {
        this.currentDriver.setName(this.tfName.getText().trim());
        this.currentDriver.setDriverClass(this.tfClassName.getText().trim());
        this.currentDriver.setLibraryList(this.classpathEditor.getLibraries());
        this.currentDriver.setSampleUrl(this.tfSampleUrl.getText());
    }

    public DbDriver getDriver() {
        this.updateDriver();
        return this.currentDriver;
    }

    public void reset() {
        this.currentDriver = null;
        this.tfName.setText("");
        this.tfClassName.setText("");
        this.classpathEditor.reset();
        this.tfSampleUrl.setText("");
    }

    private void initComponents() {
        this.lblName = new JLabel();
        this.tfName = new JTextField();
        this.lblClassName = new JLabel();
        this.tfClassName = new JTextField();
        this.lblLibrary = new JLabel();
        this.lblSample = new JLabel();
        this.tfSampleUrl = new JTextField();
        this.statusLabel = new WbStatusLabel();
        this.detectDriverButton = new FlatButton();
        this.classpathEditor = new ClasspathEditor();
        this.setLayout(new GridBagLayout());
        this.lblName.setText(ResourceMgr.getString("LblDriverName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 10, 0, 7);
        this.add((Component)this.lblName, gridBagConstraints);
        this.tfName.setHorizontalAlignment(2);
        this.tfName.setMinimumSize(new Dimension(50, 20));
        this.tfName.addMouseListener(new TextComponentMouseListener());
        this.tfName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                DriverEditorPanel.this.focusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 3, 0, 3);
        this.add((Component)this.tfName, gridBagConstraints);
        this.lblClassName.setText(ResourceMgr.getString("LblDriverClass"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 7);
        this.add((Component)this.lblClassName, gridBagConstraints);
        this.tfClassName.setColumns(10);
        this.tfClassName.setHorizontalAlignment(2);
        this.tfClassName.addMouseListener(new TextComponentMouseListener());
        this.tfClassName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                DriverEditorPanel.this.focusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 3, 0, 3);
        this.add((Component)this.tfClassName, gridBagConstraints);
        this.lblLibrary.setText(ResourceMgr.getString("LblDriverLibrary"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 7);
        this.add((Component)this.lblLibrary, gridBagConstraints);
        this.lblSample.setText(ResourceMgr.getString("LblSampleUrl"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 7);
        this.add((Component)this.lblSample, gridBagConstraints);
        this.tfSampleUrl.setColumns(10);
        this.tfSampleUrl.setHorizontalAlignment(2);
        this.tfSampleUrl.addMouseListener(new TextComponentMouseListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 3, 0, 5);
        this.add((Component)this.tfSampleUrl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(14, 10, 0, 5);
        this.add((Component)this.statusLabel, gridBagConstraints);
        this.detectDriverButton.setIcon(IconMgr.getInstance().getLabelIcon("magnifier"));
        this.detectDriverButton.setToolTipText(ResourceMgr.getString("MsgDetectDriver"));
        this.detectDriverButton.setMargin(new Insets(2, 2, 2, 2));
        this.detectDriverButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DriverEditorPanel.this.detectDriverButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(6, 0, 0, 5);
        this.add((Component)this.detectDriverButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 3, 0, 3);
        this.add((Component)this.classpathEditor, gridBagConstraints);
    }

    private void focusLost(FocusEvent focusEvent) {
        if (this.validateName()) {
            this.currentDriver.setName(this.tfName.getText().trim());
        }
    }

    private void detectDriverButtonActionPerformed(ActionEvent actionEvent) {
        this.selectClass();
    }
}

