/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.profiles;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import workbench.db.ConnectionMgr;
import workbench.db.ConnectionProfile;
import workbench.db.ProfileGroupMap;
import workbench.db.ProfileManager;
import workbench.gui.profiles.ProfileChangeListener;
import workbench.gui.profiles.ProfileKey;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class ProfileListModel
extends DefaultTreeModel
implements ProfileChangeListener {
    private File sourceFile;
    private final DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Profiles");
    private final List<ConnectionProfile> profiles = new ArrayList<ConnectionProfile>();
    private final List<ConnectionProfile> filtered = new ArrayList<ConnectionProfile>();
    private boolean profilesDeleted;

    ProfileListModel() {
        super(new DefaultMutableTreeNode("Profiles"), true);
        this.buildTree();
        this.addGroup(ResourceMgr.getString("LblDefGroup"));
    }

    ProfileListModel(List<ConnectionProfile> list) {
        super(new DefaultMutableTreeNode("Profiles"), true);
        for (ConnectionProfile connectionProfile : list) {
            this.profiles.add(connectionProfile.createStatefulCopy());
        }
        this.buildTree();
    }

    public void setSourceFile(File file) {
        this.sourceFile = file;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    private void sortList(List<ConnectionProfile> list) {
        if (list == null) {
            return;
        }
        list.sort(ConnectionProfile.getNameComparator());
    }

    @Override
    public void profileChanged(ConnectionProfile connectionProfile) {
        TreePath treePath = this.getPath(connectionProfile);
        if (treePath == null) {
            return;
        }
        if (treePath.getPathCount() < 3) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(2);
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        int n = defaultMutableTreeNode.getIndex(defaultMutableTreeNode2);
        this.fireTreeNodesChanged(this.rootNode, treePath.getPath(), new int[]{n}, new Object[]{defaultMutableTreeNode2});
    }

    public TreePath addProfile(ConnectionProfile connectionProfile) {
        this.profiles.add(connectionProfile);
        DefaultMutableTreeNode defaultMutableTreeNode = this.findGroupNode(connectionProfile.getGroup());
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(connectionProfile, false);
        this.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        TreePath treePath = new TreePath(new Object[]{this.rootNode, defaultMutableTreeNode, defaultMutableTreeNode2});
        return treePath;
    }

    public DefaultMutableTreeNode findProfileNode(ConnectionProfile connectionProfile) {
        TreePath treePath = this.getPath(connectionProfile);
        if (treePath == null) {
            return null;
        }
        return (DefaultMutableTreeNode)treePath.getLastPathComponent();
    }

    public DefaultMutableTreeNode findGroupNode(String string) {
        if (this.rootNode == null) {
            return null;
        }
        int n = this.getChildCount(this.rootNode);
        for (int i = 0; i < n; ++i) {
            String string2;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getChild(this.rootNode, i);
            if (defaultMutableTreeNode == null || !(string2 = (String)defaultMutableTreeNode.getUserObject()).equals(string)) continue;
            return defaultMutableTreeNode;
        }
        return null;
    }

    public boolean isFiltered() {
        return this.filtered.size() > 0;
    }

    public Set<String> getAllTags() {
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        this.profiles.stream().forEach(connectionProfile -> set.addAll(connectionProfile.getTags()));
        this.filtered.stream().forEach(connectionProfile -> set.addAll(connectionProfile.getTags()));
        return set;
    }

    public void resetFilter() {
        this.profiles.addAll(this.filtered);
        this.filtered.clear();
        this.buildTree();
    }

    public void applyTagFilter(Set<String> set) {
        this.profiles.addAll(this.filtered);
        this.filtered.clear();
        if (CollectionUtil.isNonEmpty(set)) {
            Iterator<ConnectionProfile> iterator = this.profiles.iterator();
            while (iterator.hasNext()) {
                ConnectionProfile connectionProfile = iterator.next();
                if (connectionProfile.getTags().containsAll(set)) continue;
                this.filtered.add(connectionProfile);
                iterator.remove();
            }
        }
        this.buildTree();
    }

    public void applyNameFilter(String string) {
        this.profiles.addAll(this.filtered);
        this.filtered.clear();
        if (StringUtil.isNonBlank(string)) {
            string = string.toLowerCase();
            Iterator<ConnectionProfile> iterator = this.profiles.iterator();
            while (iterator.hasNext()) {
                ConnectionProfile connectionProfile = iterator.next();
                String string2 = StringUtil.coalesce(connectionProfile.getName(), "").toLowerCase();
                String string3 = StringUtil.coalesce(connectionProfile.getUrl(), "").toLowerCase();
                String string4 = StringUtil.coalesce(connectionProfile.getUsername(), "").toLowerCase();
                boolean bl = string2.contains(string);
                bl = bl || GuiSettings.getIncludeJDBCUrlInProfileSearch() && string3.contains(string);
                if (bl = bl || GuiSettings.getIncludeUsernameInProfileSearch() && string4.contains(string)) continue;
                this.filtered.add(connectionProfile);
                iterator.remove();
            }
        }
        this.buildTree();
    }

    public boolean isChanged() {
        return this.profilesDeleted || this.profilesAreModified() || this.groupsChanged();
    }

    public boolean profilesAreModified() {
        if (this.profiles.stream().anyMatch(connectionProfile -> connectionProfile.isChanged())) {
            return true;
        }
        return this.filtered.stream().anyMatch(connectionProfile -> connectionProfile.isChanged());
    }

    public boolean groupsChanged() {
        if (this.profiles.stream().anyMatch(connectionProfile -> connectionProfile.isGroupChanged())) {
            return true;
        }
        return this.filtered.stream().anyMatch(connectionProfile -> connectionProfile.isGroupChanged());
    }

    public TreePath[] getGroupNodes() {
        if (this.rootNode == null) {
            return null;
        }
        int n = this.getChildCount(this.rootNode);
        TreePath[] treePathArray = new TreePath[n];
        for (int i = 0; i < n; ++i) {
            TreeNode treeNode = (TreeNode)this.getChild(this.rootNode, i);
            if (treeNode == null) continue;
            treePathArray[i] = new TreePath(new Object[]{this.rootNode, treeNode});
        }
        return treePathArray;
    }

    public List<String> getGroups() {
        if (this.rootNode == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.getChildCount(this.rootNode);
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getChild(this.rootNode, i);
            if (defaultMutableTreeNode == null) continue;
            String string = (String)defaultMutableTreeNode.getUserObject();
            arrayList.add(string);
        }
        return arrayList;
    }

    public void deleteGroup(String string) {
        if (string == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.findGroupNode(string);
        if (defaultMutableTreeNode == null) {
            return;
        }
        this.deleteGroupProfiles(defaultMutableTreeNode);
        this.removeGroupNode(defaultMutableTreeNode);
    }

    public void deleteGroupProfiles(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return;
        }
        int n = defaultMutableTreeNode.getChildCount();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            ConnectionProfile connectionProfile = (ConnectionProfile)defaultMutableTreeNode2.getUserObject();
            this.profiles.remove(connectionProfile);
        }
        defaultMutableTreeNode.removeAllChildren();
    }

    public void deleteNodes(DefaultMutableTreeNode[] defaultMutableTreeNodeArray) {
    }

    public void deleteProfile(ConnectionProfile connectionProfile) {
        TreePath treePath = this.getPath(connectionProfile);
        MutableTreeNode mutableTreeNode = (MutableTreeNode)treePath.getLastPathComponent();
        if (!mutableTreeNode.isLeaf()) {
            return;
        }
        this.profiles.remove(connectionProfile);
        this.removeNodeFromParent(mutableTreeNode);
        this.profilesDeleted = true;
    }

    public TreePath getFirstProfile() {
        if (this.rootNode.getChildCount() == 0) {
            return null;
        }
        TreeNode treeNode = this.rootNode.getChildAt(0);
        TreeNode treeNode2 = treeNode.getChildAt(0);
        return new TreePath(new Object[]{this.rootNode, treeNode, treeNode2});
    }

    public TreePath getPath(ProfileKey profileKey) {
        if (profileKey == null) {
            return null;
        }
        ConnectionProfile connectionProfile = ProfileManager.findProfile(this.profiles, profileKey);
        if (connectionProfile != null) {
            return this.getPath(connectionProfile);
        }
        return null;
    }

    public TreePath getPath(ConnectionProfile connectionProfile) {
        Object object;
        int n;
        if (connectionProfile == null) {
            return null;
        }
        String string = connectionProfile.getGroup();
        Object object2 = null;
        if (StringUtil.isEmptyString(string)) {
            object2 = this.getChild(this.rootNode, 0);
        } else {
            n = this.getChildCount(this.rootNode);
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getChild(this.rootNode, i);
                if (defaultMutableTreeNode == null || !string.equals(object = (String)defaultMutableTreeNode.getUserObject())) continue;
                object2 = defaultMutableTreeNode;
                break;
            }
        }
        if (object2 == null) {
            return null;
        }
        n = this.getChildCount(object2);
        Object object3 = null;
        for (int i = 0; i < n; ++i) {
            object = (DefaultMutableTreeNode)this.getChild(object2, i);
            ConnectionProfile connectionProfile2 = (ConnectionProfile)((DefaultMutableTreeNode)object).getUserObject();
            if (!connectionProfile2.equals(connectionProfile)) continue;
            object3 = object;
        }
        if (object3 == null) {
            return null;
        }
        return new TreePath(new Object[]{this.rootNode, object2, object3});
    }

    public int getSize() {
        return this.profiles.size();
    }

    public TreePath addGroup(String string) {
        if (string == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string, true);
        this.insertNodeInto(defaultMutableTreeNode, this.rootNode, this.rootNode.getChildCount());
        return new TreePath(new Object[]{this.rootNode, defaultMutableTreeNode});
    }

    public void addEmptyProfile() {
        ConnectionProfile connectionProfile = ConnectionProfile.createEmptyProfile();
        connectionProfile.setUrl("jdbc:");
        this.profiles.add(connectionProfile);
        this.buildTree();
    }

    public void removeGroupNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.deleteGroupProfiles(defaultMutableTreeNode);
        this.removeNodeFromParent(defaultMutableTreeNode);
    }

    public void saveTo(File file) {
        ProfileManager profileManager = new ProfileManager(file);
        profileManager.applyProfiles(this.getAllProfiles());
        profileManager.save();
        this.sourceFile = file;
        this.resetChanged();
    }

    public void saveProfiles() {
        this.applyProfiles();
        ConnectionMgr.getInstance().saveProfiles();
        this.resetChanged();
    }

    public void resetChanged() {
        for (ConnectionProfile connectionProfile : this.profiles) {
            connectionProfile.resetChangedFlags();
        }
        this.profilesDeleted = false;
    }

    public List<ConnectionProfile> getAllProfiles() {
        ArrayList<ConnectionProfile> arrayList = new ArrayList<ConnectionProfile>(this.profiles.size() + this.filtered.size());
        for (ConnectionProfile connectionProfile : this.profiles) {
            arrayList.add(connectionProfile);
        }
        for (ConnectionProfile connectionProfile : this.filtered) {
            arrayList.add(connectionProfile);
        }
        return arrayList;
    }

    public void applyProfiles() {
        ConnectionMgr.getInstance().applyProfiles(this.getAllProfiles());
    }

    private void buildTree() {
        ProfileGroupMap profileGroupMap = new ProfileGroupMap(this.profiles);
        this.rootNode.removeAllChildren();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(profileGroupMap.keySet());
        arrayList.sort(CaseInsensitiveComparator.INSTANCE);
        for (String string : arrayList) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string, true);
            this.rootNode.add(defaultMutableTreeNode);
            List list = (List)profileGroupMap.get(string);
            this.sortList(list);
            for (ConnectionProfile connectionProfile : list) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(connectionProfile, false);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
        }
        this.setRoot(this.rootNode);
    }

    public void moveProfilesToGroup(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.findGroupNode(string);
        if (defaultMutableTreeNode2 == null) {
            return;
        }
        int n2 = defaultMutableTreeNode.getChildCount();
        if (n2 == 0) {
            return;
        }
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[n2];
        for (n = 0; n < n2; ++n) {
            defaultMutableTreeNodeArray[n] = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
        }
        for (n = 0; n < n2; ++n) {
            defaultMutableTreeNode.remove(defaultMutableTreeNodeArray[n]);
            defaultMutableTreeNode2.add(defaultMutableTreeNodeArray[n]);
        }
    }

    public void removeNodesFromParent(DefaultMutableTreeNode[] defaultMutableTreeNodeArray) {
        if (defaultMutableTreeNodeArray == null) {
            return;
        }
        for (DefaultMutableTreeNode defaultMutableTreeNode : defaultMutableTreeNodeArray) {
            this.removeNodeFromParent(defaultMutableTreeNode);
        }
    }

    public DefaultMutableTreeNode moveProfilesToGroup(List<ConnectionProfile> list, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        if (defaultMutableTreeNode == null) {
            return null;
        }
        String string = (String)defaultMutableTreeNode.getUserObject();
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (ConnectionProfile connectionProfile : list) {
            if (connectionProfile == null) continue;
            connectionProfile.setGroup(string);
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(connectionProfile, false);
            if (defaultMutableTreeNode2 == null) {
                defaultMutableTreeNode2 = defaultMutableTreeNode3;
            }
            this.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        }
        return defaultMutableTreeNode2;
    }

    private void adjustCopiededProfileName(ConnectionProfile connectionProfile, DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object;
        String string = connectionProfile.getName();
        String string2 = string.toLowerCase();
        boolean bl = false;
        Pattern pattern = Pattern.compile("\\(([0-9+])\\)$");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            bl = true;
            string2 = string.substring(0, matcher.start()).trim().toLowerCase();
        }
        int n = 0;
        int n2 = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n2; ++i) {
            String string3;
            object = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (!(object2 instanceof ConnectionProfile) || !(string3 = ((ConnectionProfile)object2).getName()).toLowerCase().startsWith(string2)) continue;
            ++n;
        }
        if (n > 0) {
            String string4 = "(" + n + ")";
            object = bl ? matcher.replaceFirst(string4) : string + " " + string4;
            connectionProfile.setName((String)object);
        }
    }

    public DefaultMutableTreeNode copyProfilesToGroup(List<ConnectionProfile> list, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        if (defaultMutableTreeNode == null) {
            return null;
        }
        String string = (String)defaultMutableTreeNode.getUserObject();
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (ConnectionProfile connectionProfile : list) {
            if (connectionProfile == null) continue;
            ConnectionProfile connectionProfile2 = connectionProfile.createCopy();
            connectionProfile2.setGroup(string);
            this.profiles.add(connectionProfile2);
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(connectionProfile2, false);
            if (defaultMutableTreeNode2 == null) {
                defaultMutableTreeNode2 = defaultMutableTreeNode3;
            }
            this.adjustCopiededProfileName(connectionProfile2, defaultMutableTreeNode);
            this.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        }
        return defaultMutableTreeNode2;
    }

    public static ProfileListModel emptyModel() {
        return new ProfileListModel(new ArrayList<ConnectionProfile>());
    }

    public static ProfileListModel getDummyModel() {
        ArrayList<ConnectionProfile> arrayList = new ArrayList<ConnectionProfile>();
        ConnectionProfile connectionProfile = new ConnectionProfile();
        connectionProfile.setName("Admin");
        connectionProfile.setGroup("Postgres");
        arrayList.add(connectionProfile);
        ConnectionProfile connectionProfile2 = new ConnectionProfile();
        connectionProfile2.setName("Arthur");
        connectionProfile2.setGroup("Postgres");
        arrayList.add(connectionProfile2);
        ConnectionProfile connectionProfile3 = new ConnectionProfile();
        connectionProfile3.setName("Zaphod");
        connectionProfile3.setGroup("Oracle");
        arrayList.add(connectionProfile3);
        ConnectionProfile connectionProfile4 = new ConnectionProfile();
        connectionProfile4.setName("Tricia");
        connectionProfile4.setGroup("Oracle");
        arrayList.add(connectionProfile4);
        return new ProfileListModel(arrayList);
    }
}

