/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.RowHighlighter;
import workbench.gui.components.WbTable;
import workbench.gui.renderer.ColorUtils;
import workbench.gui.renderer.RendererSetup;
import workbench.gui.renderer.RequiredFieldHighlighter;
import workbench.gui.renderer.WbRenderer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class ToolTipRenderer
extends JComponent
implements TableCellRenderer,
WbRenderer,
RequiredFieldHighlighter {
    protected String displayValue = "";
    protected Object currentValue;
    protected String tooltip;
    protected int rightMargin;
    protected Color selectedForeground;
    protected Color selectedBackground;
    protected Color unselectedForeground;
    protected Color unselectedBackground;
    protected Color highlightBackground;
    protected Color filterHighlightColor = GuiSettings.getExpressionHighlightColor();
    protected RendererSetup rendererSetup;
    protected int maxTooltipSize = Settings.getInstance().getIntProperty("workbench.gui.renderer.maxtooltipsize", 1000);
    private static final int DEFAULT_BLEND = 0;
    protected int selectionBlendFactor = 0;
    protected int alternateBlendFactor = 0;
    protected int editingRow = -1;
    private boolean isEditing;
    private boolean[] highlightCols;
    private int currentColumn = -1;
    private int currentRow = -1;
    private String currentColumnName;
    private Rectangle paintIconR = new Rectangle();
    private Rectangle paintTextR = new Rectangle();
    private Rectangle paintViewR = new Rectangle();
    protected Insets focusedInsets;
    protected Insets regularInsets = ToolTipRenderer.getDefaultInsets();
    protected boolean isSelected;
    protected boolean hasFocus;
    protected boolean isNull;
    protected RowHighlighter filter;
    private int valign = 1;
    private int halign = 2;
    private boolean isAlternatingRow;
    private boolean isModifiedColumn;
    protected boolean showTooltip = true;
    protected Map renderingHints;

    public ToolTipRenderer() {
        int n = WbSwingUtilities.FOCUSED_CELL_BORDER.getThickness();
        this.focusedInsets = new Insets(n + this.regularInsets.top - 1, n + this.regularInsets.left - 1, n + this.regularInsets.bottom - 1, n + this.regularInsets.right - 1);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.renderingHints = (Map)toolkit.getDesktopProperty("awt.font.desktophints");
        this.showTooltip = Settings.getInstance().getBoolProperty("workbench.gui.renderer.showtooltip", true);
        this.selectionBlendFactor = this.retrieveBlendFactor("selection");
        this.alternateBlendFactor = this.retrieveBlendFactor("alternate");
    }

    private int retrieveBlendFactor(String string) {
        int n = Settings.getInstance().getIntProperty("workbench.gui.renderer.blend." + string, 0);
        if (n < 0 || n > 256) {
            n = 0;
        }
        return n;
    }

    static Insets getDefaultInsets() {
        List<String> list;
        Insets insets = null;
        String string = Settings.getInstance().getProperty("workbench.gui.renderer.insets", null);
        List<String> list2 = list = string != null ? StringUtil.stringToList(string, ",", true, true, false) : null;
        if (list != null && list.size() == 4) {
            try {
                int n = Integer.valueOf(list.get(0));
                int n2 = Integer.valueOf(list.get(1));
                int n3 = Integer.valueOf(list.get(2));
                int n4 = Integer.valueOf(list.get(3));
                insets = new Insets(n, n2, n3, n4);
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error reading default insets from settings: " + string, exception);
                insets = null;
            }
        }
        if (insets == null) {
            insets = new Insets(1, 1, 1, 1);
        }
        return insets;
    }

    @Override
    public void setEditingRow(int n) {
        this.editingRow = n;
    }

    @Override
    public void setHighlightColumns(boolean[] blArray) {
        this.highlightCols = blArray;
    }

    public void setVerticalAlignment(int n) {
        this.valign = n;
    }

    public void setHorizontalAlignment(int n) {
        this.halign = n;
    }

    @Override
    public int getHorizontalAlignment() {
        return this.halign;
    }

    @Override
    public void setHighlightBackground(Color color) {
        this.highlightBackground = color;
    }

    private boolean doModificationHighlight(WbTable wbTable, int n, int n2) {
        if (this.rendererSetup.modifiedColor == null) {
            return false;
        }
        if (wbTable == null) {
            return false;
        }
        DataStoreTableModel dataStoreTableModel = wbTable.getDataStoreTableModel();
        if (dataStoreTableModel == null) {
            return false;
        }
        return dataStoreTableModel.isColumnModified(n, n2);
    }

    protected void initDisplay(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.isNull = object == null;
        this.hasFocus = bl2;
        this.isEditing = n == this.editingRow && this.highlightBackground != null;
        this.currentColumn = n2;
        this.currentColumnName = jTable.getColumnName(n2);
        this.currentRow = n;
        this.isSelected = bl;
        this.currentValue = object;
        try {
            WbTable wbTable = (WbTable)jTable;
            this.rendererSetup = wbTable.getRendererSetup();
            this.filter = wbTable.getHighlightExpression();
            this.isModifiedColumn = this.doModificationHighlight(wbTable, n, n2);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        boolean bl3 = this.isAlternatingRow = this.rendererSetup.useAlternatingColors && n % 2 == 1;
        if (this.selectedForeground == null) {
            this.selectedForeground = jTable.getSelectionForeground();
            this.selectedBackground = jTable.getSelectionBackground();
        }
        if (this.unselectedForeground == null) {
            this.unselectedForeground = jTable.getForeground();
            this.unselectedBackground = jTable.getBackground();
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.initDisplay(jTable, object, bl, bl2, n, n2);
        Font font = jTable.getFont();
        if (object != null) {
            this.setFont(font);
            this.prepareDisplay(object);
        } else {
            if (this.rendererSetup.nullFontStyle > 0 && this.rendererSetup.nullString != null) {
                font = font.deriveFont(this.rendererSetup.nullFontStyle);
            }
            this.setFont(font);
            this.displayValue = this.rendererSetup.nullString;
            this.setTooltip(null);
        }
        return this;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        dimension.setSize(dimension.getWidth(), (double)fontMetrics.getHeight());
        return dimension;
    }

    protected Color getForegroundColor() {
        if (this.isSelected) {
            return this.selectedForeground;
        }
        return this.unselectedForeground;
    }

    private boolean isHighlightColumn(int n) {
        if (this.highlightCols == null) {
            return false;
        }
        if (n < 0 || n >= this.highlightCols.length) {
            return false;
        }
        return this.highlightCols[n];
    }

    protected Color getBackgroundColor() {
        Color color = this.getColumnHighlightColor(this.currentRow);
        if (this.isSelected) {
            return ColorUtils.blend(this.selectedBackground, color, this.selectionBlendFactor);
        }
        if (this.isAlternatingRow) {
            return ColorUtils.blend(this.rendererSetup.alternateBackground, color, this.alternateBlendFactor);
        }
        if (color != null) {
            return color;
        }
        return this.unselectedBackground;
    }

    protected Color getColumnHighlightColor(int n) {
        if (this.isEditing) {
            if (this.isHighlightColumn(this.currentColumn)) {
                return this.highlightBackground;
            }
            return this.unselectedBackground;
        }
        if (this.checkHighlightExpression(n, this.currentValue)) {
            return this.filterHighlightColor;
        }
        if (this.isModifiedColumn) {
            return this.rendererSetup.modifiedColor;
        }
        if (this.displayValue == null || this.isNull) {
            return this.rendererSetup.nullColor;
        }
        return null;
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Insets insets = this.hasFocus ? this.focusedInsets : this.regularInsets;
        this.paintViewR.x = insets.left;
        this.paintViewR.y = insets.top;
        this.paintViewR.width = n2 - (insets.left + insets.right);
        this.paintViewR.height = n3 - (insets.top + insets.bottom);
        this.paintIconR.height = 0;
        this.paintIconR.width = 0;
        this.paintIconR.y = 0;
        this.paintIconR.x = 0;
        this.paintTextR.height = 0;
        this.paintTextR.width = 0;
        this.paintTextR.y = 0;
        this.paintTextR.x = 0;
        String string = "";
        if (this.displayValue != null) {
            string = SwingUtilities.layoutCompoundLabel(this, fontMetrics, this.displayValue, null, this.valign, this.halign, 1, 4, this.paintViewR, this.paintIconR, this.paintTextR, 0);
        }
        int n4 = this.paintTextR.x;
        if ((n4 -= this.rightMargin) < 0) {
            n4 = 0;
        }
        if ((n = this.paintTextR.y + fontMetrics.getAscent()) < 0) {
            n = 0;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.renderingHints != null) {
            graphics2D.addRenderingHints(this.renderingHints);
        }
        graphics.setFont(font);
        graphics.setColor(this.getBackgroundColor());
        graphics.fillRect(0, 0, n2, n3);
        graphics.setColor(this.getForegroundColor());
        graphics.drawString(string, n4, n);
        if (this.hasFocus) {
            WbSwingUtilities.FOCUSED_CELL_BORDER.paintBorder(this, graphics, 0, 0, n2, n3);
        }
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    @Override
    public void prepareDisplay(Object object) {
        this.displayValue = object == null ? null : object.toString();
        this.setTooltip(this.displayValue);
    }

    protected boolean checkHighlightExpression(int n, Object object) {
        if (this.filter == null) {
            return false;
        }
        return this.filter.hightlightColumn(n, this.currentColumnName, this.currentValue);
    }

    @Override
    public String getToolTipText() {
        return this.tooltip;
    }

    protected void setTooltip(String string) {
        this.tooltip = this.showTooltip && string != null && string.length() > 0 ? StringUtil.getMaxSubstring(string, this.maxTooltipSize) : null;
    }

    @Override
    public String getDisplayValue() {
        return this.displayValue;
    }
}

