/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import workbench.gui.components.WbFilePicker;
import workbench.interfaces.Restoreable;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class BackupOptions
extends JPanel
implements Restoreable,
ActionListener {
    private JTextField backupCount;
    private WbFilePicker backupDirPicker;
    private JCheckBox backupDrivers;
    private JCheckBox backupMacros;
    private JCheckBox backupProfiles;
    private JCheckBox backupSettingsFile;
    private JCheckBox createWkspBackup;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;

    public BackupOptions() {
        this.initComponents();
    }

    @Override
    public void restoreSettings() {
        this.createWkspBackup.setSelected(Settings.getInstance().getCreateWorkspaceBackup());
        this.backupSettingsFile.setSelected(Settings.getInstance().getCreateSettingsBackup());
        this.backupDrivers.setSelected(Settings.getInstance().getCreateDriverBackup());
        this.backupProfiles.setSelected(Settings.getInstance().getCreateProfileBackup());
        this.backupMacros.setSelected(Settings.getInstance().getCreateMacroBackup());
        this.backupCount.setEnabled(this.createWkspBackup.isSelected());
        this.backupCount.setText(Integer.toString(Settings.getInstance().getMaxBackupFiles()));
        this.backupDirPicker.setFilename(Settings.getInstance().getBackupDir());
    }

    @Override
    public void saveSettings() {
        Settings settings = Settings.getInstance();
        int n = StringUtil.getIntValue(this.backupCount.getText(), -1);
        if (n > -1) {
            settings.setMaxWorkspaceBackup(n);
        }
        settings.setBackupDir(this.backupDirPicker.getFilename());
        settings.setCreateSettingsBackup(this.backupSettingsFile.isSelected());
        settings.setCreateWorkspaceBackup(this.createWkspBackup.isSelected());
        settings.setCreateDriverBackup(this.backupDrivers.isSelected());
        settings.setCreateProfileBackup(this.backupProfiles.isSelected());
        settings.setCreateMacroBackup(this.backupMacros.isSelected());
    }

    private void initComponents() {
        this.createWkspBackup = new JCheckBox();
        this.backupSettingsFile = new JCheckBox();
        this.backupMacros = new JCheckBox();
        this.backupProfiles = new JCheckBox();
        this.backupDrivers = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.backupDirPicker = new WbFilePicker();
        this.backupCount = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.createWkspBackup.setText(ResourceMgr.getString("LblBckWksp"));
        this.createWkspBackup.setToolTipText(ResourceMgr.getString("d_LblBckWksp"));
        this.createWkspBackup.setBorder(null);
        this.createWkspBackup.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.createWkspBackup, gridBagConstraints);
        this.backupSettingsFile.setText(ResourceMgr.getString("LblBckSettings"));
        this.backupSettingsFile.setBorder(null);
        this.backupSettingsFile.setHorizontalAlignment(2);
        this.backupSettingsFile.setHorizontalTextPosition(4);
        this.backupSettingsFile.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.backupSettingsFile, gridBagConstraints);
        this.backupMacros.setText(ResourceMgr.getString("LblBckMacros"));
        this.backupMacros.setBorder(null);
        this.backupMacros.setHorizontalAlignment(2);
        this.backupMacros.setHorizontalTextPosition(4);
        this.backupMacros.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.backupMacros, gridBagConstraints);
        this.backupProfiles.setText(ResourceMgr.getString("LblBckProfiles"));
        this.backupProfiles.setBorder(null);
        this.backupProfiles.setHorizontalAlignment(2);
        this.backupProfiles.setHorizontalTextPosition(4);
        this.backupProfiles.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.backupProfiles, gridBagConstraints);
        this.backupDrivers.setText(ResourceMgr.getString("LblBckDrivers"));
        this.backupDrivers.setBorder(null);
        this.backupDrivers.setHorizontalAlignment(2);
        this.backupDrivers.setHorizontalTextPosition(4);
        this.backupDrivers.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.backupDrivers, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.backupDirPicker.setToolTipText(ResourceMgr.getString("d_LblBckDir"));
        this.backupDirPicker.setSelectDirectoryOnly(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 13, 5, 11);
        this.jPanel1.add((Component)this.backupDirPicker, gridBagConstraints);
        this.backupCount.setColumns(3);
        this.backupCount.setHorizontalAlignment(11);
        this.backupCount.setToolTipText(ResourceMgr.getString("d_LblMaxWkspBck"));
        this.backupCount.setMinimumSize(new Dimension(30, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 13, 1, 0);
        this.jPanel1.add((Component)this.backupCount, gridBagConstraints);
        this.jLabel2.setText(ResourceMgr.getString("LblBckDir"));
        this.jLabel2.setToolTipText(ResourceMgr.getString("d_LblBckDir"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 4, 5);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel1.setLabelFor(this.backupCount);
        this.jLabel1.setText(ResourceMgr.getString("LblMaxWkspBck"));
        this.jLabel1.setToolTipText(ResourceMgr.getString("d_LblMaxWkspBck"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 1, 7);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.createWkspBackup) {
            this.createWkspBackupActionPerformed(actionEvent);
        }
    }

    private void createWkspBackupActionPerformed(ActionEvent actionEvent) {
    }
}

