/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.WbColorPicker;
import workbench.interfaces.Restoreable;
import workbench.interfaces.ValidatingComponent;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class DataColorOptions
extends JPanel
implements Restoreable,
ValidatingComponent {
    private JTextField alternateBlend;
    private WbColorPicker alternateColor;
    private JLabel alternateColorLabel;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel7;
    private WbColorPicker modifiedColor;
    private WbColorPicker nullColor;
    private WbColorPicker searchHilite;
    private WbColorPicker selectedTextColor;
    private JLabel selectedTextColorLabel;
    private JTextField selectionBlend;
    private WbColorPicker selectionColor;
    private JLabel selectionColorLabel;
    private WbColorPicker stdBackground;
    private JLabel stdBackgroundLabel;
    private WbColorPicker textColor;
    private JLabel textColorLabel;

    public DataColorOptions() {
        this.initComponents();
        WbSwingUtilities.setMinimumSize(this.alternateBlend, 5);
        WbSwingUtilities.setMinimumSize(this.selectionBlend, 5);
    }

    @Override
    public void restoreSettings() {
        this.alternateColor.setSelectedColor(GuiSettings.getAlternateRowColor());
        this.nullColor.setSelectedColor(GuiSettings.getNullColor());
        this.stdBackground.setDefaultLabelKey("LblDefaultIndicator");
        this.textColor.setDefaultLabelKey("LblDefaultIndicator");
        this.selectionColor.setDefaultLabelKey("LblDefaultIndicator");
        this.selectedTextColor.setDefaultLabelKey("LblDefaultIndicator");
        this.stdBackground.setSelectedColor(Settings.getInstance().getColor("workbench.gui.table.background", null));
        this.textColor.setSelectedColor(Settings.getInstance().getColor("workbench.gui.table.foreground", null));
        this.selectionColor.setSelectedColor(Settings.getInstance().getColor("workbench.gui.table.selection.background", null));
        this.selectedTextColor.setSelectedColor(Settings.getInstance().getColor("workbench.gui.table.selection.foreground", null));
        this.modifiedColor.setSelectedColor(GuiSettings.getColumnModifiedColor());
        this.selectionBlend.setText(Settings.getInstance().getProperty("workbench.gui.renderer.blend.selection", ""));
        this.alternateBlend.setText(Settings.getInstance().getProperty("workbench.gui.renderer.blend.alternate", ""));
        this.searchHilite.setSelectedColor(GuiSettings.getExpressionHighlightColor());
    }

    @Override
    public void saveSettings() {
        Color color = this.alternateColor.getSelectedColor();
        GuiSettings.setUseAlternateRowColor(color != null);
        GuiSettings.setAlternateRowColor(this.alternateColor.getSelectedColor());
        GuiSettings.setNullColor(this.nullColor.getSelectedColor());
        GuiSettings.setColumnModifiedColor(this.modifiedColor.getSelectedColor());
        GuiSettings.setExpressionHighlightColor(this.searchHilite.getSelectedColor());
        Settings.getInstance().setColor("workbench.gui.table.background", this.stdBackground.getSelectedColor());
        Settings.getInstance().setColor("workbench.gui.table.foreground", this.textColor.getSelectedColor());
        Settings.getInstance().setColor("workbench.gui.table.selection.background", this.selectionColor.getSelectedColor());
        Settings.getInstance().setColor("workbench.gui.table.selection.foreground", this.selectedTextColor.getSelectedColor());
        Settings.getInstance().setProperty("workbench.gui.renderer.blend.selection", this.selectionBlend.getText().trim());
        Settings.getInstance().setProperty("workbench.gui.renderer.blend.alternate", this.alternateBlend.getText().trim());
    }

    @Override
    public void componentWillBeClosed() {
    }

    @Override
    public void componentDisplayed() {
    }

    @Override
    public boolean validateInput() {
        if (!this.validateTextField(this.selectionBlend)) {
            return false;
        }
        return this.validateTextField(this.alternateBlend);
    }

    private boolean validateTextField(JTextField jTextField) {
        if (StringUtil.isEmptyString(jTextField.getText().trim())) {
            return true;
        }
        String string = ResourceMgr.getString("ErrInvalidBlend");
        int n = -1;
        try {
            n = Integer.parseInt(jTextField.getText().trim());
        }
        catch (Exception exception) {
            n = -1;
        }
        if (n < 0 || n > 256) {
            WbSwingUtilities.showErrorMessage(this, ResourceMgr.getString("TxtError"), string);
            EventQueue.invokeLater(jTextField::requestFocusInWindow);
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.alternateColorLabel = new JLabel();
        this.alternateColor = new WbColorPicker(true);
        this.nullColor = new WbColorPicker(true);
        this.jLabel2 = new JLabel();
        this.stdBackground = new WbColorPicker(true);
        this.stdBackgroundLabel = new JLabel();
        this.textColorLabel = new JLabel();
        this.textColor = new WbColorPicker(true);
        this.selectionColorLabel = new JLabel();
        this.selectionColor = new WbColorPicker(true);
        this.selectedTextColorLabel = new JLabel();
        this.selectedTextColor = new WbColorPicker(true);
        this.jLabel7 = new JLabel();
        this.modifiedColor = new WbColorPicker(true);
        this.jPanel7 = new JPanel();
        this.jLabel8 = new JLabel();
        this.selectionBlend = new JTextField();
        this.alternateBlend = new JTextField();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.searchHilite = new WbColorPicker(true);
        this.setLayout(new GridBagLayout());
        this.alternateColorLabel.setText(ResourceMgr.getString("LblAlternateRowColor"));
        this.alternateColorLabel.setToolTipText(ResourceMgr.getString("d_LblAlternateRowColor"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.alternateColorLabel, gridBagConstraints);
        this.alternateColor.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.alternateColor, gridBagConstraints);
        this.nullColor.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.nullColor, gridBagConstraints);
        this.jLabel2.setText(ResourceMgr.getString("LblNullValueColor"));
        this.jLabel2.setToolTipText(ResourceMgr.getString("d_LblNullValueColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.stdBackground.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.stdBackground, gridBagConstraints);
        this.stdBackgroundLabel.setText(ResourceMgr.getString("LblTableBkgColor"));
        this.stdBackgroundLabel.setToolTipText(ResourceMgr.getString("d_LblTableBkgColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.stdBackgroundLabel, gridBagConstraints);
        this.textColorLabel.setText(ResourceMgr.getString("LblTableTextColor"));
        this.textColorLabel.setToolTipText(ResourceMgr.getString("d_LblTableTextColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.textColorLabel, gridBagConstraints);
        this.textColor.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.textColor, gridBagConstraints);
        this.selectionColorLabel.setText(ResourceMgr.getString("LblTableSelBckColor"));
        this.selectionColorLabel.setToolTipText(ResourceMgr.getString("d_LblTableSelBckColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.selectionColorLabel, gridBagConstraints);
        this.selectionColor.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.selectionColor, gridBagConstraints);
        this.selectedTextColorLabel.setText(ResourceMgr.getString("LblTableSelTextColor"));
        this.selectedTextColorLabel.setToolTipText(ResourceMgr.getString("d_LblTableSelTextColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.selectedTextColorLabel, gridBagConstraints);
        this.selectedTextColor.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.selectedTextColor, gridBagConstraints);
        this.jLabel7.setText(ResourceMgr.getString("LblModifiedColor"));
        this.jLabel7.setToolTipText(ResourceMgr.getString("d_LblModifiedColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.jLabel7, gridBagConstraints);
        this.modifiedColor.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.modifiedColor, gridBagConstraints);
        this.jPanel7.setLayout(new GridBagLayout());
        this.jLabel8.setText(ResourceMgr.getString("LblSelectionBlend"));
        this.jLabel8.setToolTipText(ResourceMgr.getString("d_LblSelectionBlend"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel7.add((Component)this.jLabel8, gridBagConstraints);
        this.selectionBlend.setToolTipText(ResourceMgr.getString("d_LblSelectionBlend"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel7.add((Component)this.selectionBlend, gridBagConstraints);
        this.alternateBlend.setToolTipText(ResourceMgr.getString("d_LblAlternateBlend"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 10, 0, 0);
        this.jPanel7.add((Component)this.alternateBlend, gridBagConstraints);
        this.jLabel9.setText(ResourceMgr.getString("LblAlternateBlend"));
        this.jLabel9.setToolTipText(ResourceMgr.getString("d_LblAlternateBlend"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.jPanel7.add((Component)this.jLabel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(7, 0, 0, 20);
        this.add((Component)this.jPanel7, gridBagConstraints);
        this.jLabel10.setText(ResourceMgr.getString("LblDataHiliteColor"));
        this.jLabel10.setToolTipText(ResourceMgr.getString("d_LblDataHiliteColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.jLabel10, gridBagConstraints);
        this.searchHilite.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.searchHilite, gridBagConstraints);
    }
}

