/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import workbench.gui.components.FlatButton;
import workbench.gui.components.WbColorPicker;
import workbench.interfaces.Restoreable;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.FileDialogUtil;
import workbench.util.StringUtil;

public class DataEditOptionsPanel
extends JPanel
implements ActionListener,
Restoreable {
    private JCheckBox checkEditable;
    private JTextField fieldLength;
    private JCheckBox highlightRequired;
    private JTextField inputLines;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JTextField pkMapFile;
    private JLabel pkMapFileLabel;
    private JCheckBox previewDml;
    private WbColorPicker requiredFieldColor;
    private JButton selectMapFile;
    private JCheckBox warnDiscard;

    public DataEditOptionsPanel() {
        this.initComponents();
    }

    @Override
    public void restoreSettings() {
        this.pkMapFile.setCaretPosition(0);
        this.previewDml.setSelected(Settings.getInstance().getPreviewDml());
        this.requiredFieldColor.setSelectedColor(GuiSettings.getRequiredFieldColor());
        this.highlightRequired.setSelected(GuiSettings.getHighlightRequiredFields());
        this.pkMapFile.setText(Settings.getInstance().getPKMappingFilename());
        this.warnDiscard.setSelected(GuiSettings.getConfirmDiscardResultSetChanges());
        this.fieldLength.setText(Integer.toString(GuiSettings.getDefaultFormFieldWidth()));
        this.inputLines.setText(Integer.toString(GuiSettings.getDefaultFormFieldLines()));
        this.checkEditable.setSelected(Settings.getInstance().getCheckEditableColumns());
    }

    @Override
    public void saveSettings() {
        GuiSettings.setRequiredFieldColor(this.requiredFieldColor.getSelectedColor());
        GuiSettings.setHighlightRequiredFields(this.highlightRequired.isSelected());
        GuiSettings.setConfirmDiscardResultSetChanges(this.warnDiscard.isSelected());
        Settings.getInstance().setPreviewDml(this.previewDml.isSelected());
        Settings.getInstance().setPKMappingFilename(this.pkMapFile.getText());
        int n = StringUtil.getIntValue(this.fieldLength.getText(), -1);
        if (n > 0) {
            GuiSettings.setDefaultFormFieldWidth(n);
        }
        int n2 = StringUtil.getIntValue(this.inputLines.getText(), -1);
        if (n > 0) {
            GuiSettings.setDefaultFormFieldLines(n2);
        }
        Settings.getInstance().setCheckEditableColumns(this.checkEditable.isSelected());
    }

    private void initComponents() {
        this.previewDml = new JCheckBox();
        this.warnDiscard = new JCheckBox();
        this.checkEditable = new JCheckBox();
        this.requiredFieldColor = new WbColorPicker();
        this.highlightRequired = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.pkMapFileLabel = new JLabel();
        this.pkMapFile = new JTextField();
        this.selectMapFile = new FlatButton();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.fieldLength = new JTextField();
        this.inputLines = new JTextField();
        this.setLayout(new GridBagLayout());
        this.previewDml.setText(ResourceMgr.getString("LblPreviewDml"));
        this.previewDml.setToolTipText(ResourceMgr.getString("d_LblPreviewDml"));
        this.previewDml.setBorder(null);
        this.previewDml.setHorizontalAlignment(2);
        this.previewDml.setHorizontalTextPosition(4);
        this.previewDml.setIconTextGap(5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.previewDml, gridBagConstraints);
        this.warnDiscard.setText(ResourceMgr.getString("LblWarnChgResultSet"));
        this.warnDiscard.setToolTipText(ResourceMgr.getString("d_LblWarnChgResultSet"));
        this.warnDiscard.setBorder(null);
        this.warnDiscard.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 1);
        this.add((Component)this.warnDiscard, gridBagConstraints);
        this.checkEditable.setText(ResourceMgr.getString("LblCheckEditable"));
        this.checkEditable.setToolTipText(ResourceMgr.getString("d_LblCheckEditable"));
        this.checkEditable.setBorder(null);
        this.checkEditable.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 1);
        this.add((Component)this.checkEditable, gridBagConstraints);
        this.requiredFieldColor.setToolTipText(ResourceMgr.getString("LblReqFldColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 0, 25);
        this.add((Component)this.requiredFieldColor, gridBagConstraints);
        this.highlightRequired.setText(ResourceMgr.getString("LblHiliteRqd"));
        this.highlightRequired.setToolTipText(ResourceMgr.getString("d_LblHiliteRqd"));
        this.highlightRequired.setBorder(null);
        this.highlightRequired.setHorizontalAlignment(2);
        this.highlightRequired.setHorizontalTextPosition(4);
        this.highlightRequired.setIconTextGap(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 1);
        this.add((Component)this.highlightRequired, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.pkMapFileLabel.setText(ResourceMgr.getString("LblPKMapFile"));
        this.pkMapFileLabel.setToolTipText(ResourceMgr.getString("d_LblPKMapFile"));
        this.pkMapFileLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.pkMapFileLabel, gridBagConstraints);
        this.pkMapFile.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel1.add((Component)this.pkMapFile, gridBagConstraints);
        this.selectMapFile.setText("...");
        this.selectMapFile.setMinimumSize(new Dimension(22, 22));
        this.selectMapFile.setPreferredSize(new Dimension(22, 22));
        this.selectMapFile.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.selectMapFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 16);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(ResourceMgr.getString("LblFreeFormSettings")));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel1.setText(ResourceMgr.getString("LblFreeFormFieldLen"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 5, 0, 0);
        this.jPanel3.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText(ResourceMgr.getString("LblFreeFormLines"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 5, 6, 0);
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.fieldLength.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 9, 0, 8);
        this.jPanel3.add((Component)this.fieldLength, gridBagConstraints);
        this.inputLines.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 6, 8);
        this.jPanel3.add((Component)this.inputLines, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 10);
        this.add((Component)this.jPanel3, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.selectMapFile) {
            this.selectMapFile(actionEvent);
        }
    }

    private void selectMapFile(ActionEvent actionEvent) {
        String string = FileDialogUtil.selectPkMapFile(this);
        if (string != null) {
            this.pkMapFile.setText(string);
        }
    }
}

