/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import workbench.WbManager;
import workbench.db.WbConnection;
import workbench.gui.MainWindow;
import workbench.gui.components.WbFilePicker;
import workbench.interfaces.MainPanel;
import workbench.interfaces.Restoreable;
import workbench.interfaces.ValidatingComponent;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.formatter.ExternalFormatter;

public class ExternalFormatterOptions
extends JPanel
implements Restoreable,
ValidatingComponent {
    private ExternalFormatter currentFormatter;
    private JCheckBox cbxEnabled;
    private JTextField cmdLine;
    private JComboBox dbList;
    private WbFilePicker exePath;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSeparator jSeparator1;
    private JLabel lblHelp;
    private JCheckBox supportsScripts;

    public ExternalFormatterOptions() {
        this.initComponents();
        this.exePath.setLastDirProperty("workbench.gui.formatter.lastexe.dir");
        this.lblHelp.setText(ResourceMgr.getFormattedString("MsgExtFmtHelp", "${wbin}", "${wbout}"));
    }

    private void fillDropDown() {
        Map<String, String> map = Settings.getInstance().getDbIdMapping();
        Object[] objectArray = new FormatterEntry[map.size() + 1];
        FormatterEntry formatterEntry = new FormatterEntry();
        formatterEntry.dbid = "default";
        formatterEntry.name = "Default";
        formatterEntry.formatter = ExternalFormatter.getDefinition("default");
        objectArray[0] = formatterEntry;
        int n = 1;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            FormatterEntry formatterEntry2 = new FormatterEntry();
            formatterEntry2.dbid = entry.getKey();
            formatterEntry2.name = entry.getValue();
            formatterEntry2.formatter = ExternalFormatter.getDefinition(formatterEntry2.dbid);
            objectArray[n] = formatterEntry2;
            ++n;
        }
        Arrays.sort(objectArray);
        this.dbList.setModel(new DefaultComboBoxModel<Object>(objectArray));
        this.showSelection();
    }

    @Override
    public void restoreSettings() {
        this.fillDropDown();
        MainWindow mainWindow = (MainWindow)WbManager.getInstance().getCurrentWindow();
        if (mainWindow == null) {
            return;
        }
        WbConnection wbConnection = mainWindow.getCurrentPanel().map(MainPanel::getConnection).orElse(null);
        if (wbConnection != null) {
            ComboBoxModel comboBoxModel = this.dbList.getModel();
            int n = -1;
            int n2 = comboBoxModel.getSize();
            for (int i = 0; i < n2; ++i) {
                FormatterEntry formatterEntry = (FormatterEntry)comboBoxModel.getElementAt(i);
                if (!formatterEntry.dbid.equals(wbConnection.getDbId())) continue;
                n = i;
                break;
            }
            if (n != -1) {
                this.dbList.setSelectedIndex(n);
            }
        }
    }

    @Override
    public void saveSettings() {
        this.save(this.getSelectedFormatter());
        int n = this.dbList.getItemCount();
        for (int i = 0; i < n; ++i) {
            FormatterEntry formatterEntry = (FormatterEntry)this.dbList.getItemAt(i);
            ExternalFormatter.saveDefinition(formatterEntry.formatter, formatterEntry.dbid);
        }
    }

    @Override
    public boolean validateInput() {
        return true;
    }

    @Override
    public void componentWillBeClosed() {
    }

    @Override
    public void componentDisplayed() {
    }

    private ExternalFormatter getSelectedFormatter() {
        FormatterEntry formatterEntry = (FormatterEntry)this.dbList.getSelectedItem();
        return formatterEntry.formatter;
    }

    private void showSelection() {
        this.currentFormatter = this.getSelectedFormatter();
        this.show(this.currentFormatter);
    }

    private void show(ExternalFormatter externalFormatter) {
        if (externalFormatter == null) {
            return;
        }
        this.cbxEnabled.setSelected(externalFormatter.isEnabled());
        this.exePath.setFilename(externalFormatter.getProgram());
        this.cmdLine.setText(externalFormatter.getCommandLine());
        this.supportsScripts.setSelected(externalFormatter.supportsMultipleStatements());
    }

    private void save(ExternalFormatter externalFormatter) {
        if (externalFormatter == null) {
            return;
        }
        externalFormatter.setEnabled(this.cbxEnabled.isSelected());
        externalFormatter.setProgram(this.exePath.getFilename());
        externalFormatter.setCommandLine(this.cmdLine.getText());
        externalFormatter.setSupportsMultipleStatements(this.supportsScripts.isSelected());
    }

    private void initComponents() {
        this.dbList = new JComboBox();
        this.exePath = new WbFilePicker();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.cmdLine = new JTextField();
        this.cbxEnabled = new JCheckBox();
        this.supportsScripts = new JCheckBox();
        this.lblHelp = new JLabel();
        this.setLayout(new GridBagLayout());
        this.dbList.setMaximumRowCount(15);
        this.dbList.setModel(new DefaultComboBoxModel<String>(new String[]{"PostgreSQL"}));
        this.dbList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExternalFormatterOptions.this.dbListActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.dbList, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 5, 0, 5);
        this.add((Component)this.exePath, gridBagConstraints);
        this.jLabel1.setText(ResourceMgr.getString("LblExePath"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 0, 6, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.jLabel2.setText(ResourceMgr.getString("LblExtFmtArg"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(7, 5, 0, 5);
        this.add((Component)this.cmdLine, gridBagConstraints);
        this.cbxEnabled.setText(ResourceMgr.getString("LblExtFmtEnabled"));
        this.cbxEnabled.setBorder(null);
        this.cbxEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExternalFormatterOptions.this.cbxEnabledActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 7, 0);
        this.add((Component)this.cbxEnabled, gridBagConstraints);
        this.supportsScripts.setText(ResourceMgr.getString("LblExtFmtScript"));
        this.supportsScripts.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.supportsScripts, gridBagConstraints);
        this.lblHelp.setText("jLabel3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 25;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 15, 5);
        this.add((Component)this.lblHelp, gridBagConstraints);
    }

    private void cbxEnabledActionPerformed(ActionEvent actionEvent) {
    }

    private void dbListActionPerformed(ActionEvent actionEvent) {
        this.save(this.currentFormatter);
        this.showSelection();
    }

    private static class FormatterEntry
    implements Comparable<FormatterEntry> {
        ExternalFormatter formatter;
        String dbid;
        String name;

        private FormatterEntry() {
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(FormatterEntry formatterEntry) {
            if (this.dbid.equals("default")) {
                return -1;
            }
            if (formatterEntry.dbid.equals("default")) {
                return 1;
            }
            return this.name.compareTo(formatterEntry.name);
        }
    }
}

