/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import workbench.gui.components.WbFontPicker;
import workbench.interfaces.Restoreable;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.PlatformHelper;

public class FontOptionsPanel
extends JPanel
implements Restoreable {
    private WbFontPicker dataFont;
    private JLabel dataFontLabel;
    private WbFontPicker editorFont;
    private JLabel editorFontLabel;
    private JComboBox<String> iconSize;
    private JPanel iconSizePanel;
    private JLabel jLabel1;
    private JLabel msgFontLabel;
    private WbFontPicker msgLogFont;
    private JCheckBox scaleFonts;
    private WbFontPicker standardFont;
    private JLabel standardFontLabel;
    private JCheckBox wheelZoom;

    public FontOptionsPanel() {
        this.initComponents();
        this.standardFont.setAllowFontReset(true);
        this.editorFont.setAllowFontReset(true);
        this.editorFont.setListMonospacedOnly(true);
        this.dataFont.setAllowFontReset(true);
        this.msgLogFont.setAllowFontReset(true);
        if (!PlatformHelper.isWindows()) {
            this.scaleFonts.setVisible(false);
            this.scaleFonts.setEnabled(false);
        }
        String[] stringArray = new String[]{ResourceMgr.getString("LblDefaultIndicator"), "16px", "24px", "32px"};
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(stringArray);
        this.iconSize.setModel(defaultComboBoxModel);
    }

    @Override
    public void restoreSettings() {
        this.editorFont.setSelectedFont(Settings.getInstance().getEditorFont(false));
        this.dataFont.setSelectedFont(Settings.getInstance().getDataFont());
        this.msgLogFont.setSelectedFont(Settings.getInstance().getMsgLogFont());
        this.standardFont.setSelectedFont(Settings.getInstance().getStandardFont());
        this.wheelZoom.setSelected(GuiSettings.getZoomFontWithMouseWheel());
        if (this.scaleFonts.isVisible()) {
            this.scaleFonts.setSelected(Settings.getInstance().getScaleFonts());
        }
        if (Settings.getInstance().getScaleMenuIcons()) {
            this.iconSize.setSelectedIndex(0);
        } else {
            int n = Settings.getInstance().getToolbarIconSize();
            switch (n) {
                case 16: {
                    this.iconSize.setSelectedIndex(1);
                    break;
                }
                case 24: {
                    this.iconSize.setSelectedIndex(2);
                    break;
                }
                case 32: {
                    this.iconSize.setSelectedIndex(3);
                }
            }
        }
    }

    @Override
    public void saveSettings() {
        Settings.getInstance().setEditorFont(this.editorFont.getSelectedFont());
        Settings.getInstance().setDataFont(this.dataFont.getSelectedFont());
        Settings.getInstance().setStandardFont(this.standardFont.getSelectedFont());
        Settings.getInstance().setMsgLogFont(this.msgLogFont.getSelectedFont());
        if (this.scaleFonts.isVisible()) {
            Settings.getInstance().setScaleFonts(this.scaleFonts.isSelected());
        }
        GuiSettings.setZoomFontWithMouseWheel(this.wheelZoom.isSelected());
        int n = this.iconSize.getSelectedIndex();
        switch (n) {
            case 0: {
                Settings.getInstance().setScaleMenuIcons(true);
                break;
            }
            case 1: {
                Settings.getInstance().setScaleMenuIcons(false);
                Settings.getInstance().setToolbarIconSize(16);
                break;
            }
            case 2: {
                Settings.getInstance().setScaleMenuIcons(false);
                Settings.getInstance().setToolbarIconSize(24);
                break;
            }
            case 3: {
                Settings.getInstance().setScaleMenuIcons(false);
                Settings.getInstance().setToolbarIconSize(32);
            }
        }
    }

    private void initComponents() {
        this.dataFontLabel = new JLabel();
        this.dataFont = new WbFontPicker();
        this.standardFont = new WbFontPicker();
        this.standardFontLabel = new JLabel();
        this.msgFontLabel = new JLabel();
        this.msgLogFont = new WbFontPicker();
        this.editorFont = new WbFontPicker();
        this.editorFontLabel = new JLabel();
        this.scaleFonts = new JCheckBox();
        this.wheelZoom = new JCheckBox();
        this.iconSizePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.iconSize = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.dataFontLabel.setText(ResourceMgr.getString("LblDataFont"));
        this.dataFontLabel.setToolTipText(ResourceMgr.getString("d_LblDataFont"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 1, 5, 0);
        this.add((Component)this.dataFontLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 5, 15);
        this.add((Component)this.dataFont, gridBagConstraints);
        this.standardFont.setFont(this.standardFont.getFont());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 5, 15);
        this.add((Component)this.standardFont, gridBagConstraints);
        this.standardFontLabel.setText(ResourceMgr.getString("LblStandardFont"));
        this.standardFontLabel.setToolTipText(ResourceMgr.getString("d_LblStandardFont"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 1, 5, 0);
        this.add((Component)this.standardFontLabel, gridBagConstraints);
        this.msgFontLabel.setText(ResourceMgr.getString("LblMsgLogFont"));
        this.msgFontLabel.setToolTipText(ResourceMgr.getString("d_LblMsgLogFont"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 1, 5, 0);
        this.add((Component)this.msgFontLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 5, 15);
        this.add((Component)this.msgLogFont, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 8, 5, 15);
        this.add((Component)this.editorFont, gridBagConstraints);
        this.editorFontLabel.setText(ResourceMgr.getString("LblEditorFont"));
        this.editorFontLabel.setToolTipText(ResourceMgr.getString("d_LblEditorFont"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 1, 5, 0);
        this.add((Component)this.editorFontLabel, gridBagConstraints);
        this.scaleFonts.setText(ResourceMgr.getString("LblScaleFont"));
        this.scaleFonts.setToolTipText(ResourceMgr.getString("d_LblScaleFont"));
        this.scaleFonts.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 1, 5, 0);
        this.add((Component)this.scaleFonts, gridBagConstraints);
        this.wheelZoom.setText(ResourceMgr.getString("LblEnableWheelZoom"));
        this.wheelZoom.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(7, 1, 5, 0);
        this.add((Component)this.wheelZoom, gridBagConstraints);
        this.iconSizePanel.setLayout(new GridBagLayout());
        this.jLabel1.setText(ResourceMgr.getString("LblIconSize"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.iconSizePanel.add((Component)this.jLabel1, gridBagConstraints);
        this.iconSize.setModel(new DefaultComboBoxModel<String>(new String[]{"16 px", "24 px", "32 px", " "}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.iconSizePanel.add(this.iconSize, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.iconSizePanel, gridBagConstraints);
    }
}

