/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import workbench.gui.components.TextFieldWidthAdjuster;
import workbench.gui.components.WbColorPicker;
import workbench.interfaces.Restoreable;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class HighlightSettingsPanel
extends JPanel
implements Restoreable {
    private WbColorPicker bracketHilite;
    private JLabel bracketHiliteLabel;
    private JCheckBox enableHilite;
    private JCheckBox enableSelHilite;
    private JRadioButton hiliteBoth;
    private JRadioButton hiliteMatching;
    private JCheckBox hiliteRec;
    private ButtonGroup hiliteType;
    private JCheckBox ignoreCase;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JSeparator jSeparator1;
    private JRadioButton matchLeft;
    private JRadioButton matchRight;
    private ButtonGroup matchType;
    private JCheckBox noWhitespace;
    private WbColorPicker selHiliteColor;
    private JTextField selMinLength;

    public HighlightSettingsPanel() {
        this.initComponents();
        TextFieldWidthAdjuster textFieldWidthAdjuster = new TextFieldWidthAdjuster();
        textFieldWidthAdjuster.adjustField(this.selMinLength);
    }

    @Override
    public void restoreSettings() {
        Settings settings = Settings.getInstance();
        Color color = settings.getEditorBracketHighlightColor();
        this.enableHilite.setSelected(settings.isBracketHighlightEnabled());
        this.bracketHilite.setSelectedColor(color);
        this.matchLeft.setSelected(settings.getBracketHighlightLeft());
        this.matchRight.setSelected(!settings.getBracketHighlightLeft());
        this.hiliteRec.setSelected(settings.getBracketHighlightRectangle());
        this.hiliteBoth.setSelected(settings.getBracketHighlightBoth());
        this.hiliteMatching.setSelected(!settings.getBracketHighlightBoth());
        this.enableSelHilite.setSelected(settings.getHighlightCurrentSelection());
        this.noWhitespace.setSelected(settings.getSelectionHighlightNoWhitespace());
        this.selMinLength.setText(Integer.toString(settings.getMinLengthForSelectionHighlight()));
        this.selHiliteColor.setSelectedColor(settings.geSelectionHighlightColor());
        this.ignoreCase.setSelected(settings.getSelectionHighlightIgnoreCase());
    }

    @Override
    public void saveSettings() {
        Settings settings = Settings.getInstance();
        settings.setColor("workbench.editor.bracket.hilite.color", this.bracketHilite.getSelectedColor());
        settings.setBracketHighlight(this.enableHilite.isSelected());
        settings.setBracketHighlightLeft(this.matchLeft.isSelected());
        settings.setBracketHighlightRectangle(this.hiliteRec.isSelected());
        settings.setBracketHighlightBoth(this.hiliteBoth.isSelected());
        settings.setSelectionHighlightColor(this.selHiliteColor.getSelectedColor());
        settings.setSelectionHighlightNoWhitespace(this.noWhitespace.isSelected());
        settings.setHighlightCurrentSelection(this.enableSelHilite.isSelected());
        settings.setSelectionHighlightIgnoreCase(this.ignoreCase.isSelected());
        int n = StringUtil.getIntValue(this.selMinLength.getText(), -1);
        if (n != -1) {
            settings.setMinLengthForSelectionHighlight(n);
        }
    }

    private void initComponents() {
        this.matchType = new ButtonGroup();
        this.hiliteType = new ButtonGroup();
        this.enableHilite = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.matchLeft = new JRadioButton();
        this.matchRight = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.hiliteBoth = new JRadioButton();
        this.hiliteMatching = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.bracketHiliteLabel = new JLabel();
        this.hiliteRec = new JCheckBox();
        this.bracketHilite = new WbColorPicker(true);
        this.jSeparator1 = new JSeparator();
        this.jPanel4 = new JPanel();
        this.enableSelHilite = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.selMinLength = new JTextField();
        this.selHiliteColor = new WbColorPicker(true);
        this.jLabel2 = new JLabel();
        this.ignoreCase = new JCheckBox();
        this.noWhitespace = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.enableHilite.setText(ResourceMgr.getString("LblBracketHilite"));
        this.enableHilite.setToolTipText(ResourceMgr.getString("d_LblBracketHilite"));
        this.enableHilite.setBorder(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.enableHilite, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setLayout(new GridBagLayout());
        this.matchType.add(this.matchLeft);
        this.matchLeft.setText(ResourceMgr.getString("LblBracketLeftOfCursor"));
        this.matchLeft.setToolTipText(ResourceMgr.getString("d_LblBracketLeftOfCursor"));
        this.matchLeft.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel1.add((Component)this.matchLeft, gridBagConstraints);
        this.matchType.add(this.matchRight);
        this.matchRight.setText(ResourceMgr.getString("LblBracketRightOfCursor"));
        this.matchRight.setToolTipText(ResourceMgr.getString("d_LblBracketRightOfCursor"));
        this.matchRight.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.matchRight, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 5, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel2.setLayout(new GridBagLayout());
        this.hiliteType.add(this.hiliteBoth);
        this.hiliteBoth.setText(ResourceMgr.getString("LblBracketHiliteBoth"));
        this.hiliteBoth.setToolTipText(ResourceMgr.getString("d_LblBracketHiliteBoth"));
        this.hiliteBoth.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel2.add((Component)this.hiliteBoth, gridBagConstraints);
        this.hiliteType.add(this.hiliteMatching);
        this.hiliteMatching.setText(ResourceMgr.getString("LblBracketHiliteMatching"));
        this.hiliteMatching.setToolTipText(ResourceMgr.getString("d_LblBracketHiliteMatching"));
        this.hiliteMatching.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.hiliteMatching, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 5, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.bracketHiliteLabel.setText(ResourceMgr.getString("LblBracketHiliteColor"));
        this.bracketHiliteLabel.setToolTipText(ResourceMgr.getString("d_LblBracketHiliteColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 1, 0, 0);
        this.jPanel3.add((Component)this.bracketHiliteLabel, gridBagConstraints);
        this.hiliteRec.setText(ResourceMgr.getString("LblBracketHiliteRec"));
        this.hiliteRec.setToolTipText(ResourceMgr.getString("d_LblBracketHiliteRec"));
        this.hiliteRec.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.jPanel3.add((Component)this.hiliteRec, gridBagConstraints);
        this.bracketHilite.setToolTipText(ResourceMgr.getString("d_LblBracketHiliteColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.jPanel3.add((Component)this.bracketHilite, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.enableSelHilite.setText(ResourceMgr.getString("LblHiliteSel"));
        this.enableSelHilite.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.jPanel4.add((Component)this.enableSelHilite, gridBagConstraints);
        this.jLabel1.setText(ResourceMgr.getString("LblHiliteSelMinLen"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.jPanel4.add((Component)this.jLabel1, gridBagConstraints);
        this.selMinLength.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(8, 7, 0, 0);
        this.jPanel4.add((Component)this.selMinLength, gridBagConstraints);
        this.selHiliteColor.setToolTipText(ResourceMgr.getString("d_LblBracketHiliteColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.jPanel4.add((Component)this.selHiliteColor, gridBagConstraints);
        this.jLabel2.setText(ResourceMgr.getString("LblHiliteSelColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 9, 0, 0);
        this.jPanel4.add((Component)this.jLabel2, gridBagConstraints);
        this.ignoreCase.setText(ResourceMgr.getString("LblSearchIgnoreCase"));
        this.ignoreCase.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel4.add((Component)this.ignoreCase, gridBagConstraints);
        this.noWhitespace.setText(ResourceMgr.getString("LblHiliteNoSpc"));
        this.noWhitespace.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel4.add((Component)this.noWhitespace, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jPanel4, gridBagConstraints);
    }
}

