/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.EventQueue;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import workbench.resource.ResourceMgr;

public class KeyboardMapper
extends JPanel
implements KeyListener {
    private JTextField display = new JTextField(20);
    private KeyStroke newkey;

    public KeyboardMapper() {
        this.display.addKeyListener(this);
        this.display.setEditable(false);
        this.display.setDisabledTextColor(this.display.getForeground());
        this.display.setBackground(UIManager.getColor("TextArea.background"));
        this.add(this.display);
    }

    @Override
    public void grabFocus() {
        this.display.grabFocus();
        this.display.requestFocusInWindow();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        int n2 = keyEvent.getKeyCode();
        if (n == 0 && !keyEvent.isActionKey()) {
            return;
        }
        if (n2 >= 32 || n2 == 10 || n2 == 8 || n2 == 9 || n2 == 27) {
            String string = KeyEvent.getKeyText(n2);
            if (n > 0) {
                string = KeyEvent.getKeyModifiersText(n) + "-" + string;
            }
            this.newkey = KeyStroke.getKeyStroke(n2, n);
            this.display.setText(string);
        }
    }

    public KeyStroke getKeyStroke() {
        return this.newkey;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public static KeyStroke getKeyStroke(JComponent jComponent) {
        final KeyboardMapper keyboardMapper = new KeyboardMapper();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                keyboardMapper.grabFocus();
            }
        });
        Object[] objectArray = new String[]{ResourceMgr.getPlainString("LblOK"), ResourceMgr.getPlainString("LblCancel")};
        JOptionPane jOptionPane = new JOptionPane(keyboardMapper, -1, 2, null, objectArray);
        JDialog jDialog = jOptionPane.createDialog(jComponent, ResourceMgr.getString("LblEnterKeyWindowTitle"));
        jDialog.setResizable(true);
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        jDialog.dispose();
        KeyStroke keyStroke = null;
        if (((String)objectArray[0]).equals(object)) {
            keyStroke = keyboardMapper.getKeyStroke();
        }
        return keyStroke;
    }
}

