/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.settings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import workbench.gui.components.DividerBorder;
import workbench.interfaces.Disposable;
import workbench.interfaces.Restoreable;
import workbench.interfaces.ValidatingComponent;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;

public class OptionPanelPage {
    public static final Border PAGE_BORDER = new EmptyBorder(8, 8, 8, 8);
    private static final Set<String> NO_BORDER_PANELS = CollectionUtil.treeSet("LnFOptionsPanel", "ExternalToolsPanel", "FormatterOptionsPanel", "DbExplorerOptionsPanel");
    private String label;
    private String pageClass;
    private JPanel panel;
    private Restoreable options;
    private boolean addBorder;

    public OptionPanelPage(String string, String string2) {
        this.label = ResourceMgr.getString(string2);
        this.pageClass = "workbench.gui.settings." + string;
        this.addBorder = !NO_BORDER_PANELS.contains(string);
    }

    public String toString() {
        return this.label;
    }

    public String getLabel() {
        return this.label;
    }

    public JPanel getPanel() {
        if (this.panel == null) {
            try {
                Class<?> clazz = Class.forName(this.pageClass);
                JPanel jPanel = (JPanel)clazz.newInstance();
                this.options = (Restoreable)((Object)jPanel);
                this.options.restoreSettings();
                JLabel jLabel = new JLabel(this.label);
                jLabel.setName("pagetitle");
                jLabel.setOpaque(true);
                jLabel.setBackground(Color.WHITE);
                Font font = jLabel.getFont();
                Font font2 = font.deriveFont(1, 12.0f);
                jLabel.setBorder(new CompoundBorder(DividerBorder.BOTTOM_DIVIDER, new EmptyBorder(4, 6, 4, 6)));
                jLabel.setFont(font2);
                this.panel = new JPanel(new BorderLayout());
                if (this.addBorder) {
                    jPanel.setBorder(PAGE_BORDER);
                }
                this.panel.setBorder(BorderFactory.createEtchedBorder());
                this.panel.add((Component)jLabel, "North");
                this.panel.add((Component)jPanel, "Center");
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Could not create panel", exception);
                this.panel = new JPanel();
                this.panel.add(new JLabel(ExceptionUtil.getDisplay(exception)));
            }
        }
        return this.panel;
    }

    public boolean validateInput() {
        if (this.options instanceof ValidatingComponent) {
            ValidatingComponent validatingComponent = (ValidatingComponent)((Object)this.options);
            return validatingComponent.validateInput();
        }
        return true;
    }

    public void saveSettings() {
        try {
            if (this.options != null) {
                this.options.saveSettings();
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not save panel settings", exception);
        }
    }

    public void dispose() {
        if (this.options instanceof Disposable) {
            ((Disposable)((Object)this.options)).dispose();
        }
    }
}

