/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import workbench.WbManager;
import workbench.db.ColumnIdentifier;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.gui.MainWindow;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.CopyRowAction;
import workbench.gui.actions.CreateDeleteScriptAction;
import workbench.gui.actions.DeleteDependentRowsAction;
import workbench.gui.actions.DeleteRowAction;
import workbench.gui.actions.InsertRowAction;
import workbench.gui.actions.SelectKeyColumnsAction;
import workbench.gui.actions.UpdateDatabaseAction;
import workbench.gui.actions.WbAction;
import workbench.gui.components.ColumnOrderMgr;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.GenericRowMonitor;
import workbench.gui.components.OneLineTableModel;
import workbench.gui.components.TableRowHeader;
import workbench.gui.components.UpdateTableSelector;
import workbench.gui.components.WbScrollPane;
import workbench.gui.components.WbTable;
import workbench.gui.components.WbTextCellEditor;
import workbench.gui.renderer.RendererSetup;
import workbench.gui.sql.DwStatusBar;
import workbench.gui.sql.DwUpdatePreview;
import workbench.gui.sql.MissingPkDialog;
import workbench.gui.sql.ReferenceTableNavigator;
import workbench.interfaces.DbData;
import workbench.interfaces.DbUpdater;
import workbench.interfaces.Interruptable;
import workbench.interfaces.JobErrorHandler;
import workbench.interfaces.StatusBar;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.DataTooltipType;
import workbench.resource.GuiSettings;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.StatementRunner;
import workbench.sql.StatementRunnerResult;
import workbench.storage.DataStore;
import workbench.storage.NamedSortDefinition;
import workbench.storage.ResultColumnMetaData;
import workbench.storage.RowActionMonitor;
import workbench.storage.SourceTableDetector;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.HtmlUtil;
import workbench.util.LowMemoryException;
import workbench.util.NumberStringCache;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbThread;

public class DwPanel
extends JPanel
implements TableModelListener,
ListSelectionListener,
ChangeListener,
DbData,
DbUpdater,
Interruptable,
JobErrorHandler,
PropertyChangeListener,
StatusBar {
    public static final String PROP_UPDATE_TABLE = "updateTable";
    private static int nextId;
    private final int id = ++nextId;
    protected WbTable dataTable;
    protected DwStatusBar statusBar;
    private String sql;
    private String lastMessage;
    protected WbConnection dbConnection;
    private boolean hasResultSet;
    protected WbScrollPane scrollPane;
    private long lastExecutionDuration;
    private boolean showLoadProgress;
    private boolean savingData = false;
    protected UpdateDatabaseAction updateAction;
    protected InsertRowAction insertRow;
    protected CopyRowAction duplicateRow;
    protected DeleteRowAction deleteRow;
    protected DeleteDependentRowsAction deleteDependentRow;
    protected CreateDeleteScriptAction createDeleteScript;
    protected SelectKeyColumnsAction selectKeys;
    private boolean batchUpdate;
    private boolean readOnly;
    private boolean sharedStatusBar;
    private StatementRunner stmtRunner;
    private GenericRowMonitor genericRowMonitor;
    private ReferenceTableNavigator referenceNavigator;
    private boolean showSQLAsTooltip;
    private JLabel sqlInfo;
    private boolean enableSqlInfo;
    private boolean disconnected;
    private boolean wasReUsed;
    private boolean locked;

    public DwPanel() {
        this((DwStatusBar)null);
    }

    public DwPanel(DwStatusBar dwStatusBar) {
        this.initLayout(dwStatusBar);
        this.setDoubleBuffered(true);
        this.dataTable.addTableModelListener(this);
        this.updateAction = new UpdateDatabaseAction(this);
        this.updateAction.setEnabled(GuiSettings.getAlwaysEnableSaveButton());
        this.insertRow = new InsertRowAction(this);
        this.insertRow.setEnabled(false);
        this.deleteRow = new DeleteRowAction(this);
        this.deleteDependentRow = new DeleteDependentRowsAction(this);
        this.duplicateRow = new CopyRowAction(this);
        this.selectKeys = new SelectKeyColumnsAction(this);
        this.dataTable.addPopupAction(this.updateAction, true);
        this.dataTable.addPopupAction(this.insertRow, true);
        this.dataTable.addPopupAction(this.deleteRow, false);
        this.dataTable.addPopupAction(this.deleteDependentRow, false);
        this.dataTable.setSelectionMode(2);
        this.dataTable.setRowSelectionAllowed(true);
        this.dataTable.getSelectionModel().addListSelectionListener(this);
        this.dataTable.setStatusBar(this.statusBar);
        this.genericRowMonitor = new GenericRowMonitor(this.statusBar);
        Settings.getInstance().addPropertyChangeListener(this, "workbench.gui.display.result.sql", new String[0]);
        this.dataTable.setShowDataTypeInHeader(GuiSettings.showDatatypeInTableHeader());
        this.dataTable.setShowRemarksInHeader(GuiSettings.showRemarksInTableHeader());
        this.initColors();
    }

    public int hashCode() {
        int n = 7;
        n = 97 * n + this.id;
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DwPanel dwPanel = (DwPanel)object;
        return this.id == dwPanel.id;
    }

    public int getId() {
        return this.id;
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setReUsed(boolean bl) {
        this.wasReUsed = bl;
    }

    public boolean wasReUsed() {
        return this.wasReUsed;
    }

    public void dispose() {
        this.clearContent();
        Settings.getInstance().removePropertyChangeListener(this);
        if (this.referenceNavigator != null) {
            this.referenceNavigator.dispose();
        }
        WbAction.dispose(this.createDeleteScript, this.deleteDependentRow, this.deleteRow, this.duplicateRow, this.insertRow, this.selectKeys, this.updateAction);
        if (this.dataTable != null) {
            this.dataTable.dispose();
        }
    }

    public void setSqlInfoEnabled(boolean bl) {
        this.enableSqlInfo = bl;
        if (!this.enableSqlInfo) {
            this.hideSQLInfo();
        }
    }

    private void initColors() {
        this.dataTable.setRendererSetup(new RendererSetup());
        this.dataTable.setModifiedColor(GuiSettings.getColumnModifiedColor());
        this.dataTable.setHighlightRequiredFields(GuiSettings.getHighlightRequiredFields());
    }

    public void showCreateDeleteScript() {
        if (this.createDeleteScript == null) {
            this.createDeleteScript = new CreateDeleteScriptAction(this.dataTable);
            this.dataTable.addPopupActionAfter(this.createDeleteScript, this.deleteDependentRow);
        }
    }

    public void initTableNavigation(MainWindow mainWindow) {
        if (this.referenceNavigator != null) {
            this.referenceNavigator.dispose();
        }
        this.referenceNavigator = new ReferenceTableNavigator(this, mainWindow);
    }

    public SelectKeyColumnsAction getSelectKeysAction() {
        return this.selectKeys;
    }

    public void checkAndSelectKeyColumns() {
        if (this.checkUpdateTable() == TableCheck.tableOk) {
            this.dataTable.selectKeyColumns();
        }
    }

    public void setDefaultStatusMessage(String string) {
        this.statusBar.setReadyMsg(string);
    }

    public void disconnect() {
        this.setConnection(null);
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        this.dataTable.setCursor(cursor);
    }

    public void setShowLoadProcess(boolean bl) {
        this.showLoadProgress = bl;
    }

    public void setPrintHeader(String string) {
        this.dataTable.setPrintHeader(string);
    }

    public int getStatusBarHeight() {
        if (this.statusBar == null) {
            return 32;
        }
        return this.statusBar.getPreferredSize().height;
    }

    public void detachConnection() {
        if (this.dbConnection != null) {
            this.dbConnection.removeChangeListener(this);
        }
        if (this.dataTable == null) {
            return;
        }
        DataStore dataStore = this.dataTable.getDataStore();
        if (dataStore != null) {
            dataStore.setOriginalConnection(null);
        }
        this.disconnected = true;
        this.dataTable.removePopupAction(this.updateAction);
        this.dataTable.removePopupAction(this.deleteDependentRow);
        this.dataTable.removePopupAction(this.deleteRow);
        this.dataTable.removePopupAction(this.insertRow);
        this.dataTable.removePopupAction(this.dataTable.getReplacer().getReplaceAction());
        if (this.referenceNavigator != null) {
            this.referenceNavigator.removeFromPopup();
        }
        this.dbConnection = null;
        if (this.stmtRunner != null) {
            this.stmtRunner.done();
        }
        this.stmtRunner = null;
        this.clearStatusMessage();
        this.checkResultSetActions();
    }

    public void setConnection(WbConnection wbConnection) {
        if (this.dbConnection != null) {
            this.dbConnection.removeChangeListener(this);
        }
        this.clearContent();
        this.dbConnection = wbConnection;
        if (this.stmtRunner != null) {
            this.stmtRunner.done();
        }
        this.stmtRunner = null;
        this.clearStatusMessage();
        if (this.dbConnection != null) {
            this.setReadOnly(this.dbConnection.isSessionReadOnly());
            this.dbConnection.addChangeListener(this);
        }
    }

    private void createStatementRunner() {
        if (this.stmtRunner == null) {
            this.stmtRunner = new StatementRunner();
            this.stmtRunner.setRowMonitor(this.genericRowMonitor);
        }
        if (this.stmtRunner != null) {
            this.stmtRunner.setConnection(this.dbConnection);
        }
    }

    public void setUpdateHandler(DbUpdater dbUpdater) {
        this.updateAction.setClient(dbUpdater);
    }

    boolean prepareDatabaseUpdate(boolean bl) {
        List<ColumnIdentifier> list;
        MissingPkDialog missingPkDialog;
        boolean bl2;
        boolean bl3;
        TableCheck tableCheck;
        if (this.dbConnection == null) {
            return false;
        }
        DataStore dataStore = this.dataTable.getDataStore();
        if (dataStore == null) {
            return false;
        }
        this.dataTable.stopEditing();
        if (dataStore.getUpdateTable() == null && (tableCheck = this.checkUpdateTable()) != TableCheck.tableOk) {
            LogMgr.logError(new CallerInfo(){}, "No update table found! Cannot save changes for SQL=" + dataStore.getGeneratingSql(), null);
            return false;
        }
        boolean bl4 = dataStore.needPkForUpdate();
        if (bl4) {
            bl3 = this.dataTable.detectDefinedPkColumns();
            if (!bl3) {
                bl3 = this.getTable().selectKeyColumns();
            }
            if (!bl3) {
                return false;
            }
        }
        bl3 = dataStore.pkColumnsComplete();
        if (bl4 && !bl3 && !(bl2 = (missingPkDialog = new MissingPkDialog(list = dataStore.getMissingPkColumns())).checkContinue(this))) {
            return false;
        }
        return !bl || this.shouldSaveChanges(this.dbConnection);
    }

    private boolean shouldSaveChanges(WbConnection wbConnection) {
        this.dataTable.stopEditing();
        DataStore dataStore = this.dataTable.getDataStore();
        DwUpdatePreview dwUpdatePreview = new DwUpdatePreview();
        boolean bl = dwUpdatePreview.confirmUpdate(this, dataStore, wbConnection);
        return bl;
    }

    @Override
    public void saveChangesToDatabase(boolean bl) {
        if (this.savingData) {
            IllegalStateException illegalStateException = new IllegalStateException("Concurrent save called");
            LogMgr.logWarning(new CallerInfo(){}, "Save changes called while save in progress", illegalStateException);
            return;
        }
        if (!this.prepareDatabaseUpdate(bl)) {
            return;
        }
        WbThread wbThread = new WbThread("DwPanel update"){

            @Override
            public void run() {
                try {
                    DwPanel.this.saveChanges(DwPanel.this.dbConnection, DwPanel.this);
                }
                catch (Exception exception) {
                    LogMgr.logError(new CallerInfo(){}, "Error saving data", exception);
                }
            }
        };
        wbThread.start();
    }

    @Override
    public WbConnection getConnection() {
        return this.dbConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveChanges(WbConnection wbConnection, JobErrorHandler jobErrorHandler) throws SQLException {
        int n = 0;
        DwPanel dwPanel = this;
        synchronized (dwPanel) {
            this.dataTable.stopEditing();
            this.disableUpdateActions();
            try {
                this.setStatusMessage(ResourceMgr.getString("MsgUpdatingDatabase"));
                this.savingData = true;
                DataStore dataStore = this.dataTable.getDataStore();
                dataStore.setProgressMonitor(this.genericRowMonitor);
                long l = System.currentTimeMillis();
                n = dataStore.updateDb(wbConnection, jobErrorHandler);
                long l2 = System.currentTimeMillis();
                dataStore.setProgressMonitor(null);
                long l3 = l2 - l;
                this.lastMessage = ResourceMgr.getString("MsgUpdateSuccessfull");
                this.lastMessage = this.lastMessage + "\n " + ResourceMgr.getFormattedString("MsgRowsAffected", n) + "\n";
                this.lastMessage = this.lastMessage + ResourceMgr.getString("MsgExecTime") + " " + (double)l3 / 1000.0 + "s";
                if (!dataStore.lastUpdateHadErrors()) {
                    this.endEdit();
                }
            }
            catch (SQLException sQLException) {
                this.lastMessage = ExceptionUtil.getDisplay(sQLException);
                n = -1;
                throw sQLException;
            }
            finally {
                this.savingData = false;
                this.clearStatusMessage();
                this.checkResultSetActions();
            }
        }
        return n;
    }

    public void disableUpdateActions() {
        this.updateAction.setEnabled(GuiSettings.getAlwaysEnableSaveButton());
        this.insertRow.setEnabled(false);
        this.duplicateRow.setEnabled(false);
        this.deleteRow.setEnabled(false);
        this.deleteDependentRow.setEnabled(false);
    }

    public void defineUpdateTable(TableDefinition tableDefinition) {
        DataStore dataStore = this.dataTable.getDataStore();
        if (dataStore != null && tableDefinition != null) {
            dataStore.setUpdateTable(tableDefinition);
        }
        if (this.referenceNavigator != null) {
            this.referenceNavigator.reset();
        }
    }

    public void setUpdateTableToBeUsed(TableIdentifier tableIdentifier) {
        DataStore dataStore = this.dataTable.getDataStore();
        if (dataStore != null && tableIdentifier != null) {
            dataStore.setUpdateTableToBeUsed(tableIdentifier);
        }
        if (this.referenceNavigator != null) {
            this.referenceNavigator.reset();
        }
    }

    public void setUpdateTable(TableIdentifier tableIdentifier) {
        this.setStatusMessage(ResourceMgr.getString("MsgRetrieveUpdateTableInfo"));
        try {
            DataStore dataStore = this.dataTable.getDataStore();
            if (dataStore != null && tableIdentifier != null) {
                dataStore.setUpdateTable(tableIdentifier);
            }
            this.checkResultSetActions();
            this.fireUpdateTableChanged();
        }
        finally {
            this.clearStatusMessage();
        }
    }

    private void fireUpdateTableChanged() {
        String string = this.getUpdateTable();
        if (string != null) {
            this.firePropertyChange(PROP_UPDATE_TABLE, null, string);
        }
    }

    private String getUpdateTable() {
        DataStore dataStore;
        TableIdentifier tableIdentifier = null;
        if (this.getTable() != null && (dataStore = this.getTable().getDataStore()) != null) {
            tableIdentifier = dataStore.getUpdateTable();
        }
        if (tableIdentifier != null) {
            return tableIdentifier.getTableExpression();
        }
        return null;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
        if (this.readOnly && this.isEditingStarted()) {
            this.dataTable.cancelEditing();
        }
        this.checkResultSetActions();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableCheck checkUpdateTable() {
        if (this.readOnly || this.dbConnection == null || this.sql == null) {
            return TableCheck.noTable;
        }
        DataStore dataStore = this.dataTable.getDataStore();
        if (dataStore == null) {
            return TableCheck.noTable;
        }
        this.setStatusMessage(ResourceMgr.getString("MsgCheckingUpdateTable"));
        this.statusBar.forcePaint();
        TableCheck tableCheck = TableCheck.noTable;
        try {
            boolean bl = dataStore.checkUpdateTable(this.dbConnection);
            if (!bl) {
                UpdateTableSelector updateTableSelector = new UpdateTableSelector(this.dataTable);
                TableIdentifier tableIdentifier = updateTableSelector.selectUpdateTable();
                if (tableIdentifier == null) {
                    TableCheck tableCheck2 = TableCheck.cancel;
                    return tableCheck2;
                }
                tableCheck = TableCheck.tableOk;
                if (this.dataTable.getDataStore().getResultInfo().columnTablesAvailable()) {
                    LogMgr.logDebug(new CallerInfo(){}, "All columns have a source table defined. No need to parse the underlying SQL query.");
                } else {
                    SourceTableDetector sourceTableDetector = new SourceTableDetector();
                    List<String> list = sourceTableDetector.getColumnsFromTable(tableIdentifier, this.sql, this.dbConnection);
                    if (CollectionUtil.isEmpty(list)) {
                        tableCheck = TableCheck.noTableColumns;
                    }
                }
                if (tableCheck == TableCheck.tableOk) {
                    this.setUpdateTable(tableIdentifier);
                }
            } else {
                tableCheck = TableCheck.tableOk;
            }
            this.selectKeys.setEnabled(tableCheck == TableCheck.tableOk);
        }
        finally {
            this.clearStatusMessage();
        }
        return tableCheck;
    }

    public boolean hasKeyColumns() {
        if (this.dataTable.getDataStore() == null) {
            return false;
        }
        return this.dataTable.getDataStore().hasPkColumns();
    }

    public boolean isUpdateable() {
        if (this.dataTable.getDataStore() == null) {
            return false;
        }
        return this.dataTable.getDataStore().isUpdateable();
    }

    public boolean hasUpdateableColumns() {
        if (this.dataTable.getDataStore() == null) {
            return false;
        }
        return this.dataTable.getDataStore().hasUpdateableColumns();
    }

    public int getQueryTimeout() {
        return this.statusBar.getQueryTimeout();
    }

    public void setQueryTimeout(int n) {
        this.statusBar.setQueryTimeout(n);
    }

    public int getMaxRows() {
        return this.statusBar.getMaxRows();
    }

    public void setMaxRows(int n) {
        this.statusBar.setMaxRows(n);
    }

    public long getLastExecutionTime() {
        return this.lastExecutionDuration;
    }

    public void setStatusBar(DwStatusBar dwStatusBar) {
        if (this.statusBar != null) {
            this.remove(this.statusBar);
            this.statusBar.removeSelectionIndicator(this.dataTable);
        }
        this.sharedStatusBar = false;
        this.statusBar = dwStatusBar;
        this.add((Component)this.statusBar, "South");
        if (this.dataTable != null) {
            this.dataTable.setStatusBar(this.statusBar);
        }
        this.invalidate();
        this.doLayout();
    }

    public void showLastExecutionDuration() {
        this.statusBar.setExecutionTime(this.lastExecutionDuration);
    }

    public void setSortDefinition(NamedSortDefinition namedSortDefinition) {
        DataStoreTableModel dataStoreTableModel = this.dataTable.getDataStoreTableModel();
        if (dataStoreTableModel != null) {
            try {
                this.dataTable.sortingStarted();
                dataStoreTableModel.setSortDefinition(namedSortDefinition);
            }
            finally {
                this.dataTable.sortingFinished();
            }
        }
    }

    public DataStore getDataStore() {
        if (this.dataTable == null) {
            return null;
        }
        return this.dataTable.getDataStore();
    }

    public NamedSortDefinition getCurrentSort() {
        if (this.dataTable == null) {
            return null;
        }
        return this.dataTable.getCurrentSort();
    }

    public void runCurrentSql(boolean bl) throws SQLException, Exception {
        DataStore dataStore = this.getDataStore();
        if (dataStore == null) {
            return;
        }
        String string = dataStore.getGeneratingSql();
        if (string == null) {
            return;
        }
        NamedSortDefinition namedSortDefinition = this.dataTable.getCurrentSort();
        this.runQuery(string, bl);
        if (namedSortDefinition != null) {
            this.dataTable.getDataStoreTableModel().setSortDefinition(namedSortDefinition);
            this.dataTable.adjustColumns();
        }
        if (GuiSettings.getShowMaxRowsReached()) {
            this.checkLimitReachedDisplay();
        }
        if (this.showSQLAsTooltip) {
            this.showGeneratingSQLAsTooltip();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runQuery(String string, boolean bl) throws SQLException, Exception {
        if (this.stmtRunner == null) {
            this.createStatementRunner();
        }
        boolean bl2 = false;
        try {
            WbSwingUtilities.invoke(() -> {
                this.clearContent();
                this.initColors();
            });
            this.sql = string;
            int n = bl ? this.statusBar.getMaxRows() : 0;
            int n2 = this.statusBar.getQueryTimeout();
            this.stmtRunner.setMaxRows(n);
            this.stmtRunner.setQueryTimeout(n2);
            StatementRunnerResult statementRunnerResult = this.stmtRunner.runStatement(string);
            if (statementRunnerResult != null) {
                if (statementRunnerResult.isSuccess()) {
                    bl2 = true;
                    this.showData(statementRunnerResult);
                } else if (statementRunnerResult.hasMessages()) {
                    String string2 = statementRunnerResult.getMessages().toString();
                    this.showError(string2);
                    WbSwingUtilities.showErrorMessage(SwingUtilities.getWindowAncestor(this), string2);
                }
            }
        }
        finally {
            this.stmtRunner.statementDone();
            this.stmtRunner.done();
            this.clearStatusMessage();
        }
        return bl2;
    }

    public void showData(StatementRunnerResult statementRunnerResult) throws SQLException {
        if (statementRunnerResult == null || !statementRunnerResult.isSuccess()) {
            this.lastExecutionDuration = 0L;
            this.hasResultSet = false;
        } else if (statementRunnerResult.hasDataStores()) {
            this.showData(statementRunnerResult.getDataStores().get(0), statementRunnerResult.getSourceCommand(), statementRunnerResult.getExecutionDuration());
        } else if (statementRunnerResult.hasResultSets()) {
            this.showData(statementRunnerResult.getResultSets().get(0), statementRunnerResult.getSourceCommand(), statementRunnerResult.getExecutionDuration());
        }
    }

    public void showData(ResultSet resultSet, String string, long l) throws SQLException {
        DataStore dataStore = null;
        try {
            dataStore = this.showLoadProgress ? new DataStore(resultSet, true, this.genericRowMonitor, this.getMaxRows(), this.dbConnection) : new DataStore(resultSet, true, null, this.getMaxRows(), this.dbConnection);
            this.showData(dataStore, string, l);
        }
        catch (LowMemoryException lowMemoryException) {
            WbManager.getInstance().showLowMemoryError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showData(DataStore dataStore, String string, long l) throws SQLException {
        try {
            this.setBatchUpdate(true);
            this.hasResultSet = true;
            this.sql = string;
            this.lastExecutionDuration = l;
            dataStore.setOriginalConnection(this.dbConnection);
            dataStore.setProgressMonitor(null);
            this.clearStatusMessage();
            WbSwingUtilities.invoke(() -> {
                this.dataTable.reset();
                this.dataTable.setAutoCreateColumnsFromModel(true);
                this.dataTable.setModel(new DataStoreTableModel(dataStore), true);
                this.setPrintHeader(this.sql);
                this.checkResultSetActions();
                this.dataTable.applyHighlightExpression(dataStore.getGeneratingFilter());
                if (GuiSettings.getShowTableRowNumbers()) {
                    TableRowHeader.showRowHeader(this.dataTable);
                }
                if (this.enableSqlInfo && GuiSettings.getShowResultSQL()) {
                    this.showSQLInfo();
                }
            });
        }
        finally {
            this.setBatchUpdate(false);
        }
    }

    private JTabbedPane getTabParent() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JTabbedPane)) continue;
            return (JTabbedPane)container;
        }
        return null;
    }

    private int getTabIndex(JTabbedPane jTabbedPane) {
        if (jTabbedPane == null) {
            return -1;
        }
        int n = jTabbedPane.indexOfComponent(this);
        if (n == -1) {
            n = jTabbedPane.indexOfComponent(this.getParent());
        }
        return n;
    }

    private boolean maxRowsReached() {
        if (!GuiSettings.getShowMaxRowsReached()) {
            return false;
        }
        int n = this.getMaxRows();
        int n2 = this.getTable().getRowCount();
        boolean bl = n > 0 && (n == n2 || n == n2 - 1);
        return bl;
    }

    private void clearWarningIcon() {
        JTabbedPane jTabbedPane = this.getTabParent();
        int n = this.getTabIndex(jTabbedPane);
        if (n > -1) {
            jTabbedPane.setIconAt(n, null);
        }
    }

    public void showGeneratingSQLAsTooltip() {
        this.showGeneratingSQLAsTooltip(this.maxRowsReached(), GuiSettings.getDataTooltipType());
    }

    public void showGeneratingSQLAsTooltip(boolean bl) {
        this.showGeneratingSQLAsTooltip(bl, GuiSettings.getDataTooltipType());
    }

    public void showGeneratingSQLAsTooltip(DataTooltipType dataTooltipType) {
        this.showGeneratingSQLAsTooltip(this.maxRowsReached(), dataTooltipType);
    }

    public void showGeneratingSQLAsTooltip(boolean bl, DataTooltipType dataTooltipType) {
        if (this.sql == null) {
            return;
        }
        if (dataTooltipType == DataTooltipType.none) {
            this.showSQLAsTooltip = false;
            return;
        }
        JTabbedPane jTabbedPane = this.getTabParent();
        int n = this.getTabIndex(jTabbedPane);
        if (n == -1) {
            return;
        }
        DataStore dataStore = this.getDataStore();
        if (dataStore == null) {
            return;
        }
        String string = StringUtil.formatIsoTimestamp(dataStore.getLoadedAt());
        String string2 = ResourceMgr.getFormattedString("TxtLastExec", string);
        String string3 = "<html>";
        if (bl) {
            string3 = string3 + "<b>" + ResourceMgr.getString("MsgRetrieveAbort") + "</b><br>";
        }
        string3 = string3 + "(" + string2 + ")";
        if (dataTooltipType == DataTooltipType.full) {
            string3 = string3 + "<br><pre>" + HtmlUtil.escapeXML(this.sql.trim(), false) + "</pre></html>";
        }
        jTabbedPane.setToolTipTextAt(n, string3);
        this.showSQLAsTooltip = true;
        if (this.sqlInfo != null) {
            this.sqlInfo.setToolTipText(string3);
        }
    }

    public void checkLimitReachedDisplay() {
        JTabbedPane jTabbedPane = this.getTabParent();
        int n = this.getTabIndex(jTabbedPane);
        if (n > -1) {
            boolean bl = this.maxRowsReached();
            if (bl) {
                jTabbedPane.setIconAt(n, this.getWarningIcon());
                JComponent jComponent = (JComponent)jTabbedPane.getTabComponentAt(n);
                if (GuiSettings.getShowMaxRowsTooltip()) {
                    WbSwingUtilities.showToolTip(jComponent, "<html><p style=\"margin-top:10px;margin-bottom:10px;margin-left:5px;margin-right:5px\">" + ResourceMgr.getString("MsgRetrieveAbort") + "</p></html>");
                }
            } else {
                this.clearWarningIcon();
            }
        }
    }

    private ImageIcon getWarningIcon() {
        return IconMgr.getInstance().getLabelIcon("alert");
    }

    public void readColumnComments() {
        DataStore dataStore = this.getDataStore();
        if (dataStore == null) {
            return;
        }
        try {
            this.setStatusMessage(ResourceMgr.getString("MsgRetrievingColComments"));
            ResultColumnMetaData resultColumnMetaData = new ResultColumnMetaData(dataStore);
            resultColumnMetaData.retrieveColumnRemarks(dataStore.getResultInfo());
            this.dataTable.adjustColumns();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error reading comments", exception);
        }
        finally {
            this.clearStatusMessage();
        }
    }

    private void checkResultSetActions() {
        if (this.disconnected) {
            this.disableUpdateActions();
            if (this.selectKeys != null) {
                this.selectKeys.setEnabled(false);
            }
            return;
        }
        boolean bl = this.hasResultSet();
        int n = this.getTable().getSelectedRowCount();
        if (this.readOnly) {
            this.disableUpdateActions();
        } else {
            if (this.updateAction != null) {
                this.updateAction.setEnabled(GuiSettings.getAlwaysEnableSaveButton() || this.isModified());
            }
            if (this.duplicateRow != null) {
                this.duplicateRow.setEnabled(n == 1);
            }
            if (this.deleteRow != null) {
                this.deleteRow.setEnabled(n > 0);
            }
            if (this.insertRow != null) {
                this.insertRow.setEnabled(bl);
            }
            if (this.deleteDependentRow != null) {
                this.deleteDependentRow.setEnabled(n > 0);
            }
        }
        this.dataTable.setReadOnly(this.readOnly);
        this.dataTable.setAllowEditMode(true);
        if (this.selectKeys != null) {
            this.selectKeys.setEnabled(bl);
        }
        this.dataTable.checkCopyActions();
    }

    public void rowCountChanged() {
        if (this.isVisible()) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            n = this.dataTable.getFirstVisibleRow();
            n2 = this.dataTable.getLastVisibleRow();
            n3 = this.dataTable.getRowCount();
            this.statusBar.setRowcount(n + 1, n2 + 1, n3);
        }
    }

    @Override
    public int duplicateRow() {
        if (this.dataTable.getSelectedRowCount() != 1) {
            return -1;
        }
        int n = this.dataTable.getSelectedRow();
        if (n < 0) {
            return -1;
        }
        if (this.readOnly) {
            return -1;
        }
        if (!this.startEdit(false)) {
            return -1;
        }
        int n2 = this.dataTable.duplicateRow(n);
        if (n2 >= 0) {
            EventQueue.invokeLater(() -> {
                this.dataTable.getSelectionModel().setSelectionInterval(n2, n2);
                this.dataTable.setEditingRow(n2);
                this.dataTable.setEditingColumn(1);
                this.dataTable.editCellAt(n2, 1);
                TableCellEditor tableCellEditor = this.dataTable.getCellEditor(n2, 1);
                if (tableCellEditor instanceof WbTextCellEditor) {
                    ((WbTextCellEditor)tableCellEditor).requestFocus();
                }
                this.rowCountChanged();
            });
        }
        return n2;
    }

    @Override
    public void deleteRowWithDependencies() {
        if (this.readOnly) {
            return;
        }
        if (!this.startEdit(true)) {
            return;
        }
        this.setStatusMessage(ResourceMgr.getFormattedString("MsgCalcDependencies", this.getUpdateTable()));
        final DwPanel dwPanel = this;
        WbSwingUtilities.showWaitCursor(this);
        WbThread wbThread = new WbThread("DeleteDependency"){

            @Override
            public void run() {
                try {
                    DwPanel.this.dbConnection.setBusy(true);
                    DwPanel.this.dataTable.deleteRow(true);
                    DwPanel.this.rowCountChanged();
                }
                catch (SQLException sQLException) {
                    LogMgr.logError(new CallerInfo(){}, "Error deleting row from table", sQLException);
                    WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(sQLException));
                }
                finally {
                    DwPanel.this.dbConnection.setBusy(false);
                    DwPanel.this.clearStatusMessage();
                    WbSwingUtilities.showDefaultCursor(dwPanel);
                }
            }
        };
        wbThread.start();
    }

    private boolean isLastRowSelected() {
        int[] nArray = this.dataTable.getSelectedRows();
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        return nArray[nArray.length - 1] == this.dataTable.getRowCount() - 1;
    }

    @Override
    public void deleteRow() {
        if (this.readOnly) {
            return;
        }
        if (!this.startEdit(true)) {
            return;
        }
        try {
            boolean bl = this.isLastRowSelected();
            this.dataTable.deleteRow(false);
            this.rowCountChanged();
            if (bl) {
                EventQueue.invokeLater(this.dataTable::clearSelection);
            }
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Error deleting row from table", sQLException);
            WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(sQLException));
        }
    }

    @Override
    public int addRow() {
        if (this.readOnly) {
            return -1;
        }
        if (!this.startEdit()) {
            return -1;
        }
        int n = this.dataTable.addRow();
        if (n > -1) {
            this.rowCountChanged();
        }
        return n;
    }

    @Override
    public boolean confirmCancel() {
        return true;
    }

    @Override
    public void cancelExecution() {
        if (this.stmtRunner != null) {
            this.stmtRunner.cancel();
        }
    }

    public boolean hasResultSet() {
        return this.hasResultSet;
    }

    public boolean isModified() {
        DataStore dataStore = this.dataTable.getDataStore();
        if (dataStore == null) {
            return false;
        }
        return dataStore.isModified();
    }

    private void initLayout(DwStatusBar dwStatusBar) {
        this.setLayout(new BorderLayout());
        this.setBorder(WbSwingUtilities.EMPTY_BORDER);
        this.dataTable = new WbTable(true, true, true);
        this.dataTable.showInputFormAction();
        this.dataTable.setRowResizeAllowed(GuiSettings.getAllowRowHeightResizing());
        if (dwStatusBar != null) {
            this.statusBar = dwStatusBar;
            this.sharedStatusBar = true;
        } else {
            this.statusBar = new DwStatusBar(true, false);
            this.sharedStatusBar = false;
            this.add((Component)this.statusBar, "South");
        }
        this.statusBar.setFocusable(false);
        this.setFocusable(false);
        this.scrollPane = new WbScrollPane(this.dataTable);
        this.scrollPane.getViewport().addChangeListener(this);
        this.add((Component)this.scrollPane, "Center");
        this.dataTable.setBorder(WbSwingUtilities.EMPTY_BORDER);
        this.dataTable.setAdjustToColumnLabel(true);
    }

    public int getVerticalScrollBarWidth() {
        if (this.scrollPane == null) {
            return 0;
        }
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        if (jScrollBar != null) {
            return jScrollBar.getWidth();
        }
        return 0;
    }

    public void hideSQLInfo() {
        if (this.sqlInfo != null) {
            this.remove(this.sqlInfo);
            this.sqlInfo = null;
        }
    }

    public void showSQLInfo() {
        if (this.sqlInfo == null) {
            this.sqlInfo = new JLabel("");
            CompoundBorder compoundBorder = new CompoundBorder(new EtchedBorder(1), new EmptyBorder(1, 1, 1, 1));
            compoundBorder = new CompoundBorder(new EmptyBorder(2, 1, 5, 1), compoundBorder);
            this.sqlInfo.setBorder(compoundBorder);
            this.add((Component)this.sqlInfo, "North");
        }
        this.sqlInfo.setText(SqlUtil.makeCleanSql(this.sql == null ? "" : this.sql, false, false, true, this.dbConnection));
    }

    private void updateSqlInfoTooltip() {
        JTabbedPane jTabbedPane = this.getTabParent();
        int n = this.getTabIndex(jTabbedPane);
        if (n == -1) {
            return;
        }
        String string = jTabbedPane.getToolTipTextAt(n);
        if (this.sqlInfo != null) {
            this.sqlInfo.setToolTipText(string);
        }
    }

    public void updateStatusBar() {
        if (this.isVisible()) {
            this.rowCountChanged();
            if (GuiSettings.getShowSelectionSummary() && this.statusBar != null) {
                this.statusBar.showSelectionIndicator(this.dataTable);
            }
        }
    }

    @Override
    public void doRepaint() {
        this.statusBar.doRepaint();
    }

    @Override
    public String getText() {
        return this.statusBar.getText();
    }

    @Override
    public void setStatusMessage(String string) {
        this.statusBar.setStatusMessage(string);
    }

    @Override
    public void setStatusMessage(String string, int n) {
        this.statusBar.setStatusMessage(string, n);
    }

    @Override
    public void clearStatusMessage() {
        this.statusBar.clearStatusMessage();
    }

    public void showError(String string) {
        this.setMessageDisplayModel(this.getErrorTableModel(string));
    }

    protected void setMessageDisplayModel(TableModel tableModel) {
        if (this.dataTable.getModel() == tableModel) {
            return;
        }
        WbSwingUtilities.invoke(() -> {
            this.dataTable.setModel(tableModel);
            TableColumnModel tableColumnModel = this.dataTable.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(0);
            tableColumn.setPreferredWidth(this.getWidth() - 10);
            this.statusBar.setRowcount(0, 0, 0);
        });
    }

    public void clearContent() {
        this.dataTable.reset();
        this.hasResultSet = false;
        this.sql = null;
        this.selectKeys.setEnabled(false);
        this.clearWarningIcon();
        this.statusBar.removeSelectionIndicator(this.dataTable);
        this.lastMessage = null;
        if (!this.sharedStatusBar) {
            this.statusBar.clearRowcount();
            this.statusBar.clearExecutionTime();
        }
        this.checkResultSetActions();
    }

    @Override
    public int getActionOnError(int n, String string, String string2, String string3) {
        String string4 = ResourceMgr.getFormattedString("ErrUpdateSqlError", NumberStringCache.getNumberString(n), StringUtil.getMaxSubstring(string2, 50), string3);
        Window window = SwingUtilities.getWindowAncestor(this);
        int n2 = WbSwingUtilities.getYesNoIgnoreAll(window, string4);
        int n3 = 3;
        if (n2 == 0) {
            n3 = 1;
        } else if (n2 == 2042) {
            n3 = 2;
        }
        return n3;
    }

    private TableModel getErrorTableModel(String string) {
        String string2 = ResourceMgr.getString("ErrMessageTitle");
        OneLineTableModel oneLineTableModel = new OneLineTableModel(string2, string);
        return oneLineTableModel;
    }

    public WbTable getTable() {
        return this.dataTable;
    }

    @Override
    public void endEdit() {
        if (!this.isEditingStarted()) {
            return;
        }
        this.dataTable.stopEditing();
        this.dataTable.hideStatusColumn();
        this.checkResultSetActions();
        this.updateAction.setEnabled(GuiSettings.getAlwaysEnableSaveButton());
        this.dataTable.restoreOriginalValues();
        TableRowHeader tableRowHeader = TableRowHeader.getRowHeader(this.dataTable);
        if (tableRowHeader != null) {
            tableRowHeader.rowHeightChanged();
        }
    }

    @Override
    public boolean startEdit() {
        return this.startEdit(true);
    }

    public boolean isEditingStarted() {
        return this.dataTable.isStatusColumnVisible();
    }

    public boolean startEdit(boolean bl) {
        if (this.readOnly) {
            return false;
        }
        int[] nArray = this.dataTable.getSelectedRows();
        int n = this.dataTable.getEditingRow();
        int n2 = this.dataTable.isStatusColumnVisible() ? 0 : 1;
        int n3 = this.dataTable.getEditingColumn() + n2;
        Window window = SwingUtilities.getWindowAncestor(this);
        TableCheck tableCheck = this.checkUpdateTable();
        if (tableCheck == TableCheck.cancel) {
            return false;
        }
        boolean bl2 = this.isUpdateable();
        if (!(bl2 || tableCheck != TableCheck.noTable && tableCheck != TableCheck.noTableColumns)) {
            if (tableCheck == TableCheck.noTableColumns) {
                WbSwingUtilities.showErrorMessageKey(window, "MsgNoTableColumns");
            } else {
                WbSwingUtilities.showErrorMessageKey(window, "MsgNoTables");
            }
            this.setUpdateTable(null);
            this.disableUpdateActions();
            this.selectKeys.setEnabled(false);
            return false;
        }
        if (bl2) {
            Object object;
            List<String> list = null;
            if (this.dataTable.isColumnOrderChanged()) {
                list = ColumnOrderMgr.getInstance().getColumnOrder(this.dataTable);
            }
            this.dataTable.showStatusColumn();
            if (list != null) {
                object = this.dataTable.getColumnModel().getColumn(0).getIdentifier().toString();
                list.add(0, (String)object);
            }
            if (bl) {
                if (n > -1 && n3 > -1) {
                    this.dataTable.selectCell(n, n3);
                    this.dataTable.setColumnSelectionAllowed(false);
                } else if (n > -1) {
                    this.dataTable.scrollToRow(n);
                    this.dataTable.setRowSelectionInterval(n, n);
                } else if (nArray != null) {
                    object = this.dataTable.getSelectionModel();
                    object.setValueIsAdjusting(true);
                    object.clearSelection();
                    for (int i = 0; i < nArray.length; ++i) {
                        object.addSelectionInterval(nArray[i], nArray[i]);
                    }
                    object.setValueIsAdjusting(false);
                }
                if (list != null) {
                    ColumnOrderMgr.getInstance().applyColumnOrder(this.dataTable, list, true);
                }
                this.dataTable.requestFocusInWindow();
            }
            WbSwingUtilities.invoke(this::checkResultSetActions);
        } else {
            String string = null;
            String string2 = this.getUpdateTable();
            if (string2 == null) {
                string = ResourceMgr.getString("MsgNoUpdateTable");
            } else if (!this.hasUpdateableColumns()) {
                string = ResourceMgr.getString("MsgNoUpdateColumns");
                string = StringUtil.replace(string, "%table%", string2);
            }
            WbSwingUtilities.showErrorMessage(window, string);
        }
        return bl2;
    }

    public InsertRowAction getInsertRowAction() {
        return this.insertRow;
    }

    public CopyRowAction getCopyRowAction() {
        return this.duplicateRow;
    }

    public DeleteRowAction getDeleteRowAction() {
        return this.deleteRow;
    }

    public DeleteDependentRowsAction getDeleteDependentRowsAction() {
        return this.deleteDependentRow;
    }

    public UpdateDatabaseAction getUpdateDatabaseAction() {
        return this.updateAction;
    }

    public void setBatchUpdate(boolean bl) {
        this.batchUpdate = bl;
    }

    public RowActionMonitor getRowMonitor() {
        return this.genericRowMonitor;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        boolean bl;
        if (this.batchUpdate) {
            return;
        }
        if (this.readOnly) {
            return;
        }
        boolean bl2 = this.isEditingStarted();
        boolean bl3 = this.isModified();
        int n = tableModelEvent.getFirstRow();
        boolean bl4 = bl = n == -1 || n == -1;
        if (bl3 && !bl) {
            EventQueue.invokeLater(() -> {
                if (!bl2) {
                    this.startEdit();
                }
                this.checkResultSetActions();
            });
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("readonly") && propertyChangeEvent.getSource() == this.dbConnection) {
            this.setReadOnly(this.dbConnection.isSessionReadOnly());
        }
        if (propertyChangeEvent.getPropertyName().equals("workbench.gui.display.result.sql")) {
            if (GuiSettings.getShowResultSQL()) {
                this.showSQLInfo();
                this.updateSqlInfoTooltip();
            } else {
                this.hideSQLInfo();
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.readOnly) {
            this.disableUpdateActions();
        } else {
            this.checkResultSetActions();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.rowCountChanged();
    }

    @Override
    public void fatalError(String string) {
        WbSwingUtilities.showFriendlyErrorMessage(this, string);
    }

    private static enum TableCheck {
        tableOk,
        cancel,
        noTable,
        noTableColumns;

    }
}

