/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import workbench.WbManager;
import workbench.db.ColumnIdentifier;
import workbench.db.importer.ImportOptions;
import workbench.db.importer.TextFileParser;
import workbench.db.importer.TextImportOptions;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.dialogs.dataimport.GeneralImportOptionsPanel;
import workbench.gui.dialogs.dataimport.TextOptionsPanel;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.ResultInfo;
import workbench.util.ClipboardFile;

public class ImportStringVerifier {
    private ResultInfo target;
    private String content;
    private JPanel optionsPanel;
    private TextOptionsPanel textOptions;
    private GeneralImportOptionsPanel generalOptions;
    private boolean columnNamesMatched;
    private boolean columnCountMatched;

    public ImportStringVerifier(String string, ResultInfo resultInfo) {
        this.target = resultInfo;
        this.content = string;
    }

    public boolean checkData() {
        ClipboardFile clipboardFile = new ClipboardFile(this.content);
        TextFileParser textFileParser = new TextFileParser(clipboardFile);
        textFileParser.setContainsHeader(true);
        if (this.textOptions != null) {
            if (!this.textOptions.getContainsHeader()) {
                return true;
            }
            textFileParser.setTextDelimiter(this.textOptions.getTextDelimiter());
        }
        List<ColumnIdentifier> list = textFileParser.getColumnsFromFile();
        int n = 0;
        for (ColumnIdentifier columnIdentifier : list) {
            int n2 = this.target.findColumn(columnIdentifier.getColumnName());
            if (n2 <= -1) continue;
            ++n;
        }
        this.columnCountMatched = list.size() == this.target.getColumnCount();
        this.columnNamesMatched = n > 0;
        return this.columnCountMatched || this.columnNamesMatched;
    }

    public boolean columnNamesMatched() {
        return this.columnNamesMatched;
    }

    private void createOptionsPanel() {
        if (this.optionsPanel != null) {
            return;
        }
        this.textOptions = new TextOptionsPanel();
        this.textOptions.restoreSettings("clipboard");
        if (this.columnCountMatched && !this.columnNamesMatched) {
            this.textOptions.setContainsHeader(false);
        }
        this.generalOptions = new GeneralImportOptionsPanel();
        this.generalOptions.setModeSelectorEnabled(false);
        this.generalOptions.setEncodingVisible(false);
        this.generalOptions.restoreSettings("clipboard");
        this.optionsPanel = new JPanel(new BorderLayout());
        this.optionsPanel.add((Component)this.generalOptions, "North");
        this.optionsPanel.add((Component)this.textOptions, "South");
    }

    public boolean showOptionsDialog() {
        this.createOptionsPanel();
        JPanel jPanel = new JPanel(new BorderLayout(0, 5));
        JTextArea jTextArea = new JTextArea();
        StringBuilder stringBuilder = this.getLines(this.content, 15);
        int n = stringBuilder.length();
        for (int i = 0; i < n; ++i) {
            if (stringBuilder.charAt(i) != '\t') continue;
            stringBuilder.setCharAt(i, '\u00bb');
        }
        jTextArea.setText(stringBuilder.toString());
        jTextArea.setFont(Settings.getInstance().getEditorFont());
        jTextArea.setEditable(false);
        jTextArea.setDisabledTextColor(jTextArea.getForeground());
        jTextArea.setCaretPosition(0);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        Dimension dimension = new Dimension(350, 250);
        jTextArea.setMaximumSize(dimension);
        jScrollPane.setMaximumSize(dimension);
        jScrollPane.setPreferredSize(dimension);
        JTextField jTextField = new JTextField();
        jTextField.setEnabled(false);
        jTextField.setText(ResourceMgr.getString("MsgClipFormat"));
        jTextField.setBackground(UIManager.getColor("TextArea.background"));
        jTextField.setDisabledTextColor(jTextField.getForeground());
        EmptyBorder emptyBorder = new EmptyBorder(4, 2, 4, 2);
        jTextField.setBorder(emptyBorder);
        jPanel.add((Component)this.optionsPanel, "East");
        jPanel.add((Component)jTextField, "North");
        jPanel.add((Component)jScrollPane, "Center");
        JFrame jFrame = WbManager.getInstance().getCurrentWindow();
        ValidatingDialog validatingDialog = new ValidatingDialog((Frame)jFrame, "Import", (JComponent)jPanel);
        WbSwingUtilities.center(validatingDialog, jFrame);
        validatingDialog.setVisible(true);
        boolean bl = !validatingDialog.isCancelled();
        this.textOptions.saveSettings("clipboard");
        this.generalOptions.saveSettings("clipboard");
        return bl;
    }

    public ImportOptions getImportOptions() {
        return this.generalOptions;
    }

    public TextImportOptions getTextImportOptions() {
        return this.textOptions;
    }

    public final StringBuilder getLines(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(n * 100);
        try {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            String string2 = bufferedReader.readLine();
            for (int i = 0; string2 != null && i < n; ++i) {
                stringBuilder.append(string2);
                stringBuilder.append('\n');
                string2 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuilder;
    }
}

