/*
 * Decompiled with CFR 0.152.
 */
package workbench.print;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.MatteBorder;
import workbench.WbManager;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.WbFontChooser;
import workbench.gui.components.WbToolbar;
import workbench.gui.components.WbToolbarButton;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.print.PrintUtil;
import workbench.print.TablePrinter;
import workbench.resource.GuiSettings;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.WbThread;

public class PrintPreview
extends JDialog
implements ActionListener,
WindowListener {
    public static final String PROP_SHOW_SQLHEADER = "workbench.print.showsql";
    public static final String PROP_ALTERNATE_COLORS = "workbench.print.alternate.colors";
    protected int pageWidth;
    protected int pageHeight;
    private int scale = 100;
    protected TablePrinter printTarget;
    protected JComboBox cbZoom;
    private JButton pageSetupButton;
    private JButton printButton;
    private JButton chooseFontButton;
    private JButton closeButton;
    private JButton pageRight;
    private JButton pageLeft;
    private JButton pageDown;
    private JButton pageUp;
    private JCheckBox showSQL;
    private JCheckBox useAlternateColor;
    private boolean hasHorizontalPages;
    private JScrollPane scroll;
    private PreviewContainer preview;
    private PagePreview pageDisplay;
    private int currentPage = 0;
    private boolean pageDialogShowing = false;

    public PrintPreview(JFrame jFrame, TablePrinter tablePrinter) {
        super(jFrame, ResourceMgr.getString("TxtPrintPreviewWindowTitle"), true);
        if (!Settings.getInstance().restoreWindowSize(this)) {
            this.setSize(500, 600);
        }
        if (!Settings.getInstance().restoreWindowPosition(this)) {
            WbSwingUtilities.center(this, jFrame);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.printTarget = tablePrinter;
        WbToolbar wbToolbar = new WbToolbar();
        wbToolbar.addDefaultBorder();
        this.printButton = new WbToolbarButton(ResourceMgr.getString("LblPrintButton"));
        this.printButton.addActionListener(this);
        wbToolbar.add(this.printButton);
        wbToolbar.addSeparator();
        this.chooseFontButton = new WbToolbarButton(ResourceMgr.getString("LblSelectPrintFont"));
        this.chooseFontButton.addActionListener(this);
        wbToolbar.add(this.chooseFontButton);
        wbToolbar.addSeparator();
        this.pageSetupButton = new WbToolbarButton(ResourceMgr.getString("LblPageSetupButton"));
        this.pageSetupButton.addActionListener(this);
        wbToolbar.add(this.pageSetupButton);
        boolean bl = Settings.getInstance().getBoolProperty(PROP_SHOW_SQLHEADER, true);
        this.printTarget.setShowHeader(bl);
        this.showSQL = new JCheckBox(ResourceMgr.getString("LblPrintShowSQL"));
        this.showSQL.setSelected(bl);
        this.showSQL.addActionListener(this);
        wbToolbar.add(this.showSQL);
        Color color = GuiSettings.getAlternateRowColor();
        boolean bl2 = Settings.getInstance().getBoolProperty(PROP_ALTERNATE_COLORS, false);
        this.useAlternateColor = new JCheckBox(ResourceMgr.getString("LblPrintAltColor"));
        this.useAlternateColor.setSelected(bl2);
        this.useAlternateColor.setEnabled(color != null);
        this.useAlternateColor.addActionListener(this);
        wbToolbar.add(this.useAlternateColor);
        wbToolbar.addSeparator();
        this.pageDown = new WbToolbarButton(IconMgr.getInstance().getLabelIcon("Down"));
        this.pageDown.addActionListener(this);
        this.pageDown.setEnabled(false);
        wbToolbar.add(this.pageDown);
        this.pageUp = new WbToolbarButton(IconMgr.getInstance().getLabelIcon("Up"));
        this.pageUp.addActionListener(this);
        this.pageUp.setEnabled(false);
        wbToolbar.add(this.pageUp);
        this.pageLeft = new WbToolbarButton(IconMgr.getInstance().getLabelIcon("Back"));
        this.pageLeft.addActionListener(this);
        this.pageLeft.setEnabled(false);
        wbToolbar.add(this.pageLeft);
        this.pageRight = new WbToolbarButton(IconMgr.getInstance().getLabelIcon("Forward"));
        this.pageRight.addActionListener(this);
        this.pageRight.setEnabled(false);
        wbToolbar.add(this.pageRight);
        this.hasHorizontalPages = this.printTarget.getPagesAcross() > 1;
        this.pageLeft.setVisible(this.hasHorizontalPages);
        this.pageLeft.setVisible(this.hasHorizontalPages);
        wbToolbar.addSeparator();
        String[] stringArray = new String[]{"10%", "25%", "50%", "100%", "150%"};
        this.cbZoom = new JComboBox<String>(stringArray);
        Dimension dimension = this.cbZoom.getPreferredSize();
        Dimension dimension2 = new Dimension((int)dimension.getWidth() + 10, (int)dimension.getHeight());
        this.cbZoom.setMaximumSize(dimension2);
        this.cbZoom.setEditable(true);
        this.cbZoom.setSelectedItem("100%");
        this.cbZoom.addActionListener(this);
        wbToolbar.add(this.cbZoom);
        wbToolbar.addSeparator();
        this.closeButton = new WbToolbarButton(ResourceMgr.getString("LblClose"));
        this.closeButton.addActionListener(this);
        wbToolbar.add(this.closeButton);
        this.getContentPane().add((Component)wbToolbar, "North");
        this.addWindowListener(this);
        this.preview = new PreviewContainer();
        this.pageDisplay = new PagePreview();
        this.preview.add(this.pageDisplay);
        this.showCurrentPage();
        this.scroll = new JScrollPane(this.preview);
        this.adjustScrollbar();
        this.getContentPane().add((Component)this.scroll, "Center");
        this.setDefaultCloseOperation(2);
    }

    private void selectPrintFont() {
        Font font = WbFontChooser.chooseFont(this.getRootPane(), this.printTarget.getFont(), false);
        if (font != null) {
            Settings.getInstance().setPrintFont(font);
            this.printTarget.setFont(font);
            this.currentPage = 0;
            WbThread wbThread = new WbThread("PrintPreview update font"){

                @Override
                public void run() {
                    PrintPreview.this.invalidate();
                    PrintPreview.this.showCurrentPage();
                    PrintPreview.this.repaint();
                }
            };
            wbThread.start();
        }
    }

    private void adjustScrollbar() {
        this.scroll.getVerticalScrollBar().setBlockIncrement((int)this.printTarget.getPageFormat().getImageableHeight());
        Font font = this.printTarget.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.scroll.getVerticalScrollBar().setUnitIncrement(fontMetrics.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showCurrentPage() {
        WbSwingUtilities.showWaitCursorOnWindow(this);
        this.hasHorizontalPages = this.printTarget.getPagesAcross() > 1;
        this.pageLeft.setVisible(this.hasHorizontalPages);
        this.pageLeft.setVisible(this.hasHorizontalPages);
        try {
            PageFormat pageFormat = this.printTarget.getPageFormat();
            this.pageWidth = (int)pageFormat.getWidth();
            this.pageHeight = (int)pageFormat.getHeight();
            int n = this.pageWidth * this.scale / 100;
            int n2 = this.pageHeight * this.scale / 100;
            try {
                BufferedImage bufferedImage = new BufferedImage(this.pageWidth, this.pageHeight, 1);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(0, 0, this.pageWidth, this.pageHeight);
                graphics2D.setColor(Color.LIGHT_GRAY);
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(new BasicStroke(0.2f));
                graphics2D.drawRect((int)pageFormat.getImageableX() - 1, (int)pageFormat.getImageableY() - 1, (int)pageFormat.getImageableWidth() + 1, (int)pageFormat.getImageableHeight() + 1);
                graphics2D.setStroke(stroke);
                if (this.printTarget.print(graphics2D, pageFormat, this.currentPage) == 0) {
                    this.pageDisplay.setImage(n, n2, bufferedImage);
                }
            }
            catch (PrinterException printerException) {
                LogMgr.logError(new CallerInfo(){}, "Error when creating preview", printerException);
                WbSwingUtilities.showErrorMessage(this, ResourceMgr.getString("MsgPrintPreviewError") + "\n" + printerException.getMessage());
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            WbManager.getInstance().showOutOfMemoryError();
            this.pageDisplay.setImage(0, 0, null);
        }
        finally {
            WbSwingUtilities.repaintLater(this);
            WbSwingUtilities.showDefaultCursorOnWindow(this);
        }
        this.pageUp.setEnabled(this.printTarget.getPreviousVerticalPage(this.currentPage) != -1);
        this.pageDown.setEnabled(this.printTarget.getNextVerticalPage(this.currentPage) != -1);
        this.pageLeft.setVisible(this.hasHorizontalPages);
        this.pageRight.setVisible(this.hasHorizontalPages);
        if (this.hasHorizontalPages) {
            this.pageLeft.setEnabled(this.printTarget.getPreviousHorizontalPage(this.currentPage) != -1);
            this.pageRight.setEnabled(this.printTarget.getNextHorizontalPage(this.currentPage) != -1);
        }
    }

    public void doPrint() {
        try {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPrintable(this.printTarget, this.printTarget.getPageFormat());
            printerJob.setPageable(this.printTarget);
            if (!printerJob.printDialog()) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            printerJob.print();
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.dispose();
        }
        catch (PrinterException printerException) {
            LogMgr.logError(new CallerInfo(){}, "Error when printing", printerException);
        }
    }

    protected void showCrossPlatformPageSetup() {
        if (this.pageDialogShowing) {
            return;
        }
        this.pageDialogShowing = true;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = this.printTarget.getPageFormat();
        PrintRequestAttributeSet printRequestAttributeSet = PrintUtil.getPrintAttributes(pageFormat);
        PageFormat pageFormat2 = printerJob.pageDialog(printRequestAttributeSet);
        this.pageDialogShowing = false;
        this.applyNewPage(pageFormat2, pageFormat);
    }

    protected void showNativePageSetup() {
        if (this.pageDialogShowing) {
            return;
        }
        this.pageDialogShowing = true;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = this.printTarget.getPageFormat();
        PageFormat pageFormat2 = printerJob.pageDialog(pageFormat);
        this.pageDialogShowing = false;
        this.applyNewPage(pageFormat2, pageFormat);
    }

    protected void applyNewPage(PageFormat pageFormat, PageFormat pageFormat2) {
        if (pageFormat == null) {
            return;
        }
        if (!PrintUtil.pageFormatEquals(pageFormat, pageFormat2)) {
            Settings.getInstance().setPageFormat(pageFormat);
            EventQueue.invokeLater(() -> {
                this.printTarget.setPageFormat(pageFormat);
                this.showCurrentPage();
                this.invalidate();
                this.preview.validate();
                this.preview.doLayout();
            });
        }
    }

    public void doPageSetup() {
        if (Settings.getInstance().getShowNativePageDialog()) {
            WbThread wbThread = new WbThread("PageSetup Thread"){

                @Override
                public void run() {
                    PrintPreview.this.showNativePageSetup();
                }
            };
            wbThread.start();
        } else {
            EventQueue.invokeLater(this::showCrossPlatformPageSetup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeZoom() {
        WbSwingUtilities.showWaitCursor(this);
        try {
            Component[] componentArray;
            String string = this.cbZoom.getSelectedItem().toString();
            if (string.endsWith("%")) {
                string = string.substring(0, string.length() - 1);
            }
            string = string.trim();
            try {
                this.scale = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.preview.validate();
                this.preview.doLayout();
                WbSwingUtilities.showDefaultCursor(this);
                return;
            }
            int n = this.pageWidth * this.scale / 100;
            int n2 = this.pageHeight * this.scale / 100;
            for (Component component : componentArray = this.preview.getComponents()) {
                if (!(component instanceof PagePreview)) continue;
                PagePreview pagePreview = (PagePreview)component;
                pagePreview.setScaledSize(n, n2);
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error when changing the zoom factor", throwable);
        }
        finally {
            this.preview.validate();
            this.preview.doLayout();
            WbSwingUtilities.showDefaultCursor(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.showSQL) {
            Settings.getInstance().setProperty(PROP_SHOW_SQLHEADER, this.showSQL.isSelected());
            this.printTarget.setShowHeader(this.showSQL.isSelected());
            this.showCurrentPage();
        } else if (actionEvent.getSource() == this.useAlternateColor) {
            Settings.getInstance().setProperty(PROP_ALTERNATE_COLORS, this.useAlternateColor.isSelected());
            this.printTarget.setUseAlternateColor(this.useAlternateColor.isSelected());
            this.showCurrentPage();
        } else if (actionEvent.getSource() == this.printButton) {
            this.doPrint();
        } else if (actionEvent.getSource() == this.pageSetupButton) {
            this.doPageSetup();
        } else if (actionEvent.getSource() == this.chooseFontButton) {
            this.selectPrintFont();
        } else if (actionEvent.getSource() == this.cbZoom) {
            WbThread wbThread = new WbThread("PrintPreview Zoom thread"){

                @Override
                public void run() {
                    PrintPreview.this.changeZoom();
                }
            };
            wbThread.start();
        } else if (actionEvent.getSource() == this.pageRight) {
            int n = this.printTarget.getNextHorizontalPage(this.currentPage);
            if (n != -1) {
                this.currentPage = n;
            }
            this.showCurrentPage();
        } else if (actionEvent.getSource() == this.pageLeft) {
            int n = this.printTarget.getPreviousHorizontalPage(this.currentPage);
            if (n != -1) {
                this.currentPage = n;
            }
            this.showCurrentPage();
        } else if (actionEvent.getSource() == this.pageUp) {
            int n = this.printTarget.getPreviousVerticalPage(this.currentPage);
            if (n != -1) {
                this.currentPage = n;
                this.showCurrentPage();
            }
        } else if (actionEvent.getSource() == this.pageDown) {
            int n = this.printTarget.getNextVerticalPage(this.currentPage);
            if (n != -1) {
                this.currentPage = n;
                this.showCurrentPage();
            }
        } else if (actionEvent.getSource() == this.closeButton) {
            this.saveSettings();
            this.dispose();
        }
    }

    public void saveSettings() {
        Settings.getInstance().storeWindowSize(this);
        Settings.getInstance().storeWindowPosition(this);
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.saveSettings();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    static class PagePreview
    extends JPanel {
        protected int m_w;
        protected int m_h;
        protected Image m_source;
        protected Image m_img;

        PagePreview() {
        }

        PagePreview(int n, int n2, Image image) {
            this.setImage(n, n2, image);
        }

        public final void setImage(int n, int n2, Image image) {
            this.m_w = n;
            this.m_h = n2;
            this.m_source = image;
            this.m_img = this.m_source.getScaledInstance(this.m_w, this.m_h, 4);
            this.m_img.flush();
            this.setBackground(Color.WHITE);
            this.setBorder(new MatteBorder(1, 1, 2, 2, Color.BLACK));
        }

        public void setScaledSize(int n, int n2) {
            this.m_w = n;
            this.m_h = n2;
            this.m_img = this.m_source.getScaledInstance(this.m_w, this.m_h, 4);
            this.m_img.flush();
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            return new Dimension(this.m_w + insets.left + insets.right, this.m_h + insets.top + insets.bottom);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.m_img != null) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics.drawImage(this.m_img, 0, 0, this);
                this.paintBorder(graphics);
            }
        }
    }

    static class PreviewContainer
    extends JPanel {
        protected int H_GAP = 16;
        protected int V_GAP = 10;

        PreviewContainer() {
        }

        @Override
        public Dimension getPreferredSize() {
            int n = this.getComponentCount();
            if (n == 0) {
                return new Dimension(this.H_GAP, this.V_GAP);
            }
            Component component = this.getComponent(0);
            Dimension dimension = component.getPreferredSize();
            int n2 = dimension.width;
            int n3 = dimension.height;
            Dimension dimension2 = this.getParent().getSize();
            int n4 = Math.max((dimension2.width - this.H_GAP) / (n2 + this.H_GAP), 1);
            int n5 = n / n4;
            if (n5 * n4 < n) {
                ++n5;
            }
            int n6 = n4 * (n2 + this.H_GAP) + this.H_GAP;
            int n7 = n5 * (n3 + this.V_GAP) + this.V_GAP;
            Insets insets = this.getInsets();
            return new Dimension(n6 + insets.left + insets.right, n7 + insets.top + insets.bottom);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void doLayout() {
            Insets insets = this.getInsets();
            int n = insets.left + this.H_GAP;
            int n2 = insets.top + this.V_GAP;
            int n3 = this.getComponentCount();
            if (n3 == 0) {
                return;
            }
            Component component = this.getComponent(0);
            Dimension dimension = component.getPreferredSize();
            int n4 = dimension.width;
            int n5 = dimension.height;
            Dimension dimension2 = this.getParent().getSize();
            int n6 = Math.max((dimension2.width - this.H_GAP) / (n4 + this.H_GAP), 1);
            int n7 = n3 / n6;
            if (n7 * n6 < n3) {
                ++n7;
            }
            int n8 = 0;
            for (int i = 0; i < n7; ++i) {
                for (int j = 0; j < n6; ++j) {
                    if (n8 >= n3) {
                        return;
                    }
                    component = this.getComponent(n8++);
                    component.setBounds(n, n2, n4, n5);
                    n += n4 + this.H_GAP;
                }
                n2 += n5 + this.V_GAP;
                n = insets.left + this.H_GAP;
            }
        }
    }
}

