/*
 * Decompiled with CFR 0.152.
 */
package workbench.resource;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import workbench.gui.WbSwingUtilities;
import workbench.gui.lnf.LnFHelper;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourcePath;
import workbench.resource.Settings;

public class IconMgr {
    public static final String IMG_SAVE = "save";
    public static final int SMALL_ICON = 16;
    public static final int MEDIUM_ICON = 24;
    public static final int LARGE_ICON = 32;
    private final RenderingHints scaleHints;
    private final Map<String, ImageIcon> iconCache = new HashMap<String, ImageIcon>();
    private final String filepath = ResourcePath.ICONS.getPath() + "/";
    private final int menuFontHeight = LnFHelper.getMenuFontHeight();
    private final int labelFontHeight = LnFHelper.getLabelFontHeight();
    private final int toolbarIconSize;
    private final boolean scaleMenuIcons = Settings.getInstance().getScaleMenuIcons();

    public static IconMgr getInstance() {
        return LazyInstanceHolder.INSTANCE;
    }

    private IconMgr() {
        this.toolbarIconSize = this.retrieveToolbarIconSize();
        this.scaleHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.scaleHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        LogMgr.logInfo(new CallerInfo(){}, "Using sizes: toolbar: " + this.toolbarIconSize + ", menu: " + this.getSizeForMenuItem());
    }

    private int retrieveToolbarIconSize() {
        int n;
        int n2 = Settings.getInstance().getToolbarIconSize();
        if (n2 < 16) {
            LogMgr.logError(new CallerInfo(){}, "Invalid icon size: " + n2 + " specified. Reverting to 16!", null);
            n2 = 16;
            Settings.getInstance().setToolbarIconSize(n2);
        }
        if (Settings.getInstance().getScaleMenuIcons() && (n = this.getSizeForMenuItem()) > n2) {
            return n;
        }
        return n2;
    }

    public int getToolbarIconSize() {
        return this.toolbarIconSize;
    }

    public ImageIcon getGifIcon(String string) {
        return this.getIcon(string, this.toolbarIconSize, false);
    }

    public ImageIcon getPicture(String string) {
        return this.retrieveImage(string);
    }

    public ImageIcon getPngIcon(String string, int n) {
        return this.getIcon(string, n, true);
    }

    public ImageIcon getToolbarIcon(String string) {
        return this.getIcon(string.toLowerCase(), this.toolbarIconSize, true);
    }

    public int getSizeForMenuItem() {
        if (this.scaleMenuIcons) {
            return this.getSizeForFont(this.menuFontHeight);
        }
        return 16;
    }

    public int getSizeForLabel() {
        if (this.scaleMenuIcons) {
            return this.getSizeForFont(this.labelFontHeight);
        }
        return 16;
    }

    public int getSizeForFont(int n) {
        if (n < 24) {
            return 16;
        }
        if (n < 32) {
            return 24;
        }
        return 32;
    }

    public int getSizeForComponentFont(JComponent jComponent) {
        int n = 16;
        if (this.scaleMenuIcons) {
            n = WbSwingUtilities.getFontHeight(jComponent);
        }
        return this.getSizeForFont(n);
    }

    public ImageIcon getLabelIcon(String string) {
        int n = this.getSizeForLabel();
        return this.getIcon(string.toLowerCase(), n, true);
    }

    public ImageIcon getLoadingImage(String string) {
        return this.retrieveImage(string + ".gif");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageIcon getIcon(String string, int n, boolean bl) {
        String string2 = this.makeFilename(string, n, bl);
        boolean bl2 = Settings.getInstance().getCacheIcons();
        ImageIcon imageIcon = null;
        IconMgr iconMgr = this;
        synchronized (iconMgr) {
            ImageIcon imageIcon2 = imageIcon = bl2 ? this.iconCache.get(string2) : null;
            if (imageIcon == null) {
                imageIcon = this.retrieveImage(string2);
                if (imageIcon == null) {
                    if (n > 16) {
                        LogMgr.logDebug(new CallerInfo(){}, "Icon " + string2 + " not found. Scaling existing 16px image");
                        ImageIcon imageIcon3 = this.retrieveImage(this.makeBaseFilename(string, bl));
                        imageIcon = this.scale(imageIcon3, n);
                    } else {
                        LogMgr.logWarning(new CallerInfo(){}, "Icon " + string2 + " not found!");
                    }
                }
                if (bl2) {
                    this.iconCache.put(string2, imageIcon);
                }
            }
        }
        return imageIcon;
    }

    private String makeBaseFilename(String string, boolean bl) {
        return this.makeFilename(string, 16, bl);
    }

    private String makeFilename(String string, int n, boolean bl) {
        String string2 = Integer.toString(n);
        if (bl) {
            string = string.toLowerCase();
        }
        return string + (bl ? string2 + ".png" : string2 + ".gif");
    }

    public ImageIcon getExternalImage(String string, int n) {
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(Settings.getInstance().getConfigDir(), string);
        }
        if (!file.exists()) {
            return null;
        }
        ImageIcon imageIcon = null;
        string = file.getAbsolutePath();
        if (Settings.getInstance().getCacheIcons()) {
            imageIcon = this.iconCache.get(string);
        }
        if (imageIcon == null) {
            imageIcon = new ImageIcon(string);
        }
        if (n > 0 && (imageIcon.getIconWidth() > n || imageIcon.getIconHeight() > n)) {
            imageIcon = this.scale(imageIcon, n);
        }
        return imageIcon;
    }

    private ImageIcon retrieveImage(String string) {
        ImageIcon imageIcon = null;
        URL uRL = this.getClass().getClassLoader().getResource(this.filepath + string);
        if (uRL != null) {
            imageIcon = new ImageIcon(uRL);
        }
        return imageIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageIcon scale(ImageIcon imageIcon, int n) {
        if (imageIcon == null) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n, 3);
        Graphics2D graphics2D = null;
        try {
            graphics2D = bufferedImage.createGraphics();
            graphics2D.addRenderingHints(this.scaleHints);
            graphics2D.drawImage(imageIcon.getImage(), 0, 0, n, n, null);
        }
        catch (Throwable throwable) {
            Image image = imageIcon.getImage();
            if (image == null) {
                ImageIcon imageIcon2 = imageIcon;
                return imageIcon2;
            }
            ImageIcon imageIcon3 = new ImageIcon(image.getScaledInstance(n, n, 4));
            return imageIcon3;
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
        return new ImageIcon(bufferedImage);
    }

    private static class LazyInstanceHolder {
        private static final IconMgr INSTANCE = new IconMgr();

        private LazyInstanceHolder() {
        }
    }
}

