/*
 * Decompiled with CFR 0.152.
 */
package workbench.resource;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import workbench.WbManager;
import workbench.db.ConnectionProfile;
import workbench.db.PasswordTrimType;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.lnf.FontScaler;
import workbench.gui.profiles.ProfileKey;
import workbench.gui.settings.ExternalFileHandling;
import workbench.interfaces.FontChangedListener;
import workbench.interfaces.PropertyStorage;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.AutoFileSaveType;
import workbench.resource.ColumnSortType;
import workbench.resource.GeneratedIdentifierCase;
import workbench.resource.MultiRowInserts;
import workbench.resource.ResourceMgr;
import workbench.resource.SettingsListener;
import workbench.resource.ShortcutManager;
import workbench.sql.DelimiterDefinition;
import workbench.sql.ErrorReportLevel;
import workbench.sql.formatter.JoinWrapStyle;
import workbench.storage.PkMapping;
import workbench.util.ClasspathUtil;
import workbench.util.CollectionUtil;
import workbench.util.DurationFormat;
import workbench.util.FileAttributeChanger;
import workbench.util.FileDialogUtil;
import workbench.util.FileUtil;
import workbench.util.PlatformHelper;
import workbench.util.StringUtil;
import workbench.util.ToolDefinition;
import workbench.util.WbFile;
import workbench.util.WbLocale;
import workbench.util.WbNumberFormatter;
import workbench.util.WbProperties;

public class Settings
implements PropertyStorage {
    public static final String PROPERTY_MASTER_PWD = "workbench.profiles.masterpassword";
    public static final String PROPERTY_TRIM_PWD = "workbench.profiles.trimpassword";
    public static final String PROPERTY_DATE_FORMAT = "workbench.gui.display.dateformat";
    public static final String PROPERTY_DATETIME_FORMAT = "workbench.gui.display.datetimeformat";
    public static final String PROPERTY_VARIABLE_LENGTH_TS_FRACTION = "workbench.gui.display.datetimeformat.fractions.variable";
    public static final String PROPERTY_TIME_FORMAT = "workbench.gui.display.timeformat";
    public static final String PROPERTY_SHOW_TOOLBAR = "workbench.gui.mainwindow.showtoolbar";
    public static final String PROPERTY_TAB_POLICY = "workbench.gui.mainwindow.tabpolicy";
    public static final String PROPERTY_SHOW_LINE_NUMBERS = "workbench.editor.showlinenumber";
    public static final String PROPERTY_HIGHLIGHT_CURRENT_STATEMENT = "workbench.editor.highlightcurrent";
    public static final String PROPERTY_AUTO_JUMP_STATEMENT = "workbench.editor.autojumpnext";
    public static final String PROPERTY_DBEXP_REMEMBER_SORT = "workbench.dbexplorer.remembersort";
    public static final String PROPERTY_SHOW_TAB_INDEX = "workbench.gui.tabs.showindex";
    public static final String PROPERTY_EDITOR_FONT = "editor";
    public static final String PROPERTY_STANDARD_FONT = "std";
    public static final String PROPERTY_MSGLOG_FONT = "msglog";
    public static final String PROPERTY_DATA_FONT = "data";
    public static final String PROPERTY_PRINTER_FONT = "printer";
    public static final String PROPERTY_PROFILE_STORAGE = "workbench.settings.profilestorage";
    public static final String PROPERTY_DEFAULT_MACRO_STORAGE = "workbench.settings.macrostorage";
    public static final String PROPERTY_EDITOR_TAB_WIDTH = "workbench.editor.tabwidth";
    public static final String PROPERTY_EDITOR_CURRENT_LINE_COLOR = "workbench.editor.currentline.color";
    public static final String PROPERTY_EDITOR_CURRENT_STMT_COLOR = "workbench.editor.currentstmt.color";
    public static final String PROPERTY_EDITOR_ERROR_STMT_COLOR = "workbench.editor.color.error";
    public static final String PROPERTY_EDITOR_OCCURANCE_HIGHLIGHT_BASE = "workbench.editor.occurance.highlight";
    public static final String PROPERTY_EDITOR_OCCURANCE_HIGHLIGHT = "workbench.editor.occurance.highlight.enable";
    public static final String PROPERTY_EDITOR_OCCURANCE_HIGHLIGHT_COLOR = "workbench.editor.occurance.highlight.color";
    public static final String PROPERTY_EDITOR_OCCURANCE_HIGHLIGHT_MINLEN = "workbench.editor.occurance.highlight.minlength";
    public static final String PROPERTY_EDITOR_OCCURANCE_HIGHLIGHT_IGNORE_CASE = "workbench.editor.occurance.highlight.casesensitive";
    public static final String PROPERTY_EDITOR_OCCURANCE_HIGHLIGHT_NO_WHITESPACE = "workbench.editor.occurance.highlight.nowhitespace";
    public static final String PROPERTY_EDITOR_BRACKET_HILITE_BASE = "workbench.editor.bracket.hilite";
    public static final String PROPERTY_EDITOR_BRACKET_HILITE_COLOR = "workbench.editor.bracket.hilite.color";
    public static final String PROPERTY_EDITOR_BRACKET_HILITE_LEFT = "workbench.editor.bracket.hilite.left";
    public static final String PROPERTY_EDITOR_BRACKET_HILITE_REC = "workbench.editor.bracket.hilite.rectangle";
    public static final String PROPERTY_EDITOR_BRACKET_HILITE_BOTH = "workbench.editor.bracket.hilite.both";
    public static final String PROPERTY_EDITOR_BRACKET_HILITE = "workbench.editor.bracket.hilite.enable";
    public static final String PROPERTY_EDITOR_ELECTRIC_SCROLL = "workbench.editor.electricscroll";
    public static final String PROPERTY_EDITOR_BG_COLOR = "workbench.editor.color.background";
    public static final String PROPERTY_EDITOR_FG_COLOR = "workbench.editor.color.foreground";
    public static final String PROPERTY_EDITOR_CURSOR_COLOR = "workbench.editor.color.cursor";
    public static final String PROPERTY_EDITOR_SELECTION_COLOR = "workbench.editor.color.selection";
    public static final String PROPERTY_CONSOLIDATE_LOG_MESSAGES = "workbench.gui.log.consolidate";
    public static final String PROPERTY_LOG_ALL_SQL = "workbench.sql.log.statements";
    public static final String PROPERTY_LOG_OBFUSCATE = "workbench.sql.log.obfuscate";
    public static final String PROPERTY_SHOW_IGNORED_WARN = "workbench.sql.ignored.show.warning";
    public static final String PROP_LOG_VARIABLE_SUBSTITUTION = "workbench.sql.parameter.log.substitution";
    public static final String PROP_LOG_CLEAN_SQL = "workbench.sql.log.statements.clean";
    public static final String PROP_DURATION_FORMAT = "workbench.log.timing.format";
    public static final String PROP_DURATION_DECIMAL = "workbench.log.timing.decimal";
    public static final String PROPERTY_ERROR_STATEMENT_LOG_LEVEL = "workbench.gui.log.errorstatement";
    public static final String PROPERTY_CMDLINE_VARS_GLOBAL = "workbench.sql.parameter.vars.global";
    public static final String PROPERTY_VAR_CLEANUP = "workbench.sql.parameter.values.cleanup";
    public static final String PROPERTY_SORT_VARS = "workbench.sql.parameter.prompt.sort";
    public static final String PROPERTY_VAR_PREFIX = "workbench.sql.parameter.prefix";
    public static final String PROPERTY_VAR_SUFFIX = "workbench.sql.parameter.suffix";
    public static final String PROPERTY_DECIMAL_DIGITS = "workbench.gui.display.maxfractiondigits";
    public static final String PROPERTY_FIXED_DIGITS = "workbench.gui.display.decimal.digits.fixed";
    public static final String PROPERTY_DECIMAL_SEP = "workbench.gui.display.decimal.separator";
    public static final String PROPERTY_DECIMAL_GROUP = "workbench.gui.display.decimal.group";
    public static final String PROPERTY_DECIMAL_FORMAT = "workbench.gui.display.decimal.format";
    public static final String PROPERTY_INTEGER_FORMAT = "workbench.gui.display.integer.format";
    public static final String PROP_JOIN_COMPLETION_USE_PARENS = "workbench.gui.sql.join.completion.use.parenthesis";
    public static final String PROP_JOIN_COMPLETION_PREFER_USING = "workbench.gui.sql.join.completion.prefer.using";
    public static final String PROP_EDITOR_TRIM = "workbench.file.save.trim.trailing";
    public static final String PROP_LIBDIR = "workbench.libdir";
    public static final String PROP_LOGFILE_VIEWER = "workbench.logfile.viewer.program";
    public static final String PROP_READ_DRIVER_TEMPLATES = "workbench.jdbc.read.drivertemplates";
    public static final String TEST_MODE_PROPERTY = "workbench.gui.testmode";
    public static final String DEFAULT_MACRO_FILENAME = "WbMacros.xml";
    public static final String PK_MAPPING_FILENAME_PROPERTY = "workbench.pkmapping.file";
    public static final String UNIX_LINE_TERMINATOR_PROP_VALUE = "lf";
    public static final String DOS_LINE_TERMINATOR_PROP_VALUE = "crlf";
    public static final String DEFAULT_LINE_TERMINATOR_PROP_VALUE = "default";
    public static final String LIB_DIR_KEY = "%LibDir%";
    private static final String TOOLS_EXE = ".executable";
    private static final String TOOLS_NAME = ".name";
    private static final String TOOLS_PARAM = ".parameter";
    private static final String TOOLS_PREFIX = "workbench.tools.";
    private WbProperties props;
    private WbFile configfile;
    private final List<FontChangedListener> fontChangeListeners = new ArrayList<FontChangedListener>(5);
    private final List<SettingsListener> saveListener = new ArrayList<SettingsListener>(5);
    private long fileTime;
    private boolean createBackup;
    private List<WbFile> profileStorage = new ArrayList<WbFile>(1);

    public static final Settings getInstance() {
        return LazyInstanceHolder.INSTANCE;
    }

    protected Settings() {
        this.initialize();
        this.renameOldProps();
        this.migrateProps();
        this.removeObsolete();
    }

    public boolean isModified() {
        return this.props.isModified();
    }

    @Override
    public Set<String> getKeys() {
        return this.props.getKeys();
    }

    public final void initialize() {
        Object object;
        ClasspathUtil classpathUtil = new ClasspathUtil();
        if (WbManager.getInstance() != null) {
            System.setProperty("workbench.install.dir", classpathUtil.getJarPath());
        }
        WbFile wbFile = null;
        try {
            object = StringUtil.replaceProperties(System.getProperty("workbench.configdir", null));
            object = StringUtil.trimQuotes((String)object);
            if (StringUtil.isBlank((CharSequence)object)) {
                File file = new File(System.getProperty("user.dir"), "workbench.settings");
                if (file.exists()) {
                    wbFile = new WbFile(file.getParentFile());
                } else if (WbManager.getInstance() != null && !(file = new File(wbFile = new WbFile(classpathUtil.getJarPath()), "workbench.settings")).exists()) {
                    wbFile = null;
                }
            } else {
                wbFile = new WbFile((String)object);
            }
        }
        catch (Exception exception) {
            wbFile = new WbFile(System.getProperty("user.home"), ".sqlworkbench");
        }
        if (wbFile == null) {
            wbFile = new WbFile(System.getProperty("user.home"), ".sqlworkbench");
        }
        if (!wbFile.exists() && WbManager.getInstance() != null && WbManager.getInstance().getSettingsShouldBeSaved()) {
            wbFile.mkdirs();
        }
        object = new WbFile(wbFile, "workbench.settings");
        boolean bl = this.loadConfig((WbFile)object);
        if (this.configfile != null) {
            System.setProperty("workbench.config.dir", this.configfile.getParentFile().getAbsolutePath());
        }
        CallerInfo callerInfo = new CallerInfo(){};
        if (bl || this.isTestMode()) {
            this.initLogging();
            LogMgr.logInfo(callerInfo, "Using configdir: " + this.configfile.getParentFile().getAbsolutePath());
            LogMgr.logDebug(callerInfo, "Using default xstlDir: " + this.getDefaultXsltDirectory());
            LogMgr.logDebug(callerInfo, "Last modification time of loaded config file: " + this.fileTime);
            if (this.getBoolProperty("workbench.db.resetdefaults")) {
                LogMgr.logInfo(callerInfo, "Resetting database properties to built-in defaults");
                this.resetDefaults();
            }
        }
        if (wbFile.isHidden() && PlatformHelper.isWindows()) {
            FileAttributeChanger fileAttributeChanger = new FileAttributeChanger();
            LogMgr.logDebug(callerInfo, "Removing hidden attribute of the configuration directory");
            fileAttributeChanger.removeHidden(wbFile);
        }
    }

    private boolean initLog4j() {
        File file;
        String string = StringUtil.replaceProperties(this.getProperty("workbench.log.log4j", "false"));
        String string2 = null;
        boolean bl = false;
        if ("true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
            bl = StringUtil.stringToBool(string);
        } else {
            file = new File(string);
            if (file.exists()) {
                bl = true;
                string2 = string;
            }
        }
        if (bl && StringUtil.isNonBlank(string2)) {
            try {
                file = new File(string2);
                if (!file.isAbsolute() && this.configfile != null) {
                    file = new File(this.configfile.getParentFile(), string2);
                }
                if (file.exists()) {
                    String string3 = file.toURI().toString();
                    System.setProperty("log4j.configuration", string3);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return bl;
    }

    private void initLogging() {
        boolean bl = this.initLog4j();
        LogMgr.init(bl);
        boolean bl2 = this.getBoolProperty("workbench.log.console", false);
        LogMgr.logToSystemError(bl2);
        String string = this.getProperty("workbench.log.level", "INFO");
        LogMgr.setLevel(string);
        String string2 = "{timestamp} {type} {message} {error}";
        if (LogMgr.isDebugEnabled()) {
            string2 = "{timestamp} {type} {source} {message} {error}";
        }
        String string3 = this.getProperty("workbench.log.format", string2);
        LogMgr.setMessageFormat(string3);
        try {
            WbFile wbFile;
            String string4 = StringUtil.replaceProperties(this.getProperty("workbench.log.filename", "workbench.log"));
            string4 = FileDialogUtil.replaceProgramDir(string4);
            string4 = StringUtil.replace(string4, "%ConfigDir%", this.getConfigDir().getAbsolutePath());
            if (string4.equalsIgnoreCase("System.out") || string4.equalsIgnoreCase("System.err")) {
                string4 = "workbench.log";
                this.setProperty("workbench.log.filename", "workbench.log");
            }
            if (!(wbFile = new WbFile(string4)).isAbsolute()) {
                wbFile = new WbFile(this.getConfigDir(), string4);
            }
            if (!wbFile.getParentFile().exists()) {
                wbFile.getParentFile().mkdirs();
            }
            String string5 = null;
            if (!wbFile.isWriteable()) {
                string5 = wbFile.getFullPath();
                wbFile = new WbFile(this.getConfigDir(), "workbench.log");
                this.setProperty("workbench.log.filename", "workbench.log");
            }
            int n = this.getMaxLogfileSize();
            int n2 = this.getLogfileBackupCount();
            LogMgr.setOutputFile(wbFile, n, n2);
            if (string5 != null) {
                LogMgr.logWarning(new CallerInfo(){}, "Could not write requested logfile '" + string5 + "'");
            }
        }
        catch (Throwable throwable) {
            System.err.println("Error initializing log system!");
            throwable.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadConfig(WbFile wbFile) {
        if (wbFile == null) {
            return false;
        }
        long l = wbFile.lastModified();
        if (wbFile.equals(this.configfile) && this.fileTime == l) {
            return false;
        }
        this.configfile = wbFile;
        this.props = new WbProperties(this);
        this.fileTime = l;
        this.fillDefaults();
        if (wbFile.exists() && wbFile.length() > 0L) {
            this.props.clearComments();
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(this.configfile), 32768);
            this.props.loadFromStream(bufferedInputStream);
            FileUtil.closeQuietely(bufferedInputStream);
        }
        catch (IOException iOException) {
            this.fillDefaults();
        }
        finally {
            FileUtil.closeQuietely(bufferedInputStream);
        }
        return true;
    }

    private void resetDefaults() {
        WbProperties wbProperties = this.getDefaultProperties();
        for (String string : wbProperties.stringPropertyNames()) {
            if (!string.startsWith("workbench.db")) continue;
            this.setProperty(string, wbProperties.getProperty(string));
        }
    }

    public void setCreatBackupOnSave(boolean bl) {
        this.createBackup = bl;
    }

    public boolean showScriptNameForInclude() {
        return this.getBoolProperty("workbench.batchrunner.progress.showscriptname", false);
    }

    @Override
    public List<String> getKeysWithPrefix(String string) {
        return this.props.getKeysWithPrefix(string);
    }

    public void addSaveListener(SettingsListener settingsListener) {
        this.saveListener.add(settingsListener);
    }

    public void removeSaveListener(SettingsListener settingsListener) {
        this.saveListener.remove(settingsListener);
    }

    public String replaceProperties(String string) {
        return StringUtil.replaceProperties(this.props, string);
    }

    public void setUseSinglePageHelp(boolean bl) {
        this.setProperty("workbench.help.singlepage", bl);
    }

    public boolean useSinglePageHelp() {
        return this.getBoolProperty("workbench.help.singlepage", false);
    }

    public boolean replaceEnvVarsInProfile() {
        return this.getBoolProperty("workbench.profiles.replace.env.vars", true);
    }

    public boolean usePgPassFile() {
        return this.getBoolProperty("workbench.db.postgresql.use.pgpass", true);
    }

    public void setLanguage(Locale locale) {
        this.setProperty("workbench.gui.language", locale.getLanguage());
    }

    public List<WbLocale> getLanguages() {
        List<String> list = this.getListProperty("workbench.gui.languages.available", false, "en,de");
        ArrayList<WbLocale> arrayList = new ArrayList<WbLocale>(list.size());
        for (String string : list) {
            try {
                arrayList.add(new WbLocale(new Locale(string)));
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Invalid locale specified: " + string, exception);
            }
        }
        return arrayList;
    }

    public Locale getLanguage() {
        String string = this.getProperty("workbench.gui.language", "en");
        Locale locale = null;
        try {
            locale = new Locale(string);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error creating Locale for language=" + string, exception);
            locale = new Locale("en");
        }
        return locale;
    }

    public String getDriverConfigFilename() {
        return new WbFile(this.getConfigDir(), "WbDrivers.xml").getFullPath();
    }

    public File getColumnOrderStorage() {
        return new WbFile(this.getConfigDir(), "WbColumnOrder.xml");
    }

    public final File getWorkspaceDir() {
        String string = this.getProperty("workbench.workspacedir", null);
        if (string == null) {
            return this.getConfigDir();
        }
        File file = new File(string);
        if (!file.exists()) {
            return this.getConfigDir();
        }
        return file;
    }

    public final File getConfigDir() {
        return this.configfile.getParentFile();
    }

    public String replaceLibDirKey(String string) {
        if (string == null) {
            return null;
        }
        WbFile wbFile = this.getLibDir();
        return StringUtil.replace(string, LIB_DIR_KEY, wbFile.getFullPath());
    }

    public WbFile getLibDir() {
        String string = this.getProperty(PROP_LIBDIR, null);
        string = FileDialogUtil.replaceConfigDir(string);
        if ((string = FileDialogUtil.replaceProgramDir(string)) == null) {
            return new WbFile(this.getConfigDir());
        }
        return new WbFile(string);
    }

    public String getShortcutFilename() {
        return new WbFile(this.getConfigDir(), "WbShortcuts.xml").getFullPath();
    }

    public String getMacroStorage() {
        String string = this.props.getProperty(PROPERTY_DEFAULT_MACRO_STORAGE);
        if (string == null) {
            return new File(this.getConfigDir(), DEFAULT_MACRO_FILENAME).getAbsolutePath();
        }
        String string2 = FileDialogUtil.replaceConfigDir(string);
        WbFile wbFile = new WbFile(string2);
        if (!wbFile.isAbsolute()) {
            wbFile = new WbFile(this.getConfigDir(), string2);
        }
        return wbFile.getFullPath();
    }

    public void setMacroStorage(String string) {
        if (StringUtil.isEmptyString(string)) {
            this.props.remove(PROPERTY_DEFAULT_MACRO_STORAGE);
        } else {
            this.props.setProperty(PROPERTY_DEFAULT_MACRO_STORAGE, string);
        }
    }

    public List<WbFile> getProfileStorage() {
        return Collections.unmodifiableList(this.profileStorage);
    }

    public WbFile getDefaultProfileStorage() {
        List<String> list = CollectionUtil.arrayList("wb-profiles.properties", "WbProfiles.xml");
        for (String string : list) {
            WbFile wbFile = new WbFile(this.getConfigDir(), string);
            if (!wbFile.exists()) continue;
            return wbFile;
        }
        return new WbFile(this.getConfigDir(), list.get(0));
    }

    public void setProfileStorage(List<WbFile> list) {
        if (CollectionUtil.isEmpty(list)) {
            this.profileStorage.clear();
            this.profileStorage.add(this.getDefaultProfileStorage());
        } else {
            this.profileStorage.addAll(list);
        }
    }

    public void setLastUsedBlobTool(String string) {
        this.setProperty("workbench.tools.last.blob", string);
    }

    public String getLastUsedBlobTool() {
        return this.getProperty("workbench.tools.last.blob", null);
    }

    public List<ToolDefinition> getExternalTools() {
        return this.getExternalTools(true, false);
    }

    public List<ToolDefinition> getAllExternalTools() {
        return this.getExternalTools(false, false);
    }

    public String getOpenLogFileTool() {
        return this.getProperty(PROP_LOGFILE_VIEWER, "internal");
    }

    public List<ToolDefinition> getExternalTools(boolean bl, boolean bl2) {
        int n = this.getIntProperty("workbench.tools.count", 0);
        ArrayList<ToolDefinition> arrayList = new ArrayList<ToolDefinition>(n);
        for (int i = 0; i < n; ++i) {
            String string = this.getProperty(TOOLS_PREFIX + i + TOOLS_EXE, "");
            String string2 = this.getProperty(TOOLS_PREFIX + i + TOOLS_NAME, string);
            String string3 = this.getProperty(TOOLS_PREFIX + i + TOOLS_PARAM, null);
            ToolDefinition toolDefinition = new ToolDefinition(string, string3, string2);
            if (!bl) {
                arrayList.add(toolDefinition);
                continue;
            }
            if (!toolDefinition.executableExists()) continue;
            arrayList.add(toolDefinition);
        }
        return arrayList;
    }

    private void clearTools() {
        int n = this.getIntProperty("workbench.tools.count", 0);
        for (int i = 0; i < n; ++i) {
            this.removeProperty(TOOLS_PREFIX + i + TOOLS_EXE);
            this.removeProperty(TOOLS_PREFIX + i + TOOLS_NAME);
            this.removeProperty(TOOLS_PREFIX + i + TOOLS_PARAM);
        }
    }

    public void setExternalTools(Collection<ToolDefinition> collection) {
        this.clearTools();
        int n = 0;
        for (ToolDefinition toolDefinition : collection) {
            this.setProperty(TOOLS_PREFIX + n + TOOLS_EXE, toolDefinition.getExecutablePath());
            this.setProperty(TOOLS_PREFIX + n + TOOLS_NAME, toolDefinition.getName());
            this.setProperty(TOOLS_PREFIX + n + TOOLS_PARAM, toolDefinition.getParameters());
            ++n;
        }
        this.setProperty("workbench.tools.count", n);
    }

    public boolean checkJavaVersion() {
        return this.getBoolProperty("workbench.gui.check.java.version", true);
    }

    public Date getLastUpdateCheck() {
        String string = this.getProperty("workbench.gui.updatecheck.lastcheck", null);
        return StringUtil.parseISODate(string);
    }

    public void setLastUpdateCheck() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.props.setProperty("workbench.gui.updatecheck.lastcheck", simpleDateFormat.format(date), false);
    }

    public int getUpdateCheckInterval() {
        return this.getIntProperty("workbench.gui.updatecheck.interval", 30);
    }

    public void setUpdateCheckInterval(int n) {
        this.setProperty("workbench.gui.updatecheck.interval", n);
    }

    public boolean isPropertyDefined(String string) {
        return this.props.containsKey(string);
    }

    public DurationFormat getDurationFormat() {
        return this.getEnumProperty(PROP_DURATION_FORMAT, DurationFormat.dynamic);
    }

    public boolean checkCockroachDBConnection() {
        return this.getBoolProperty("workbench.db.postgresql.check.cockroachdb", false);
    }

    public boolean getObfuscateDbInformation() {
        return this.getBoolProperty(PROPERTY_LOG_OBFUSCATE, false);
    }

    public void setObfuscateDbInformation(boolean bl) {
        this.setProperty(PROPERTY_LOG_OBFUSCATE, bl);
    }

    public final boolean getLogAllStatements() {
        return this.getBoolProperty(PROPERTY_LOG_ALL_SQL, false);
    }

    public void setLogAllStatements(boolean bl) {
        this.setProperty(PROPERTY_LOG_ALL_SQL, bl);
    }

    public int getLowMemoryCheckInterval() {
        return this.getIntProperty("workbench.gui.data.memcheckinterval", 1000);
    }

    public boolean getFixSqlServerTimestampDisplay() {
        return this.getBoolProperty("workbench.db.microsoft_sql_server.fix.timestamp", false);
    }

    public boolean useOracleNativeCancel() {
        return this.getBoolProperty("workbench.db.oracle.cancel.native", true);
    }

    public boolean fixOracleDateType() {
        return this.getBoolProperty("workbench.db.oracle.fixdatetype", false);
    }

    public void setFixOracleDateType(boolean bl) {
        this.setProperty("workbench.db.oracle.fixdatetype", bl);
    }

    public boolean getConvertOracleTypes() {
        return this.getBoolProperty("workbench.db.oracle.types.autoconvert", true);
    }

    public void setConvertOracleTypes(boolean bl) {
        this.setProperty("workbench.db.oracle.types.autoconvert", bl);
    }

    public String getPopularEncodings() {
        return this.getProperty("workbench.export.defaultencodings", "UTF-8,ISO-8859-1,ISO-8859-15");
    }

    public List<String> getEncodingsToUse() {
        return this.getListProperty("workbench.encodings", false, null);
    }

    public boolean getExitOnFirstConnectCancel() {
        return this.getBoolProperty("workbench.gui.cancel.firstconnect.exit", false);
    }

    public void setExitOnFirstConnectCancel(boolean bl) {
        this.setProperty("workbench.gui.cancel.firstconnect.exit", bl);
    }

    public boolean getShowConnectDialogOnStartup() {
        return this.getBoolProperty("workbench.gui.autoconnect", true);
    }

    public void setShowConnectDialogOnStartup(boolean bl) {
        this.setProperty("workbench.gui.autoconnect", bl);
    }

    public int getFormatterMaxColumnsInUpdate() {
        return this.getIntProperty("workbench.sql.formatter.update.columnsperline", 1);
    }

    public void setFormatterMaxColumnsInUpdate(int n) {
        this.setProperty("workbench.sql.formatter.update.columnsperline", n);
    }

    public int getFormatterMaxColumnsInInsert() {
        return this.getIntProperty("workbench.sql.formatter.insert.columnsperline", 1);
    }

    public void setFormatterMaxColumnsInInsert(int n) {
        this.setProperty("workbench.sql.formatter.insert.columnsperline", n);
    }

    public int getFormatterMaxColumnsInSelect() {
        return this.getIntProperty("workbench.sql.formatter.select.columnsperline", 1);
    }

    public void setFormatterMaxColumnsInSelect(int n) {
        this.setProperty("workbench.sql.formatter.select.columnsperline", n);
    }

    public GeneratedIdentifierCase getFormatterDatatypeCase() {
        return this.getIdentifierCase("workbench.sql.formatter.datatype.case", GeneratedIdentifierCase.upper);
    }

    public void setFormatterDatatypeCase(GeneratedIdentifierCase generatedIdentifierCase) {
        this.setIdentifierCase("workbench.sql.formatter.datatype.case", generatedIdentifierCase);
    }

    public GeneratedIdentifierCase getFormatterFunctionCase() {
        String string = this.getProperty("workbench.sql.formatter.functions.lowercase", null);
        if ("true".equals(string)) {
            return GeneratedIdentifierCase.lower;
        }
        if ("false".equals(string)) {
            return GeneratedIdentifierCase.lower;
        }
        return this.getIdentifierCase("workbench.sql.formatter.functions.case", GeneratedIdentifierCase.upper);
    }

    public void setFormatterFunctionCase(GeneratedIdentifierCase generatedIdentifierCase) {
        this.removeProperty("workbench.sql.formatter.functions.lowercase");
        this.setIdentifierCase("workbench.sql.formatter.functions.case", generatedIdentifierCase);
    }

    public boolean getFormatterSubselectInNewLine() {
        return this.getBoolProperty("workbench.sql.formatter.subselect.newline", false);
    }

    public void setFormatterSubselectInNewLine(boolean bl) {
        this.setProperty("workbench.sql.formatter.subselect.newline", bl);
    }

    public void setFormatterKeywordsCase(GeneratedIdentifierCase generatedIdentifierCase) {
        this.removeProperty("workbench.sql.formatter.keywords.uppercase");
        this.setIdentifierCase("workbench.sql.formatter.keywords.case", generatedIdentifierCase);
    }

    public GeneratedIdentifierCase getFormatterKeywordsCase() {
        String string = this.getProperty("workbench.sql.formatter.keywords.uppercase", null);
        if ("true".equals(string)) {
            return GeneratedIdentifierCase.upper;
        }
        return this.getIdentifierCase("workbench.sql.formatter.keywords.case", GeneratedIdentifierCase.upper);
    }

    public GeneratedIdentifierCase getFormatterIdentifierCase() {
        return this.getIdentifierCase("workbench.sql.formatter.identifier.case", GeneratedIdentifierCase.asIs);
    }

    public void setFormatterIdentifierCase(GeneratedIdentifierCase generatedIdentifierCase) {
        this.setIdentifierCase("workbench.sql.formatter.identifier.case", generatedIdentifierCase);
    }

    public boolean getFormatterIndentWhereConditions() {
        return this.getBoolProperty("workbench.sql.formatter.where.condition.indent", false);
    }

    public void setFormatterIndentWhereConditions(boolean bl) {
        this.setProperty("workbench.sql.formatter.where.condition.indent", bl);
    }

    public boolean getFormatterAddSpaceAfterComma() {
        return this.getBoolProperty("workbench.sql.formatter.comma.spaceafter", false);
    }

    public void setFormatterAddSpaceAfterComma(boolean bl) {
        this.setProperty("workbench.sql.formatter.comma.spaceafter", bl);
    }

    public boolean getFormatterIndentInsert() {
        return this.getBoolProperty("workbench.sql.formatter.insert.indent", true);
    }

    public void setFormatterIndentInsert(boolean bl) {
        this.setProperty("\"workbench.sql.formatter.insert.indent", bl);
    }

    public boolean getFormatterCommaAfterLineBreak() {
        return this.getBoolProperty("workbench.sql.formatter.comma.afterLineBreak", false);
    }

    public void setFormatterCommaAfterLineBreak(boolean bl) {
        this.setProperty("workbench.sql.formatter.comma.afterLineBreak", bl);
    }

    public boolean getFormatterAddColumnNameComment() {
        return this.getBoolProperty("workbench.sql.formatter.insert.values.columnname", false);
    }

    public void setFormatterAddColumnNameComment(boolean bl) {
        this.setProperty("workbench.sql.formatter.insert.values.columnname", bl);
    }

    public void setFormatterJoinWrapStyle(JoinWrapStyle joinWrapStyle) {
        this.setProperty("workbench.sql.formatter.join.condition.wrapstyle", joinWrapStyle.name());
    }

    public JoinWrapStyle getFormatterJoinWrapStyle() {
        return this.getEnumProperty("workbench.sql.formatter.join.condition.wrapstyle", JoinWrapStyle.onlyMultiple);
    }

    public void setFormatterWrapMultipleJoinConditions(boolean bl) {
        this.setProperty("workbench.sql.formatter.join.condition.multiple.wrap", bl);
    }

    public boolean getFormatterAddSpaceAfterLineBreakComma() {
        return this.getBoolProperty("workbench.sql.formatter.comma.spaceAfterLineBreakComma", false);
    }

    public void setFormatterAddSpaceAfterLineBreakComma(boolean bl) {
        this.setProperty("workbench.sql.formatter.comma.spaceAfterLineBreakComma", bl);
    }

    public int getFormatterMaxSubselectLength() {
        return this.getIntProperty("workbench.sql.formatter.subselect.maxlength", 60);
    }

    public void setFormatterMaxSubselectLength(int n) {
        this.setProperty("workbench.sql.formatter.subselect.maxlength", n);
    }

    public int getMaxCharInListElements() {
        return this.getIntProperty("workbench.editor.format.list.maxelements.quoted", 2);
    }

    public void setMaxCharInListElements(int n) {
        this.setProperty("workbench.editor.format.list.maxelements.quoted", n <= 0 ? 2 : n);
    }

    public int getMaxNumInListElements() {
        return this.getIntProperty("workbench.editor.format.list.maxelements.nonquoted", 10);
    }

    public void setMaxNumInListElements(int n) {
        this.setProperty("workbench.editor.format.list.maxelements.nonquoted", n <= 0 ? 10 : n);
    }

    public int getFormatUpdateColumnThreshold() {
        return this.getIntProperty("workbench.sql.generate.update.newlinethreshold", 5);
    }

    public void setFormatUpdateColumnThreshold(int n) {
        this.setProperty("workbench.sql.generate.update.newlinethreshold", n);
    }

    public int getFormatInsertColsPerLine() {
        return this.getIntProperty("workbench.sql.generate.insert.colsperline", 1);
    }

    public void setFormatInsertColsPerLine(int n) {
        this.setProperty("workbench.sql.generate.insert.colsperline", 1);
    }

    public boolean getGenerateInsertIgnoreIdentity() {
        return this.getBoolProperty("workbench.sql.generate.insert.ignoreidentity", true);
    }

    public void setGenerateInsertIgnoreIdentity(boolean bl) {
        this.setProperty("workbench.sql.generate.insert.ignoreidentity", bl);
    }

    public int getFormatInsertColumnThreshold() {
        return this.getIntProperty("workbench.sql.generate.insert.newlinethreshold", 5);
    }

    public void setFormatInsertColumnThreshold(int n) {
        this.setProperty("workbench.sql.generate.insert.newlinethreshold", n);
    }

    public boolean getDoFormatUpdates() {
        return this.getBoolProperty("workbench.sql.generate.update.doformat", true);
    }

    public void setDoFormatUpdates(boolean bl) {
        this.setProperty("workbench.sql.generate.update.doformat", bl);
    }

    public boolean getDoFormatDeletes() {
        return this.getBoolProperty("workbench.sql.generate.delete.doformat", true);
    }

    public void setDoFormatDeletes(boolean bl) {
        this.setProperty("workbench.sql.generate.delete.doformat", bl);
    }

    public boolean getDoFormatInserts() {
        return this.getBoolProperty("workbench.sql.generate.insert.doformat", true);
    }

    public void setDoFormatInserts(boolean bl) {
        this.setProperty("workbench.sql.generate.insert.doformat", bl);
    }

    public void setIncludeEmptyComments(boolean bl) {
        this.setProperty("workbench.sql.generate.comment.includeempty", bl);
    }

    public boolean getIncludeEmptyComments() {
        return this.getBoolProperty("workbench.sql.generate.comment.includeempty", false);
    }

    public void addFontChangedListener(FontChangedListener fontChangedListener) {
        this.fontChangeListeners.add(fontChangedListener);
    }

    public synchronized void removeFontChangedListener(FontChangedListener fontChangedListener) {
        this.fontChangeListeners.remove(fontChangedListener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener, String string, String ... stringArray) {
        this.props.addPropertyChangeListener(propertyChangeListener, string);
        if (stringArray.length > 0) {
            this.props.addPropertyChangeListener(propertyChangeListener, stringArray);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.props.removePropertyChangeListener(propertyChangeListener);
    }

    public void setFont(String string, Font font) {
        String string2 = "workbench.font." + string;
        this.removeProperty(string2 + TOOLS_NAME);
        this.removeProperty(string2 + ".size");
        this.removeProperty(string2 + ".style");
        if (font == null) {
            return;
        }
        String string3 = font.getFamily();
        String string4 = Integer.toString(font.getSize());
        int n = font.getStyle();
        this.props.setProperty(string2 + TOOLS_NAME, string3);
        this.props.setProperty(string2 + ".size", string4);
        String string5 = null;
        if ((n & 1) == 1) {
            string5 = "BOLD";
        }
        if ((n & 2) == 2) {
            string5 = string5 == null ? "ITALIC" : string5 + ",ITALIC";
        }
        if (string5 == null) {
            string5 = "PLAIN";
        }
        this.props.setProperty(string2 + ".style", string5);
        this.fireFontChangedEvent(string, font);
    }

    public void fireFontChangedEvent(String string, Font font) {
        for (FontChangedListener fontChangedListener : this.fontChangeListeners) {
            if (fontChangedListener == null) continue;
            fontChangedListener.fontChanged(string, font);
        }
    }

    public void setPrintFont(Font font) {
        this.setFont(PROPERTY_PRINTER_FONT, font);
    }

    public boolean getEditorDetectEncoding() {
        return this.getBoolProperty("workbench.editor.drop.detect.encoding", true);
    }

    public void setEditorFont(Font font) {
        this.setFont(PROPERTY_EDITOR_FONT, font);
    }

    public Font getEditorFont() {
        return this.getEditorFont(true);
    }

    public Font getEditorFont(boolean bl) {
        return this.getMonospacedFont(PROPERTY_EDITOR_FONT, bl);
    }

    public void setMsgLogFont(Font font) {
        this.setFont(PROPERTY_MSGLOG_FONT, font);
    }

    public Font getMsgLogFont() {
        return this.getMonospacedFont(PROPERTY_MSGLOG_FONT, true);
    }

    public void setDataFont(Font font) {
        this.setFont(PROPERTY_DATA_FONT, font);
    }

    public Font getDataFont() {
        return this.getDataFont(false);
    }

    public Font getDataFont(boolean bl) {
        return this.getMonospacedFont(PROPERTY_DATA_FONT, bl);
    }

    private Font getMonospacedFont(String string, boolean bl) {
        boolean bl2 = false;
        Font font = this.getFont(string);
        if (font == null && bl) {
            font = new Font("Monospaced", 0, 12);
            bl2 = true;
        }
        if (this.getScaleFonts() && bl2) {
            FontScaler fontScaler = new FontScaler();
            font = fontScaler.scaleFont(font);
        }
        return font;
    }

    public Font getPrinterFont() {
        Font font = this.getFont(PROPERTY_PRINTER_FONT);
        if (font == null) {
            font = this.getDataFont();
        }
        return font;
    }

    public Font getStandardFont() {
        return this.getFont(PROPERTY_STANDARD_FONT);
    }

    public void setStandardFont(Font font) {
        this.setFont(PROPERTY_STANDARD_FONT, font);
    }

    public float getScaleFactor() {
        String string = Settings.getInstance().getProperty("workbench.gui.desktop.scalefonts.factor", null);
        if (string == null) {
            return -1.0f;
        }
        float f = -1.0f;
        try {
            f = Float.parseFloat(string);
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Invalid font scale factor specified: " + string, throwable);
        }
        return f;
    }

    public boolean getScaleFonts() {
        if (this.getScaleFactor() > 1.0f) {
            return true;
        }
        int n = Toolkit.getDefaultToolkit().getScreenResolution();
        boolean bl = n >= 120;
        return this.getBoolProperty("workbench.gui.desktop.scalefonts", bl);
    }

    public void setScaleFonts(boolean bl) {
        this.setProperty("workbench.gui.desktop.scalefonts", bl);
    }

    public Font getFont(String string) {
        Font font = null;
        String string2 = "workbench.font." + string;
        String string3 = StringUtil.trimToNull(this.getProperty(string2 + TOOLS_NAME, null));
        if (string3 == null) {
            return null;
        }
        String string4 = StringUtil.trimToNull(this.getProperty(string2 + ".size", "12"));
        String string5 = this.getProperty(string2 + ".style", "Plain");
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string5);
        while (stringTokenizer.hasMoreTokens()) {
            String string6 = stringTokenizer.nextToken();
            if ("bold".equalsIgnoreCase(string6)) {
                n |= 1;
            }
            if (!"italic".equalsIgnoreCase(string5)) continue;
            n |= 2;
        }
        int n2 = 12;
        try {
            n2 = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        font = new Font(string3, n, n2);
        return font;
    }

    public List<String> getLiteralTypeList() {
        List<String> list = this.getListProperty("workbench.sql.literals.types", false, "jdbc,ansi,dbms,default");
        if (!list.contains("dbms")) {
            list.add("dbms");
        }
        return list;
    }

    public void setDefaultCopyDateLiteralType(String string) {
        this.setProperty("workbench.export.copy.sql.dateliterals", string);
    }

    public String getDefaultCopyDateLiteralType() {
        return this.getProperty("workbench.export.copy.sql.dateliterals", "dbms");
    }

    public void setDefaultExportDateLiteralType(String string) {
        this.setProperty("workbench.export.sql.default.dateliterals", string);
    }

    public boolean getAbortExportWithMissingQuoteChar() {
        return this.getBoolProperty("workbench.export.text.abort.missing.quotechar", false);
    }

    public String getDefaultExportDateLiteralType() {
        return this.getProperty("workbench.export.sql.default.dateliterals", "dbms");
    }

    public boolean getDefaultExportInfoSheet(String string) {
        if (string == null) {
            return false;
        }
        return this.getBoolProperty("workbench.export." + string.trim().toLowerCase() + ".default.infosheet", false);
    }

    public String getDefaultDiffDateLiteralType() {
        return this.getProperty("workbench.diff.sql.default.dateliterals", "jdbc");
    }

    public void setDefaultDiffDateLiteralType(String string) {
        this.setProperty("workbench.diff.sql.default.dateliterals", string);
    }

    public boolean getAutoRunExportStatement() {
        return this.getBoolProperty("workbench.export.sql.autorun.executecurrent", true);
    }

    public void setAutoRunExportStatement(boolean bl) {
        this.setProperty("workbench.export.sql.autorun.executecurrent", bl);
    }

    public Collection<String> getAutoRunVerbs() {
        List<String> list = this.getListProperty("workbench.export.sql.autorun.verbs", false, null);
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        set.addAll(list);
        return set;
    }

    public Color getColor(String string) {
        return this.getColor(string, null);
    }

    public Color getColor(String string, Color color) {
        String string2 = this.getProperty(string, null);
        if (string2 == null) {
            return color;
        }
        Color color2 = Settings.stringToColor(string2);
        if (color2 == null) {
            return color;
        }
        return color2;
    }

    public static Color stringToColor(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(",");
        if (stringArray.length != 3) {
            return null;
        }
        try {
            int n = StringUtil.getIntValue(stringArray[0]);
            int n2 = StringUtil.getIntValue(stringArray[1]);
            int n3 = StringUtil.getIntValue(stringArray[2]);
            return new Color(n, n2, n3);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public PageFormat getPageFormat() {
        PageFormat pageFormat = new PageFormat();
        double d = this.getDoubleProperty("workbench.print.paper.iwidth", 538.5826771653543);
        double d2 = this.getDoubleProperty("workbench.print.paper.iheight", 785.1968503937007);
        double d3 = this.getDoubleProperty("workbench.print.paper.top", 28.346456692913385);
        double d4 = this.getDoubleProperty("workbench.print.paper.left", 28.346456692913385);
        double d5 = this.getDoubleProperty("workbench.print.paper.width", 595.275590551181);
        double d6 = this.getDoubleProperty("workbench.print.paper.height", 841.8897637795276);
        Paper paper = new Paper();
        paper.setSize(d5, d6);
        paper.setImageableArea(d4, d3, d, d2);
        pageFormat.setPaper(paper);
        pageFormat.setOrientation(this.getPrintOrientation());
        return pageFormat;
    }

    private double getDoubleProperty(String string, double d) {
        String string2 = this.getProperty(string, null);
        return StringUtil.getDoubleValue(string2, d);
    }

    public boolean getShowNativePageDialog() {
        return this.getBoolProperty("workbench.print.nativepagedialog", true);
    }

    private int getPrintOrientation() {
        return this.getIntProperty("workbench.print.orientation", 1);
    }

    public void setPageFormat(PageFormat pageFormat) {
        double d = pageFormat.getWidth();
        double d2 = pageFormat.getHeight();
        double d3 = pageFormat.getImageableWidth();
        double d4 = pageFormat.getImageableHeight();
        double d5 = pageFormat.getImageableX();
        double d6 = pageFormat.getImageableY();
        this.props.setProperty("workbench.print.paper.iwidth", Double.toString(d3));
        this.props.setProperty("workbench.print.paper.iheight", Double.toString(d4));
        this.props.setProperty("workbench.print.paper.top", Double.toString(d6));
        this.props.setProperty("workbench.print.paper.left", Double.toString(d5));
        this.props.setProperty("workbench.print.paper.width", Double.toString(d));
        this.props.setProperty("workbench.print.paper.height", Double.toString(d2));
        this.props.setProperty("workbench.print.orientation", Integer.toString(pageFormat.getOrientation()));
    }

    public final boolean getConsolidateLogMsg() {
        return this.getBoolProperty(PROPERTY_CONSOLIDATE_LOG_MESSAGES, false);
    }

    public void setConsolidateLogMsg(boolean bl) {
        this.setProperty(PROPERTY_CONSOLIDATE_LOG_MESSAGES, bl);
    }

    public boolean getUsePlainEditorForData() {
        return this.getBoolProperty("workbench.gui.editor.data.plain", true);
    }

    public int getRectSelectionModifier() {
        String string = this.getProperty("workbench.editor.rectselection.modifier", "alt");
        if (string.equalsIgnoreCase("ctrl")) {
            return 2;
        }
        return 8;
    }

    public int getRectSelectionKey() {
        int n = this.getRectSelectionModifier();
        if (n == 2) {
            return 17;
        }
        return 18;
    }

    public void setRectSelectionModifier(String string) {
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("alt")) {
            this.setProperty("workbench.editor.rectselection.modifier", "alt");
        } else if (string.equalsIgnoreCase("ctrl")) {
            this.setProperty("workbench.editor.rectselection.modifier", "ctrl");
        }
    }

    public String getExternalEditorLineEnding() {
        return this.getLineEndingProperty("workbench.editor.lineending.external", DEFAULT_LINE_TERMINATOR_PROP_VALUE);
    }

    public void setExternalEditorLineEnding(String string) {
        this.setLineEndingProperty("workbench.editor.lineending.external", string);
    }

    public String getInternalEditorLineEnding() {
        return this.getLineEndingProperty("workbench.editor.lineending.internal", UNIX_LINE_TERMINATOR_PROP_VALUE);
    }

    public void setInternalEditorLineEnding(String string) {
        this.setLineEndingProperty("workbench.editor.lineending.internal", string);
    }

    public String getExternalLineEndingValue() {
        return this.getProperty("workbench.editor.lineending.external", DEFAULT_LINE_TERMINATOR_PROP_VALUE);
    }

    public String getInteralLineEndingValue() {
        return this.getProperty("workbench.editor.lineending.internal", UNIX_LINE_TERMINATOR_PROP_VALUE);
    }

    private String getLineEndingProperty(String string, String string2) {
        String string3 = this.getProperty(string, string2);
        if (DEFAULT_LINE_TERMINATOR_PROP_VALUE.equalsIgnoreCase(string3)) {
            return StringUtil.LINE_TERMINATOR;
        }
        if (UNIX_LINE_TERMINATOR_PROP_VALUE.equalsIgnoreCase(string3)) {
            return "\n";
        }
        if (DOS_LINE_TERMINATOR_PROP_VALUE.equalsIgnoreCase(string3)) {
            return "\r\n";
        }
        return "\n";
    }

    private void setLineEndingProperty(String string, String string2) {
        if (string2 == null) {
            return;
        }
        this.setProperty(string, string2.toLowerCase());
    }

    public boolean getStoreFilesInHistory() {
        return this.getBoolProperty("workbench.sql.history.includefiles", true);
    }

    public void getStoreFilesInHistory(boolean bl) {
        this.setProperty("workbench.sql.history.includefiles", bl);
    }

    public int getConsoleHistorySize() {
        return this.getIntProperty("workbench.console.sql.historysize", 50);
    }

    public int getMaxHistorySize() {
        return this.getIntProperty("workbench.sql.historysize", 15);
    }

    public void setMaxHistorySize(int n) {
        this.setProperty("workbench.sql.historysize", n);
    }

    public int getToolbarIconSize() {
        return this.getIntProperty("workbench.gui.iconsize", 16);
    }

    public void setToolbarIconSize(int n) {
        this.setProperty("workbench.gui.iconsize", n);
    }

    public boolean getScaleMenuIcons() {
        return this.getBoolProperty("workbench.gui.scale.menuicon", true);
    }

    public void setScaleMenuIcons(boolean bl) {
        this.setProperty("workbench.gui.scale.menuicon", bl);
    }

    public boolean getCacheIcons() {
        return this.getBoolProperty("workbench.gui.icon.cache.enabled", true);
    }

    public void setCacheIcons(boolean bl) {
        this.setProperty("workbench.gui.icon.cache.enabled", bl);
    }

    public final DelimiterDefinition getAlternateDelimiter(WbConnection wbConnection, DelimiterDefinition delimiterDefinition) {
        String string;
        DelimiterDefinition delimiterDefinition2 = null;
        if (wbConnection != null && wbConnection.getProfile() != null) {
            delimiterDefinition2 = wbConnection.getProfile().getAlternateDelimiter();
        }
        if (delimiterDefinition2 == null && wbConnection != null && StringUtil.isNonBlank(string = this.getDbDelimiter(wbConnection.getDbId()))) {
            delimiterDefinition2 = new DelimiterDefinition(string);
        }
        if (delimiterDefinition2 == null) {
            delimiterDefinition2 = this.getAlternateDelimiter(delimiterDefinition);
        }
        return delimiterDefinition2;
    }

    public final DelimiterDefinition getAlternateDelimiter(DelimiterDefinition delimiterDefinition) {
        String string = this.getProperty("workbench.sql.alternatedelimiter", null);
        if (StringUtil.isBlank(string)) {
            return delimiterDefinition;
        }
        DelimiterDefinition delimiterDefinition2 = new DelimiterDefinition(string);
        if (delimiterDefinition2.isStandard()) {
            return null;
        }
        return delimiterDefinition2;
    }

    public void setAlternateDelimiter(String string) {
        this.setProperty("workbench.sql.alternatedelimiter", string);
    }

    public boolean getRightClickMovesCursor() {
        return this.getBoolProperty("workbench.editor.rightclickmovescursor", false);
    }

    public void setRightClickMovesCursor(boolean bl) {
        this.setProperty("workbench.editor.rightclickmovescursor", bl);
    }

    public boolean getShowIgnoredWarning() {
        return this.getBoolProperty(PROPERTY_SHOW_IGNORED_WARN, true);
    }

    public boolean getShowLineNumbers() {
        return this.getBoolProperty(PROPERTY_SHOW_LINE_NUMBERS, true);
    }

    public void setShowLineNumbers(boolean bl) {
        this.setProperty(PROPERTY_SHOW_LINE_NUMBERS, bl);
    }

    public boolean getAutoJumpNextStatement() {
        return this.getBoolProperty(PROPERTY_AUTO_JUMP_STATEMENT, false);
    }

    public void setAutoJumpNextStatement(boolean bl) {
        this.setProperty(PROPERTY_AUTO_JUMP_STATEMENT, bl);
    }

    public boolean getIgnoreErrors() {
        return StringUtil.stringToBool(this.props.getProperty("workbench.sql.ignoreerror", "false"));
    }

    public void setIgnoreErrors(boolean bl) {
        this.setProperty("workbench.sql.ignoreerror", bl);
    }

    public boolean getHighlightCurrentStatement() {
        return this.getBoolProperty(PROPERTY_HIGHLIGHT_CURRENT_STATEMENT, false);
    }

    public Color getEditorBackgroundColor() {
        return this.getColor(PROPERTY_EDITOR_BG_COLOR, null);
    }

    public void setEditorBackgroundColor(Color color) {
        this.setColor(PROPERTY_EDITOR_BG_COLOR, color);
    }

    public Color getEditorTextColor() {
        return this.getColor(PROPERTY_EDITOR_FG_COLOR, null);
    }

    public void setEditorTextColor(Color color) {
        this.setColor(PROPERTY_EDITOR_FG_COLOR, color);
    }

    public void setEditorCursorColor(Color color) {
        this.setColor(PROPERTY_EDITOR_CURSOR_COLOR, color);
    }

    public Color getEditorCursorColor() {
        return this.getColor(PROPERTY_EDITOR_CURSOR_COLOR, Color.BLACK);
    }

    public void setEditorSelectionColor(Color color) {
        this.setColor(PROPERTY_EDITOR_SELECTION_COLOR, color);
    }

    public Color getEditorSelectionColor() {
        return this.getColor(PROPERTY_EDITOR_SELECTION_COLOR, null);
    }

    public void setEditorCurrentStmtColor(Color color) {
        this.setColor(PROPERTY_EDITOR_CURRENT_STMT_COLOR, color);
    }

    public Color getEditorCurrentStmtColor() {
        return this.getColor(PROPERTY_EDITOR_CURRENT_STMT_COLOR, Color.GREEN.brighter());
    }

    public void setEditorErrorColor(Color color) {
        this.setColor(PROPERTY_EDITOR_ERROR_STMT_COLOR, color);
    }

    public Color getEditorErrorColor() {
        return this.getColor(PROPERTY_EDITOR_ERROR_STMT_COLOR, Color.RED.brighter());
    }

    public Color getEditorCurrentLineColor() {
        return this.getColor(PROPERTY_EDITOR_CURRENT_LINE_COLOR, null);
    }

    public void setMinLengthForSelectionHighlight(int n) {
        this.setProperty(PROPERTY_EDITOR_OCCURANCE_HIGHLIGHT_MINLEN, n);
    }

    public int getMinLengthForSelectionHighlight() {
        return this.getIntProperty(PROPERTY_EDITOR_OCCURANCE_HIGHLIGHT_MINLEN, 2);
    }

    public boolean getSelectionHighlightIgnoreCase() {
        return this.getBoolProperty(PROPERTY_EDITOR_OCCURANCE_HIGHLIGHT_IGNORE_CASE, true);
    }

    public void setSelectionHighlightIgnoreCase(boolean bl) {
        this.setProperty(PROPERTY_EDITOR_OCCURANCE_HIGHLIGHT_IGNORE_CASE, bl);
    }

    public boolean getSelectionHighlightNoWhitespace() {
        return this.getBoolProperty(PROPERTY_EDITOR_OCCURANCE_HIGHLIGHT_NO_WHITESPACE, true);
    }

    public void setSelectionHighlightNoWhitespace(boolean bl) {
        this.setProperty(PROPERTY_EDITOR_OCCURANCE_HIGHLIGHT_NO_WHITESPACE, bl);
    }

    public void setHighlightCurrentSelection(boolean bl) {
        this.setProperty(PROPERTY_EDITOR_OCCURANCE_HIGHLIGHT, bl);
    }

    public boolean getHighlightCurrentSelection() {
        return this.getBoolProperty(PROPERTY_EDITOR_OCCURANCE_HIGHLIGHT, true);
    }

    public void setSelectionHighlightColor(Color color) {
        this.setColor(PROPERTY_EDITOR_OCCURANCE_HIGHLIGHT_COLOR, color);
    }

    public Color geSelectionHighlightColor() {
        return this.getColor(PROPERTY_EDITOR_OCCURANCE_HIGHLIGHT_COLOR, Color.YELLOW);
    }

    public boolean isBracketHighlightEnabled() {
        return this.getBoolProperty(PROPERTY_EDITOR_BRACKET_HILITE, true);
    }

    public void setBracketHighlight(boolean bl) {
        this.setProperty(PROPERTY_EDITOR_BRACKET_HILITE, bl);
    }

    public boolean getBracketHighlightLeft() {
        return this.getBoolProperty(PROPERTY_EDITOR_BRACKET_HILITE_LEFT, true);
    }

    public void setBracketHighlightLeft(boolean bl) {
        this.setProperty(PROPERTY_EDITOR_BRACKET_HILITE_LEFT, bl);
    }

    public boolean getBracketHighlightRectangle() {
        return this.getBoolProperty(PROPERTY_EDITOR_BRACKET_HILITE_REC, true);
    }

    public void setBracketHighlightRectangle(boolean bl) {
        this.setProperty(PROPERTY_EDITOR_BRACKET_HILITE_REC, bl);
    }

    public boolean getBracketHighlightBoth() {
        return this.getBoolProperty(PROPERTY_EDITOR_BRACKET_HILITE_BOTH, false);
    }

    public void setBracketHighlightBoth(boolean bl) {
        this.setProperty(PROPERTY_EDITOR_BRACKET_HILITE_BOTH, bl);
    }

    public Color getEditorBracketHighlightColor() {
        return this.getColor(PROPERTY_EDITOR_BRACKET_HILITE_COLOR, null);
    }

    public void setEditorCurrentLineColor(Color color) {
        this.setColor(PROPERTY_EDITOR_CURRENT_LINE_COLOR, color);
    }

    public int getElectricScroll() {
        return this.getIntProperty(PROPERTY_EDITOR_ELECTRIC_SCROLL, 0);
    }

    public void setElectricScroll(int n) {
        this.setProperty(PROPERTY_EDITOR_ELECTRIC_SCROLL, n < 0 ? 0 : n);
    }

    public int getEditorTabWidth() {
        return this.getIntProperty(PROPERTY_EDITOR_TAB_WIDTH, 2);
    }

    public void setEditorTabWidth(int n) {
        this.setProperty(PROPERTY_EDITOR_TAB_WIDTH, n);
    }

    public boolean getEditorUseTabCharacter() {
        return this.getBoolProperty("workbench.editor.usetab", false);
    }

    public void setEditorUseTabCharacter(boolean bl) {
        this.setProperty("workbench.editor.usetab", bl);
    }

    public String getEditorNoWordSep() {
        return this.getProperty("workbench.editor.nowordsep", "_$");
    }

    public void setEditorNoWordSep(String string) {
        this.setProperty("workbench.editor.nowordsep", string);
    }

    public boolean getJoinCompletionUseParens() {
        return this.getBoolProperty(PROP_JOIN_COMPLETION_USE_PARENS, false);
    }

    public void setJoinCompletionUseParens(boolean bl) {
        this.setProperty(PROP_JOIN_COMPLETION_USE_PARENS, bl);
    }

    public boolean getJoinCompletionPreferUSING() {
        return this.getBoolProperty(PROP_JOIN_COMPLETION_PREFER_USING, false);
    }

    public void setJoinCompletionPreferUSING(boolean bl) {
        this.setProperty(PROP_JOIN_COMPLETION_PREFER_USING, bl);
    }

    public boolean getUseProfileFilterForCompletion() {
        return this.getBoolProperty("workbench.editor.autocompletion.use.profilefilter", true);
    }

    public void setUseProfileFilterForCompletion(boolean bl) {
        this.setProperty("workbench.editor.autocompletion.use.profilefilter", bl);
    }

    public void setAutoCompletionPasteCase(GeneratedIdentifierCase generatedIdentifierCase) {
        this.setIdentifierCase("workbench.editor.autocompletion.paste.case", generatedIdentifierCase);
    }

    private void setIdentifierCase(String string, GeneratedIdentifierCase generatedIdentifierCase) {
        this.setProperty(string, generatedIdentifierCase.name());
    }

    public GeneratedIdentifierCase getAutoCompletionPasteCase() {
        return this.getIdentifierCase("workbench.editor.autocompletion.paste.case", GeneratedIdentifierCase.asIs);
    }

    private GeneratedIdentifierCase getIdentifierCase(String string, GeneratedIdentifierCase generatedIdentifierCase) {
        return this.getEnumProperty(string, generatedIdentifierCase);
    }

    public boolean getAutoCompletionUseCurrentNameSpace() {
        return this.getBoolProperty("workbench.editor.autocompletion.current.schema", true);
    }

    public void setAutoCompletionUseCurrentNameSpace(boolean bl) {
        this.setProperty("workbench.editor.autocompletion.current.schema", bl);
    }

    public ColumnSortType getAutoCompletionColumnSortType() {
        return this.getEnumProperty("workbench.editor.autocompletion.paste.sort", ColumnSortType.name);
    }

    public void setAutoCompletionColumnSort(ColumnSortType columnSortType) {
        this.setProperty("workbench.editor.autocompletion.paste.sort", columnSortType.name());
    }

    public boolean getCloseAutoCompletionWithSearch() {
        return this.getBoolProperty("workbench.editor.autocompletion.closewithsearch", false);
    }

    public void setCloseAutoCompletionWithSearch(boolean bl) {
        this.setProperty("workbench.editor.autocompletion.closewithsearch", bl);
    }

    public boolean getEmptyLineIsDelimiter() {
        return this.getBoolProperty("workbench.editor.sql.emptyline.delimiter", false);
    }

    public void setEmptyLineIsDelimiter(boolean bl) {
        this.setProperty("workbench.editor.sql.emptyline.delimiter", bl);
    }

    public AutoFileSaveType getAutoSaveExternalFiles() {
        AutoFileSaveType autoFileSaveType = AutoFileSaveType.never;
        if (this.getAutoSaveWorkspace()) {
            autoFileSaveType = AutoFileSaveType.always;
        }
        String string = this.getProperty("workbench.editor.autosave", autoFileSaveType.name());
        try {
            return AutoFileSaveType.valueOf(string);
        }
        catch (Throwable throwable) {
            return autoFileSaveType;
        }
    }

    public void setAutoSaveExternalFiles(AutoFileSaveType autoFileSaveType) {
        if (autoFileSaveType == null) {
            return;
        }
        this.setProperty("workbench.editor.autosave", autoFileSaveType.name());
    }

    public boolean getAutoSaveWorkspace() {
        return this.getBoolProperty("workbench.workspace.autosave", false);
    }

    public void setAutoSaveWorkspace(boolean bl) {
        this.setProperty("workbench.workspace.autosave", bl);
    }

    public int getMaxBackupFiles() {
        return this.getIntProperty("workbench.workspace.maxbackup", 5);
    }

    public void setMaxWorkspaceBackup(int n) {
        this.setProperty("workbench.workspace.maxbackup", n);
    }

    public void setCreateWorkspaceBackup(boolean bl) {
        this.setProperty("workbench.workspace.createbackup", bl);
    }

    public boolean getCreateWorkspaceBackup() {
        return this.getBoolProperty("workbench.workspace.createbackup", true);
    }

    public void setBackupDir(String string) {
        this.setProperty("workbench.workspace.backup.dir", string);
    }

    public String getBackupDir() {
        String string = FileDialogUtil.replaceConfigDir(this.getProperty("workbench.workspace.backup.dir", null));
        if (StringUtil.isBlank(string)) {
            return null;
        }
        WbFile wbFile = new WbFile(string);
        return wbFile.getAbsolutePath();
    }

    public boolean getCreateProfileBackup() {
        return this.getBoolProperty("workbench.profiles.createbackup", true);
    }

    public void setCreateProfileBackup(boolean bl) {
        this.setProperty("workbench.profiles.createbackup", bl);
    }

    public boolean getCreateDriverBackup() {
        return this.getBoolProperty("workbench.drivers.createbackup", true);
    }

    public void setCreateDriverBackup(boolean bl) {
        this.setProperty("workbench.drivers.createbackup", bl);
    }

    public boolean getCreateMacroBackup() {
        return this.getBoolProperty("workbench.macros.createbackup", true);
    }

    public void setCreateMacroBackup(boolean bl) {
        this.setProperty("workbench.macro.createbackup", bl);
    }

    public boolean getCreateSettingsBackup() {
        return this.getBoolProperty("workbench.settings.createbackup", false);
    }

    public void setCreateSettingsBackup(boolean bl) {
        this.setProperty("workbench.settings.createbackup", bl);
    }

    public void setFilesInWorkspaceHandling(ExternalFileHandling externalFileHandling) {
        this.setProperty("workbench.workspace.store.filenames", externalFileHandling.toString());
    }

    public ExternalFileHandling getFilesInWorkspaceHandling() {
        String string = this.getProperty("workbench.workspace.store.filenames", ExternalFileHandling.link.toString());
        return ExternalFileHandling.getValue(string);
    }

    public char getFileVersionDelimiter() {
        String string = this.getProperty("workbench.file.version.delimiter", ".");
        if (StringUtil.isBlank(string)) {
            return '.';
        }
        return string.charAt(0);
    }

    public boolean hideIgnoreWarnings() {
        return this.getBoolProperty("workbench.db.warnings.ignored.hide", true);
    }

    public boolean getUseGenericExecuteForSelect() {
        return this.getBoolProperty("workbench.db.select.genericexecute", false);
    }

    public String getPKMappingFilename() {
        String string = System.getProperty(PK_MAPPING_FILENAME_PROPERTY, this.getProperty(PK_MAPPING_FILENAME_PROPERTY, null));
        if (StringUtil.isEmptyString(string)) {
            return null;
        }
        return StringUtil.replace(string, "%ConfigDir%", this.getConfigDir().getAbsolutePath());
    }

    public void setPKMappingFilename(String string) {
        this.setProperty(PK_MAPPING_FILENAME_PROPERTY, string);
    }

    public boolean retrieveDbmsOutputAfterExec() {
        return this.getBoolProperty("workbench.db.oracle.dbmsoutput.automatic", true);
    }

    public boolean getPreviewDml() {
        return this.getBoolProperty("workbench.db.previewsql", true);
    }

    public void setPreviewDml(boolean bl) {
        this.props.setProperty("workbench.db.previewsql", Boolean.toString(bl));
    }

    public boolean getDebugMetadataSql() {
        return this.getBoolProperty("workbench.dbmetadata.debugmetasql", false);
    }

    public void setDebugMetadataSql(boolean bl) {
        this.setProperty("workbench.dbmetadata.debugmetasql", bl);
    }

    public boolean getCheckPreparedStatements() {
        return this.getBoolProperty("workbench.sql.checkprepared", false);
    }

    public void setCheckPreparedStatements(boolean bl) {
        this.setProperty("workbench.sql.checkprepared", bl);
    }

    public boolean getCheckEditableColumns() {
        return this.getBoolProperty("workbench.db.edit.verify.updateable", false);
    }

    public void setCheckEditableColumns(boolean bl) {
        this.setProperty("workbench.db.edit.verify.updateable", bl);
    }

    public int getStreamingPOIRows() {
        return this.getIntProperty("workbench.export.sxssf.rows.memory", 5000);
    }

    public boolean useStreamingPOI() {
        return this.getBoolProperty("workbench.export.xslx.use.sxssf", true);
    }

    public boolean getIncludeOwnerInSqlExport() {
        return this.getBoolProperty("workbench.export.sql.includeowner", true);
    }

    public void setIncludeOwnerInSqlExport(boolean bl) {
        this.setProperty("workbench.export.sql.includeowner", bl);
    }

    public String getDefaultTextDelimiter() {
        return this.getDefaultTextDelimiter(false);
    }

    public String getQuoteChar() {
        return this.getProperty("workbench.export.text.quotechar", "");
    }

    public void setQuoteChar(String string) {
        this.props.setProperty("workbench.export.text.quotechar", string);
    }

    public String getDefaultBlobTextEncoding() {
        return this.getProperty("workbench.blob.text.encoding", this.getDefaultDataEncoding());
    }

    public void setDefaultBlobTextEncoding(String string) {
        this.setProperty("workbench.blob.text.encoding", string);
    }

    public String getExportNullString() {
        return this.getProperty("workbench.export.general.nullstring", null);
    }

    public void setExportNullString(String string) {
        this.setProperty("workbench.export.general.nullstring", string);
    }

    public String getSystemFileEncoding() {
        String string = System.getProperty("file.encoding");
        if ("Cp1252".equals(string)) {
            string = "ISO-8859-15";
        }
        return string;
    }

    public String getDefaultDataEncoding() {
        return this.getProperty("workbench.file.data.encoding", this.getSystemFileEncoding());
    }

    public String getDefaultEncoding() {
        return this.getProperty("workbench.encoding", this.getSystemFileEncoding());
    }

    public String getDefaultFileEncoding() {
        return this.getProperty("workbench.file.encoding", this.getSystemFileEncoding());
    }

    public void setDefaultFileEncoding(String string) {
        this.props.setProperty("workbench.file.encoding", string);
    }

    public boolean getTrimTrailingSpaces() {
        return this.getBoolProperty(PROP_EDITOR_TRIM, false);
    }

    public void setTrimTrailingSpaces(boolean bl) {
        this.props.setProperty(PROP_EDITOR_TRIM, bl);
    }

    public String getDefaultTextDelimiter(boolean bl) {
        return this.getDelimiter("workbench.export.text.fielddelimiter", "\\t", bl);
    }

    public String getCssForClipboardHtml(String string) {
        return this.getProperty("workbench.copy.clipboard.html.css", string);
    }

    public boolean copyToClipboardAsHtml() {
        return this.getBoolProperty("workbench.copy.clipboard.html.enabled", true);
    }

    public void setClipboardDelimiter(String string) {
        this.setDelimiter("workbench.import.clipboard.fielddelimiter", string);
    }

    public String getClipboardDelimiter(boolean bl) {
        return this.getDelimiter("workbench.import.clipboard.fielddelimiter", "\\t", bl);
    }

    public void setUseMultirowInsertForClipboard(MultiRowInserts multiRowInserts) {
        this.setProperty("workbench.copy.clipboard.insert.multirow", multiRowInserts.toString());
    }

    public MultiRowInserts getUseMultirowInsertForClipboard() {
        String string = this.getProperty("workbench.copy.clipboard.insert.multirow", "dbms");
        if ("true".equals(string)) {
            return MultiRowInserts.always;
        }
        if ("false".equals(string)) {
            return MultiRowInserts.never;
        }
        try {
            return MultiRowInserts.valueOf(string);
        }
        catch (Exception exception) {
            return MultiRowInserts.never;
        }
    }

    public void setDelimiter(String string, String string2) {
        if (string2.equals("\t")) {
            string2 = "\\t";
        }
        this.setProperty(string, string2);
    }

    public String getDelimiter(String string, String string2, boolean bl) {
        String string3 = this.getProperty(string, string2);
        if (bl) {
            if (string3.equals("\t")) {
                string3 = "\\t";
            }
        } else if (string3.equals("\\t")) {
            string3 = "\t";
        }
        return string3;
    }

    public String getLastImportDelimiter(boolean bl) {
        return this.getDelimiter("workbench.import.text.fielddelimiter", "\\t", bl);
    }

    public File getDefaultXsltDirectory() {
        if (WbManager.getInstance() == null) {
            return new File(".");
        }
        String string = this.getProperty("workbench.xslt.dir", null);
        File file = null;
        if (string == null) {
            ClasspathUtil classpathUtil = new ClasspathUtil();
            file = new File(classpathUtil.getJarPath(), "xslt");
        } else {
            file = new File(string);
        }
        return file;
    }

    public String getDefaultXmlVersion() {
        return this.getProperty("workbench.xml.default.version", "1.0");
    }

    public boolean getDefaultWriteEmptyExports() {
        return this.getBoolProperty("workbench.export.default.writeempty", true);
    }

    public void setLastImportDelimiter(String string) {
        if (string.equals("\t")) {
            string = "\\t";
        }
        this.props.setProperty("workbench.import.text.fielddelimiter", string);
    }

    public boolean getLastImportWithHeaders() {
        return this.getBoolProperty("workbench.import.text.containsheader", true);
    }

    public void setLastImportWithHeaders(boolean bl) {
        this.props.setProperty("workbench.import.text.containsheader", Boolean.toString(bl));
    }

    public String getLastImportDateFormat() {
        return this.getProperty("workbench.import.dateformat", this.getDefaultDateFormat());
    }

    public void setLastImportDateFormat(String string) {
        this.props.setProperty("workbench.import.dateformat", string);
    }

    public void setLastImportNumberFormat(String string) {
        this.props.setProperty("workbench.import.numberformat", string);
    }

    public String getLastImportNumberFormat() {
        String string = this.getProperty("workbench.import.numberformat", null);
        if (string == null) {
            string = "#" + this.getDecimalSymbol() + "#";
        }
        return string;
    }

    public boolean getLastImportDecode() {
        return this.getBoolProperty("workbench.import.decode");
    }

    public void setLastImportDecode(boolean bl) {
        this.setProperty("workbench.import.decode", bl);
    }

    public String getLastImportQuoteChar() {
        return this.getProperty("workbench.import.quotechar", "\"");
    }

    public void setLastImportQuoteChar(String string) {
        this.props.setProperty("workbench.import.quotechar", string);
    }

    public String getLastImportDir() {
        return this.getProperty("workbench.import.lastdir", this.getLastExportDir());
    }

    public void setLastImportDir(String string) {
        this.props.setProperty("workbench.import.lastdir", string);
    }

    public boolean getUseXLSXSaxReader() {
        return this.getBoolProperty("workbench.import.xlsx.use.saxreader", false);
    }

    public String getLastLibraryDir() {
        return this.getProperty("workbench.drivers.lastlibdir", "");
    }

    public void setLastLibraryDir(String string) {
        this.props.setProperty("workbench.drivers.lastlibdir", string);
    }

    public String getLastBlobDir() {
        return this.getProperty("workbench.data.blob.save.lastdir", null);
    }

    public void setLastBlobDir(String string) {
        this.setProperty("workbench.data.blob.save.lastdir", string);
    }

    public String getLastWorkspaceDir() {
        return this.getProperty("workbench.workspace.lastdir", this.getConfigDir().getAbsolutePath());
    }

    public void setLastWorkspaceDir(String string) {
        this.props.setProperty("workbench.workspace.lastdir", string);
    }

    public String getLastExportDir() {
        return this.getProperty("workbench.export.lastdir", "");
    }

    public void setLastExportDir(String string) {
        this.props.setProperty("workbench.export.lastdir", string);
    }

    public boolean getStoreScriptDirInWksp() {
        return this.getBoolProperty("workbench.scriptdir.store.in.workspace", false);
    }

    public void setStoreScriptDirInWksp(boolean bl) {
        this.setProperty("workbench.scriptdir.store.in.workspace", bl);
    }

    public String getLastSqlDir() {
        return this.getProperty("workbench.sql.lastscriptdir", "");
    }

    public void setLastSqlDir(String string) {
        this.props.setProperty("workbench.sql.lastscriptdir", string);
    }

    public String getLastEditorDir() {
        return this.getProperty("workbench.editor.lastdir", "");
    }

    public void setLastEditorDir(String string) {
        this.props.setProperty("workbench.editor.lastdir", string);
    }

    public String getLastFilterDir() {
        return this.getProperty("workbench.filter.lastdir", "");
    }

    public void setLastFilterDir(String string) {
        this.props.setProperty("workbench.filter.lastdir", string);
    }

    public void setDefaultDateFormat(String string) {
        this.props.setProperty(PROPERTY_DATE_FORMAT, string);
    }

    public void registerDateFormatChangeListener(PropertyChangeListener propertyChangeListener) {
        this.addPropertyChangeListener(propertyChangeListener, PROPERTY_DATE_FORMAT, PROPERTY_DATETIME_FORMAT, PROPERTY_TIME_FORMAT);
    }

    public boolean isDateFormatProperty(String string) {
        if (string == null) {
            return false;
        }
        return PROPERTY_DATE_FORMAT.equals(string) || PROPERTY_DATETIME_FORMAT.equals(string) || PROPERTY_TIME_FORMAT.equals(string);
    }

    public boolean useVariableLengthTimeFractions() {
        return this.getBoolProperty(PROPERTY_VARIABLE_LENGTH_TS_FRACTION, false);
    }

    public String getDefaultDateFormat() {
        return this.getProperty(PROPERTY_DATE_FORMAT, "yyyy-MM-dd");
    }

    public String getDefaultTimestampFormat() {
        return this.getProperty(PROPERTY_DATETIME_FORMAT, "yyyy-MM-dd HH:mm:ss.SSS");
    }

    public void setDefaultTimestampFormat(String string) {
        this.props.setProperty(PROPERTY_DATETIME_FORMAT, string);
    }

    public void setDefaultTimeFormat(String string) {
        this.props.setProperty(PROPERTY_TIME_FORMAT, string);
    }

    public String getDefaultTimeFormat() {
        return this.getProperty(PROPERTY_TIME_FORMAT, "HH:mm:ss");
    }

    public boolean getUsedFixedDigits() {
        return this.getBoolProperty(PROPERTY_FIXED_DIGITS, false);
    }

    public void setUsedFixedDigits(boolean bl) {
        this.setProperty(PROPERTY_FIXED_DIGITS, bl);
    }

    public void setDefaultExportTextDelimiter(String string) {
        if (string.equals("\t")) {
            string = "\\t";
        }
        this.props.setProperty("workbench.export.text.fielddelimiter", string);
    }

    public void setLastExportDecimalSeparator(String string) {
        this.setProperty("workbench.export.text.decimal.last", string);
    }

    public String getLastExportDecimalSeparator() {
        return this.getProperty("workbench.export.text.decimal.last", this.getDecimalSymbol());
    }

    public int getLastExportMaxFractionDigits() {
        return this.getIntProperty("workbench.export.text.digits.last", this.getMaxFractionDigits());
    }

    public void setLastExportMaxFractionDigits(int n) {
        this.setProperty("workbench.export.text.digits.last", n);
    }

    public int getMaxFractionDigits() {
        return this.getIntProperty(PROPERTY_DECIMAL_DIGITS, 0);
    }

    public void setMaxFractionDigits(int n) {
        this.props.setProperty(PROPERTY_DECIMAL_DIGITS, Integer.toString(n));
    }

    public WbNumberFormatter createDefaultDecimalFormatter(int n) {
        String string = this.getDecimalSymbol();
        return new WbNumberFormatter(n, string.charAt(0));
    }

    public WbNumberFormatter createDefaultIntegerFormatter() {
        String string = this.getIntegerFormatString();
        if (StringUtil.isNonBlank(string)) {
            char c = this.getDecimalSymbol().charAt(0);
            char c2 = this.getDecimalGroupCharacter().charAt(0);
            return new WbNumberFormatter(string, c, c2);
        }
        return null;
    }

    public WbNumberFormatter createDefaultDecimalFormatter() {
        String string = this.getDecimalFormatString();
        char c = this.getDecimalSymbol().charAt(0);
        char c2 = this.getDecimalGroupCharacter().charAt(0);
        if (StringUtil.isNonBlank(string)) {
            try {
                return new WbNumberFormatter(string, c, c2);
            }
            catch (Throwable throwable) {
                LogMgr.logError(new CallerInfo(){}, "Could not create number formatter using \"" + string + "\"", throwable);
            }
        }
        int n = this.getMaxFractionDigits();
        return new WbNumberFormatter(n, c);
    }

    public String getDecimalSymbol() {
        String string = this.getProperty(PROPERTY_DECIMAL_SEP, ".");
        if (StringUtil.isEmptyString(string)) {
            return ".";
        }
        return string;
    }

    public void setDecimalSymbol(String string) {
        this.props.setProperty(PROPERTY_DECIMAL_SEP, string);
    }

    public String getDecimalGroupCharacter() {
        String string = this.getProperty(PROPERTY_DECIMAL_GROUP, ",");
        if (StringUtil.isEmptyString(string)) {
            string = ",";
        }
        return string;
    }

    public void setDecimalGroupCharacter(String string) {
        this.props.setProperty(PROPERTY_DECIMAL_GROUP, string);
    }

    public void setDecimalFormatString(String string) {
        this.props.setProperty(PROPERTY_DECIMAL_FORMAT, string);
    }

    public String getDecimalFormatString() {
        return this.getProperty(PROPERTY_DECIMAL_FORMAT, null);
    }

    public void setIntegerFormatString(String string) {
        this.props.setProperty(PROPERTY_INTEGER_FORMAT, string);
    }

    public String getIntegerFormatString() {
        return this.getProperty(PROPERTY_INTEGER_FORMAT, null);
    }

    public int getMaxErrorStatementLength() {
        return this.getIntProperty("workbench.gui.log.error.sql.maxlength", 150);
    }

    public final ErrorReportLevel getStatementErrorReportLevel() {
        return this.getEnumProperty(PROPERTY_ERROR_STATEMENT_LOG_LEVEL, ErrorReportLevel.limited);
    }

    public boolean getSaveProfilesImmediately() {
        return this.getBoolProperty("workbench.profiles.saveonclose", false);
    }

    public void setSaveProfilesImmediately(boolean bl) {
        this.setProperty("workbench.profiles.saveonclose", bl);
    }

    public int getSyncChunkSize() {
        return this.getIntProperty("workbench.sql.sync.chunksize", 25);
    }

    public boolean getCommandLineVarsAreGlobal() {
        return this.getBoolProperty(PROPERTY_CMDLINE_VARS_GLOBAL, true);
    }

    public boolean getCleanupVariableValues() {
        return this.getBoolProperty(PROPERTY_VAR_CLEANUP, false);
    }

    public boolean getSortPromptVariables() {
        return this.getBoolProperty(PROPERTY_SORT_VARS, true);
    }

    public String getSqlParameterPrefix() {
        String string = this.getProperty(PROPERTY_VAR_PREFIX, "$[");
        if (StringUtil.isEmptyString(string)) {
            string = "$[";
        }
        return string;
    }

    public String getSqlParameterSuffix() {
        if (this.props.containsKey(PROPERTY_VAR_SUFFIX) || System.getProperties().containsKey(PROPERTY_VAR_SUFFIX)) {
            return this.getProperty(PROPERTY_VAR_SUFFIX, "");
        }
        return "]";
    }

    public final boolean getLogParameterSubstitution() {
        return this.getBoolProperty(PROP_LOG_VARIABLE_SUBSTITUTION, false);
    }

    public int getMaxLogfileSize() {
        return this.getIntProperty("workbench.log.maxfilesize", 0xA00000);
    }

    public int getLogfileBackupCount() {
        return this.getIntProperty("workbench.log.backup.count", 5);
    }

    public boolean getDelimiterDefaultSingleLine() {
        return this.getBoolProperty("workbench.delimiter.newline.default", true);
    }

    public boolean getWbIncludeDefaultContinue() {
        return this.getBoolProperty("workbench.wbinclude.continue.default", false);
    }

    public boolean getWbIncludeDefaultVerbose() {
        return this.getBoolProperty("workbench.wbinclude.verbose.default", true);
    }

    public boolean useNonStandardQuoteEscaping(String string) {
        boolean bl = this.getBoolProperty("workbench.sql.checkescapedquotes", false);
        if (string != null) {
            return this.getBoolProperty("workbench.db." + string + ".sql.checkescapedquotes", bl);
        }
        return bl;
    }

    public boolean useNonStandardQuoteEscaping(WbConnection wbConnection) {
        return this.useNonStandardQuoteEscaping(wbConnection == null ? null : wbConnection.getDbId());
    }

    public boolean getAutoConnectObjectSearcher() {
        return this.getBoolProperty("workbench.objectsearcher.autoconnect", true);
    }

    public void setAutoConnectObjectSearcer(boolean bl) {
        this.setProperty("workbench.objectsearcher.autoconnect", bl);
    }

    public boolean getAutoConnectDataPumper() {
        return this.getBoolProperty("workbench.datapumper.autoconnect", true);
    }

    public void setAutoConnectDataPumper(boolean bl) {
        this.setProperty("workbench.datapumper.autoconnect", bl);
    }

    public ProfileKey getLastConnection(String string) {
        String string2;
        if (string == null) {
            string = "workbench.connection.last";
        }
        if ((string2 = this.getProperty(string, null)) == null) {
            return null;
        }
        String string3 = this.getProperty(string + ".group", null);
        return new ProfileKey(string2, string3);
    }

    public void setLastConnection(ConnectionProfile connectionProfile) {
        this.setLastConnection("workbench.connection.last", connectionProfile);
    }

    public void setLastConnection(String string, ConnectionProfile connectionProfile) {
        if (connectionProfile == null) {
            this.props.setProperty(string, "");
            this.props.setProperty(string + ".group", "");
        } else if (!connectionProfile.isTemporaryProfile()) {
            this.props.setProperty(string, connectionProfile.getName());
            this.props.setProperty(string + ".group", connectionProfile.getGroup());
        }
    }

    public void setGeneratedSqlTableCase(GeneratedIdentifierCase generatedIdentifierCase) {
        this.setIdentifierCase("workbench.sql.generate.table.case", generatedIdentifierCase);
    }

    public GeneratedIdentifierCase getGeneratedSqlTableCase() {
        return this.getIdentifierCase("workbench.sql.generate.table.case", GeneratedIdentifierCase.asIs);
    }

    public int getInMemoryScriptSizeThreshold() {
        return this.getIntProperty("workbench.sql.script.inmemory.maxsize", 0x200000);
    }

    public void setInMemoryScriptSizeThreshold(int n) {
        this.setProperty("workbench.sql.script.inmemory.maxsize", n);
    }

    public Locale getSortLocale() {
        if (!this.getBoolProperty("workbench.sort.usecollator", false)) {
            return null;
        }
        Locale locale = null;
        String string = Settings.getInstance().getSortLanguage();
        String string2 = Settings.getInstance().getSortCountry();
        try {
            if (string != null && string2 != null) {
                locale = new Locale(string, string2);
            } else if (string != null && string2 == null) {
                locale = new Locale(string);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error creating collation", exception);
            locale = Locale.getDefault();
        }
        return locale;
    }

    public void setSortLocale(Locale locale) {
        if (locale == null) {
            this.setProperty("workbench.sort.usecollator", false);
        } else {
            this.setProperty("workbench.sort.usecollator", true);
            this.setProperty("workbench.sort.language", locale.getLanguage());
            this.setProperty("workbench.sort.country", locale.getCountry());
        }
    }

    public boolean isUTF8Language(Locale locale) {
        return this.getBoolProperty("workbench.locale.use.utf8." + locale.getLanguage(), false);
    }

    private String getSortLanguage() {
        return this.getProperty("workbench.sort.language", System.getProperty("user.language"));
    }

    private String getSortCountry() {
        return this.getProperty("workbench.sort.country", System.getProperty("user.country"));
    }

    public void setEncryptedMasterPassword(String string) {
        this.setProperty(PROPERTY_MASTER_PWD, StringUtil.trimToNull(string));
    }

    public boolean getUseMasterPassword() {
        return this.getEncryptedMasterPassword() != null;
    }

    public String getEncryptedMasterPassword() {
        return this.getProperty(PROPERTY_MASTER_PWD, null);
    }

    @Override
    public void removeProperty(String string) {
        System.getProperties().remove(string);
        this.props.removeProperty(string);
    }

    public boolean getBoolProperty(String string) {
        return this.getBoolProperty(string, false);
    }

    @Override
    public final boolean getBoolProperty(String string, boolean bl) {
        String string2 = System.getProperty(string, null);
        if (string2 != null) {
            return Boolean.valueOf(string2);
        }
        return this.props.getBoolProperty(string, bl);
    }

    @Override
    public void setProperty(String string, boolean bl) {
        this.props.setProperty(string, bl);
    }

    public void setTemporaryProperty(String string, String string2) {
        this.props.setTemporaryProperty(string, string2);
    }

    @Override
    public Object setProperty(String string, String string2) {
        return this.props.setProperty(string, string2);
    }

    @Override
    public void setProperty(String string, int n) {
        this.props.setProperty(string, Integer.toString(n));
    }

    @Override
    public String getProperty(String string, String string2) {
        return System.getProperty(string, this.props.getProperty(string, string2));
    }

    public final <E extends Enum<E>> E getEnumProperty(String string, E e) {
        String string2 = this.getProperty(string, null);
        return this.getEnumValue(string2, e);
    }

    public final <E extends Enum<E>> E getEnumValue(String string, E e) {
        if (string != null) {
            try {
                return (E)Enum.valueOf(e.getClass(), string);
            }
            catch (Throwable throwable) {
                LogMgr.logWarning(new CallerInfo(){}, "Invalid enum value '" + string + "' specified");
            }
        }
        return e;
    }

    public List<String> getListProperty(String string, boolean bl) {
        return this.getListProperty(string, bl, null);
    }

    public List<String> getListProperty(String string, boolean bl, String string2) {
        String string3 = System.getProperty(string, this.props.getProperty(string, string2));
        if (bl && string3 != null) {
            string3 = string3.toLowerCase();
        }
        return StringUtil.stringToList(string3, ",", true, true, false);
    }

    @Override
    public final int getIntProperty(String string, int n) {
        String string2 = System.getProperty(string, null);
        if (string2 != null) {
            return StringUtil.getIntValue(string2, n);
        }
        return this.props.getIntProperty(string, n);
    }

    public void setColor(String string, Color color) {
        this.setProperty(string, Settings.colorToString(color));
    }

    public static String colorToString(Color color) {
        String string = null;
        if (color != null) {
            int n = color.getRed();
            int n2 = color.getGreen();
            int n3 = color.getBlue();
            string = Integer.toString(n) + "," + Integer.toString(n2) + "," + Integer.toString(n3);
        }
        return string;
    }

    public int getWindowPosX(String string) {
        int n = this.getIntProperty(this.getResolutionDependentKey(string, "x"), Integer.MIN_VALUE);
        if (n == Integer.MIN_VALUE) {
            n = this.getIntProperty(string + ".x", Integer.MIN_VALUE);
        }
        return n;
    }

    public int getWindowPosY(String string) {
        int n = this.getIntProperty(this.getResolutionDependentKey(string, "y"), Integer.MIN_VALUE);
        if (n == Integer.MIN_VALUE) {
            n = this.getIntProperty(string + ".y", Integer.MIN_VALUE);
        }
        return n;
    }

    public int getWindowWidth(String string) {
        int n = this.getIntProperty(this.getResolutionDependentKey(string, "width"), Integer.MIN_VALUE);
        if (n == Integer.MIN_VALUE) {
            n = this.getIntProperty(string + ".width", Integer.MIN_VALUE);
        }
        return n;
    }

    public int getWindowHeight(String string) {
        int n = this.getIntProperty(this.getResolutionDependentKey(string, "height"), Integer.MIN_VALUE);
        if (n == Integer.MIN_VALUE) {
            n = this.getIntProperty(string + ".height", Integer.MIN_VALUE);
        }
        return n;
    }

    public void storeWindowPosition(Component component) {
        this.storeWindowPosition(component, component.getClass().getName());
    }

    public void storeWindowPosition(Component component, String string) {
        Point point = component.getLocation();
        this.setWindowPosition(string, point.x, point.y);
    }

    public void storeWindowSize(Component component) {
        this.storeWindowSize(component, null);
    }

    private String getScreenResolutionKey() {
        try {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            return Long.toString((long)dimension.getWidth()) + "x" + Long.toString((long)dimension.getHeight());
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    private String getResolutionDependentKey(String string, String string2) {
        String string3 = this.getScreenResolutionKey();
        if (string3 == null) {
            return string + "." + string2;
        }
        return string + "." + string3 + "." + string2;
    }

    public void storeWindowSize(Component component, String string) {
        if (component == null) {
            return;
        }
        Dimension dimension = component.getSize();
        if (string == null) {
            string = component.getClass().getName();
        }
        this.setWindowSize(string, dimension.width, dimension.height);
    }

    public void setWindowPosition(String string, int n, int n2) {
        this.props.setProperty(this.getResolutionDependentKey(string, "x"), Integer.toString(n));
        this.props.setProperty(this.getResolutionDependentKey(string, "y"), Integer.toString(n2));
    }

    public void setWindowSize(String string, int n, int n2) {
        this.props.setProperty(this.getResolutionDependentKey(string, "width"), Integer.toString(n));
        this.props.setProperty(this.getResolutionDependentKey(string, "height"), Integer.toString(n2));
    }

    public boolean restoreWindowSize(Component component) {
        return this.restoreWindowSize(component, component.getClass().getName());
    }

    private int getLastVersionForWindowSizes(String string) {
        return this.getIntProperty(string + ".last_version", 0);
    }

    private void storeLastVersionForWindowSizes(String string) {
        this.setProperty(string + ".last_version", ResourceMgr.getBuildNumber().getMajorVersion());
    }

    private int getCurrentVersionForWindowSizes() {
        return ResourceMgr.getBuildNumber().getMajorVersion();
    }

    private boolean resetSizeIfNeeded(String string) {
        boolean bl = this.getBoolProperty(string + ".reset_size", false);
        if (!bl) {
            return false;
        }
        int n = this.getCurrentVersionForWindowSizes();
        if (n == 999) {
            return false;
        }
        if (this.getLastVersionForWindowSizes(string) < n) {
            LogMgr.logDebug(new CallerInfo(){}, "Resetting stored window sizes and position for: " + string);
            List<String> list = this.props.getKeysWithPrefix(string);
            for (String string2 : list) {
                if (!string2.endsWith(".width") && !string2.endsWith(".height") && !string2.endsWith(".xx") && !string2.endsWith(".yy")) continue;
                LogMgr.logTrace(new CallerInfo(){}, "Removing property: " + string2);
                this.removeProperty(string2);
            }
            this.storeLastVersionForWindowSizes(string);
            return true;
        }
        return false;
    }

    public boolean restoreWindowSize(Component component, String string) {
        if (StringUtil.isEmptyString(string)) {
            return false;
        }
        if (this.resetSizeIfNeeded(string)) {
            return false;
        }
        boolean bl = false;
        int n = this.getWindowWidth(string);
        int n2 = this.getWindowHeight(string);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (n > 0 && n2 > 0 && (double)n <= dimension.getWidth() && (double)n2 <= dimension.getHeight()) {
            bl = true;
            WbSwingUtilities.invoke(() -> component.setSize(new Dimension(n, n2)));
        }
        return bl;
    }

    public boolean restoreWindowPosition(Component component) {
        return this.restoreWindowPosition(component, component.getClass().getName());
    }

    public boolean restoreWindowPosition(Component component, String string) {
        if (component == null) {
            return false;
        }
        int n = this.getWindowPosX(string);
        int n2 = this.getWindowPosY(string);
        if (n == Integer.MIN_VALUE || n2 == Integer.MIN_VALUE) {
            return false;
        }
        Rectangle rectangle = WbSwingUtilities.getVirtualBounds();
        Rectangle rectangle2 = new Rectangle(n, n2, component.getWidth(), component.getHeight());
        if (WbSwingUtilities.isOutsideOfScreen(rectangle2)) {
            LogMgr.logInfo(new CallerInfo(){}, "Stored window position " + WbSwingUtilities.displayString(rectangle2) + " not restored because it is outside the current screen size: " + WbSwingUtilities.displayString(rectangle));
            return false;
        }
        LogMgr.logDebug(new CallerInfo(){}, "Restoring window position for '" + string + "', current screen size: " + WbSwingUtilities.displayString(rectangle) + ", requested position: " + WbSwingUtilities.displayString(rectangle2));
        WbSwingUtilities.invoke(() -> component.setLocation(new Point(n, n2)));
        return true;
    }

    private void migrateProps() {
        Object object;
        String string = this.getProperty("workbench.db.objecttype.selectable.default", null);
        if (string != null && !(object = StringUtil.stringToList(string.toLowerCase(), ",", true, true, false)).contains("synonym")) {
            object.add("synonym");
            this.setProperty("workbench.db.objecttype.selectable.default", StringUtil.listToString((Collection)object, ','));
        }
        if ((object = this.getProperty("workbench.db.oracle.exclude.synonyms", null)) != null && !((String)object).startsWith("^/.*")) {
            object = "^/.*|" + (String)object;
            this.setProperty("workbench.db.oracle.exclude.synonyms", (String)object);
        }
        WbProperties wbProperties = this.getDefaultProperties();
        this.upgradeListProp(wbProperties, "workbench.db.oracle.syntax.functions");
        this.upgradeProp(wbProperties, "workbench.db.postgresql.selectinto.pattern", "(?s)^SELECT\\s+.*INTO\\s+\\p{Print}*\\s*FROM.*");
        this.upgradeProp(wbProperties, "workbench.db.informix_dynamic_server.selectinto.pattern", "(?s)^SELECT.*FROM.*INTO\\s*\\p{Print}*");
        this.upgradeProp(wbProperties, "workbench.db.sql.comment.column", "COMMENT ON COLUMN %object_name%.%column% IS '%comment%';");
        this.upgradeProp(wbProperties, "workbench.db.oracle.add.column", "ALTER TABLE %table_name% ADD COLUMN %column_name% %datatype% %default_expression% %nullable%");
        this.upgradeListProp(wbProperties, "workbench.db.nonullkeyword");
    }

    private void upgradeProp(WbProperties wbProperties, String string, String string2) {
        String string3 = this.getProperty(string, "");
        if (string2.equals(string3)) {
            String string4 = wbProperties.getProperty(string, null);
            this.setProperty(string, string4);
        }
    }

    private void upgradeListProp(WbProperties wbProperties, String string) {
        String string2 = this.getProperty(string, "");
        List<String> list = StringUtil.stringToList(string2, ",", true, true, false);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(list);
        String string3 = wbProperties.getProperty(string, "");
        List<String> list2 = StringUtil.stringToList(string3, ",", true, true, false);
        hashSet.addAll(list2);
        this.setProperty(string, StringUtil.listToString(hashSet, ','));
    }

    public void replacePartialKey(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Object object : this.props.keySet()) {
            String string3 = object.toString();
            if (!string3.contains(string)) continue;
            hashMap.put(string3, string3.replace(string, string2));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            LogMgr.logDebug(new CallerInfo(){}, "Renaming: " + (String)entry.getKey() + " to " + (String)entry.getValue());
            this.renameProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void renameOldProps() {
        this.renameProperty("workbench.worspace.recent", "workbench.workspace.recent");
        this.renameProperty("workbench.sql.search.lastValue", "workbench.sql.search.lastvalue");
        this.renameProperty("workbench.sql.maxcolwidth", "workbench.gui.optimalwidth.maxsize");
        this.renameProperty("workbench.sql.mincolwidth", "workbench.gui.optimalwidth.minsize");
        this.renameProperty("sort.language", "workbench.sort.language");
        this.renameProperty("sort.country", "workbench.sort.country");
        this.renameProperty("connection.last", "workbench.connection.last");
        this.renameProperty("drivers.lastlibdir", "workbench.drivers.lastlibdir");
        this.renameProperty("workbench.db.debugger", "workbench.db.previewsql");
        this.renameProperty("workbench.db.objecttype.data.postgres", "workbench.db.objecttype.data.postgresql");
        this.renameProperty("workbench.db.objecttype.selectable.postgres", "workbench.db.objecttype.selectable.postgresql");
        this.renameProperty("workbench.ignoretypes.postgres", "workbench.ignoretypes.postgresql");
        String string = this.getProperty("workbench.db.truncatesupported", null);
        if (string != null) {
            string = string.replace(",postgres,", ",postgresql,");
            this.setProperty("workbench.db.truncatesupported", string);
        }
        this.renameProperty("workbench.history.tablelist", "workbench.quickfilter.tablelist.history");
        this.renameProperty("workbench.history.columnlist", "workbench.quickfilter.columnlist.history");
        this.renameProperty("workbench.gui.dbobjects.ProcedureListPanel.lastsearch", "workbench.quickfilter.procedurelist.history");
        this.renameProperty("workbench.blob.text.encoding", "workbench.gui.blob.text.encoding");
        this.renameProperty("workbench.javacode.includenewline", "workbench.clipcreate.includenewline");
        this.renameProperty("workbench.javacode.codeprefix", "workbench.clipcreate.codeprefix");
        this.renameProperty("workbench.sql.replace.criteria", "workbench.sql.replace.criteria.lastvalue");
        this.renameProperty("workbench.sql.replace.replacement", "workbench.sql.replace.replacement.lastvalue");
        this.renameProperty("workbench.db.nullkeyword.ingres", "workbench.db.ingres.nullkeyword");
        this.renameProperty("workbench.db.defaultbeforenull.ingres", "workbench.db.ingres.defaultbeforenull");
        this.renameProperty("workbench.db.defaultbeforenull.firebird", "workbench.db.firebird.defaultbeforenull");
        this.renameProperty("workbench.db.defaultbeforenull.oracle", "workbench.db.oracle.defaultbeforenull");
        this.renameProperty("workbench.db.procversiondelimiter.microsoft_sql_server", "workbench.db.microsoft_sql_server.procversiondelimiter");
        this.renameProperty("workbench.db.procversiondelimiter.adaptive_server_enterprise", "workbench.db.adaptive_server_enterprise.procversiondelimiter");
        this.renameProperty("workbench.sql.searchsearch.history", "workbench.sql.search.history");
        this.renameProperty("workbench.sql.searchsearch.lastvalue", "workbench.sql.search.lastvalue");
        this.renameProperty("workbench.datasearch.history", "workbench.data.search.history");
        this.renameProperty("workbench.datasearch.lastvalue", "workbench.data.search.lastvalue");
        this.renameProperty("workbench.editor.autocompletion.sql.emptylineseparator", "workbench.editor.sql.emptyline.delimiter");
        this.removeProperty("workbench.gui.animatedicon.name");
        this.removeProperty("workbench.gui.animatedicon");
        String string2 = this.props.getProperty("workbench.db.postgresql..inlineconstraints", null);
        if ("true".equals(string2)) {
            this.removeProperty("workbench.db.postgresql..inlineconstraints");
            this.props.setProperty("workbench.db.postgresql.pk.inline", "true");
            this.props.setProperty("workbench.db.postgresql.fk.inline", "true");
        }
        this.renameProperty("workbench.gui.selection.summar", "workbench.gui.data.selection.summary");
    }

    private void renameProperty(String string, String string2) {
        if (this.props.containsKey(string)) {
            Object object = this.props.get(string);
            this.props.remove(string);
            this.props.put(string2, object);
        }
    }

    private void removeObsolete() {
        try {
            this.props.remove("workbench.db.fetchsize");
            this.props.remove("workbench.gui.edit.profile.ssh");
            this.props.remove("workbench.editor.java.lastdir");
            this.props.remove("workbench.sql.replace.ignorecase");
            this.props.remove("workbench.sql.replace.selectedtext");
            this.props.remove("workbench.sql.replace.useregex");
            this.props.remove("workbench.sql.replace.wholeword");
            this.props.remove("workbench.sql.search.ignorecase");
            this.props.remove("workbench.sql.search.useregex");
            this.props.remove("workbench.sql.search.wholeword");
            this.props.remove("workbench.sql.search.lastvalue");
            this.props.remove("workbench.dbexplorer.rememberSchema");
            this.props.remove("workbench.db.postgres.select.startstransaction");
            this.props.remove("workbench.db.oracle.quotedigits");
            this.props.remove("workbench.gui.macros.replaceonrun");
            this.props.remove("workbench.db.cancelneedsreconnect");
            this.props.remove("workbench.db.trigger.replacenl");
            this.props.remove("workbench.sql.multipleresultsets");
            this.props.remove("workbench.db.keywordlist.oracle");
            this.props.remove("workbench.db.keywordlist.thinksql_relational_database_management_system");
            this.props.remove("workbench.gui.settings.ExternalToolsPanel.divider");
            this.props.remove("workbench.gui.settings.LnFOptionsPanel.divider");
            this.props.remove("workbench.gui.profiles.DriverlistEditorPanel.divider");
            this.props.remove("workbench.db.cancelwithreconnect");
            this.props.remove("workbench.gui.dbobjects.TableListPanel.quickfilter.history");
            this.props.remove("workbench.gui.dbobjects.TableListPanel.quickfilter.lastvalue");
            this.props.remove("workbench.font.standard.name");
            this.props.remove("workbench.font.standard.size");
            this.props.remove("workbench.font.standard.style");
            this.props.remove("workbench.db.sql_server.batchedstatements");
            this.props.remove("workbench.db.sql_server.currentcatalog.query");
            this.props.remove("workbench.db.sql_server.objectname.case");
            this.props.remove("workbench.db.sql_server.schemaname.case");
            this.props.remove("workbench.dbexplorer.visible");
            this.props.remove("workbench.db.db2_nt.currentschema.query");
            this.props.remove("workbench.db.objecttype.selectable.db2_nt");
            this.props.remove("workbench.db.db2_nt.synonymtypes");
            this.props.remove("workbench.db.db2_nt.additional.viewtypes");
            this.props.remove("workbench.db.db2_nt.retrieve_sequences");
            this.props.remove("workbench.db.db2_nt.additional.tabletypes");
            this.props.remove("workbench.sql.dbms_output.defaultbuffer");
            this.props.remove("workbench.sql.enable_dbms_output");
            this.props.remove("workbench.db.stripprocversion");
            this.props.remove("workbench.dbexplorer.cleardata");
            this.props.remove("workbench.db.verifydriverurl");
            this.props.remove("workbench.db.retrievepklist");
            this.props.remove("workbench.print.margin.bottom");
            this.props.remove("workbench.print.margin.left");
            this.props.remove("workbench.print.margin.right");
            this.props.remove("workbench.print.margin.top");
            this.props.remove("workbench.dbexplorer.defTableType");
            this.props.remove("workbench.dbexplorer.deftabletype");
            this.props.remove("workbench.db.mysql.dropindex.needstable");
            this.props.remove("workbench.db.hxtt_dbf.dropindex.needstable");
            this.props.remove("workbench.db.microsoft_sql_server.dropindex.needstable");
            this.props.remove("workbench.ignoretypes.postgresql");
            this.props.remove("workbench.ignoretypes.mysql");
            this.props.remove("workbench.db.syntax.functions");
            this.props.remove("workbench.warn.java5");
            this.props.remove("workbench.db.microsoft_sql_server.drop.index.ddl");
            this.props.remove("workbench.db.mysql.drop.index.ddl");
            this.props.remove("workbench.db.h2.drop.column.single");
            this.props.remove("workbench.db.hsql_database_engine.drop.column.single");
            this.props.remove("workbench.db.oracle.drop.column.single");
            this.props.remove("workbench.db.postgresql.drop.column.single");
            this.props.remove("workbench.db.nonullkeyword");
            String string = this.props.getProperty("workbench.db.objecttype.selectable.apache_derby", "");
            if ("table,view,system table,system view,sequence,synonym".equalsIgnoreCase(string)) {
                this.props.remove("workbench.db.objecttype.selectable.apache_derby");
            }
            if ("table,view,system table,system view,sequence".equalsIgnoreCase(string = this.props.getProperty("workbench.db.objecttype.selectable.postgresql", null))) {
                this.props.remove("workbench.db.objecttype.selectable.postgresql");
            }
            this.props.remove("workbench.import.general.xml.verbosexml");
        }
        catch (Throwable throwable) {
            LogMgr.logWarning(new CallerInfo(){}, "Error when removing obsolete properties", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WbProperties getDefaultProperties() {
        WbProperties wbProperties = new WbProperties(this);
        InputStream inputStream = ResourceMgr.getDefaultSettings();
        try {
            wbProperties.load(inputStream);
        }
        catch (IOException iOException) {
            LogMgr.logError(new CallerInfo(){}, "Could not read default settings", iOException);
        }
        finally {
            FileUtil.closeQuietely(inputStream);
        }
        return wbProperties;
    }

    private void fillDefaults() {
        InputStream inputStream = ResourceMgr.getDefaultSettings();
        try {
            this.props.loadFromStream(inputStream);
        }
        catch (IOException iOException) {
            LogMgr.logError(new CallerInfo(){}, "Could not read default settings", iOException);
        }
        finally {
            FileUtil.closeQuietely(inputStream);
        }
    }

    public boolean isTestMode() {
        return this.getBoolProperty(TEST_MODE_PROPERTY, false);
    }

    public boolean wasExternallyModified() {
        boolean bl;
        long l = this.configfile.lastModified();
        if (l <= 0L) {
            LogMgr.logWarning(new CallerInfo(){}, "ConfigFile lastModified(): " + l);
        }
        if (l < this.fileTime) {
            LogMgr.logWarning(new CallerInfo(){}, "Current modified time: " + l + " original modified time: " + this.fileTime);
        }
        boolean bl2 = bl = l > this.fileTime;
        if (bl) {
            LogMgr.logInfo(new CallerInfo(){}, "Config file was externally modified. Current time: " + l + " original time: " + this.fileTime);
        }
        return bl;
    }

    public boolean enableJSchLoggin() {
        return this.getBoolProperty("workbench.jsch.logging.enabled", true);
    }

    public WbFile getGlogalSshConfigFile() {
        File file = this.getConfigDir();
        String string = this.getProperty("workbench.ssh.global.config.file", "wbssh.settings");
        WbFile wbFile = new WbFile(string);
        if (wbFile.isAbsolute()) {
            return wbFile;
        }
        return new WbFile(file, string);
    }

    public WbFile getConfigFile() {
        return this.configfile;
    }

    public void saveSettings(boolean bl) {
        File file;
        if (this.props == null) {
            LogMgr.logWarning(new CallerInfo(){}, "saveSettings() called but properties are null!");
            return;
        }
        if (this.isTestMode()) {
            LogMgr.logTrace(new CallerInfo(){}, "Test mode active. Settings are not saved.");
            return;
        }
        for (SettingsListener object2 : this.saveListener) {
            if (object2 == null) continue;
            object2.beforeSettingsSave();
        }
        ShortcutManager.getInstance().saveSettings();
        boolean bl2 = this.getCreateSettingsBackup();
        if (bl || this.createBackup && !bl2) {
            WbFile wbFile = this.configfile.makeBackup();
            LogMgr.logInfo(new CallerInfo(){}, "Created backup of global settings file: " + wbFile);
        }
        if (bl2) {
            FileUtil.createBackup(this.configfile);
        }
        if (!(file = this.configfile.getParentFile()).exists()) {
            LogMgr.logInfo(new CallerInfo(){}, "Creating config directory to store settings");
            file.mkdirs();
        }
        try {
            WbProperties wbProperties = this.getDefaultProperties();
            LogMgr.logDebug(new CallerInfo(){}, "Saving global settings to: " + this.configfile.getFullPath());
            this.props.saveToFile(this.configfile, wbProperties);
            this.fileTime = this.configfile.lastModified();
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error saving Settings file '" + this.configfile.getFullPath() + "'", throwable);
        }
        if (this.getPKMappingFilename() != null && PkMapping.isInitialized()) {
            PkMapping.getInstance().saveMapping(this.getPKMappingFilename());
        }
    }

    public String getDbDelimiter(String string) {
        return this.getProperty("workbench.db." + string + ".alternatedelimiter", null);
    }

    public void setDbDelimiter(String string, String string2) {
        if (StringUtil.isBlank(string2)) {
            this.setProperty("workbench.db." + string + ".alternatedelimiter", null);
        } else {
            this.setProperty("workbench.db." + string + ".alternatedelimiter", string2);
        }
    }

    public Set<String> getInformixProductNames() {
        String string = this.getProperty("workbench.db.informix.productnames.default", null);
        List<String> list = this.getListProperty("workbench.db.informix.productnames", false, string);
        return CollectionUtil.caseInsensitiveSet(list);
    }

    public Map<String, String> getDbIdMapping() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        List<String> list = this.props.getKeysWithPrefix("workbench.db.name");
        for (String string : list) {
            int n = string.lastIndexOf(46);
            String string2 = string.substring(n + 1);
            String string3 = this.getProperty(string, null);
            if (string3 == null) continue;
            linkedHashMap.put(string2, string3);
        }
        return linkedHashMap;
    }

    public String getDbmsForDbId(String string) {
        return this.getProperty("workbench.db.name." + string, StringUtil.capitalize(string));
    }

    public String toString() {
        return "[Settings]";
    }

    public PasswordTrimType getPassworTrimType() {
        String string = this.getProperty(PROPERTY_TRIM_PWD, PasswordTrimType.never.name());
        try {
            return PasswordTrimType.valueOf(string);
        }
        catch (Throwable throwable) {
            return PasswordTrimType.always;
        }
    }

    public boolean useMarkDownForConsolePrint() {
        return this.getBoolProperty("workbench.console.print.use.markdown", false);
    }

    public boolean showRemovedResultMessage() {
        return this.getBoolProperty("workbench.gui.remove.empty.show.warning", true);
    }

    public boolean getProfileDefaultSeparateConnection() {
        return this.getBoolProperty("workbench.profile.default.separate.connection", false);
    }

    public boolean getProfileDefaultStoreExplorerSchema() {
        return this.getBoolProperty("workbench.profile.default.store.explorer.schema", false);
    }

    private static class LazyInstanceHolder {
        protected static final Settings INSTANCE = new Settings();

        private LazyInstanceHolder() {
        }
    }
}

