/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import workbench.interfaces.SqlHistoryProvider;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CharacterRange;
import workbench.util.CollectionUtil;
import workbench.util.EncodingUtil;
import workbench.util.FileUtil;
import workbench.util.FixedSizeList;
import workbench.util.SqlParsingUtil;
import workbench.util.StringUtil;

public class StatementHistory
extends FixedSizeList<String>
implements SqlHistoryProvider {
    public StatementHistory(int n) {
        super(n);
        this.setAllowDuplicates(true);
        this.doAppend(true);
    }

    @Override
    public synchronized boolean add(String string) {
        String string2;
        if (StringUtil.isEmptyString(string)) {
            return false;
        }
        String string3 = string2 = this.entries.size() > 0 ? (String)this.entries.getLast() : "";
        if (string2 != null && string2.equals(string)) {
            return false;
        }
        String string4 = SqlParsingUtil.getInstance(null).getSqlVerb(string);
        if (string4.equalsIgnoreCase("WbHistory") || string4.equalsIgnoreCase("WbHist")) {
            return false;
        }
        return super.add(string);
    }

    @Override
    public List<String> getHistoryEntries() {
        return Collections.unmodifiableList(this.getEntries());
    }

    @Override
    public String getHistoryEntry(int n) {
        return (String)this.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFrom(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        this.entries.clear();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = EncodingUtil.createBufferedReader(file, "UTF-8");
            String string = bufferedReader.readLine();
            while (string != null) {
                string = StringUtil.decodeUnicode(string);
                this.append(string);
                string = bufferedReader.readLine();
            }
            LogMgr.logInfo(new CallerInfo(){}, "Loaded statement history from " + file.getAbsolutePath());
        }
        catch (IOException iOException) {
            LogMgr.logError(new CallerInfo(){}, "Could not save history", iOException);
        }
        finally {
            FileUtil.closeQuietely(bufferedReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTo(File file) {
        if (CollectionUtil.isEmpty(this.entries)) {
            return;
        }
        Writer writer = null;
        try {
            writer = EncodingUtil.createWriter(file, "UTF-8", false);
            for (String string : this.entries) {
                String string2 = StringUtil.escapeText(string, CharacterRange.RANGE_CONTROL);
                writer.write(string2);
                writer.write(10);
            }
            LogMgr.logInfo(new CallerInfo(){}, "Saved statement history to " + file.getAbsolutePath());
        }
        catch (IOException iOException) {
            try {
                LogMgr.logError(new CallerInfo(){}, "Could not save history", iOException);
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietely(writer);
                throw throwable;
            }
            FileUtil.closeQuietely(writer);
        }
        FileUtil.closeQuietely(writer);
    }
}

