/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.annotations;

import java.util.Map;
import java.util.TreeMap;
import workbench.sql.annotations.WbAnnotation;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.StringUtil;

public class MacroAnnotation
extends WbAnnotation {
    public static final String MAP_KEYWORD = "map";
    public static final String NAME_KEYWORD = "name";
    public static final String ANNOTATION = "WbMacro";
    private Map<String, String> columnMap = new TreeMap<String, String>(CaseInsensitiveComparator.INSTANCE);

    public MacroAnnotation() {
        super(ANNOTATION);
    }

    @Override
    public void setValue(String string) {
        if (StringUtil.isBlank(string)) {
            super.setValue(null);
        } else {
            ArgumentParser argumentParser = new ArgumentParser(false);
            argumentParser.addArgument(MAP_KEYWORD, ArgumentType.RepeatableValue);
            argumentParser.addArgument(NAME_KEYWORD);
            argumentParser.parse(string);
            Map<String, String> map = argumentParser.getMapValue(MAP_KEYWORD);
            if (map != null) {
                this.columnMap.clear();
                this.columnMap.putAll(map);
            }
            super.setValue(argumentParser.getValue(NAME_KEYWORD));
        }
    }

    public String getMacroName() {
        return this.getValue();
    }

    public Map<String, String> getColumnMap() {
        return this.columnMap;
    }
}

