/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.annotations;

import java.util.Set;
import workbench.sql.annotations.WbAnnotation;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class ScrollAnnotation
extends WbAnnotation {
    public static final String ANNOTATION = "WbScrollTo";
    public static final String END_KEYWORD = "end";
    private static final Set<String> END_KEYWORDS = CollectionUtil.caseInsensitiveSet("bottom", "last", "end");

    public ScrollAnnotation() {
        super(ANNOTATION);
    }

    public static String getScrollToEndAnnotation() {
        return "-- @WbScrollTo end";
    }

    public static boolean scrollToEnd(String string) {
        if (string == null) {
            return false;
        }
        return END_KEYWORDS.contains(StringUtil.trim(string));
    }

    public static int scrollToLine(String string) {
        if (StringUtil.isNonBlank(string) && string.startsWith("#")) {
            return StringUtil.getIntValue(string.substring(1), -1);
        }
        return -1;
    }
}

