/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.commands;

import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import workbench.db.ErrorInformationReader;
import workbench.db.ReaderFactory;
import workbench.db.TableIdentifier;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.sql.ErrorDescriptor;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.sql.parser.ParserType;
import workbench.util.CollectionUtil;
import workbench.util.DdlObjectInfo;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class DdlCommand
extends SqlCommand {
    private String verb;
    private final Set<String> typesToRemember = CollectionUtil.caseInsensitiveSet("procedure", "function", "trigger", "package", "package body", "type");
    private Pattern alterDropPattern;
    private Pattern pgDropOwned;

    public static DdlCommand getRecreateCommand() {
        return new DdlCommand("RECREATE");
    }

    public static DdlCommand getCreateCommand() {
        return new DdlCommand("CREATE");
    }

    public static List<DdlCommand> getDdlCommands() {
        return CollectionUtil.readOnlyList(new DdlCommand("DROP"), DdlCommand.getCreateCommand(), new DdlCommand("ALTER"), new DdlCommand("GRANT"), new DdlCommand("REVOKE"));
    }

    private DdlCommand(String string) {
        this.verb = string;
        this.isUpdatingCommand = true;
        if ("ALTER".equals(this.verb)) {
            this.alterDropPattern = Pattern.compile("DROP\\s+(PRIMARY\\s+KEY|CONSTRAINT)\\s+", 2);
        }
        if ("DROP".equals(this.verb)) {
            this.pgDropOwned = Pattern.compile("DROP\\s+OWNED\\s+BY\\s+", 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        DdlObjectInfo ddlObjectInfo;
        StatementRunnerResult statementRunnerResult = this.createResult(string);
        statementRunnerResult.ignoreUpdateCounts(true);
        boolean bl = this.runner.useSavepointForDDL();
        CallerInfo callerInfo = new CallerInfo(){};
        if (bl && !this.currentConnection.supportsSavepoints()) {
            bl = false;
            LogMgr.logWarning(callerInfo, "A savepoint should be used for this DDL command, but the driver does not support savepoints!");
        }
        if ((ddlObjectInfo = SqlUtil.getDDLObjectInfo(string, this.currentConnection)) != null && this.verb.equals("ALTER") && ddlObjectInfo.getObjectType().equals("PACKAGE")) {
            ddlObjectInfo.setObjectType("PACKAGE BODY");
        }
        if (ddlObjectInfo != null && this.typesToRemember.contains(ddlObjectInfo.getObjectType())) {
            this.currentConnection.setLastDDLObject(ddlObjectInfo);
        }
        boolean bl2 = false;
        boolean bl3 = false;
        Savepoint savepoint = null;
        try {
            this.currentStatement = this.currentConnection.createStatement();
            if (this.currentConnection.getDbSettings().disableEscapesForDDL()) {
                this.currentStatement.setEscapeProcessing(false);
            }
            string = this.getSqlToExecute(string);
            statementRunnerResult.setSuccess();
            if (bl) {
                savepoint = this.currentConnection.setSavepoint(callerInfo);
            }
            bl3 = (bl2 = this.isDropCommand(string)) && this.runner.getIgnoreDropErrors();
            boolean bl4 = this.currentStatement.execute(string);
            this.processResults(statementRunnerResult, bl4);
            if (statementRunnerResult.hasWarning()) {
                this.addExtendErrorInfo(string, ddlObjectInfo, statementRunnerResult);
            }
            if (statementRunnerResult.isSuccess()) {
                statementRunnerResult.addMessage(this.buildSuccessMessage(ddlObjectInfo, string));
            }
            this.currentConnection.releaseSavepoint(savepoint, callerInfo);
            if (statementRunnerResult.isSuccess() && ddlObjectInfo != null && "database".equalsIgnoreCase(ddlObjectInfo.getObjectType())) {
                this.currentConnection.getObjectCache().flushCachedDatabases();
                this.currentConnection.catalogListChanged();
            } else if (bl2 && statementRunnerResult.isSuccess()) {
                this.removeFromCache(ddlObjectInfo);
            }
        }
        catch (Exception exception) {
            this.currentConnection.rollback(savepoint, callerInfo);
            if (bl3) {
                this.addDropWarning(ddlObjectInfo, statementRunnerResult);
                this.addErrorPosition(statementRunnerResult, string, exception);
                statementRunnerResult.setSuccess();
            } else {
                statementRunnerResult.setFailure();
                this.addErrorStatement(statementRunnerResult, string);
                if (statementRunnerResult.hasWarning()) {
                    if (!this.addExtendErrorInfo(string, ddlObjectInfo, statementRunnerResult)) {
                        this.addErrorPosition(statementRunnerResult, string, exception);
                    }
                } else {
                    this.addErrorPosition(statementRunnerResult, string, exception);
                }
                LogMgr.logUserSqlError(callerInfo, string, exception);
            }
        }
        finally {
            this.done();
        }
        return statementRunnerResult;
    }

    private void addDropWarning(DdlObjectInfo ddlObjectInfo, StatementRunnerResult statementRunnerResult) {
        String string = ddlObjectInfo != null ? ResourceMgr.getFormattedString("MsgDropWarningNamed", ddlObjectInfo.getObjectName()) : ResourceMgr.getString("MsgDropWarning");
        statementRunnerResult.addMessage(string);
    }

    private void removeFromCache(DdlObjectInfo ddlObjectInfo) {
        if (ddlObjectInfo == null) {
            return;
        }
        if (StringUtil.isEmptyString(ddlObjectInfo.getObjectName())) {
            return;
        }
        if (this.currentConnection == null) {
            return;
        }
        this.currentConnection.getObjectCache().removeTable(new TableIdentifier(ddlObjectInfo.getObjectName(), this.currentConnection));
    }

    @Override
    public void done() {
        super.done();
    }

    public boolean isDropCommand(String string) {
        if ("DROP".equals(this.verb)) {
            return true;
        }
        if (!"ALTER".equals(this.verb)) {
            return false;
        }
        Matcher matcher = this.alterDropPattern.matcher(string);
        return matcher.find();
    }

    private String buildSuccessMessage(DdlObjectInfo ddlObjectInfo, String string) {
        String string2;
        if (this.isPgDropOwned(string) && (string2 = this.getOwner(string)) != null) {
            return ResourceMgr.getFormattedString("MsgDropOwned", string2);
        }
        return this.getSuccessMessage(ddlObjectInfo, this.getVerb());
    }

    private String getOwner(String string) {
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(ParserType.Postgres, (CharSequence)string);
        sQLLexer.getNextToken(false, false);
        sQLLexer.getNextToken(false, false);
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        if (sQLToken != null) {
            return SqlUtil.removeObjectQuotes(sQLToken.getText());
        }
        return null;
    }

    @Override
    protected String getSuccessMessage(DdlObjectInfo ddlObjectInfo, String string) {
        String string2 = super.getSuccessMessage(ddlObjectInfo, this.getVerb());
        if (string2 == null) {
            return this.getDefaultSuccessMessage(null);
        }
        return string2;
    }

    private boolean isPgDropOwned(String string) {
        if (this.pgDropOwned != null) {
            Matcher matcher = this.pgDropOwned.matcher(string);
            return matcher.find();
        }
        return false;
    }

    private boolean addExtendErrorInfo(String string, DdlObjectInfo ddlObjectInfo, StatementRunnerResult statementRunnerResult) {
        if (ddlObjectInfo == null) {
            return false;
        }
        if (this.currentConnection == null) {
            return false;
        }
        ErrorInformationReader errorInformationReader = ReaderFactory.getErrorInformationReader(this.currentConnection);
        if (errorInformationReader == null) {
            return false;
        }
        ErrorDescriptor errorDescriptor = errorInformationReader.getErrorInfo(string, null, ddlObjectInfo.getObjectName(), ddlObjectInfo.getObjectType(), true);
        if (errorDescriptor == null) {
            return false;
        }
        if (errorDescriptor.getErrorPosition() == -1 && errorDescriptor.getErrorColumn() > -1 && errorDescriptor.getErrorLine() > -1) {
            int n = 0;
            if (!this.currentConnection.getDbSettings().getErrorPosIncludesLeadingComments()) {
                n = SqlUtil.getRealStart(string);
                string = string.substring(n);
            }
            int n2 = SqlUtil.getErrorOffset(string, errorDescriptor);
            errorDescriptor.setErrorOffset(n2 + n);
        }
        statementRunnerResult.addMessageNewLine();
        statementRunnerResult.setFailure(errorDescriptor);
        statementRunnerResult.addMessage(errorDescriptor.getErrorMessage());
        return true;
    }

    @Override
    public String getVerb() {
        return this.verb;
    }
}

