/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.commands;

import java.sql.SQLException;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.SavepointStrategy;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;

public class TransactionStartCommand
extends SqlCommand {
    public static final String MANUAL_TRANSACTION_IN_PROGRESS = "manual_transaction";
    public static final String PREVIOUS_SP_STRATEGY = "savepoint_strategy";
    public static final TransactionStartCommand BEGIN = new TransactionStartCommand("BEGIN");
    public static final TransactionStartCommand BEGIN_WORK = new TransactionStartCommand("BEGIN WORK");
    public static final TransactionStartCommand BEGIN_TRANSACTION = new TransactionStartCommand("BEGIN TRANSACTION");
    public static final TransactionStartCommand BEGIN_TRAN = new TransactionStartCommand("BEGIN TRAN");
    public static final TransactionStartCommand START_TRANSACTION = new TransactionStartCommand("START TRANSACTION");
    private final String verb;

    private TransactionStartCommand(String string) {
        this.verb = string;
        this.isUpdatingCommand = true;
    }

    public static TransactionStartCommand fromVerb(String string) {
        TransactionStartCommand[] transactionStartCommandArray;
        for (TransactionStartCommand transactionStartCommand : transactionStartCommandArray = new TransactionStartCommand[]{BEGIN, BEGIN_WORK, BEGIN_TRAN, BEGIN_TRANSACTION, START_TRANSACTION}) {
            if (!transactionStartCommand.getVerb().equalsIgnoreCase(string)) continue;
            return transactionStartCommand;
        }
        return new TransactionStartCommand(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult(string);
        try {
            this.currentStatement = this.currentConnection.createStatement();
            this.currentStatement.execute(string);
            this.appendSuccessMessage(statementRunnerResult);
            statementRunnerResult.setSuccess();
            this.handleTransactionStart();
        }
        catch (Exception exception) {
            this.addErrorInfo(statementRunnerResult, string, exception);
            LogMgr.logUserSqlError(new CallerInfo(){}, string, exception);
        }
        finally {
            this.done();
        }
        return statementRunnerResult;
    }

    @Override
    public String getVerb() {
        return this.verb;
    }

    private void handleTransactionStart() {
        if (this.currentConnection == null) {
            return;
        }
        if (!this.currentConnection.getAutoCommit()) {
            return;
        }
        CallerInfo callerInfo = new CallerInfo(){};
        try {
            LogMgr.logInfo(callerInfo, "Transaction start detected. Turning off auto commit");
            this.currentConnection.setAutoCommit(false);
            SavepointStrategy savepointStrategy = this.runner.getSavepointStrategy();
            this.runner.setSavepointStrategy(SavepointStrategy.never);
            this.runner.setSessionProperty(MANUAL_TRANSACTION_IN_PROGRESS, "true");
            this.runner.setSessionProperty(PREVIOUS_SP_STRATEGY, savepointStrategy.name());
        }
        catch (SQLException sQLException) {
            LogMgr.logError(callerInfo, "Could disable auto commit!", sQLException);
        }
    }
}

