/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.parser;

import workbench.sql.DelimiterDefinition;
import workbench.sql.lexer.SQLToken;
import workbench.sql.parser.DelimiterTester;

public class ShortIncludeDelimiterTester
implements DelimiterTester {
    private DelimiterDefinition defaultDelimiter = DelimiterDefinition.STANDARD_DELIMITER;
    private boolean checkShortInclude = true;

    @Override
    public void setDelimiter(DelimiterDefinition delimiterDefinition) {
        this.defaultDelimiter = delimiterDefinition;
        this.checkShortInclude = this.defaultDelimiter.isStandard();
    }

    @Override
    public void setAlternateDelimiter(DelimiterDefinition delimiterDefinition) {
    }

    @Override
    public boolean supportsMixedDelimiters() {
        return false;
    }

    @Override
    public void currentToken(SQLToken sQLToken, boolean bl) {
    }

    @Override
    public DelimiterDefinition getCurrentDelimiter() {
        if (this.defaultDelimiter != null) {
            return this.defaultDelimiter;
        }
        return DelimiterDefinition.STANDARD_DELIMITER;
    }

    @Override
    public void statementFinished() {
    }

    @Override
    public boolean supportsSingleLineStatements() {
        return true;
    }

    @Override
    public boolean isSingleLineStatement(SQLToken sQLToken, boolean bl) {
        if (!this.checkShortInclude) {
            return false;
        }
        if (sQLToken == null) {
            return false;
        }
        if (bl && !sQLToken.isWhiteSpace()) {
            String string = sQLToken.getText();
            return string.charAt(0) == '@';
        }
        return false;
    }

    @Override
    public void lineEnd() {
    }
}

