/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import workbench.db.DropType;
import workbench.db.WbConnection;
import workbench.db.exporter.BlobMode;
import workbench.db.importer.DeleteType;
import workbench.db.importer.ImportMode;
import workbench.interfaces.BatchCommitter;
import workbench.interfaces.Committer;
import workbench.interfaces.ProgressReporter;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.StatementRunnerResult;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.CollectionUtil;
import workbench.util.QuoteEscapeType;
import workbench.util.StringUtil;
import workbench.util.ValueConverter;

public class CommonArgs {
    public static final String ARG_PROGRESS = "showProgress";
    public static final String ARG_ENCODING = "encoding";
    public static final String ARG_COMMIT_EVERY = "commitEvery";
    public static final String ARG_DELIM = "delimiter";
    public static final String ARG_VERBOSE_XML = "verboseXML";
    public static final String ARG_IMPORT_MODE = "mode";
    public static final String ARG_CONTINUE = "continueOnError";
    public static final String ARG_BATCHSIZE = "batchSize";
    public static final String ARG_COMMIT_BATCH = "commitBatch";
    public static final String ARG_QUOTE_CHAR = "quotechar";
    public static final String ARG_QUOTE_ESCAPE = "quoteCharEscaping";
    public static final String ARG_AUTO_BOOLEAN = "booleanToNumber";
    public static final String ARG_DATE_FORMAT = "dateFormat";
    public static final String ARG_LOCALE = "locale";
    public static final String ARG_TIMESTAMP_FORMAT = "timestampFormat";
    public static final String ARG_DECIMAL_CHAR = "decimal";
    public static final String ARG_NUMERIC_TRUE = "numericTrue";
    public static final String ARG_NUMERIC_FALSE = "numericFalse";
    public static final String ARG_FALSE_LITERALS = "literalsFalse";
    public static final String ARG_TRUE_LITERALS = "literalsTrue";
    public static final String ARG_CHECK_FK_DEPS = "checkDependencies";
    public static final String ARG_PRE_TABLE_STMT = "preTableStatement";
    public static final String ARG_POST_TABLE_STMT = "postTableStatement";
    public static final String ARG_IGNORE_TABLE_STMT_ERRORS = "ignorePrePostErrors";
    public static final String ARG_RUN_POST_STMT_ON_ERROR = "runTableStatementOnError";
    public static final String ARG_TRANS_CONTROL = "transactionControl";
    public static final String ARG_DATE_LITERAL_TYPE = "sqlDateLiterals";
    public static final String ARG_DELETE_TARGET = "deleteTarget";
    public static final String ARG_TRUNCATE_TABLE = "truncateTable";
    public static final String ARG_SCHEMA = "schema";
    public static final String ARG_CATALOG = "catalog";
    public static final String ARG_TABLES = "tables";
    public static final String ARG_VIEWS = "views";
    public static final String ARG_EXCLUDE_TABLES = "excludeTables";
    public static final String ARG_SCHEMAS = "schemas";
    public static final String ARG_TYPES = "types";
    public static final String ARG_OBJECTS = "objects";
    public static final String ARG_IGNORE_IDENTITY = "ignoreIdentityColumns";
    public static final String ARG_HELP = "help";
    public static final String ARG_VERBOSE = "verbose";
    public static final String ARG_FILE = "file";
    public static final String ARG_OUTPUT_FILE = "outputFile";
    public static final String ARG_OUTPUT_DIR = "outputDir";
    public static final String ARG_COLUMN_BLOB_MODE = "columnBlobType";

    private static List<String> getDelimiterArguments() {
        return StringUtil.stringToList("'\\t',';',\"','\",'|',<char>");
    }

    public static void addTransactionControL(ArgumentParser argumentParser) {
        argumentParser.addArgument(ARG_TRANS_CONTROL, ArgumentType.BoolArgument);
    }

    public static List<String> getListArgument(ArgumentParser argumentParser, String string) {
        String string2 = argumentParser.getValue(string);
        if (StringUtil.isEmptyString(string2)) {
            return null;
        }
        List<String> list = StringUtil.stringToList(string2, ",");
        return list;
    }

    public static DeleteType getDeleteType(ArgumentParser argumentParser) {
        if (argumentParser.getBoolean(ARG_TRUNCATE_TABLE, false)) {
            return DeleteType.truncate;
        }
        if (argumentParser.getBoolean(ARG_DELETE_TARGET, false)) {
            return DeleteType.delete;
        }
        return DeleteType.none;
    }

    public static void addTableStatements(ArgumentParser argumentParser) {
        argumentParser.addArgument(ARG_PRE_TABLE_STMT);
        argumentParser.addArgument(ARG_POST_TABLE_STMT);
        argumentParser.addArgument(ARG_IGNORE_TABLE_STMT_ERRORS, ArgumentType.BoolSwitch);
        argumentParser.addArgument(ARG_RUN_POST_STMT_ON_ERROR, ArgumentType.BoolSwitch);
    }

    public static void addCheckDepsParameter(ArgumentParser argumentParser) {
        argumentParser.addArgument(ARG_CHECK_FK_DEPS, ArgumentType.BoolArgument);
    }

    public static void addContinueParameter(ArgumentParser argumentParser) {
        argumentParser.addArgument(ARG_CONTINUE, ArgumentType.BoolArgument);
    }

    public static void addImportModeParameter(ArgumentParser argumentParser) {
        argumentParser.addArgument(ARG_IMPORT_MODE, CollectionUtil.arrayList(ImportMode.insert.getArgumentString(), ImportMode.update.getArgumentString(), ImportMode.updateInsert.getArgumentString(), ImportMode.insertUpdate.getArgumentString(), ImportMode.upsert.getArgumentString(), ImportMode.insertIgnore.getArgumentString()));
    }

    public static void addSqlDateLiteralParameter(ArgumentParser argumentParser) {
        argumentParser.addArgument(ARG_DATE_LITERAL_TYPE, Settings.getInstance().getLiteralTypeList());
    }

    public static void addVerboseXmlParameter(ArgumentParser argumentParser) {
        argumentParser.addArgument(ARG_VERBOSE_XML, ArgumentType.BoolArgument);
    }

    public static void addCommitParameter(ArgumentParser argumentParser) {
        argumentParser.addArgument(ARG_COMMIT_EVERY, StringUtil.stringToList("none,atEnd,<number>"));
    }

    public static void addDelimiterParameter(ArgumentParser argumentParser) {
        argumentParser.addArgument(ARG_DELIM, CommonArgs.getDelimiterArguments());
    }

    public static Map<String, BlobMode> getColumnBlobModes(ArgumentParser argumentParser) {
        HashMap<String, BlobMode> hashMap = new HashMap<String, BlobMode>();
        Map<String, String> map = argumentParser.getMapValue(ARG_COLUMN_BLOB_MODE);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            BlobMode blobMode = BlobMode.getMode(string2);
            hashMap.put(string, blobMode);
        }
        return hashMap;
    }

    public static boolean checkQuoteEscapting(ArgumentParser argumentParser) {
        boolean bl = argumentParser.getBoolean("quoteAlways", false);
        QuoteEscapeType quoteEscapeType = CommonArgs.getQuoteEscaping(argumentParser);
        return !bl || quoteEscapeType != QuoteEscapeType.duplicate;
    }

    public static void addQuoteEscaping(ArgumentParser argumentParser) {
        argumentParser.addArgument(ARG_QUOTE_ESCAPE, StringUtil.stringToList("none,duplicate,escape"));
    }

    public static void addEncodingParameter(ArgumentParser argumentParser) {
        argumentParser.addArgument(ARG_ENCODING, StringUtil.stringToList(Settings.getInstance().getPopularEncodings()));
    }

    public static void addProgressParameter(ArgumentParser argumentParser) {
        argumentParser.addArgument(ARG_PROGRESS, StringUtil.stringToList("true,false,<number>"));
    }

    public static void setProgressInterval(ProgressReporter progressReporter, ArgumentParser argumentParser) {
        String string = argumentParser.getValue(ARG_PROGRESS, argumentParser.getValue(ARG_BATCHSIZE));
        if ("true".equalsIgnoreCase(string)) {
            progressReporter.setReportInterval(1);
        } else if ("false".equalsIgnoreCase(string)) {
            progressReporter.setReportInterval(0);
        } else if (string != null) {
            int n = StringUtil.getIntValue(string, 0);
            progressReporter.setReportInterval(n);
        } else {
            progressReporter.setReportInterval(10);
        }
    }

    public static void setCommitEvery(Committer committer, ArgumentParser argumentParser) {
        String string = argumentParser.getValue(ARG_COMMIT_EVERY);
        if (string == null) {
            return;
        }
        if ("none".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
            committer.commitNothing();
        } else if ("atEnd".equalsIgnoreCase(string)) {
            committer.setCommitEvery(0);
        } else {
            committer.setCommitEvery(StringUtil.getIntValue(string, 0));
        }
    }

    public static void addCommitAndBatchParams(ArgumentParser argumentParser) {
        argumentParser.addArgument(ARG_BATCHSIZE);
        argumentParser.addArgument(ARG_COMMIT_BATCH, ArgumentType.BoolArgument);
    }

    public static void setCommitAndBatchParams(BatchCommitter batchCommitter, ArgumentParser argumentParser) {
        int n = argumentParser.getIntValue(ARG_BATCHSIZE, -1);
        String string = argumentParser.getValue(ARG_COMMIT_EVERY);
        if (n > 0) {
            batchCommitter.setUseBatch(true);
            batchCommitter.setBatchSize(n);
            if (argumentParser.isArgPresent(ARG_COMMIT_BATCH)) {
                batchCommitter.setCommitBatch(argumentParser.getBoolean(ARG_COMMIT_BATCH, false));
            } else if ("none".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
                batchCommitter.commitNothing();
            }
        } else {
            CommonArgs.setCommitEvery(batchCommitter, argumentParser);
        }
    }

    public static QuoteEscapeType getQuoteEscaping(ArgumentParser argumentParser) {
        String string = argumentParser.getValue(ARG_QUOTE_ESCAPE);
        if (string != null) {
            try {
                QuoteEscapeType quoteEscapeType = QuoteEscapeType.valueOf(string.trim().toLowerCase());
                return quoteEscapeType;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return QuoteEscapeType.none;
    }

    public static void addConverterOptions(ArgumentParser argumentParser, boolean bl) {
        argumentParser.addArgument(ARG_AUTO_BOOLEAN, ArgumentType.BoolArgument);
        argumentParser.addArgument(ARG_DECIMAL_CHAR);
        if (bl) {
            argumentParser.addArgument(ARG_DATE_FORMAT);
            argumentParser.addArgument(ARG_TIMESTAMP_FORMAT);
        }
        argumentParser.addArgument(ARG_FALSE_LITERALS);
        argumentParser.addArgument(ARG_TRUE_LITERALS);
        argumentParser.addArgument(ARG_NUMERIC_FALSE);
        argumentParser.addArgument(ARG_NUMERIC_TRUE);
        argumentParser.addArgument(ARG_LOCALE);
    }

    public static Locale getLocale(ArgumentParser argumentParser, StatementRunnerResult statementRunnerResult) {
        String string = argumentParser.getValue(ARG_LOCALE);
        Locale locale = null;
        if (StringUtil.isNonBlank(string)) {
            try {
                String[] stringArray;
                locale = string.contains("_") ? ((stringArray = string.split("_")).length > 1 ? new Locale(stringArray[0], stringArray[1]) : new Locale(stringArray[0])) : new Locale(string);
                locale.getISO3Language();
            }
            catch (Exception exception) {
                locale = null;
                LogMgr.logWarning(new CallerInfo(){}, "Illegale locale " + string + " ignored", exception);
                String string2 = ResourceMgr.getFormattedString("ErrIllegalLocaleIgnore", string);
                statementRunnerResult.addWarning(string2);
            }
        }
        return locale;
    }

    public static ValueConverter getConverter(ArgumentParser argumentParser, StatementRunnerResult statementRunnerResult, WbConnection wbConnection) throws IllegalArgumentException {
        ValueConverter valueConverter = new ValueConverter(wbConnection);
        valueConverter.setAutoConvertBooleanNumbers(argumentParser.getBoolean(ARG_AUTO_BOOLEAN, true));
        valueConverter.setLocale(CommonArgs.getLocale(argumentParser, statementRunnerResult));
        String string = null;
        try {
            string = argumentParser.getValue(ARG_DATE_FORMAT);
            if (string != null) {
                valueConverter.setDefaultDateFormat(string);
            }
            if ((string = argumentParser.getValue(ARG_TIMESTAMP_FORMAT)) != null) {
                valueConverter.setDefaultTimestampFormat(string);
            }
        }
        catch (Exception exception) {
            String string2 = ResourceMgr.getFormattedString("ErrIllegalDateTimeFormat", string);
            throw new IllegalArgumentException(string2, exception);
        }
        String string3 = argumentParser.getValue(ARG_DECIMAL_CHAR);
        if (string3 != null) {
            valueConverter.setDecimalCharacter(string3.charAt(0));
        }
        List<String> list = argumentParser.getListValue(ARG_FALSE_LITERALS);
        List<String> list2 = argumentParser.getListValue(ARG_TRUE_LITERALS);
        if (list.size() > 0 && list2.size() > 0) {
            valueConverter.setBooleanLiterals(list2, list);
        }
        if (argumentParser.isArgPresent(ARG_NUMERIC_FALSE) && argumentParser.isArgPresent(ARG_NUMERIC_TRUE)) {
            int n = argumentParser.getIntValue(ARG_NUMERIC_TRUE, 1);
            int n2 = argumentParser.getIntValue(ARG_NUMERIC_FALSE, 0);
            valueConverter.setNumericBooleanValues(n2, n);
            valueConverter.setAutoConvertBooleanNumbers(true);
        }
        return valueConverter;
    }

    public static DropType getDropType(ArgumentParser argumentParser) {
        String string = argumentParser.getValue("dropTarget", null);
        DropType dropType = DropType.none;
        if (string != null) {
            if (string.startsWith("cascade")) {
                dropType = DropType.cascaded;
            } else if (StringUtil.stringToBool(string)) {
                dropType = DropType.regular;
            }
        }
        return dropType;
    }

    public static void appendArgument(StringBuilder stringBuilder, String string, String string2, CharSequence charSequence) {
        if (StringUtil.isNonBlank(string2)) {
            if (charSequence.charAt(0) != '\n') {
                stringBuilder.append('\n');
            }
            stringBuilder.append(charSequence);
            stringBuilder.append('-');
            stringBuilder.append(string);
            stringBuilder.append('=');
            if (string2.indexOf(45) > -1 || string2.indexOf(59) > -1) {
                stringBuilder.append('\"');
            } else if ("\"".equals(string2)) {
                stringBuilder.append('\'');
            } else if ("'".equals(string2)) {
                stringBuilder.append('\"');
            }
            stringBuilder.append(string2);
            if (string2.indexOf(45) > -1 || string2.indexOf(59) > -1) {
                stringBuilder.append('\"');
            } else if ("\"".equals(string2)) {
                stringBuilder.append('\'');
            } else if ("'".equals(string2)) {
                stringBuilder.append('\"');
            }
        }
    }
}

