/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import java.util.List;
import workbench.WbManager;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObjectFinder;
import workbench.db.DbSearchPath;
import workbench.db.DbSettings;
import workbench.db.DropType;
import workbench.db.FKHandler;
import workbench.db.ProcedureDefinition;
import workbench.db.SequenceDefinition;
import workbench.db.SequenceReader;
import workbench.db.TableColumnsDatastore;
import workbench.db.TableDefinition;
import workbench.db.TableDependency;
import workbench.db.TableIdentifier;
import workbench.db.TriggerReaderFactory;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.sql.StatementRunnerResult;
import workbench.storage.ColumnRemover;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class ObjectInfo {
    private boolean showSynonymTarget = GuiSettings.showSynonymTargetInDbExplorer();
    private boolean showSynonymBeforeTableInfo = WbManager.getInstance().isConsoleMode();

    public void setShowSynonymTarget(boolean bl) {
        this.showSynonymTarget = bl;
    }

    public void setShowSynonymBeforeTableInfo(boolean bl) {
        this.showSynonymBeforeTableInfo = bl;
    }

    public StatementRunnerResult getObjectInfo(WbConnection wbConnection, String string, boolean bl, boolean bl2) throws SQLException {
        Object object;
        Object object2;
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        long l = System.currentTimeMillis();
        TableIdentifier tableIdentifier = new TableIdentifier(string, wbConnection);
        List<String> list = DbSearchPath.Factory.getSearchPathHandler(wbConnection).getSearchPath(wbConnection, null);
        boolean bl3 = tableIdentifier.getSchema() == null && !list.isEmpty();
        TableIdentifier tableIdentifier2 = this.findObject(wbConnection, tableIdentifier);
        DbSettings dbSettings = wbConnection.getDbSettings();
        DataStore dataStore = null;
        TableIdentifier tableIdentifier3 = null;
        CharSequence charSequence = null;
        if (tableIdentifier2 != null && dbSettings.isSynonymType(tableIdentifier2.getType()) && this.showSynonymTarget) {
            dataStore = ObjectInfo.getPlainSynonymInfo(wbConnection, tableIdentifier2);
            charSequence = tableIdentifier2.getSource(wbConnection);
            dataStore.setResultName(tableIdentifier2.getFullyQualifiedName(wbConnection) + " (" + tableIdentifier2.getObjectType() + ")");
            tableIdentifier3 = tableIdentifier2;
            tableIdentifier2 = wbConnection.getMetadata().getSynonymTable(tableIdentifier2);
        }
        if (this.readSequence(wbConnection, statementRunnerResult, tableIdentifier2, bl2)) {
            return statementRunnerResult;
        }
        if (tableIdentifier2 == null) {
            try {
                tableIdentifier.adjustCase(wbConnection);
                object2 = wbConnection.getMetadata().getProcedureReader();
                object = object2.findProcedureByName(tableIdentifier);
                if (object != null) {
                    String string2 = StringUtil.capitalize(((ProcedureDefinition)object).getObjectType());
                    String string3 = ((ProcedureDefinition)object).getFullyQualifiedName(wbConnection);
                    CharSequence charSequence2 = ((ProcedureDefinition)object).getSource(wbConnection);
                    statementRunnerResult.addMessage("--------[ BEGIN " + string2 + ": " + string3 + " ]--------");
                    statementRunnerResult.addMessage(charSequence2);
                    statementRunnerResult.addMessage("--------[ END " + string2 + ": " + string3 + "   ]--------");
                    statementRunnerResult.setSuccess();
                    return statementRunnerResult;
                }
            }
            catch (Exception exception) {
                LogMgr.logError(new CallerInfo(){}, "Error retrieving procedures", exception);
            }
        }
        if (tableIdentifier2 == null) {
            object2 = ResourceMgr.getFormattedString("ErrTableOrViewNotFound", string);
            statementRunnerResult.addErrorMessage((String)object2);
            return statementRunnerResult;
        }
        object2 = null;
        object = null;
        if (wbConnection.getMetadata().isViewOrTable(tableIdentifier2.getType())) {
            object = this.getTableDefinition(wbConnection, tableIdentifier2);
            object2 = new TableColumnsDatastore((TableDefinition)object);
        } else if (dbSettings.isSynonymType(tableIdentifier2.getType())) {
            object2 = ObjectInfo.getPlainSynonymInfo(wbConnection, tableIdentifier2);
        } else {
            DataStore dataStore2 = wbConnection.getMetadata().getObjectDetails(tableIdentifier2);
            if (dataStore2 != null && dataStore2.getRowCount() > 0) {
                object2 = dataStore2;
            }
        }
        boolean bl4 = wbConnection.getMetadata().isExtendedObject(tableIdentifier2);
        CharSequence charSequence3 = null;
        String string4 = "";
        if (dbSettings.isViewType(tableIdentifier2.getType())) {
            if (bl2) {
                charSequence3 = wbConnection.getMetadata().getViewReader().getExtendedViewSource(tableIdentifier2, DropType.none);
            }
            string4 = bl3 ? tableIdentifier2.getTableExpression() : tableIdentifier2.getTableExpression(wbConnection);
        } else if (bl4) {
            charSequence3 = wbConnection.getMetadata().getObjectSource(tableIdentifier2);
            string4 = tableIdentifier2.getObjectName() + " (" + tableIdentifier2.getObjectType() + ")";
        } else if (dbSettings.isSynonymType(tableIdentifier2.getType())) {
            charSequence3 = tableIdentifier2.getSource(wbConnection);
        } else {
            string4 = tableIdentifier2.getTableExpression(wbConnection);
        }
        if (this.showSynonymBeforeTableInfo && dataStore != null) {
            statementRunnerResult.addDataStore(dataStore);
        }
        if (object2 != null) {
            ColumnRemover columnRemover = new ColumnRemover((DataStore)object2);
            DataStore dataStore3 = columnRemover.removeColumnsByName("JDBC Type", "PRECISION", "SCALE/SIZE");
            String string5 = bl3 ? tableIdentifier2.getTableExpression() : tableIdentifier2.getTableExpression(wbConnection);
            dataStore3.setResultName(string5 + " (" + tableIdentifier2.getObjectType() + ")");
            dataStore3.setGeneratingSql("DESCRIBE " + string5);
            statementRunnerResult.setSourceCommand("DESCRIBE " + string5);
            statementRunnerResult.addDataStore(dataStore3);
            statementRunnerResult.setSuccess();
        }
        if (!this.showSynonymBeforeTableInfo && dataStore != null) {
            statementRunnerResult.addDataStore(dataStore);
        }
        if (charSequence != null && tableIdentifier3 != null) {
            statementRunnerResult.addMessage("\n--------[ BEGIN " + StringUtil.capitalize(tableIdentifier3.getObjectType()) + ": " + tableIdentifier3.getObjectExpression(wbConnection) + " ]--------");
            statementRunnerResult.addMessage(charSequence.toString().trim());
            statementRunnerResult.addMessage("--------[ END " + StringUtil.capitalize(tableIdentifier2.getObjectType()) + ": " + tableIdentifier3.getObjectExpression(wbConnection) + "   ]--------");
        }
        if (charSequence3 != null) {
            statementRunnerResult.addMessage("\n--------[ BEGIN " + StringUtil.capitalize(tableIdentifier2.getObjectType()) + ": " + string4 + " ]--------");
            statementRunnerResult.addMessage(charSequence3.toString().trim());
            statementRunnerResult.addMessage("--------[ END " + StringUtil.capitalize(tableIdentifier2.getObjectType()) + ": " + string4 + "   ]--------");
            statementRunnerResult.setSourceCommand(StringUtil.getMaxSubstring(charSequence3.toString(), 350, " ... "));
            statementRunnerResult.setSuccess();
        }
        if (bl) {
            this.appendTableDependencies(wbConnection, tableIdentifier2, statementRunnerResult, string4);
        }
        statementRunnerResult.setExecutionDuration(System.currentTimeMillis() - l);
        return statementRunnerResult;
    }

    private void appendTableDependencies(WbConnection wbConnection, TableIdentifier tableIdentifier, StatementRunnerResult statementRunnerResult, String string) {
        DataStore dataStore;
        Object object;
        if (tableIdentifier == null || !wbConnection.getMetadata().isTableType(tableIdentifier.getType())) {
            return;
        }
        CallerInfo callerInfo = new CallerInfo(){};
        try {
            object = wbConnection.getMetadata().getIndexReader();
            DataStore dataStore2 = dataStore = object != null ? object.getTableIndexInformation(tableIdentifier) : null;
            if (dataStore != null && dataStore.getRowCount() > 0) {
                dataStore.setResultName(string + " - " + ResourceMgr.getString("TxtDbExplorerIndexes"));
                statementRunnerResult.addDataStore(dataStore);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(callerInfo, "Error retrieving index info for " + tableIdentifier, exception);
        }
        try {
            object = TriggerReaderFactory.createReader(wbConnection);
            DataStore dataStore3 = dataStore = object != null ? object.getTableTriggers(tableIdentifier) : null;
            if (dataStore != null && dataStore.getRowCount() > 0) {
                dataStore.setResultName(string + " - " + ResourceMgr.getString("TxtDbExplorerTriggers"));
                statementRunnerResult.addDataStore(dataStore);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(callerInfo, "Error retrieving triggers for " + tableIdentifier, exception);
        }
        if (wbConnection.getDbSettings().objectInfoWithFK()) {
            try {
                this.retrieveForeignKeys(wbConnection, string, tableIdentifier, statementRunnerResult);
            }
            catch (Exception exception) {
                LogMgr.logError(callerInfo, "Error retrieving foreign keys for " + tableIdentifier, exception);
            }
        }
    }

    private void retrieveForeignKeys(WbConnection wbConnection, String string, TableIdentifier tableIdentifier, StatementRunnerResult statementRunnerResult) throws SQLException {
        this.retrieveReferencedTables(wbConnection, string, tableIdentifier, statementRunnerResult);
        this.retrieveReferencingTables(wbConnection, string, tableIdentifier, statementRunnerResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void retrieveReferencingTables(WbConnection var1_1, String var2_2, TableIdentifier var3_3, StatementRunnerResult var4_4) throws SQLException {
        var5_5 = null;
        var6_6 = var1_1.getDbSettings().useCacheForObjectInfo();
        if (var6_6) {
            var7_7 = var1_1.isBusy();
            try {
                var1_1.setBusy(false);
                var8_9 = FKHandler.createInstance(var1_1);
                var9_10 = var1_1.getObjectCache().getReferencingTables(var3_3);
                if (!CollectionUtil.isNonEmpty(var9_10)) ** GOTO lbl19
                var5_5 = TableDependency.createDisplayDataStore(var1_1, var3_3, var9_10, false);
            }
            finally {
                var1_1.setBusy(var7_7);
            }
        } else {
            var7_8 = new TableDependency(var1_1, var3_3);
            var5_5 = var7_8.getDisplayDataStore(false);
        }
lbl19:
        // 3 sources

        if (var5_5 != null && var5_5.getRowCount() > 0) {
            var5_5.setResultName(var2_2 + " - " + ResourceMgr.getString("TxtDbExplorerReferencedColumns"));
            var4_4.addDataStore(var5_5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void retrieveReferencedTables(WbConnection var1_1, String var2_2, TableIdentifier var3_3, StatementRunnerResult var4_4) throws SQLException {
        var5_5 = null;
        var6_6 = var1_1.getDbSettings().useCacheForObjectInfo();
        if (var6_6) {
            var7_7 = var1_1.isBusy();
            try {
                var1_1.setBusy(false);
                var8_9 = var1_1.getObjectCache().getReferencedTables(var3_3);
                if (!CollectionUtil.isNonEmpty(var8_9)) ** GOTO lbl18
                var5_5 = TableDependency.createDisplayDataStore(var1_1, var3_3, var8_9, true);
            }
            finally {
                var1_1.setBusy(var7_7);
            }
        } else {
            var7_8 = new TableDependency(var1_1, var3_3);
            var5_5 = var7_8.getDisplayDataStore(true);
        }
lbl18:
        // 3 sources

        if (var5_5 != null && var5_5.getRowCount() > 0) {
            var5_5.setResultName(var2_2 + " - " + ResourceMgr.getString("TxtDbExplorerFkColumns"));
            var4_4.addDataStore(var5_5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableIdentifier findObject(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        boolean bl = wbConnection.isBusy();
        boolean bl2 = wbConnection.getDbSettings().useCacheForObjectInfo();
        DbObjectFinder dbObjectFinder = new DbObjectFinder(wbConnection);
        try {
            wbConnection.setBusy(false);
            TableIdentifier tableIdentifier2 = null;
            if (bl2 && (tableIdentifier2 = wbConnection.getObjectCache().getOrRetrieveTable(tableIdentifier)) != null) {
                TableIdentifier tableIdentifier3 = tableIdentifier2;
                return tableIdentifier3;
            }
            List<String> list = DbSearchPath.Factory.getSearchPathHandler(wbConnection).getSearchPath(wbConnection, null);
            boolean bl3 = wbConnection.getDbSettings().getSearchAllSchemas();
            if (tableIdentifier.getSchema() == null && !list.isEmpty()) {
                LogMgr.logDebug(new CallerInfo(){}, "Searching schemas: " + list + " for " + tableIdentifier.getTableName());
                for (String string : list) {
                    TableIdentifier tableIdentifier4 = tableIdentifier.createCopy();
                    tableIdentifier4.setSchema(string);
                    tableIdentifier2 = dbObjectFinder.findObject(tableIdentifier4, true, false);
                    if (tableIdentifier2 == null) continue;
                    break;
                }
            } else {
                tableIdentifier2 = dbObjectFinder.findObject(tableIdentifier, true, bl3);
            }
            TableIdentifier tableIdentifier5 = tableIdentifier2;
            return tableIdentifier5;
        }
        finally {
            wbConnection.setBusy(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableDefinition getTableDefinition(WbConnection wbConnection, TableIdentifier tableIdentifier) throws SQLException {
        TableDefinition tableDefinition = null;
        boolean bl = wbConnection.getDbSettings().useCacheForObjectInfo();
        if (bl) {
            boolean bl2 = wbConnection.isBusy();
            try {
                wbConnection.setBusy(false);
                TableIdentifier tableIdentifier2 = wbConnection.getObjectCache().getOrRetrieveTable(tableIdentifier);
                List<ColumnIdentifier> list = wbConnection.getObjectCache().getColumns(tableIdentifier2);
                tableDefinition = new TableDefinition(tableIdentifier, list);
            }
            finally {
                wbConnection.setBusy(bl2);
            }
        } else {
            tableDefinition = wbConnection.getMetadata().getTableDefinition(tableIdentifier);
            wbConnection.getObjectCache().addTable(tableDefinition);
        }
        return tableDefinition;
    }

    public static DataStore getPlainSynonymInfo(WbConnection wbConnection, TableIdentifier tableIdentifier) {
        Object object;
        String[] stringArray = new String[]{"NAME", "VALUE"};
        int[] nArray = new int[]{12, 12};
        int[] nArray2 = new int[]{20, 20};
        DataStore dataStore = new DataStore(stringArray, nArray, nArray2);
        DbMetadata dbMetadata = wbConnection.getMetadata();
        DbSettings dbSettings = wbConnection.getDbSettings();
        if (dbMetadata == null || dbSettings == null) {
            return dataStore;
        }
        int n = -1;
        if (dbSettings.supportsCatalogs()) {
            object = dbMetadata.getCatalogTerm().toUpperCase();
            n = dataStore.addRow();
            dataStore.setValue(n, 0, (Object)("SYNONYM_" + (String)object));
            dataStore.setValue(n, 1, (Object)tableIdentifier.getCatalog());
        }
        if (dbSettings.supportsSchemas()) {
            object = dbMetadata.getSchemaTerm().toUpperCase();
            n = dataStore.addRow();
            dataStore.setValue(n, 0, (Object)("SYNONYM_" + (String)object));
            dataStore.setValue(n, 1, (Object)tableIdentifier.getSchema());
        }
        n = dataStore.addRow();
        dataStore.setValue(n, 0, (Object)"SYNONYM_NAME");
        dataStore.setValue(n, 1, (Object)tableIdentifier.getObjectName());
        object = dbMetadata.getSynonymTable(tableIdentifier);
        if (object != null) {
            n = dataStore.addRow();
            dataStore.setValue(n, 0, (Object)"BASE_TABLE");
            dataStore.setValue(n, 1, (Object)((TableIdentifier)object).getTableExpression(wbConnection));
        }
        dataStore.resetStatus();
        return dataStore;
    }

    private boolean readSequence(WbConnection wbConnection, StatementRunnerResult statementRunnerResult, TableIdentifier tableIdentifier, boolean bl) {
        if (tableIdentifier == null) {
            return false;
        }
        if (!wbConnection.getMetadata().isSequenceType(tableIdentifier.getType())) {
            return false;
        }
        try {
            SequenceReader sequenceReader = wbConnection.getMetadata().getSequenceReader();
            if (sequenceReader != null) {
                String string = tableIdentifier.getSchema();
                String string2 = tableIdentifier.getObjectName();
                String string3 = tableIdentifier.getCatalog();
                SequenceDefinition sequenceDefinition = sequenceReader.getSequenceDefinition(string3, string, string2);
                if (sequenceDefinition != null) {
                    DataStore dataStore = sequenceDefinition.getRawDefinition();
                    dataStore.setResultName(sequenceDefinition.getObjectType() + ": " + sequenceDefinition.getObjectName());
                    statementRunnerResult.addDataStore(dataStore);
                    if (bl) {
                        CharSequence charSequence = sequenceDefinition.getSource();
                        if (charSequence == null) {
                            charSequence = sequenceDefinition.getSource(wbConnection);
                        }
                        if (charSequence != null) {
                            String string4 = charSequence.toString();
                            statementRunnerResult.addMessage("--------[ BEGIN " + StringUtil.capitalize(sequenceDefinition.getObjectType()) + ": " + sequenceDefinition.getObjectName() + " ]--------");
                            statementRunnerResult.addMessage(string4);
                            statementRunnerResult.addMessage("--------[ END " + StringUtil.capitalize(sequenceDefinition.getObjectType()) + ": " + sequenceDefinition.getObjectName() + "   ]--------");
                            if (StringUtil.isBlank(statementRunnerResult.getSourceCommand())) {
                                statementRunnerResult.setSourceCommand(StringUtil.getMaxSubstring(string4, 350, "..."));
                            }
                        }
                    }
                    return true;
                }
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error retrieving sequences", exception);
        }
        return false;
    }
}

