/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import workbench.interfaces.ExecutionController;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.ConditionCheck;
import workbench.util.ArgumentParser;
import workbench.util.StringUtil;

public class WbConfirm
extends SqlCommand {
    public static final String VERB = "WbConfirm";
    public static final String PARAM_MSG = "message";
    public static final String PARAM_YES = "yesText";
    public static final String PARAM_NO = "noText";

    public WbConfirm() {
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument(PARAM_MSG);
        this.cmdLine.addArgument(PARAM_YES);
        this.cmdLine.addArgument(PARAM_NO);
        ConditionCheck.addParameters(this.cmdLine);
        this.isUpdatingCommand = false;
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        String string2 = this.getCommandLine(string);
        this.cmdLine.parse(string2);
        String string3 = null;
        String string4 = null;
        String string5 = null;
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        if (this.cmdLine.hasArguments()) {
            string3 = this.cmdLine.getValue(PARAM_MSG);
            string4 = this.cmdLine.getValue(PARAM_YES);
            string5 = this.cmdLine.getValue(PARAM_NO);
            if (!this.checkConditions(statementRunnerResult)) {
                return statementRunnerResult;
            }
        } else {
            string3 = StringUtil.trimQuotes(string2);
        }
        statementRunnerResult.setStopScript(false);
        statementRunnerResult.setSuccess();
        ExecutionController executionController = this.runner.getExecutionController();
        if (executionController != null) {
            boolean bl;
            if (StringUtil.isBlank(string3)) {
                string3 = ResourceMgr.getString("MsgConfirmContinue");
            }
            if (!(bl = executionController.confirmExecution(string3, string4, string5))) {
                statementRunnerResult.setStopScript(true);
            }
        }
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

