/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import workbench.WbManager;
import workbench.db.ConnectionInfoBuilder;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;

public class WbConnInfo
extends SqlCommand {
    public static final String VERB = "WbConnInfo";

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatementRunnerResult execute(String string) throws SQLException, Exception {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult(string);
        statementRunnerResult.setSuccess();
        if (this.currentConnection == null) {
            statementRunnerResult.addMessageByKey("TxtNotConnected");
        } else {
            try {
                this.currentConnection.setBusy(false);
                int n = 0;
                ConnectionInfoBuilder connectionInfoBuilder = new ConnectionInfoBuilder();
                if (WbManager.getInstance().isConsoleMode()) {
                    statementRunnerResult.addMessageNewLine();
                    n = 2;
                }
                statementRunnerResult.addMessage(connectionInfoBuilder.getPlainTextDisplay(this.currentConnection, n));
                if (WbManager.getInstance().isConsoleMode()) {
                    statementRunnerResult.addMessageNewLine();
                }
            }
            finally {
                this.currentConnection.setBusy(true);
            }
        }
        return statementRunnerResult;
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

