/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import java.util.Collection;
import workbench.WbManager;
import workbench.console.ConsoleSettings;
import workbench.console.RowDisplay;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.ObjectInfo;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;

public class WbDescribeObject
extends SqlCommand {
    public static final String VERB = "WbDescribe";
    public static final String VERB_SHORT = "DESC";
    public static final String VERB_LONG = "DESCRIBE";
    public static final String ARG_DEPEND = "dependencies";
    public static final String ARG_OBJECT = "object";

    public WbDescribeObject() {
        this.isUpdatingCommand = false;
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument(ARG_DEPEND, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_OBJECT, ArgumentType.TableArgument);
    }

    @Override
    public Collection<String> getAllVerbs() {
        return CollectionUtil.arrayList(VERB, VERB_SHORT, VERB_LONG);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public String getAlternateVerb() {
        return VERB_LONG;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        try {
            ConsoleSettings.getInstance().setNextRowDisplay(RowDisplay.SingleLine);
            String string2 = this.getCommandLine(string);
            this.cmdLine.parse(string2);
            boolean bl = true;
            String string3 = this.cmdLine.getValue(ARG_OBJECT, this.cmdLine.getNonArguments());
            if (this.cmdLine.hasArguments()) {
                bl = this.cmdLine.getBoolean(ARG_DEPEND, true);
            }
            boolean bl2 = true;
            if (WbManager.getInstance().isConsoleMode()) {
                bl2 = this.cmdLine.isArgPresent(ARG_DEPEND) ? bl : false;
            }
            ObjectInfo objectInfo = new ObjectInfo();
            StatementRunnerResult statementRunnerResult = objectInfo.getObjectInfo(this.currentConnection, string3, bl, bl2);
            statementRunnerResult.setSourceCommand(string);
            statementRunnerResult.setShowRowCount(false);
            return statementRunnerResult;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error getting object details", exception);
            StatementRunnerResult statementRunnerResult = new StatementRunnerResult(string);
            statementRunnerResult.addErrorMessage(ExceptionUtil.getDisplay(exception));
            return statementRunnerResult;
        }
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

