/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import workbench.WbManager;
import workbench.db.ColumnIdentifier;
import workbench.db.WbConnection;
import workbench.db.exporter.BlobMode;
import workbench.db.exporter.OdfHelper;
import workbench.db.exporter.PoiHelper;
import workbench.db.importer.AbstractImportFileParser;
import workbench.db.importer.AbstractXmlDataFileParser;
import workbench.db.importer.ConstantColumnValues;
import workbench.db.importer.CycleErrorException;
import workbench.db.importer.DataImporter;
import workbench.db.importer.DeleteType;
import workbench.db.importer.GenericXmlFileParser;
import workbench.db.importer.ImportDMLStatementBuilder;
import workbench.db.importer.ImportFileLister;
import workbench.db.importer.ImportMode;
import workbench.db.importer.OverrideIdentityType;
import workbench.db.importer.ParsingInterruptedException;
import workbench.db.importer.RowDataProducer;
import workbench.db.importer.SpreadsheetFileParser;
import workbench.db.importer.StreamImporter;
import workbench.db.importer.TableStatements;
import workbench.db.importer.TextFileParser;
import workbench.db.importer.WbXmlDataFileParser;
import workbench.db.postgres.PgCopyManager;
import workbench.interfaces.ImportFileParser;
import workbench.interfaces.TabularDataParser;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.ColumnWidthDefinition;
import workbench.sql.wbcommands.CommonArgs;
import workbench.sql.wbcommands.ConditionCheck;
import workbench.sql.wbcommands.EmptyImportFileHandling;
import workbench.sql.wbcommands.MissingWidthDefinition;
import workbench.sql.wbcommands.ModifierArguments;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.ArgumentValue;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.FileUtil;
import workbench.util.StringUtil;
import workbench.util.ValueConverter;
import workbench.util.WbFile;

public class WbImport
extends SqlCommand {
    public static final String VERB = "WbImport";
    public static final String ARG_TYPE = "type";
    public static final String ARG_FILE = "file";
    public static final String ARG_TARGETTABLE = "table";
    public static final String ARG_CONTAINSHEADER = "header";
    public static final String ARG_FILECOLUMNS = "fileColumns";
    public static final String ARG_KEYCOLUMNS = "keyColumns";
    public static final String ARG_EMPTY_STRING_IS_NULL = "emptyStringIsNull";
    public static final String ARG_DECODE = "decode";
    public static final String ARG_IMPORTCOLUMNS = "importColumns";
    public static final String ARG_COL_FILTER = "columnFilter";
    public static final String ARG_LINE_FILTER = "lineFilter";
    public static final String ARG_DIRECTORY = "sourceDir";
    public static final String ARG_USE_TRUNCATE = "useTruncate";
    public static final String ARG_TRIM_VALUES = "trimValues";
    public static final String ARG_FILE_EXT = "extension";
    public static final String ARG_UPDATE_WHERE = "updateWhere";
    public static final String ARG_CREATE_TABLE = "createTarget";
    public static final String ARG_BLOB_ISFILENAME = "blobIsFilename";
    public static final String ARG_CLOB_ISFILENAME = "clobIsFilename";
    public static final String ARG_MULTI_LINE = "multiLine";
    public static final String ARG_START_ROW = "startRow";
    public static final String ARG_END_ROW = "endRow";
    public static final String ARG_BADFILE = "badFile";
    public static final String ARG_CONSTANTS = "constantValues";
    public static final String ARG_COL_WIDTHS = "columnWidths";
    public static final String ARG_IGNORE_OWNER = "ignoreOwner";
    public static final String ARG_EXCLUDE_FILES = "excludeFiles";
    public static final String ARG_USE_SAVEPOINT = "useSavepoint";
    public static final String ARG_INSERT_START = "insertSQL";
    public static final String ARG_ILLEGAL_DATE_NULL = "illegalDateIsNull";
    public static final String ARG_READ_DATES_AS_STRINGS = "stringDates";
    public static final String ARG_EMPTY_FILE = "emptyFile";
    public static final String ARG_PG_COPY = "usePgCopy";
    public static final String ARG_SHEET_NR = "sheetNumber";
    public static final String ARG_SHEET_NAME = "sheetName";
    public static final String ARG_IGNORE_MISSING_COLS = "ignoreMissingColumns";
    public static final String ARG_ADJUST_SEQ = "adjustSequences";
    public static final String ARG_RECALC_FORMULAS = "recalculateFormulas";
    public static final String ARG_XML_ROW_TAG = "xmlRowTag";
    public static final String ARG_XML_ATT_MAPPING = "xmlAttCol";
    public static final String ARG_XML_COL_TAGS = "xmlTagCol";
    public static final String ARG_COLUMN_EXPR = "columnExpression";
    public static final String ARG_OVERRIDE_IDENTITY = "overrideIdentity";
    private DataImporter imp;

    public WbImport() {
        this.isUpdatingCommand = true;
        this.cmdLine = new ArgumentParser();
        this.initArgumentParser();
    }

    @Override
    public void setConnection(WbConnection wbConnection) {
        super.setConnection(wbConnection);
        this.cmdLine.clear();
        this.initArgumentParser();
    }

    private void initArgumentParser() {
        CommonArgs.addDelimiterParameter(this.cmdLine);
        CommonArgs.addEncodingParameter(this.cmdLine);
        CommonArgs.addProgressParameter(this.cmdLine);
        CommonArgs.addCommitParameter(this.cmdLine);
        CommonArgs.addContinueParameter(this.cmdLine);
        CommonArgs.addCommitAndBatchParams(this.cmdLine);
        CommonArgs.addQuoteEscaping(this.cmdLine);
        CommonArgs.addConverterOptions(this.cmdLine, true);
        CommonArgs.addCheckDepsParameter(this.cmdLine);
        CommonArgs.addTableStatements(this.cmdLine);
        CommonArgs.addTransactionControL(this.cmdLine);
        CommonArgs.addImportModeParameter(this.cmdLine);
        List<String> list = CollectionUtil.arrayList("text", "xml");
        list.addAll(WbImport.getSupportedSpreadSheetTypes());
        this.cmdLine.addArgument(ARG_TYPE, list);
        this.cmdLine.addArgument(ARG_IGNORE_MISSING_COLS, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_SHEET_NR);
        this.cmdLine.addArgument(ARG_SHEET_NAME);
        this.cmdLine.addArgument(ARG_EMPTY_FILE, EmptyImportFileHandling.class);
        this.cmdLine.addArgument(ARG_UPDATE_WHERE);
        this.cmdLine.addArgument(ARG_FILE, ArgumentType.Filename);
        this.cmdLine.addArgument(ARG_TARGETTABLE, ArgumentType.TableArgument);
        this.cmdLine.addArgument("quotechar");
        this.cmdLine.addArgument(ARG_CONTAINSHEADER, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_FILECOLUMNS);
        this.cmdLine.addArgument(ARG_KEYCOLUMNS);
        this.cmdLine.addArgument("deleteTarget", ArgumentType.BoolArgument);
        this.cmdLine.addArgument("truncateTable", ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_EMPTY_STRING_IS_NULL, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_DECODE, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_IMPORTCOLUMNS);
        this.cmdLine.addArgument(ARG_COL_FILTER);
        this.cmdLine.addArgument(ARG_LINE_FILTER);
        this.cmdLine.addArgument(ARG_DIRECTORY, ArgumentType.DirName);
        this.cmdLine.addArgument("schema", ArgumentType.SchemaArgument);
        this.cmdLine.addArgument(ARG_USE_TRUNCATE, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_ILLEGAL_DATE_NULL, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_TRIM_VALUES, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_FILE_EXT);
        this.cmdLine.addArgument(ARG_CREATE_TABLE, ArgumentType.BoolArgument);
        this.cmdLine.addArgument("ignoreIdentityColumns", ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_BLOB_ISFILENAME, ArgumentType.BoolArgument);
        this.cmdLine.addArgument("blobType", CollectionUtil.arrayList(ARG_FILE, "ansi", "base64"));
        if (ImportDMLStatementBuilder.supportsOverrideIdentity(this.currentConnection)) {
            this.cmdLine.addArgument(ARG_OVERRIDE_IDENTITY, OverrideIdentityType.class);
        }
        this.cmdLine.addArgument(ARG_CLOB_ISFILENAME, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_MULTI_LINE, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_START_ROW, ArgumentType.IntegerArgument);
        this.cmdLine.addArgument(ARG_END_ROW, ArgumentType.IntegerArgument);
        this.cmdLine.addArgument(ARG_BADFILE);
        this.cmdLine.addArgument(ARG_CONSTANTS, ArgumentType.Repeatable);
        this.cmdLine.addArgument(ARG_COL_WIDTHS);
        this.cmdLine.addArgument(ARG_EXCLUDE_FILES);
        this.cmdLine.addArgument(ARG_IGNORE_OWNER, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_USE_SAVEPOINT, ArgumentType.BoolArgument);
        this.cmdLine.addArgument("quoteAlways");
        this.cmdLine.addArgument("nullString");
        this.cmdLine.addArgument(ARG_INSERT_START);
        this.cmdLine.addArgument(ARG_PG_COPY, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_ADJUST_SEQ, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument("skipTargetCheck", ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_READ_DATES_AS_STRINGS, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_RECALC_FORMULAS, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_XML_ROW_TAG);
        this.cmdLine.addArgument(ARG_XML_ATT_MAPPING, ArgumentType.Repeatable);
        this.cmdLine.addArgument(ARG_XML_COL_TAGS, ArgumentType.Repeatable);
        this.cmdLine.addArgument(ARG_COLUMN_EXPR, ArgumentType.Repeatable);
        this.cmdLine.addArgument("columnBlobType", ArgumentType.Repeatable);
        ModifierArguments.addArguments(this.cmdLine);
        ConditionCheck.addParameters(this.cmdLine);
    }

    public static List<String> getSupportedSpreadSheetTypes() {
        ArrayList<String> arrayList = new ArrayList<String>(3);
        if (PoiHelper.isPoiAvailable()) {
            arrayList.add("xls");
        }
        if (PoiHelper.isXLSXAvailable()) {
            arrayList.add("xlsx");
        }
        if (OdfHelper.isSimpleODFAvailable()) {
            arrayList.add("ods");
        }
        return arrayList;
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    private void addWrongParamsMessage(StatementRunnerResult statementRunnerResult) {
        if (WbManager.getInstance().isBatchMode()) {
            return;
        }
        String string = this.getWrongParamsMessage();
        statementRunnerResult.addMessageNewLine();
        statementRunnerResult.addMessage(string);
        if (statementRunnerResult.isSuccess() || statementRunnerResult.getErrorDescriptor() == null) {
            statementRunnerResult.setFailure();
        }
    }

    private String getWrongParamsMessage() {
        String string = ResourceMgr.getString("ErrImportWrongParameters");
        string = StringUtil.replace(string, "%continue_default%", Boolean.toString(WbImport.getContinueDefault()));
        string = StringUtil.replace(string, "%multiline_default%", Boolean.toString(WbImport.getMultiDefault()));
        string = StringUtil.replace(string, "%header_default%", Boolean.toString(WbImport.getHeaderDefault()));
        string = StringUtil.replace(string, "%trim_default%", Boolean.toString(this.getTrimDefault()));
        string = StringUtil.replace(string, "%default_encoding%", Settings.getInstance().getDefaultDataEncoding());
        boolean bl = this.currentConnection == null ? false : this.currentConnection.getDbSettings().useSavepointForImport();
        string = string.replace("%savepoint_default%", Boolean.toString(bl));
        return string;
    }

    static boolean getIgnoreMissingDefault() {
        return Settings.getInstance().getBoolProperty("workbench.import.default.ignoremissingcolumns", true);
    }

    static boolean getContinueDefault() {
        return Settings.getInstance().getBoolProperty("workbench.import.default.continue", false);
    }

    static boolean getHeaderDefault() {
        return Settings.getInstance().getBoolProperty("workbench.import.default.header", true);
    }

    static boolean getMultiDefault() {
        return Settings.getInstance().getBoolProperty("workbench.import.default.multilinerecord", false);
    }

    private boolean getTrimDefault() {
        return Settings.getInstance().getBoolProperty("workbench.import.default.trimvalues", false);
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        int n;
        int n2;
        Object missingWidthDefinition;
        Object string22;
        Object string21;
        Object exception;
        Object object;
        int string14;
        Object object2;
        StatementRunnerResult statementRunnerResult = this.createResult(string);
        String string2 = this.getCommandLine(string);
        this.cmdLine.parse(string2);
        if (this.displayHelp(statementRunnerResult)) {
            return statementRunnerResult;
        }
        if (this.cmdLine.hasUnknownArguments()) {
            this.setUnknownMessage(statementRunnerResult, this.cmdLine, this.getWrongParamsMessage());
            return statementRunnerResult;
        }
        if (!this.cmdLine.hasArguments()) {
            this.addWrongParamsMessage(statementRunnerResult);
            return statementRunnerResult;
        }
        if (!this.checkConditions(statementRunnerResult)) {
            return statementRunnerResult;
        }
        this.imp = new DataImporter();
        this.imp.setConnection(this.currentConnection);
        WbFile wbFile = this.evaluateFileArgument(this.cmdLine.getValue(ARG_FILE));
        String string3 = this.cmdLine.getValue(ARG_TYPE);
        String string4 = this.cmdLine.getValue(ARG_DIRECTORY);
        String string5 = null;
        if (wbFile == null && string4 == null) {
            statementRunnerResult.addErrorMessageByKey("ErrImportFileMissing");
            this.addWrongParamsMessage(statementRunnerResult);
            return statementRunnerResult;
        }
        if (string3 == null && wbFile != null) {
            string3 = WbImport.findTypeFromFilename(wbFile.getFullPath());
        }
        if (string3 == null) {
            statementRunnerResult.addErrorMessageByKey("ErrImportTypeMissing");
            this.addWrongParamsMessage(statementRunnerResult);
            return statementRunnerResult;
        }
        string3 = string3.toLowerCase();
        Set<String> set = CollectionUtil.caseInsensitiveSet("txt");
        for (ArgumentValue object72 : this.cmdLine.getAllowedValues(ARG_TYPE)) {
            set.add(object72.getValue());
        }
        if (!set.contains(string3)) {
            statementRunnerResult.addErrorMessageByKey("ErrImportInvalidType");
            return statementRunnerResult;
        }
        boolean bl = string4 != null && wbFile == null;
        String string6 = this.cmdLine.getValue(ARG_BADFILE);
        if (string6 != null) {
            File bl2 = new File(string6);
            if (bl && !bl2.isDirectory()) {
                statementRunnerResult.addErrorMessageByKey("ErrImportBadFileNoDir");
                return statementRunnerResult;
            }
        }
        CommonArgs.setCommitAndBatchParams(this.imp, this.cmdLine);
        boolean bl2 = this.cmdLine.getBoolean("continueOnError", WbImport.getContinueDefault());
        this.imp.setContinueOnError(bl2);
        boolean bl3 = this.cmdLine.getBoolean(ARG_IGNORE_MISSING_COLS, WbImport.getIgnoreMissingDefault());
        this.imp.setUseSavepoint(this.cmdLine.getBoolean(ARG_USE_SAVEPOINT, this.currentConnection.getDbSettings().useSavepointForImport()));
        this.imp.setIgnoreIdentityColumns(this.cmdLine.getBoolean("ignoreIdentityColumns", false));
        this.imp.setAdjustSequences(this.cmdLine.getBoolean(ARG_ADJUST_SEQ, false));
        this.imp.setOverrideIdentity(this.cmdLine.getEnumValue(ARG_OVERRIDE_IDENTITY, OverrideIdentityType.class));
        boolean bl4 = this.cmdLine.getBoolean("skipTargetCheck", false);
        this.imp.skipTargetCheck(bl4);
        String string7 = this.cmdLine.getValue(ARG_TARGETTABLE);
        String string8 = this.cmdLine.getValue("schema");
        EmptyImportFileHandling emptyImportFileHandling = null;
        CallerInfo callerInfo = new CallerInfo(){};
        try {
            emptyImportFileHandling = this.cmdLine.getEnumValue(ARG_EMPTY_FILE, EmptyImportFileHandling.fail);
        }
        catch (IllegalArgumentException string10) {
            String string12 = this.cmdLine.getValue(ARG_EMPTY_FILE);
            LogMgr.logError(callerInfo, "Invalid value '" + string12 + "' specified for parameter: " + ARG_EMPTY_FILE, string10);
            String n4 = ResourceMgr.getFormattedString("ErrInvalidArgValue", string12, ARG_EMPTY_FILE);
            statementRunnerResult.addErrorMessage(n4);
            return statementRunnerResult;
        }
        if (wbFile != null) {
            if (!wbFile.exists()) {
                String string11 = ResourceMgr.getFormattedString("ErrImportFileNotFound", wbFile.getFullPath());
                statementRunnerResult.addMessage(string11);
                if (bl2) {
                    LogMgr.logWarning(callerInfo, string11, null);
                    statementRunnerResult.setWarning();
                } else {
                    LogMgr.logError(callerInfo, string11, null);
                    statementRunnerResult.setFailure();
                }
                return statementRunnerResult;
            }
            if (wbFile.length() == 0L && emptyImportFileHandling != EmptyImportFileHandling.ignore) {
                String object6 = ResourceMgr.getFormattedString("ErrImportFileEmpty", wbFile.getFullPath());
                statementRunnerResult.addMessage(object6);
                if (bl2 || emptyImportFileHandling == EmptyImportFileHandling.warning) {
                    LogMgr.logWarning(callerInfo, object6, null);
                    statementRunnerResult.setWarning();
                } else {
                    LogMgr.logError(callerInfo, object6, null);
                    statementRunnerResult.setFailure();
                }
                return statementRunnerResult;
            }
        } else {
            object2 = this.evaluateFileArgument(string4);
            if (!((File)object2).exists()) {
                String string13 = ResourceMgr.getFormattedString("ErrImportSourceDirNotFound", string4);
                LogMgr.logError(callerInfo, string13, null);
                statementRunnerResult.addErrorMessage(string13);
                return statementRunnerResult;
            }
            if (!((File)object2).isDirectory()) {
                String n3 = ResourceMgr.getFormattedString("ErrImportNoDir", string4);
                LogMgr.logError(callerInfo, n3, null);
                statementRunnerResult.addErrorMessage(n3);
                return statementRunnerResult;
            }
        }
        if ((object2 = this.cmdLine.getValue("showProgress")) == null && wbFile != null) {
            string14 = this.imp.getBatchSize();
            if (string14 > 0) {
                this.imp.setReportInterval(string14);
            } else {
                int object8 = DataImporter.estimateReportIntervalFromFileSize(wbFile);
                this.imp.setReportInterval(object8);
            }
        } else if ("true".equalsIgnoreCase((String)object2)) {
            this.imp.setReportInterval(1);
        } else if ("false".equalsIgnoreCase((String)object2)) {
            this.imp.setReportInterval(0);
        } else if (object2 != null) {
            string14 = StringUtil.getIntValue((String)object2, 0);
            this.imp.setReportInterval(string14);
        } else {
            this.imp.setReportInterval(10);
        }
        String string9 = this.cmdLine.getValue("encoding");
        Object object3 = null;
        String string10 = this.cmdLine.getValue("mode", ImportMode.insert.name());
        if ("text".equalsIgnoreCase(string3) || "txt".equalsIgnoreCase(string3)) {
            if (string7 == null && string4 == null) {
                String string17 = ResourceMgr.getString("ErrImportRequiresTableName");
                LogMgr.logError(callerInfo, string17, null);
                statementRunnerResult.addErrorMessage(string17);
                return statementRunnerResult;
            }
            if (!CommonArgs.checkQuoteEscapting(this.cmdLine)) {
                String object5 = ResourceMgr.getString("ErrQuoteAlwaysEscape");
                LogMgr.logError(callerInfo, object5, null);
                statementRunnerResult.addErrorMessage(object5);
                return statementRunnerResult;
            }
            string5 = "txt";
            object3 = object = new TextFileParser();
            ((AbstractImportFileParser)object).setTableName(string7);
            if (wbFile != null) {
                ((AbstractImportFileParser)object).setInputFile(wbFile);
            }
            boolean string19 = this.cmdLine.getBoolean(ARG_MULTI_LINE, WbImport.getMultiDefault());
            ((TextFileParser)object).setEnableMultilineRecords(string19);
            ((AbstractImportFileParser)object).setTargetSchema(string8);
            ((AbstractImportFileParser)object).setConnection(this.currentConnection);
            ((TextFileParser)object).setTreatClobAsFilenames(this.cmdLine.getBoolean(ARG_CLOB_ISFILENAME, false));
            ((TextFileParser)object).setNullString(this.cmdLine.getValue("nullString", null));
            ((TextFileParser)object).setAlwaysQuoted(this.cmdLine.getBoolean("quoteAlways", false));
            ((TextFileParser)object).setIllegalDateIsNull(this.cmdLine.getBoolean(ARG_ILLEGAL_DATE_NULL, false));
            ((AbstractImportFileParser)object).setAbortOnError(!bl2);
            ((AbstractImportFileParser)object).setIgnoreMissingColumns(bl3);
            String string20 = this.cmdLine.getEscapedString("delimiter");
            if (this.cmdLine.isArgPresent("delimiter") && StringUtil.isEmptyString(string20)) {
                statementRunnerResult.addErrorMessageByKey("ErrImpDelimEmpty");
                return statementRunnerResult;
            }
            if (string20 != null) {
                ((TextFileParser)object).setTextDelimiter(string20);
            }
            if ((exception = this.cmdLine.getEscapedString("quotechar")) != null) {
                ((TextFileParser)object).setTextQuoteChar((String)exception);
            }
            ((TextFileParser)object).setDecode(this.cmdLine.getBoolean(ARG_DECODE, false));
            if (string9 != null) {
                ((AbstractImportFileParser)object).setEncoding(string9);
            }
            ((TextFileParser)object).setEmptyStringIsNull(this.cmdLine.getBoolean(ARG_EMPTY_STRING_IS_NULL, true));
            this.initParser(string7, (TabularDataParser)object, statementRunnerResult, bl, bl4);
            if (!statementRunnerResult.isSuccess()) {
                ((TextFileParser)object).done();
                return statementRunnerResult;
            }
            string21 = this.cmdLine.getValue(ARG_LINE_FILTER);
            if (string21 != null) {
                ((TextFileParser)object).setLineFilter(StringUtil.trimQuotes((String)string21));
            }
            ((TextFileParser)object).setQuoteEscaping(CommonArgs.getQuoteEscaping(this.cmdLine));
            string22 = this.cmdLine.getValue(ARG_COL_WIDTHS);
            if (!StringUtil.isEmptyString((CharSequence)string22)) {
                try {
                    missingWidthDefinition = new ColumnWidthDefinition((String)string22);
                    ((TextFileParser)object).setColumnWidths(((ColumnWidthDefinition)missingWidthDefinition).getColumnWidths());
                }
                catch (MissingWidthDefinition exception2) {
                    ((TextFileParser)object).done();
                    statementRunnerResult.addErrorMessageByKey("ErrImpWrongWidth", exception2.getColumnName());
                    return statementRunnerResult;
                }
            }
            if (this.cmdLine.isArgPresent(ARG_PG_COPY) && this.currentConnection.getMetadata().isPostgres()) {
                if (!"insert".equalsIgnoreCase(string10)) {
                    statementRunnerResult.addErrorMessage("COPY only possible with -mode=insert");
                    return statementRunnerResult;
                }
                missingWidthDefinition = new PgCopyManager(this.currentConnection);
                if (((PgCopyManager)missingWidthDefinition).isSupported()) {
                    ((TextFileParser)object).setStreamImporter((StreamImporter)missingWidthDefinition);
                    this.imp.setReportInterval(0);
                } else {
                    statementRunnerResult.addWarning("PostgreSQL copy API not supported!");
                }
            }
        } else if ("xml".equalsIgnoreCase(string3)) {
            Object bl6;
            string5 = "xml";
            String string23 = this.cmdLine.getValue(ARG_XML_ROW_TAG);
            if (StringUtil.isBlank(string23)) {
                object = new WbXmlDataFileParser();
            } else {
                if (string7 == null) {
                    String object9 = ResourceMgr.getString("ErrImportRequiresTableName");
                    LogMgr.logError(callerInfo, object9, null);
                    statementRunnerResult.addErrorMessage(object9);
                    return statementRunnerResult;
                }
                bl6 = new GenericXmlFileParser();
                if (this.cmdLine.isArgPresent(ARG_XML_COL_TAGS)) {
                    exception = this.cmdLine.getMapValue(ARG_XML_COL_TAGS);
                    ((GenericXmlFileParser)bl6).setRowAndColumnTags(string23, (Map<String, String>)exception);
                } else {
                    exception = this.cmdLine.getMapValue(ARG_XML_ATT_MAPPING);
                    ((GenericXmlFileParser)bl6).setRowAttributeMap(string23, (Map<String, String>)exception);
                }
                object = bl6;
            }
            ((AbstractImportFileParser)object).setConnection(this.currentConnection);
            ((AbstractImportFileParser)object).setAbortOnError(!bl2);
            ((AbstractImportFileParser)object).setIgnoreMissingColumns(bl3);
            ((AbstractXmlDataFileParser)object).setNullString(this.cmdLine.getValue("nullString"));
            object3 = object;
            object3.setCheckTargetWithQuery(bl4);
            if (string9 != null) {
                ((AbstractImportFileParser)object).setEncoding(string9);
            }
            if (string7 != null) {
                ((AbstractImportFileParser)object).setTableName(string7);
            }
            if (string4 == null) {
                ((AbstractImportFileParser)object).setInputFile(wbFile);
                bl6 = this.cmdLine.getValue(ARG_IMPORTCOLUMNS);
                if (bl6 != null) {
                    try {
                        ((AbstractXmlDataFileParser)object).setColumns((String)bl6);
                    }
                    catch (Exception string24) {
                        String string25 = StringUtil.listToString(((AbstractXmlDataFileParser)object).getMissingColumns(), ',');
                        String numberFormatException = ResourceMgr.getFormattedString("ErrImportColumnNotFound", string25, ((AbstractImportFileParser)object).getSourceFilename(), string7);
                        statementRunnerResult.addErrorMessage(numberFormatException);
                        LogMgr.logError(callerInfo, numberFormatException, null);
                        return statementRunnerResult;
                    }
                }
            }
            this.imp.setCreateTarget(this.cmdLine.getBoolean(ARG_CREATE_TABLE, false));
        } else if (string3.startsWith("xls") || string3.equals("ods")) {
            boolean importFileLister;
            object = this.cmdLine.getValue(ARG_SHEET_NR, "");
            String map = this.cmdLine.getValue(ARG_SHEET_NAME);
            boolean bl5 = importFileLister = "*".equals(object) || "%".equals(object) || "*".equals(map) || "%".equals(map);
            if (string3.startsWith("xls") && !PoiHelper.isPoiAvailable()) {
                statementRunnerResult.addErrorMessageByKey("ErrNoXLS");
                return statementRunnerResult;
            }
            if ((string3.equals("xlsx") || wbFile != null && wbFile.getExtension().equalsIgnoreCase("xlsx")) && !PoiHelper.isXLSXAvailable()) {
                statementRunnerResult.addErrorMessageByKey("ErrNoXLSX");
                return statementRunnerResult;
            }
            if (string3.equals("ods") && !OdfHelper.isSimpleODFAvailable()) {
                statementRunnerResult.addErrorMessageByKey("ErrNoODS");
                return statementRunnerResult;
            }
            if (string7 == null && string4 == null && !importFileLister) {
                String string11 = ResourceMgr.getString("ErrImportRequiresTableName");
                LogMgr.logError(callerInfo, string11, null);
                statementRunnerResult.addErrorMessage(string11);
                return statementRunnerResult;
            }
            string5 = string3;
            object3 = exception = new SpreadsheetFileParser();
            ((SpreadsheetFileParser)exception).setTableName(string7);
            ((AbstractImportFileParser)exception).setTargetSchema(string8);
            ((AbstractImportFileParser)exception).setConnection(this.currentConnection);
            ((SpreadsheetFileParser)exception).setContainsHeader(this.cmdLine.getBoolean(ARG_CONTAINSHEADER, true));
            ((SpreadsheetFileParser)exception).setNullString(this.cmdLine.getValue("nullString", null));
            ((SpreadsheetFileParser)exception).setReadDatesAsStrings(this.cmdLine.getBoolean(ARG_READ_DATES_AS_STRINGS, false));
            ((SpreadsheetFileParser)exception).setIllegalDateIsNull(this.cmdLine.getBoolean(ARG_ILLEGAL_DATE_NULL, false));
            ((SpreadsheetFileParser)exception).setEmptyStringIsNull(this.cmdLine.getBoolean(ARG_EMPTY_STRING_IS_NULL, true));
            ((SpreadsheetFileParser)exception).setCheckDependencies(this.cmdLine.getBoolean("checkDependencies", false));
            ((SpreadsheetFileParser)exception).setIgnoreOwner(this.cmdLine.getBoolean(ARG_IGNORE_OWNER, false));
            ((AbstractImportFileParser)exception).setAbortOnError(!bl2);
            ((AbstractImportFileParser)exception).setIgnoreMissingColumns(bl3);
            ((SpreadsheetFileParser)exception).setRecalcFormulas(this.cmdLine.getBoolean(ARG_RECALC_FORMULAS, true));
            if (wbFile != null) {
                if (importFileLister) {
                    ((SpreadsheetFileParser)exception).setSheetIndex(-1);
                    bl = true;
                } else if (this.cmdLine.isArgPresent(ARG_SHEET_NAME)) {
                    String n5 = this.cmdLine.getValue(ARG_SHEET_NAME);
                    ((SpreadsheetFileParser)exception).setSheetName(n5);
                } else {
                    int exception3 = this.cmdLine.getIntValue(ARG_SHEET_NR, 1);
                    ((SpreadsheetFileParser)exception).setSheetIndex(exception3 - 1);
                }
                ((SpreadsheetFileParser)exception).setInputFile(wbFile);
            }
            this.initParser(string7, (TabularDataParser)exception, statementRunnerResult, bl, bl4);
            if (!statementRunnerResult.isSuccess()) {
                ((SpreadsheetFileParser)exception).done();
                return statementRunnerResult;
            }
        }
        object = this.cmdLine.getValue(ARG_COL_FILTER);
        if (object != null) {
            this.addColumnFilter((String)object, (ImportFileParser)object3);
        }
        this.setBlobModes((ImportFileParser)object3);
        Map<String, String> map = this.cmdLine.getMapValue(ARG_COLUMN_EXPR);
        this.imp.setColumnExpressions(map);
        this.imp.setProducer((RowDataProducer)object3);
        object3.setRowMonitor(this.rowMonitor);
        this.imp.setInsertStart(this.cmdLine.getValue(ARG_INSERT_START));
        ImportFileLister importFileLister = this.getFileNameLister(this.cmdLine, string5);
        if (importFileLister != null) {
            object3.setSourceFiles(importFileLister);
        }
        object3.setTrimValues(this.cmdLine.getBoolean(ARG_TRIM_VALUES, this.getTrimDefault()));
        exception = null;
        try {
            exception = CommonArgs.getConverter(this.cmdLine, statementRunnerResult, this.currentConnection);
        }
        catch (Exception exception4) {
            LogMgr.logError(callerInfo, "Error creating ValueConverter", exception4);
            statementRunnerResult.addErrorMessage(exception4.getMessage());
            return statementRunnerResult;
        }
        this.imp.setTransactionControl(this.cmdLine.getBoolean("transactionControl", true));
        string21 = this.imp.getProducer();
        if (string21 != null) {
            string21.setValueConverter((ValueConverter)exception);
        }
        try {
            if (string4 == null) {
                string22 = new ModifierArguments(this.cmdLine);
                object3.setValueModifier(((ModifierArguments)string22).getModifier());
            }
        }
        catch (NumberFormatException numberFormatException) {
            statementRunnerResult.addErrorMessageByKey("ErrImportWrongLimit");
            return statementRunnerResult;
        }
        if (StringUtil.isNonEmpty(string7) && StringUtil.isNonEmpty(string4)) {
            object3.setMultiFileImport(true);
        }
        if (string6 != null) {
            this.imp.setBadfileName(string6);
        }
        if (CollectionUtil.isNonEmpty((Collection)(string22 = this.cmdLine.getList(ARG_CONSTANTS)))) {
            try {
                missingWidthDefinition = new ConstantColumnValues((List<String>)string22, this.currentConnection, string7, (ValueConverter)exception);
                this.imp.setConstantColumnValues((ConstantColumnValues)missingWidthDefinition);
            }
            catch (Exception exception5) {
                LogMgr.logError(callerInfo, "Column constants could no be parsed", exception5);
                statementRunnerResult.addErrorMessage(exception5.getMessage());
                return statementRunnerResult;
            }
        }
        if (!this.imp.setMode(string10)) {
            statementRunnerResult.addMessageByKey("ErrInvalidModeIgnored", string10);
        }
        missingWidthDefinition = this.cmdLine.getValue(ARG_UPDATE_WHERE);
        this.imp.setWhereClauseForUpdate((String)missingWidthDefinition);
        String string12 = this.cmdLine.getValue(ARG_KEYCOLUMNS);
        this.imp.setKeyColumns(string12);
        if (!object3.isMultiFileImport()) {
            DeleteType n22 = CommonArgs.getDeleteType(this.cmdLine);
            this.imp.setDeleteTarget(n22);
        }
        if ((n2 = this.cmdLine.getIntValue(ARG_START_ROW, -1)) > 0) {
            this.imp.setStartRow(n2);
        }
        if ((n = this.cmdLine.getIntValue(ARG_END_ROW, -1)) > 0) {
            this.imp.setEndRow(n);
        }
        this.imp.setRowActionMonitor(this.rowMonitor);
        this.imp.setPerTableStatements(new TableStatements(this.cmdLine));
        try {
            this.imp.startImport();
            if (this.imp.isSuccess()) {
                statementRunnerResult.setSuccess();
            } else {
                statementRunnerResult.setFailure();
            }
            if (this.imp.hasWarnings()) {
                statementRunnerResult.setWarning();
            }
        }
        catch (CycleErrorException | ParsingInterruptedException exception2) {
            statementRunnerResult.setFailure();
        }
        catch (Exception exception6) {
            LogMgr.logError(callerInfo, "Error importing " + (wbFile == null ? string4 : wbFile), exception6);
            statementRunnerResult.setFailure();
            this.addErrorInfo(statementRunnerResult, string, exception6);
        }
        statementRunnerResult.addMessage(this.imp.getMessages());
        if (!statementRunnerResult.isSuccess() && importFileLister != null) {
            this.appendRestartMessage((ImportFileParser)object3, statementRunnerResult);
        }
        return statementRunnerResult;
    }

    private void setBlobModes(ImportFileParser importFileParser) {
        String string = this.cmdLine.getValue("blobType");
        BlobMode blobMode = BlobMode.getMode(string);
        if (string != null && blobMode != null) {
            importFileParser.setDefaultBlobMode(blobMode);
        } else if (this.cmdLine.isArgPresent(ARG_BLOB_ISFILENAME)) {
            boolean bl = this.cmdLine.getBoolean(ARG_BLOB_ISFILENAME, true);
            if (bl) {
                importFileParser.setDefaultBlobMode(BlobMode.SaveToFile);
            } else {
                importFileParser.setDefaultBlobMode(BlobMode.None);
            }
        }
        Map<String, BlobMode> map = CommonArgs.getColumnBlobModes(this.cmdLine);
        importFileParser.setColumnBlobModes(map);
    }

    private void initParser(String string, TabularDataParser tabularDataParser, StatementRunnerResult statementRunnerResult, boolean bl, boolean bl2) {
        boolean bl3 = Settings.getInstance().getBoolProperty("workbench.import.default.header", true);
        boolean bl4 = this.cmdLine.getBoolean(ARG_CONTAINSHEADER, bl3);
        String string2 = this.cmdLine.getValue(ARG_FILECOLUMNS);
        tabularDataParser.setContainsHeader(bl4);
        if (StringUtil.isBlank(string)) {
            return;
        }
        String string3 = this.cmdLine.getValue(ARG_IMPORTCOLUMNS);
        List<ColumnIdentifier> list = null;
        if (StringUtil.isNonBlank(string3)) {
            list = this.stringToCols(string3);
        }
        tabularDataParser.setCheckTargetWithQuery(bl2);
        try {
            tabularDataParser.checkTargetTable();
        }
        catch (Exception exception) {
            statementRunnerResult.addMessage(tabularDataParser.getMessages());
            statementRunnerResult.setFailure();
            return;
        }
        if (bl && StringUtil.isBlank(string2) && CollectionUtil.isEmpty(list)) {
            return;
        }
        try {
            if (StringUtil.isBlank(string2)) {
                tabularDataParser.setupFileColumns(list);
            } else {
                List<ColumnIdentifier> list2 = this.stringToCols(string2);
                tabularDataParser.setColumns(list2, list);
            }
        }
        catch (Exception exception) {
            statementRunnerResult.setFailure();
            statementRunnerResult.addMessage(tabularDataParser.getMessages());
            LogMgr.logError(new CallerInfo(){}, ExceptionUtil.getDisplay(exception), null);
        }
    }

    private void appendRestartMessage(ImportFileParser importFileParser, StatementRunnerResult statementRunnerResult) {
        List<File> list = importFileParser.getProcessedFiles();
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(list.size() * 15);
        stringBuilder.append('-');
        stringBuilder.append(ARG_EXCLUDE_FILES);
        stringBuilder.append('=');
        boolean bl = true;
        for (File file : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(file.getName());
        }
        statementRunnerResult.addMessageNewLine();
        statementRunnerResult.addMessageByKey("ErrImportRestartWith");
        statementRunnerResult.addMessage(stringBuilder);
    }

    private List<ColumnIdentifier> stringToCols(String string) {
        List<String> list = StringUtil.stringToList(string, ",", true, true);
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>(list.size());
        for (String string2 : list) {
            arrayList.add(new ColumnIdentifier(string2));
        }
        return arrayList;
    }

    private ImportFileLister getFileNameLister(ArgumentParser argumentParser, String string) {
        String string2 = argumentParser.getValue(ARG_FILE);
        String string3 = argumentParser.getValue(ARG_DIRECTORY);
        if (StringUtil.isEmptyString(string3) && StringUtil.isEmptyString(string2)) {
            return null;
        }
        ImportFileLister importFileLister = null;
        if (FileUtil.hasWildcard(string2)) {
            WbFile wbFile = this.evaluateFileArgument(string2);
            importFileLister = new ImportFileLister(this.currentConnection, wbFile.getFullPath());
        } else if (string3 != null) {
            String string4 = argumentParser.getValue(ARG_FILE_EXT);
            if (string4 == null) {
                string4 = string;
            }
            WbFile wbFile = this.evaluateFileArgument(string3);
            importFileLister = new ImportFileLister(this.currentConnection, (File)wbFile, string4);
        }
        if (importFileLister != null) {
            importFileLister.setIgnoreSchema(argumentParser.getBoolean(ARG_IGNORE_OWNER, false));
            importFileLister.ignoreFiles(argumentParser.getListValue(ARG_EXCLUDE_FILES));
            importFileLister.setCheckDependencies(argumentParser.getBoolean("checkDependencies", false));
        }
        return importFileLister;
    }

    private void addColumnFilter(String string, ImportFileParser importFileParser) {
        List<String> list = StringUtil.stringToList(string, ",", false);
        if (list.size() < 1) {
            return;
        }
        for (String string2 : list) {
            List<String> list2 = StringUtil.stringToList(string2, "=", true);
            if (list2.size() != 2) continue;
            String string3 = list2.get(0);
            String string4 = list2.get(1);
            importFileParser.addColumnFilter(string3, StringUtil.trimQuotes(string4));
        }
    }

    @Override
    public void done() {
        super.done();
        this.imp = null;
    }

    @Override
    public void cancel() throws SQLException {
        super.cancel();
        if (this.imp != null) {
            this.imp.cancelExecution();
        }
    }

    public static String findTypeFromFilename(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.toLowerCase();
        if (string2.endsWith(".txt")) {
            return "text";
        }
        if (string2.endsWith(".xml")) {
            return "xml";
        }
        if (string2.endsWith(".text")) {
            return "text";
        }
        if (string2.endsWith(".csv")) {
            return "text";
        }
        if (string2.endsWith(".tsv")) {
            return "text";
        }
        if (string2.endsWith(".xls")) {
            return "xls";
        }
        if (string2.endsWith(".xlsx")) {
            return "xlsx";
        }
        if (string2.endsWith(".ods")) {
            return "ods";
        }
        return null;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

