/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.io.File;
import java.sql.SQLException;
import java.util.List;
import workbench.WbManager;
import workbench.console.ConsoleSettings;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.BatchRunner;
import workbench.sql.DelimiterDefinition;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.CommonArgs;
import workbench.sql.wbcommands.ConditionCheck;
import workbench.storage.DataStore;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.FileUtil;
import workbench.util.Replacer;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class WbInclude
extends SqlCommand {
    public static final String VERB = "WbInclude";
    public static final String ORA_INCLUDE = "@";
    public static final String ARG_SEARCH_VALUE = "searchFor";
    public static final String ARG_REPLACE_VALUE = "replaceWith";
    public static final String ARG_REPLACE_USE_REGEX = "useRegex";
    public static final String ARG_REPLACE_IGNORECASE = "ignoreCase";
    public static final String ARG_CHECK_ESCAPED_QUOTES = "checkEscapedQuotes";
    public static final String ARG_PRINT_STATEMENTS = "printStatements";
    public static final String ARG_DELIMITER = "delimiter";
    public static final String ARG_LIMIT_DISPLAY = "useMaxDisplayLimit";
    private BatchRunner batchRunner;

    public WbInclude() {
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("file", ArgumentType.Filename);
        this.cmdLine.addArgument("continueOnError", ArgumentType.BoolArgument);
        this.cmdLine.addArgument("showProgress", ArgumentType.BoolArgument);
        this.cmdLine.addArgument("displayResult", ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_CHECK_ESCAPED_QUOTES, ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_DELIMITER, StringUtil.stringToList("';',oracle,mssql"));
        this.cmdLine.addArgument("verbose", ArgumentType.BoolSwitch);
        ConditionCheck.addParameters(this.cmdLine);
        this.cmdLine.addArgument("ignoreDropErrors", ArgumentType.BoolArgument);
        this.cmdLine.addArgument("useSavepoint", ArgumentType.BoolArgument);
        this.cmdLine.addArgument(ARG_SEARCH_VALUE);
        this.cmdLine.addArgument(ARG_REPLACE_VALUE);
        this.cmdLine.addArgument(ARG_REPLACE_USE_REGEX, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_REPLACE_IGNORECASE, ArgumentType.BoolSwitch);
        this.cmdLine.addArgument(ARG_PRINT_STATEMENTS, ArgumentType.BoolSwitch);
        if (WbManager.getInstance().isConsoleMode()) {
            this.cmdLine.addArgument(ARG_LIMIT_DISPLAY, ArgumentType.BoolArgument);
        }
        this.cmdLine.addArgument("showTiming", ArgumentType.BoolSwitch);
        CommonArgs.addEncodingParameter(this.cmdLine);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public String getAlternateVerb() {
        return ORA_INCLUDE;
    }

    @Override
    protected boolean isConnectionRequired() {
        return false;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        Object object;
        StatementRunnerResult statementRunnerResult = this.createResult(string);
        statementRunnerResult.setSuccess();
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        String string2 = null;
        List<WbFile> list = null;
        String string3 = SqlUtil.makeCleanSql(string, false, false);
        if (string3.length() > 0 && string3.charAt(0) == '@') {
            string2 = string3.substring(1);
            bl = false;
            bl2 = false;
            bl3 = true;
        } else {
            object = this.getCommandLine(string);
            this.cmdLine.parse((String)object);
            if (!this.cmdLine.hasArguments()) {
                string2 = object;
                bl = false;
            } else {
                string2 = this.cmdLine.getValue("file");
            }
        }
        if (!this.checkConditions(statementRunnerResult)) {
            return statementRunnerResult;
        }
        if (StringUtil.isBlank(string2)) {
            object = ResourceMgr.getString("ErrIncludeWrongParameter").replace("%default_encoding%", Settings.getInstance().getDefaultEncoding()).replace("%default_continue%", Boolean.toString(Settings.getInstance().getWbIncludeDefaultContinue()));
            statementRunnerResult.addErrorMessage((String)object);
            return statementRunnerResult;
        }
        if (FileUtil.hasWildcard(string2)) {
            list = this.evaluateWildcardFileArgs(string2);
        } else {
            object = this.evaluateFileArgument(string2);
            if (object != null && StringUtil.isEmptyString(((WbFile)object).getExtension())) {
                object = new WbFile(((WbFile)object).getFullPath() + ".sql");
            }
            if (object != null && ((File)object).exists()) {
                list = CollectionUtil.arrayList(object);
            }
        }
        if (CollectionUtil.isEmpty(list)) {
            statementRunnerResult.addErrorMessageByKey("ErrFileNotFound", string2);
            return statementRunnerResult;
        }
        boolean bl4 = Settings.getInstance().getWbIncludeDefaultContinue();
        boolean bl5 = this.currentConnection == null ? false : this.currentConnection.getProfile().getIgnoreDropErrors();
        boolean bl6 = Settings.getInstance().useNonStandardQuoteEscaping(this.currentConnection);
        boolean bl7 = this.runner.getVerboseLogging();
        boolean bl8 = this.runner.getIgnoreDropErrors();
        boolean bl9 = false;
        boolean bl10 = false;
        DelimiterDefinition delimiterDefinition = null;
        String string4 = null;
        if (bl) {
            bl4 = this.cmdLine.getBoolean("continueOnError", bl4);
            bl6 = this.cmdLine.getBoolean(ARG_CHECK_ESCAPED_QUOTES, bl6);
            bl7 = this.cmdLine.getBoolean("verbose", bl7);
            bl8 = this.cmdLine.getBoolean("ignoreDropErrors", bl5);
            string4 = this.cmdLine.getValue("encoding");
            delimiterDefinition = DelimiterDefinition.parseCmdLineArgument(this.cmdLine.getValue(ARG_DELIMITER));
            this.setUnknownMessage(statementRunnerResult, this.cmdLine, null);
            bl9 = this.cmdLine.getBoolean(ARG_PRINT_STATEMENTS, this.runner.getTraceStatements());
            bl10 = this.cmdLine.getBoolean("showTiming", false);
            bl2 = this.cmdLine.getBoolean("showProgress", true);
        }
        if (string4 == null) {
            string4 = Settings.getInstance().getDefaultEncoding();
        }
        try {
            boolean bl11;
            this.batchRunner = new BatchRunner(list);
            this.batchRunner.setConnection(this.currentConnection);
            this.batchRunner.setDelimiter(delimiterDefinition);
            this.batchRunner.setMessageLogger(this.messageLogger);
            this.batchRunner.setVerboseLogging(bl7);
            if (bl2) {
                this.batchRunner.setRowMonitor(this.rowMonitor);
            }
            this.batchRunner.setShowProgress(bl2);
            this.batchRunner.setAbortOnError(!bl4);
            this.batchRunner.setCheckEscapedQuotes(bl6);
            this.batchRunner.setShowTiming(bl10);
            this.batchRunner.setPrintStatements(bl9);
            this.batchRunner.setEncoding(string4);
            this.batchRunner.setParameterPrompter(this.prompter);
            this.batchRunner.setExecutionController(this.runner.getExecutionController());
            if ((this.cmdLine.isArgNotPresent("continueOnError") || !bl4) && GuiSettings.enableErrorPromptForWbInclude()) {
                this.batchRunner.setRetryHandler(this.runner.getRetryHandler());
            }
            this.batchRunner.setIgnoreDropErrors(bl8);
            boolean bl12 = this.cmdLine.getBoolean("displayResult", bl3);
            this.batchRunner.showResultSets(bl12);
            if (bl12 && WbManager.getInstance().isConsoleMode() && (bl11 = this.cmdLine.getBoolean(ARG_LIMIT_DISPLAY, true))) {
                this.batchRunner.setMaxColumnDisplayLength(ConsoleSettings.getMaxColumnDataWidth());
            }
            this.batchRunner.setOptimizeColWidths(bl12);
            if (this.cmdLine.isArgPresent("useSavepoint")) {
                this.batchRunner.setUseSavepoint(this.cmdLine.getBoolean("useSavepoint"));
            }
            this.batchRunner.setReplacer(this.getReplacer());
            if (bl12) {
                if (WbManager.getInstance().isGUIMode()) {
                    this.batchRunner.setConsole(null);
                } else {
                    this.batchRunner.setShowProgress(false);
                }
            }
            this.batchRunner.execute();
            if (this.batchRunner.isSuccess()) {
                statementRunnerResult.setSuccess();
            } else if (this.batchRunner.wasCancelled()) {
                statementRunnerResult.addWarningByKey("MsgScriptCancelled");
                statementRunnerResult.setStopScript(true);
            } else {
                statementRunnerResult.setFailure(this.batchRunner.getLastError());
            }
            List<DataStore> list2 = this.batchRunner.getQueryResults();
            for (DataStore dataStore : list2) {
                statementRunnerResult.addDataStore(dataStore);
            }
            if (this.rowMonitor != null) {
                this.rowMonitor.jobFinished();
            }
        }
        catch (Exception exception) {
            statementRunnerResult.addErrorMessage(ExceptionUtil.getDisplay(exception));
        }
        return statementRunnerResult;
    }

    private Replacer getReplacer() {
        String string = this.cmdLine.getValue(ARG_SEARCH_VALUE);
        if (StringUtil.isBlank(string)) {
            return null;
        }
        if (!this.cmdLine.isArgPresent(ARG_REPLACE_VALUE)) {
            return null;
        }
        boolean bl = this.cmdLine.getBoolean(ARG_REPLACE_USE_REGEX, false);
        boolean bl2 = this.cmdLine.getBoolean(ARG_REPLACE_IGNORECASE, true);
        String string2 = this.cmdLine.getValue(ARG_REPLACE_VALUE);
        return new Replacer(string, string2, bl2, bl);
    }

    @Override
    public void done() {
        if (this.batchRunner != null) {
            this.batchRunner.done();
            this.batchRunner = null;
        }
    }

    @Override
    public void cancel() throws SQLException {
        super.cancel();
        if (this.batchRunner != null) {
            this.batchRunner.cancel();
        }
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

