/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import workbench.db.DbObject;
import workbench.db.DbObjectFinder;
import workbench.db.TableIdentifier;
import workbench.db.dependency.DependencyReader;
import workbench.db.dependency.DependencyReaderFactory;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.storage.DataStore;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.CollectionUtil;

public class WbListDependencies
extends SqlCommand {
    public static final String VERB = "WbListDependencies";
    public static final String VERB_SHORT = "WbListDeps";
    public static final String ARG_OBJECT_NAME = "name";
    public static final String ARG_OBJECT_TYPE = "objectType";
    public static final String ARG_DEPENDENCE_TYPE = "dependency";
    private static final String TYPE_USES = "uses";
    private static final String TYPE_USED_BY = "using";

    public WbListDependencies() {
        this.isUpdatingCommand = false;
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("schema", ArgumentType.SchemaArgument);
        this.cmdLine.addArgument("catalog", ArgumentType.CatalogArgument);
        this.cmdLine.addArgument(ARG_OBJECT_NAME, ArgumentType.TableArgument);
        this.cmdLine.addArgument(ARG_DEPENDENCE_TYPE, CollectionUtil.arrayList(TYPE_USES, TYPE_USED_BY));
        this.cmdLine.addArgument(ARG_OBJECT_TYPE, ArgumentType.ObjectTypeArgument);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public String getAlternateVerb() {
        return VERB_SHORT;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        String string2 = this.getCommandLine(string);
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        DependencyReader dependencyReader = DependencyReaderFactory.getReader(this.currentConnection);
        if (dependencyReader == null) {
            statementRunnerResult.addErrorMessage("Not supported");
            return statementRunnerResult;
        }
        this.cmdLine.parse(string2);
        if (this.displayHelp(statementRunnerResult)) {
            return statementRunnerResult;
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        TableIdentifier tableIdentifier = null;
        Set<String> set = CollectionUtil.caseInsensitiveSet(TYPE_USES);
        if (this.cmdLine.hasArguments()) {
            string3 = this.cmdLine.getValue("schema");
            string4 = this.cmdLine.getValue("catalog");
            string5 = this.cmdLine.getValue(ARG_OBJECT_NAME);
            string6 = this.cmdLine.getValue(ARG_OBJECT_TYPE);
            set.addAll(this.cmdLine.getListValue(ARG_DEPENDENCE_TYPE));
            tableIdentifier = new TableIdentifier(string4, string3, string5);
        } else {
            tableIdentifier = new TableIdentifier(string2);
        }
        DbObject dbObject = null;
        if ("procedure".equalsIgnoreCase(string6)) {
            dbObject = this.currentConnection.getMetadata().getProcedureReader().findProcedureByName(tableIdentifier);
        } else {
            Object object = null;
            if (string6 != null) {
                object = new String[]{string6};
            }
            dbObject = new DbObjectFinder(this.currentConnection).searchObjectOnPath(tableIdentifier, (String[])object);
        }
        if (dbObject == null) {
            statementRunnerResult.addErrorMessageByKey("ErrTableOrViewNotFound", tableIdentifier.getObjectExpression(this.currentConnection));
            return statementRunnerResult;
        }
        if (set.contains("*")) {
            set = CollectionUtil.caseInsensitiveSet(TYPE_USES, TYPE_USED_BY);
        }
        for (String string7 : set) {
            String string8 = null;
            List<DbObject> list = null;
            if (string7.equalsIgnoreCase(TYPE_USED_BY)) {
                list = dependencyReader.getUsedBy(this.currentConnection, dbObject);
                string8 = "TxtDepsUsedByParm";
            } else if (string7.equalsIgnoreCase(TYPE_USES)) {
                list = dependencyReader.getUsedObjects(this.currentConnection, dbObject);
                string8 = "TxtDepsUsesParm";
            }
            if (!CollectionUtil.isNonEmpty(list)) continue;
            DataStore dataStore = this.currentConnection.getMetadata().createTableListDataStore();
            dataStore.setResultName(ResourceMgr.getFormattedString(string8, dbObject.getObjectExpression(this.currentConnection)));
            for (DbObject dbObject2 : list) {
                int n = dataStore.addRow();
                dataStore.setValue(n, 2, (Object)dbObject2.getCatalog());
                dataStore.setValue(n, 3, (Object)dbObject2.getSchema());
                dataStore.setValue(n, 0, (Object)dbObject2.getObjectName());
                dataStore.setValue(n, 1, (Object)dbObject2.getObjectType());
                dataStore.setValue(n, 4, (Object)dbObject2.getComment());
            }
            dataStore.resetStatus();
            statementRunnerResult.addDataStore(dataStore);
        }
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

