/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import workbench.console.ConsoleSettings;
import workbench.console.RowDisplay;
import workbench.db.TriggerReader;
import workbench.db.TriggerReaderFactory;
import workbench.resource.ResourceMgr;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.storage.DataStore;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;

public class WbListTriggers
extends SqlCommand {
    public static final String VERB = "WbListTriggers";

    public WbListTriggers() {
        this.isUpdatingCommand = false;
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument("schema", ArgumentType.SchemaArgument);
        this.cmdLine.addArgument("catalog", ArgumentType.CatalogArgument);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        String string2 = this.getCommandLine(string);
        this.cmdLine.parse(string2);
        if (this.displayHelp(statementRunnerResult)) {
            return statementRunnerResult;
        }
        ConsoleSettings.getInstance().setNextRowDisplay(RowDisplay.SingleLine);
        TriggerReader triggerReader = TriggerReaderFactory.createReader(this.currentConnection);
        String string3 = this.cmdLine.getValue("schema", this.currentConnection.getCurrentSchema());
        String string4 = this.cmdLine.getValue("catalog", this.currentConnection.getMetadata().getCurrentCatalog());
        DataStore dataStore = triggerReader.getTriggers(string4, string3);
        dataStore.setResultName(ResourceMgr.getString("TxtDbExplorerTriggers"));
        dataStore.setGeneratingSql("WbListTriggers " + string2);
        statementRunnerResult.addDataStore(dataStore);
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

