/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.sql.SQLException;
import workbench.db.ConnectionProfile;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.util.ArgumentParser;

public class WbMode
extends SqlCommand {
    public static final String VERB = "WbMode";

    public WbMode() {
        this.isUpdatingCommand = false;
        this.cmdLine = new ArgumentParser(false);
        this.cmdLine.addArgument("status");
        this.cmdLine.addArgument("readonly");
        this.cmdLine.addArgument("normal");
        this.cmdLine.addArgument("reset");
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    protected boolean isConnectionRequired() {
        return true;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        ConnectionProfile connectionProfile;
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        statementRunnerResult.setSuccess();
        ConnectionProfile connectionProfile2 = connectionProfile = this.currentConnection != null ? this.currentConnection.getProfile() : null;
        if (connectionProfile == null) {
            statementRunnerResult.setFailure();
            statementRunnerResult.addMessageByKey("TxtNotConnected");
            return statementRunnerResult;
        }
        String string2 = null;
        try {
            SQLLexer sQLLexer = SQLLexerFactory.createLexer(this.currentConnection, string);
            SQLToken sQLToken = sQLLexer.getNextToken(false, false);
            sQLToken = sQLLexer.getNextToken(false, false);
            if (sQLToken != null) {
                string2 = sQLToken.getContents();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string2 == null) {
            statementRunnerResult.addMessageByKey("ErrModeWrongArgs");
            statementRunnerResult.setFailure();
            return statementRunnerResult;
        }
        if (string2.equalsIgnoreCase("reset")) {
            this.currentConnection.resetSessionFlags();
        } else if (string2.equalsIgnoreCase("status")) {
            statementRunnerResult.setSuccess();
        } else if (string2.equalsIgnoreCase("normal")) {
            this.currentConnection.setSessionConfirmUpdate(false);
            this.currentConnection.setSessionReadOnly(false);
        } else if (string2.equalsIgnoreCase("readonly")) {
            this.currentConnection.setSessionReadOnly(true);
        } else if (string2.equalsIgnoreCase("confirm")) {
            this.currentConnection.setSessionConfirmUpdate(true);
        } else {
            statementRunnerResult.setFailure();
        }
        if (statementRunnerResult.isSuccess()) {
            statementRunnerResult.addMessageByKey("MsgModeSession", this.currentConnection.isSessionReadOnly(), this.currentConnection.confirmUpdatesInSession());
        } else {
            statementRunnerResult.addMessageByKey("ErrModeWrongArgs");
        }
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

