/*
 * Decompiled with CFR 0.152.
 */
package workbench.sql.wbcommands;

import java.io.IOException;
import java.sql.SQLException;
import workbench.db.ProcedureDefinition;
import workbench.db.ProcedureReader;
import workbench.db.TableIdentifier;
import workbench.sql.SqlCommand;
import workbench.sql.StatementRunnerResult;
import workbench.sql.wbcommands.CommonArgs;
import workbench.util.ArgumentParser;
import workbench.util.ArgumentType;
import workbench.util.EncodingUtil;
import workbench.util.FileUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class WbProcSource
extends SqlCommand {
    public static final String VERB = "WbProcSource";
    public static final String ARG_PROCNAME = "procedure";

    public WbProcSource() {
        this.isUpdatingCommand = false;
        this.cmdLine = new ArgumentParser();
        this.cmdLine.addArgument(ARG_PROCNAME);
        this.cmdLine.addArgument("file", ArgumentType.Filename);
        CommonArgs.addEncodingParameter(this.cmdLine);
    }

    @Override
    public String getVerb() {
        return VERB;
    }

    @Override
    public StatementRunnerResult execute(String string) throws SQLException {
        StatementRunnerResult statementRunnerResult = new StatementRunnerResult();
        String string2 = this.getCommandLine(string);
        this.cmdLine.parse(string2);
        String string3 = null;
        WbFile wbFile = null;
        String string4 = null;
        if (this.displayHelp(statementRunnerResult)) {
            return statementRunnerResult;
        }
        if (this.cmdLine.hasArguments()) {
            string3 = this.cmdLine.getValue(ARG_PROCNAME);
            wbFile = this.evaluateFileArgument(this.cmdLine.getValue("file"));
            string4 = this.cmdLine.getValue("encoding", EncodingUtil.getDefaultEncoding());
        } else {
            string3 = string2;
        }
        TableIdentifier tableIdentifier = new TableIdentifier(string3, this.currentConnection);
        tableIdentifier.adjustCase(this.currentConnection);
        tableIdentifier.adjustCatalogAndSchema(this.currentConnection);
        ProcedureReader procedureReader = this.currentConnection.getMetadata().getProcedureReader();
        ProcedureDefinition procedureDefinition = procedureReader.findProcedureByName(tableIdentifier);
        if (procedureDefinition != null) {
            CharSequence charSequence = procedureDefinition.getSource(this.currentConnection);
            if (wbFile != null && charSequence != null) {
                try {
                    FileUtil.writeString(wbFile, charSequence.toString(), string4, false);
                    statementRunnerResult.addMessageByKey("MsgScriptWritten", wbFile.getFullPath());
                    statementRunnerResult.setSuccess();
                }
                catch (IOException iOException) {
                    statementRunnerResult.addErrorMessage(iOException.getLocalizedMessage());
                }
            } else {
                if (procedureDefinition.isPackageProcedure()) {
                    CharSequence charSequence2 = procedureReader.getPackageProcedureSource(procedureDefinition);
                    if (charSequence2 != null) {
                        String string5 = "Package: " + procedureDefinition.getPackageName();
                        statementRunnerResult.addMessage(string5);
                        statementRunnerResult.addMessage(StringUtil.padRight("-", string5.length(), '-') + "\n");
                        statementRunnerResult.addMessage(charSequence2);
                        statementRunnerResult.addMessageNewLine();
                    } else {
                        statementRunnerResult.addMessage(charSequence);
                    }
                } else {
                    statementRunnerResult.addMessage(charSequence);
                }
                statementRunnerResult.setSuccess();
            }
        } else {
            String string6 = this.currentConnection.getMetadata().adjustObjectnameCase(this.currentConnection.getCurrentUser());
            CharSequence charSequence = procedureReader.getPackageSource(null, string6, tableIdentifier.getObjectName());
            if (charSequence != null) {
                statementRunnerResult.addMessage(charSequence);
                statementRunnerResult.addMessageNewLine();
                return statementRunnerResult;
            }
            statementRunnerResult.addMessageByKey("ErrProcNotFound", string2);
            statementRunnerResult.setFailure();
        }
        return statementRunnerResult;
    }

    @Override
    public boolean isWbCommand() {
        return true;
    }
}

