/*
 * Decompiled with CFR 0.152.
 */
package workbench.ssh;

import com.jcraft.jsch.Logger;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class JschLogger
implements Logger {
    @Override
    public boolean isEnabled(int n) {
        switch (n) {
            case 0: {
                return LogMgr.isDebugEnabled();
            }
            case 1: {
                return LogMgr.isInfoEnabled();
            }
        }
        return true;
    }

    @Override
    public void log(int n, String string) {
        CallerInfo callerInfo;
        if (LogMgr.isDebugEnabled()) {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            StackTraceElement stackTraceElement = stackTraceElementArray[2];
            String string2 = "JSch" + this.getSimpleClassName(stackTraceElement) + "." + stackTraceElement.getMethodName() + "()";
            callerInfo = new CallerInfo(string2){};
        } else {
            callerInfo = new CallerInfo(){};
        }
        switch (n) {
            case 0: {
                LogMgr.logDebug(callerInfo, string);
                break;
            }
            case 1: {
                LogMgr.logInfo(callerInfo, string);
                break;
            }
            case 2: {
                LogMgr.logWarning(callerInfo, string, null);
                break;
            }
            default: {
                LogMgr.logError(callerInfo, string, null);
            }
        }
    }

    private String getSimpleClassName(StackTraceElement stackTraceElement) {
        if (stackTraceElement == null) {
            return "";
        }
        String string = stackTraceElement.getClassName();
        int n = string.lastIndexOf(46);
        return string.substring(n);
    }
}

