/*
 * Decompiled with CFR 0.152.
 */
package workbench.ssh;

import java.io.Serializable;
import java.util.Objects;
import workbench.db.ConnectionMgr;
import workbench.ssh.SshConfigMgr;
import workbench.ssh.SshHostConfig;
import workbench.util.StringUtil;

public class SshConfig
implements Serializable {
    private boolean changed;
    private SshHostConfig hostConfig;
    private int localPort;
    private int dbPort;
    private String dbHostname;
    private String sshHostConfigName;

    public String getSshHostConfigName() {
        return this.sshHostConfigName;
    }

    public void setSshHostConfigName(String string) {
        this.changed = StringUtil.stringsAreNotEqual(this.sshHostConfigName, string);
        this.sshHostConfigName = StringUtil.trimToNull(string);
        this.hostConfig = null;
    }

    public SshHostConfig getSshHostConfig() {
        SshHostConfig sshHostConfig;
        if (this.sshHostConfigName != null && (sshHostConfig = SshConfigMgr.getDefaultInstance().getHostConfig(this.sshHostConfigName)) != null) {
            return sshHostConfig;
        }
        return this.hostConfig;
    }

    public SshHostConfig getHostConfig() {
        return this.hostConfig;
    }

    public void setHostConfig(SshHostConfig sshHostConfig) {
        if (sshHostConfig == null) {
            return;
        }
        if (sshHostConfig.getConfigName() != null) {
            this.setSshHostConfigName(sshHostConfig.getConfigName());
        } else {
            this.changed = this.hostConfig == null || !sshHostConfig.equals(this.hostConfig);
            this.hostConfig = sshHostConfig.createCopy();
            this.sshHostConfigName = null;
        }
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int n) {
        this.changed = this.changed || n != this.localPort;
        this.localPort = n < 0 ? 0 : n;
    }

    public int getDbPort() {
        return this.dbPort;
    }

    public void setDbPort(int n) {
        if (n > 0 && n != this.dbPort) {
            this.changed = true;
            this.dbPort = n;
        }
    }

    public String getDbHostname() {
        return this.dbHostname;
    }

    public void setDbHostname(String string) {
        if (!StringUtil.equalStringOrEmpty(this.dbHostname, string)) {
            this.changed = true;
            this.dbHostname = string;
        }
    }

    public boolean isValid() {
        return this.hostConfig != null && this.hostConfig.isValid();
    }

    public void resetChanged() {
        this.changed = false;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void copyFrom(SshConfig sshConfig) {
        if (sshConfig == this) {
            return;
        }
        if (sshConfig.getSshHostConfigName() != null) {
            this.setSshHostConfigName(sshConfig.getSshHostConfigName());
        } else {
            this.setHostConfig(sshConfig.getHostConfig());
        }
        this.setLocalPort(sshConfig.getLocalPort());
        this.setDbHostname(sshConfig.getDbHostname());
        this.setDbPort(sshConfig.getDbPort());
    }

    public SshConfig createCopy() {
        SshConfig sshConfig = new SshConfig();
        sshConfig.localPort = this.localPort;
        sshConfig.changed = this.changed;
        sshConfig.dbPort = this.dbPort;
        sshConfig.dbHostname = this.dbHostname;
        sshConfig.sshHostConfigName = this.sshHostConfigName;
        if (this.sshHostConfigName == null && this.hostConfig != null) {
            sshConfig.hostConfig = this.hostConfig.createCopy();
        }
        return sshConfig;
    }

    public int hashCode() {
        int n = 7;
        n = 19 * n + Objects.hashCode(this.hostConfig);
        n = 19 * n + this.dbPort;
        n = 19 * n + Objects.hashCode(this.dbHostname);
        if (this.localPort > 0) {
            n = 19 * n + this.localPort;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SshConfig sshConfig = (SshConfig)object;
        if (this.dbPort != sshConfig.dbPort) {
            return false;
        }
        if ((this.localPort > 0 || sshConfig.localPort > 0) && this.localPort != sshConfig.localPort) {
            return false;
        }
        if (!StringUtil.equalStringIgnoreCase(this.dbHostname, sshConfig.dbHostname)) {
            return false;
        }
        return Objects.equals(this.hostConfig, sshConfig.hostConfig);
    }

    public String getInfoString() {
        int n = ConnectionMgr.getInstance().getSshManager().getLocalPort(this);
        String string = "";
        if (n > 0) {
            string = string + "localhost:" + n + " > ";
        }
        string = string + this.getSshHostConfig().getInfoString();
        string = string + " > " + this.dbHostname;
        if (this.dbPort > 0) {
            string = string + ":" + this.dbPort;
        }
        return string;
    }

    public void setHostname(String string) {
        if (this.hostConfig == null) {
            this.changed = true;
            this.hostConfig = new SshHostConfig();
        }
        this.hostConfig.setHostname(string);
    }

    public void setUsername(String string) {
        if (this.hostConfig == null) {
            this.changed = true;
            this.hostConfig = new SshHostConfig();
        }
        this.hostConfig.setUsername(string);
    }

    public void setPrivateKeyFile(String string) {
        if (this.hostConfig == null) {
            this.changed = true;
            this.hostConfig = new SshHostConfig();
        }
        this.hostConfig.setPrivateKeyFile(string);
    }

    public void setSshPort(int n) {
        if (this.hostConfig == null) {
            this.changed = true;
            this.hostConfig = new SshHostConfig();
        }
        this.hostConfig.setSshPort(n);
    }

    public void setTryAgent(boolean bl) {
        if (this.hostConfig == null) {
            this.changed = true;
            this.hostConfig = new SshHostConfig();
        }
        this.hostConfig.setTryAgent(bl);
    }

    public void setPassword(String string) {
        if (this.hostConfig == null) {
            this.changed = true;
            this.hostConfig = new SshHostConfig();
        }
        this.hostConfig.setPassword(string);
    }
}

