/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import workbench.db.DependencyNode;
import workbench.db.JdbcUtils;
import workbench.db.PkDefinition;
import workbench.db.QuoteHandler;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.TableSelectBuilder;
import workbench.db.WbConnection;
import workbench.db.search.ServerSideTableSearcher;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;
import workbench.util.CollectionUtil;

public class LookupDataLoader {
    private TableDefinition lookupTable;
    private boolean retrieved;
    private TableIdentifier baseTable;
    private String referencingColumn;
    private Map<String, String> columnMap;

    public LookupDataLoader(TableIdentifier tableIdentifier, String string) {
        this.referencingColumn = string;
        this.baseTable = tableIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataStore getLookupData(WbConnection wbConnection, int n, String string, boolean bl) throws SQLException {
        Object object;
        if (this.lookupTable == null && !this.retrieved) {
            this.retrieveReferencedTable(wbConnection);
        }
        if (this.lookupTable == null) {
            return null;
        }
        String string2 = null;
        if (string == null) {
            object = new TableSelectBuilder(wbConnection, "lookupretrieval");
            ((TableSelectBuilder)object).setSortPksFirst(true);
            ((TableSelectBuilder)object).setIncludeBLOBColumns(false);
            ((TableSelectBuilder)object).setIncludeCLOBColumns(false);
            string2 = ((TableSelectBuilder)object).getSelectForColumns(this.lookupTable.getTable(), this.lookupTable.getColumns(), n);
        } else {
            object = new ServerSideTableSearcher();
            ((ServerSideTableSearcher)object).setColumnFunction(wbConnection.getDbSettings().getLowerFunctionTemplate());
            ((ServerSideTableSearcher)object).setCriteria(string, true);
            ((ServerSideTableSearcher)object).setConnection(wbConnection);
            string2 = ((ServerSideTableSearcher)object).buildSqlForTable(this.lookupTable, "lookupretrieval");
        }
        if (bl) {
            string2 = string2 + this.getOrderBy(wbConnection, this.lookupTable.getTable().getPrimaryKey());
        }
        object = null;
        ResultSet resultSet = null;
        DataStore dataStore = null;
        LogMgr.logDebug(new CallerInfo(){}, "Using sql: " + string2);
        try {
            object = wbConnection.createStatementForQuery();
            resultSet = object.executeQuery(string2);
            dataStore = new DataStore(resultSet, true, n);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeAll(resultSet, (Statement)object);
            throw throwable;
        }
        JdbcUtils.closeAll(resultSet, (Statement)object);
        return dataStore;
    }

    private String getOrderBy(WbConnection wbConnection, PkDefinition pkDefinition) {
        if (pkDefinition == null || CollectionUtil.isEmpty(pkDefinition.getColumns())) {
            return "";
        }
        QuoteHandler quoteHandler = wbConnection == null ? QuoteHandler.STANDARD_HANDLER : wbConnection.getMetadata();
        StringBuilder stringBuilder = new StringBuilder(50);
        stringBuilder.append(" ORDER BY ");
        int n = 0;
        for (String string : pkDefinition.getColumns()) {
            if (n > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(quoteHandler.quoteObjectname(string));
            ++n;
        }
        return stringBuilder.toString();
    }

    public Map<String, String> getForeignkeyMap() {
        return Collections.unmodifiableMap(this.columnMap);
    }

    public List<String> getReferencingColumns() {
        return new ArrayList<String>(this.columnMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveReferencedTable(WbConnection wbConnection) throws SQLException {
        try {
            this.lookupTable = null;
            TableIdentifier tableIdentifier = null;
            List<DependencyNode> list = wbConnection.getObjectCache().getReferencedTables(this.baseTable);
            for (DependencyNode dependencyNode : list) {
                Map<String, String> map = dependencyNode.getColumns();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (!entry.getValue().equalsIgnoreCase(this.referencingColumn)) continue;
                    tableIdentifier = dependencyNode.getTable();
                    this.columnMap = dependencyNode.getColumns();
                }
            }
            wbConnection.setBusy(true);
            this.lookupTable = wbConnection.getMetadata().getTableDefinition(tableIdentifier);
        }
        finally {
            wbConnection.setBusy(false);
            this.retrieved = true;
        }
    }

    public TableIdentifier getLookupTable() {
        if (this.lookupTable == null) {
            return null;
        }
        return this.lookupTable.getTable();
    }

    public PkDefinition getPK() {
        if (this.lookupTable == null) {
            return null;
        }
        return this.lookupTable.getTable().getPrimaryKey();
    }
}

