/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import workbench.db.ColumnIdentifier;
import workbench.db.DataTypeResolver;
import workbench.db.DbMetadata;
import workbench.db.DbObjectFinder;
import workbench.db.IndexReader;
import workbench.db.PkDefinition;
import workbench.db.QuoteHandler;
import workbench.db.ReaderFactory;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.GuiSettings;
import workbench.storage.PkMapping;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class ResultInfo {
    private List<ColumnIdentifier> columns;
    private int realColumns;
    private TableIdentifier updateTable;
    private boolean isUserDefinedPK;
    private boolean useGetStringForBit;
    private boolean columnTablesDetected;

    public ResultInfo(ColumnIdentifier[] columnIdentifierArray) {
        this.columns = new ArrayList<ColumnIdentifier>(columnIdentifierArray.length);
        for (ColumnIdentifier columnIdentifier : columnIdentifierArray) {
            this.columns.add(columnIdentifier.createCopy());
        }
    }

    public ResultInfo(List<ColumnIdentifier> list) {
        this.columns = new ArrayList<ColumnIdentifier>(list.size());
        for (ColumnIdentifier columnIdentifier : list) {
            this.columns.add(columnIdentifier.createCopy());
        }
    }

    public ResultInfo(String[] stringArray, int[] nArray, int[] nArray2) {
        this.columns = new ArrayList<ColumnIdentifier>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            ColumnIdentifier columnIdentifier = new ColumnIdentifier(stringArray[i]);
            if (nArray2 != null) {
                columnIdentifier.setColumnSize(nArray2[i]);
            }
            columnIdentifier.setDataType(nArray[i]);
            this.columns.add(columnIdentifier);
        }
    }

    public ResultInfo(TableIdentifier tableIdentifier, WbConnection wbConnection) throws SQLException {
        Object object;
        DbMetadata dbMetadata = wbConnection.getMetadata();
        TableIdentifier tableIdentifier2 = new DbObjectFinder(wbConnection).findObject(tableIdentifier);
        if (tableIdentifier2 == null) {
            tableIdentifier2 = tableIdentifier.createCopy();
            if (tableIdentifier2.getType() == null) {
                object = dbMetadata.getObjectType(tableIdentifier2);
                tableIdentifier2.setType((String)object);
            }
            if (tableIdentifier2.getSchema() == null) {
                tableIdentifier2.setSchema(dbMetadata.getCurrentSchema());
            }
            if (tableIdentifier2.getCatalog() == null) {
                tableIdentifier2.setCatalog(dbMetadata.getCurrentCatalog());
            }
        }
        this.updateTable = tableIdentifier2;
        object = dbMetadata.getTableColumns(tableIdentifier2);
        this.columns = new ArrayList<ColumnIdentifier>((Collection<ColumnIdentifier>)object);
        this.initDbConfig(wbConnection);
    }

    private void initDbConfig(WbConnection wbConnection) {
        if (wbConnection != null) {
            this.useGetStringForBit = wbConnection.getDbSettings().useGetStringForBit();
        }
    }

    /*
     * WARNING - void declaration
     */
    public ResultInfo(ResultSetMetaData resultSetMetaData, WbConnection wbConnection) throws SQLException {
        int n = resultSetMetaData.getColumnCount();
        this.columns = new ArrayList<ColumnIdentifier>(n);
        CallerInfo callerInfo = new CallerInfo(){};
        this.initDbConfig(wbConnection);
        DbMetadata dbMetadata = null;
        DataTypeResolver dataTypeResolver = null;
        if (wbConnection != null) {
            dbMetadata = wbConnection.getMetadata();
            dataTypeResolver = dbMetadata.getDataTypeResolver();
        }
        boolean bl = wbConnection == null ? false : wbConnection.getDbSettings().getCheckResultSetReadOnlyCols();
        boolean bl2 = wbConnection == null ? false : wbConnection.getDbSettings().reportsRealSizeAsDisplaySize();
        boolean bl3 = wbConnection == null ? false : wbConnection.getDbSettings().supportsResultMetaGetTable();
        boolean bl4 = GuiSettings.showTableNameInColumnHeader();
        int n2 = 0;
        if (n2 < n) {
            void string4;
            void var15_26;
            String string = null;
            String string2 = null;
            try {
                string = resultSetMetaData.getColumnName(n2 + 1);
                string2 = resultSetMetaData.getColumnLabel(n2 + 1);
            }
            catch (Throwable throwable) {
                LogMgr.logWarning(callerInfo, "Could not obtain column name or alias", throwable);
            }
            if (StringUtil.isNonBlank(string)) {
                ++this.realColumns;
            } else {
                string = "Col" + (n2 + 1);
            }
            ColumnIdentifier columnIdentifier = new ColumnIdentifier(string);
            columnIdentifier.setPosition(n2 + 1);
            if (StringUtil.stringsAreNotEqual(string, string2)) {
                columnIdentifier.setColumnAlias(string2);
            }
            try {
                int bl5 = resultSetMetaData.isNullable(n2 + 1);
                columnIdentifier.setIsNullable(bl5 != 0);
            }
            catch (Throwable throwable) {
                LogMgr.logWarning(callerInfo, "Error when checking nullable for column : " + string, throwable);
            }
            if (bl) {
                try {
                    boolean throwable = resultSetMetaData.isReadOnly(n2 + 1);
                    columnIdentifier.setReadonly(throwable);
                }
                catch (Throwable string3) {
                    LogMgr.logWarning(callerInfo, "Error when checking readonly attribute for column : " + string, string3);
                    bl = false;
                }
            }
            if (bl3 || bl4) {
                try {
                    String throwable = resultSetMetaData.getTableName(n2 + 1);
                    columnIdentifier.setSourceTableName(throwable);
                }
                catch (Throwable throwable) {
                    if (wbConnection != null && bl3) {
                        LogMgr.logWarning(callerInfo, "Disabling usage of ResultSetMetaData.getTableName() for DBID: " + wbConnection.getDbId(), throwable);
                        wbConnection.getDbSettings().setSupportsResultMetaGetTable(false);
                    }
                    bl3 = false;
                    bl4 = false;
                }
            }
            Object var15_23 = null;
            try {
                String string3 = resultSetMetaData.getColumnTypeName(n2 + 1);
            }
            catch (Exception exception) {
                Object var15_25 = null;
            }
            int n3 = resultSetMetaData.getColumnType(n2 + 1);
            if (StringUtil.isEmptyString((CharSequence)var15_26)) {
                String string5 = SqlUtil.getTypeName(n3);
            }
            if (dataTypeResolver != null) {
                n3 = dataTypeResolver.fixColumnType(n3, (String)string4);
            }
            columnIdentifier.setDataType(n3);
            columnIdentifier.setColumnTypeName((String)string4);
            int n4 = 0;
            int n5 = 0;
            try {
                if (SqlUtil.isNumberType(n3)) {
                    n4 = resultSetMetaData.getScale(n2 + 1);
                }
            }
            catch (Throwable throwable) {
                n4 = -1;
            }
            try {
                n5 = resultSetMetaData.getPrecision(n2 + 1);
            }
            finally {
                int n6 = 0;
            }
        }
    }

    public boolean columnTablesAvailable() {
        for (ColumnIdentifier columnIdentifier : this.columns) {
            if (!StringUtil.isBlank(columnIdentifier.getSourceTableName())) continue;
            return false;
        }
        return true;
    }

    public boolean isColumnTableDetected() {
        return this.columnTablesDetected;
    }

    public void setColumnTableDetected(boolean bl) {
        this.columnTablesDetected = bl;
    }

    public ColumnIdentifier getColumn(int n) {
        return this.columns.get(n);
    }

    public ColumnIdentifier[] getColumns() {
        return this.columns.toArray(new ColumnIdentifier[0]);
    }

    public List<ColumnIdentifier> getColumnList() {
        if (this.columns == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.columns);
    }

    public boolean isNullable(int n) {
        return this.columns.get(n).isNullable();
    }

    public void resetPkColumns() {
        this.isUserDefinedPK = false;
        for (ColumnIdentifier columnIdentifier : this.columns) {
            columnIdentifier.setIsPkColumn(false);
        }
    }

    public void setIsPkColumn(String string, boolean bl) {
        int n = this.findColumn(string);
        if (n > -1) {
            this.setIsPkColumn(n, bl);
        }
    }

    public void setIsPkColumn(int n, boolean bl) {
        this.columns.get(n).setIsPkColumn(bl);
    }

    public boolean hasUpdateableColumns() {
        return this.realColumns > 0;
    }

    public boolean isUpdateable(int n) {
        return this.columns.get(n).isUpdateable();
    }

    public void setIsNullable(int n, boolean bl) {
        this.columns.get(n).setIsNullable(bl);
    }

    public void setUpdateable(int n, boolean bl) {
        this.columns.get(n).setUpdateable(bl);
    }

    public boolean isPkColumn(int n) {
        return this.columns.get(n).isPkColumn();
    }

    public void setPKColumns(ColumnIdentifier[] columnIdentifierArray) {
        for (ColumnIdentifier columnIdentifier : columnIdentifierArray) {
            String string = columnIdentifier.getColumnName();
            int n = this.findColumn(string);
            if (n <= -1) continue;
            boolean bl = columnIdentifier.isPkColumn();
            this.columns.get(n).setIsPkColumn(bl);
        }
    }

    public void setPKColumns(List<ColumnIdentifier> list) {
        for (ColumnIdentifier columnIdentifier : this.columns) {
            columnIdentifier.setIsPkColumn(false);
        }
        for (ColumnIdentifier columnIdentifier : list) {
            String string = columnIdentifier.getColumnName();
            int n = this.findColumn(string);
            if (n <= -1) continue;
            this.columns.get(n).setIsPkColumn(true);
        }
    }

    public boolean hasPkColumns() {
        for (ColumnIdentifier columnIdentifier : this.columns) {
            if (!columnIdentifier.isPkColumn()) continue;
            return true;
        }
        return false;
    }

    public void setUpdateTable(TableIdentifier tableIdentifier) {
        this.updateTable = tableIdentifier;
    }

    public TableIdentifier getUpdateTable() {
        return this.updateTable;
    }

    public int getColumnSize(int n) {
        return this.columns.get(n).getColumnSize();
    }

    public void setColumnSizes(int[] nArray) {
        if (nArray == null) {
            return;
        }
        if (nArray.length != this.columns.size()) {
            return;
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            this.columns.get(i).setColumnSize(nArray[i]);
        }
    }

    public int getColumnType(int n) {
        return this.columns.get(n).getDataType();
    }

    public void setColumnClassName(int n, String string) {
        this.columns.get(n).setColumnClassName(string);
    }

    public String getColumnClassName(int n) {
        String string = this.columns.get(n).getColumnClassName();
        if (string != null) {
            return string;
        }
        return this.getColumnClass(n).getName();
    }

    public String getColumnDisplayName(int n) {
        return this.columns.get(n).getDisplayName();
    }

    public String getColumnName(int n) {
        return this.columns.get(n).getColumnName();
    }

    public String getDbmsTypeName(int n) {
        return this.columns.get(n).getDbmsType();
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public Class getColumnClass(int n) {
        if (n > this.getColumnCount()) {
            return null;
        }
        return this.columns.get(n).getColumnClass();
    }

    public void readPkDefinition(WbConnection wbConnection) throws SQLException {
        if (wbConnection == null) {
            return;
        }
        if (this.updateTable == null) {
            return;
        }
        this.resetPkColumns();
        PkDefinition pkDefinition = this.updateTable.getPrimaryKey();
        if (pkDefinition == null) {
            IndexReader indexReader = ReaderFactory.getIndexReader(wbConnection.getMetadata());
            pkDefinition = indexReader.getPrimaryKey(this.updateTable);
        }
        if (pkDefinition != null) {
            for (String string : pkDefinition.getColumns()) {
                int n = this.findColumn(string);
                if (n <= -1) continue;
                this.columns.get(n).setIsPkColumn(true);
            }
        } else {
            this.readPkColumnsFromMapping();
        }
    }

    public int findColumn(String string) {
        return this.findColumn(string, QuoteHandler.STANDARD_HANDLER);
    }

    public int findColumn(String string, QuoteHandler quoteHandler) {
        if (string == null) {
            return -1;
        }
        String string2 = quoteHandler.removeQuotes(string);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            String string3 = quoteHandler.removeQuotes(this.getColumnName(i));
            if (!string2.equalsIgnoreCase(string3)) continue;
            return i;
        }
        return -1;
    }

    public boolean isUserDefinedPK() {
        return this.isUserDefinedPK;
    }

    public boolean readPkColumnsFromMapping() {
        if (this.updateTable == null) {
            return false;
        }
        List<String> list = PkMapping.getInstance().getPKColumns(this.updateTable.createCopy());
        if (list == null) {
            return false;
        }
        this.isUserDefinedPK = false;
        for (String string : list) {
            int n = this.findColumn(string);
            if (n <= -1) continue;
            this.setIsPkColumn(n, true);
            this.isUserDefinedPK = true;
        }
        if (this.isUserDefinedPK) {
            LogMgr.logInfo(new CallerInfo(){}, "Using pk definition for " + this.updateTable.getTableName() + " from mapping file: " + StringUtil.listToString(list, ',', false));
        }
        return this.isUserDefinedPK;
    }

    public ResultInfo createCopy() {
        ResultInfo resultInfo = new ResultInfo(this.columns);
        resultInfo.realColumns = this.realColumns;
        if (this.updateTable != null) {
            resultInfo.updateTable = this.updateTable.createCopy();
        }
        resultInfo.isUserDefinedPK = this.isUserDefinedPK;
        return resultInfo;
    }

    public void addColumn(ColumnIdentifier columnIdentifier) {
        this.addColumnAt(columnIdentifier, this.columns.size());
    }

    public void addColumnAt(ColumnIdentifier columnIdentifier, int n) {
        this.columns.add(n, columnIdentifier);
    }
}

