/*
 * Decompiled with CFR 0.152.
 */
package workbench.storage.reader;

import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import workbench.db.DBID;
import workbench.db.DbMetadata;
import workbench.db.JdbcUtils;
import workbench.db.WbConnection;
import workbench.storage.reader.OracleTZHandler;
import workbench.storage.reader.SqlServerTZHandler;
import workbench.util.WbDateFormatter;

public interface TimestampTZHandler {
    public static final TimestampTZHandler DUMMY_HANDLER = object -> object;
    public static final TimestampTZHandler OFFSET_HANDLER = object -> {
        if (object == null) {
            return object;
        }
        if (object instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)object;
            return zonedDateTime.toOffsetDateTime();
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return OffsetDateTime.of(timestamp.toLocalDateTime(), WbDateFormatter.getSystemDefaultOffset());
        }
        return object;
    };
    public static final TimestampTZHandler ZONE_HANDLER = object -> {
        if (object instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)object;
            return offsetDateTime.toZonedDateTime();
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return ZonedDateTime.of(timestamp.toLocalDateTime(), ZoneId.systemDefault());
        }
        return object;
    };

    public Object convertTimestampTZ(Object var1);

    public static class Factory {
        private static final Map<DBID, String> DRIVER_VERSIONS = new HashMap<DBID, String>();

        public static boolean supportsJava8Time(WbConnection wbConnection) {
            if (wbConnection == null) {
                return false;
            }
            String string = DRIVER_VERSIONS.get((Object)DBID.fromConnection(wbConnection));
            return JdbcUtils.hasMiniumDriverVersion(wbConnection, string);
        }

        public static TimestampTZHandler getHandler(WbConnection wbConnection) {
            if (wbConnection == null) {
                return DUMMY_HANDLER;
            }
            if (!Factory.supportsJava8Time(wbConnection)) {
                return DUMMY_HANDLER;
            }
            DbMetadata dbMetadata = wbConnection.getMetadata();
            if (dbMetadata == null) {
                return DUMMY_HANDLER;
            }
            if (dbMetadata.isPostgres()) {
                return OFFSET_HANDLER;
            }
            if (dbMetadata.isOracle()) {
                return new OracleTZHandler(wbConnection, false);
            }
            if (dbMetadata.isSqlServer()) {
                return new SqlServerTZHandler(wbConnection);
            }
            return DUMMY_HANDLER;
        }

        static {
            DRIVER_VERSIONS.put(DBID.Postgres, "42.0");
            DRIVER_VERSIONS.put(DBID.Oracle, "12.2");
            DRIVER_VERSIONS.put(DBID.SQL_Server, "4.0");
        }
    }
}

