/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.util.Locale;
import workbench.resource.ResourceMgr;
import workbench.util.StringUtil;
import workbench.util.WbLocale;

public class DisplayLocale
implements Comparable<DisplayLocale> {
    private final WbLocale locale;
    private String display;
    private Locale displayLocale;

    public DisplayLocale() {
        this.locale = null;
    }

    public DisplayLocale(WbLocale wbLocale) {
        this.locale = wbLocale;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return null;
        }
        return this.locale.getLocale();
    }

    public void setDisplayLocale(Locale locale) {
        this.displayLocale = locale;
    }

    public boolean isEmpty() {
        return this.locale == null;
    }

    public String toString() {
        if (this.display != null) {
            return this.display;
        }
        if (this.locale == null) {
            this.display = ResourceMgr.getString("LblDefaultIndicator");
        } else {
            StringBuilder stringBuilder = new StringBuilder(20);
            String string = null;
            if (this.displayLocale == null) {
                stringBuilder.append(this.locale.getLocale().getDisplayLanguage());
                string = this.locale.getLocale().getDisplayCountry();
            } else {
                stringBuilder.append(this.locale.getLocale().getDisplayLanguage(this.displayLocale));
                string = this.locale.getLocale().getDisplayCountry(this.displayLocale);
            }
            if (!StringUtil.isEmptyString(string)) {
                stringBuilder.append(" (");
                stringBuilder.append(string);
                stringBuilder.append(')');
            }
            this.display = stringBuilder.toString();
        }
        return this.display;
    }

    @Override
    public int compareTo(DisplayLocale displayLocale) {
        if (this.locale == null) {
            return -1;
        }
        if (displayLocale.locale == null) {
            return 1;
        }
        return this.locale.compareTo(displayLocale.locale);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof DisplayLocale) {
            DisplayLocale displayLocale = (DisplayLocale)object;
            if (this.locale == null && displayLocale.locale == null) {
                return true;
            }
            if (this.locale != null && displayLocale.locale == null) {
                return false;
            }
            if (this.locale == null && displayLocale.locale != null) {
                return false;
            }
            return this.locale.equals(displayLocale.locale);
        }
        return false;
    }

    public int hashCode() {
        return this.locale.hashCode();
    }
}

