/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.awt.Component;
import java.awt.Window;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.EncodingDropDown;
import workbench.gui.components.ExtensionFileFilter;
import workbench.gui.components.WbFileChooser;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.ClasspathUtil;
import workbench.util.CollectionUtil;
import workbench.util.ExceptionUtil;
import workbench.util.FileUtil;
import workbench.util.ImageUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;

public class FileDialogUtil {
    private static final int FILE_TYPE_UNKNOWN = -1;
    private static final int FILE_TYPE_TXT = 0;
    private static final int FILE_TYPE_SQL = 1;
    private static final int FILE_TYPE_XML = 2;
    private static final int FILE_TYPE_HTML = 3;
    private static final int FILE_TYPE_SQL_UPDATE = 4;
    private int lastFileType = -1;
    public static final String CONFIG_DIR_KEY = "%ConfigDir%";
    public static final String WKSP_DIR_KEY = "%WorkspaceDir%";
    public static final String PROGRAM_DIR_KEY = "%ProgramDir%";
    private String encoding = null;

    public int getLastSelectedFileType() {
        return this.lastFileType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getXmlReportFilename(Component component) {
        String string = Settings.getInstance().getProperty("workbench.xmlreport.lastdir", null);
        WbFileChooser wbFileChooser = new WbFileChooser(string);
        wbFileChooser.addChoosableFileFilter(ExtensionFileFilter.getXmlFileFilter());
        wbFileChooser.setFileFilter(ExtensionFileFilter.getXmlFileFilter());
        if (this.encoding == null) {
            this.encoding = Settings.getInstance().getDefaultDataEncoding();
        }
        EncodingDropDown encodingDropDown = new EncodingDropDown(this.encoding);
        encodingDropDown.setBorder(new EmptyBorder(0, 5, 0, 0));
        wbFileChooser.setAccessory(encodingDropDown);
        String string2 = null;
        Window window = SwingUtilities.getWindowAncestor(component);
        int n = wbFileChooser.showSaveDialog(window);
        if (n == 0) {
            FileFilter fileFilter;
            this.encoding = encodingDropDown.getEncoding();
            File file = wbFileChooser.getSelectedFile();
            if (StringUtil.isEmptyString(this.encoding)) {
                this.encoding = FileUtil.detectFileEncoding(file);
            }
            if ((fileFilter = wbFileChooser.getFileFilter()) instanceof ExtensionFileFilter) {
                ExtensionFileFilter extensionFileFilter = (ExtensionFileFilter)fileFilter;
                string2 = file.getAbsolutePath();
                String string3 = ExtensionFileFilter.getExtension(file);
                if (StringUtil.isEmptyString(string3)) {
                    if (!string2.endsWith(".")) {
                        string2 = string2 + ".";
                    }
                    string2 = string2 + extensionFileFilter.getDefaultExtension();
                }
                this.lastFileType = this.getFileFilterType(fileFilter);
            } else {
                string2 = file.getAbsolutePath();
            }
            string = wbFileChooser.getCurrentDirectory().getAbsolutePath();
            Settings.getInstance().setProperty("workbench.xmlreport.lastdir", string);
        }
        return string2;
    }

    private int getFileFilterType(FileFilter fileFilter) {
        if (fileFilter == ExtensionFileFilter.getSqlFileFilter()) {
            return 1;
        }
        if (fileFilter == ExtensionFileFilter.getSqlUpdateFileFilter()) {
            return 4;
        }
        if (fileFilter == ExtensionFileFilter.getXmlFileFilter()) {
            return 2;
        }
        if (fileFilter == ExtensionFileFilter.getTextFileFilter()) {
            return 0;
        }
        if (fileFilter == ExtensionFileFilter.getHtmlFileFilter()) {
            return 3;
        }
        return -1;
    }

    public static String getBlobFile(Component component) {
        return FileDialogUtil.getBlobFile(component, true);
    }

    public static String getBlobFile(Component component, boolean bl) {
        try {
            Window window = SwingUtilities.getWindowAncestor(component);
            String string = Settings.getInstance().getLastBlobDir();
            WbFileChooser wbFileChooser = new WbFileChooser(string);
            int n = 1;
            n = bl ? wbFileChooser.showSaveDialog(window) : wbFileChooser.showOpenDialog(window);
            String string2 = null;
            if (n == 0) {
                File file = wbFileChooser.getSelectedFile();
                string2 = file.getAbsolutePath();
                Settings.getInstance().setLastBlobDir(file.getParentFile().getAbsolutePath());
            }
            return string2;
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error selecting file", throwable);
            WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(throwable));
            return null;
        }
    }

    public String getWorkspaceFilename(Window window, boolean bl, boolean bl2) {
        try {
            String string = Settings.getInstance().getLastWorkspaceDir();
            WbFileChooser wbFileChooser = new WbFileChooser(string);
            FileFilter fileFilter = ExtensionFileFilter.getWorkspaceFileFilter();
            wbFileChooser.removeChoosableFileFilter(wbFileChooser.getFileFilter());
            wbFileChooser.addChoosableFileFilter(fileFilter);
            String string2 = null;
            int n = 1;
            if (bl) {
                wbFileChooser.setDialogTitle(ResourceMgr.getString("TxtSaveWksp"));
                n = wbFileChooser.showSaveDialog(window);
            } else {
                wbFileChooser.setDialogTitle(ResourceMgr.getString("TxtLoadWksp"));
                n = wbFileChooser.showOpenDialog(window);
            }
            if (n == 0) {
                File file = wbFileChooser.getSelectedFile();
                FileFilter fileFilter2 = wbFileChooser.getFileFilter();
                if (fileFilter2 == fileFilter) {
                    string2 = file.getAbsolutePath();
                    String string3 = ExtensionFileFilter.getExtension(file);
                    if (StringUtil.isEmptyString(string3)) {
                        if (!string2.endsWith(".")) {
                            string2 = string2 + ".";
                        }
                        string2 = string2 + "wksp";
                    }
                } else {
                    string2 = file.getAbsolutePath();
                }
                string = wbFileChooser.getCurrentDirectory().getAbsolutePath();
                Settings.getInstance().setLastWorkspaceDir(string);
            }
            if (bl2 && string2 != null) {
                string2 = FileDialogUtil.removeConfigDir(string2);
            }
            return string2;
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error selecting file", throwable);
            WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(throwable));
            return null;
        }
    }

    public static String removeConfigDir(String string) {
        WbFile wbFile = new WbFile(string);
        return FileDialogUtil.removeConfigDir(wbFile);
    }

    public static String removeConfigDir(WbFile wbFile) {
        String string = wbFile.getName();
        File file = wbFile.getParentFile();
        File file2 = Settings.getInstance().getConfigDir();
        if (file != null && file.equals(file2)) {
            return string;
        }
        return wbFile.getFullPath();
    }

    public static String getPathWithPlaceholder(WbFile wbFile) {
        File file = Settings.getInstance().getConfigDir();
        File file2 = wbFile.getParentFile();
        while (!file2.equals(file) && (file2 = file2.getParentFile()) != null) {
        }
        if (file2 == null) {
            return wbFile.getFullPath();
        }
        String string = wbFile.getAbsolutePath().replace(file2.getAbsolutePath(), CONFIG_DIR_KEY);
        return string;
    }

    public static String replaceConfigDir(String string) {
        if (string == null) {
            return null;
        }
        WbFile wbFile = new WbFile(Settings.getInstance().getConfigDir());
        return StringUtil.replace(string, CONFIG_DIR_KEY, wbFile.getFullPath());
    }

    public static String makeWorkspacePath(String string) {
        if (string == null) {
            return null;
        }
        WbFile wbFile = new WbFile(Settings.getInstance().getWorkspaceDir());
        String string2 = FileDialogUtil.replaceConfigDir(string);
        string2 = StringUtil.replace(string2, WKSP_DIR_KEY, wbFile.getFullPath());
        string2 = FileDialogUtil.replaceProgramDir(string2);
        return string2;
    }

    public static String replaceProgramDir(String string) {
        if (string == null) {
            return null;
        }
        if (!string.contains(PROGRAM_DIR_KEY)) {
            return string;
        }
        ClasspathUtil classpathUtil = new ClasspathUtil();
        WbFile wbFile = new WbFile(classpathUtil.getJarPath());
        return StringUtil.replace(string, PROGRAM_DIR_KEY, wbFile.getFullPath());
    }

    public static void selectPkMapFileIfNecessary(Component component) {
        File file;
        String string = Settings.getInstance().getPKMappingFilename();
        if (string != null && (file = new File(string)).exists()) {
            return;
        }
        boolean bl = WbSwingUtilities.getYesNo(component, ResourceMgr.getString("MsgSelectPkMapFile"));
        if (!bl) {
            return;
        }
        string = FileDialogUtil.selectPkMapFile(component);
        if (string != null) {
            Settings.getInstance().setPKMappingFilename(string);
        }
    }

    public static String selectPkMapFile(Component component) {
        String string = Settings.getInstance().getPKMappingFilename();
        File file = null;
        file = string == null ? Settings.getInstance().getConfigDir() : new File(string).getParentFile();
        try {
            WbFileChooser wbFileChooser = new WbFileChooser(file);
            wbFileChooser.setApproveButtonText(ResourceMgr.getString("LblOK"));
            if (string != null) {
                wbFileChooser.setSelectedFile(new File(string));
            }
            String string2 = null;
            int n = wbFileChooser.showSaveDialog(component);
            if (n == 0) {
                File file2 = wbFileChooser.getSelectedFile();
                string2 = file2.getAbsolutePath();
            }
            return string2;
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error selecting file", throwable);
            WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(throwable));
            return null;
        }
    }

    public static WbFile selectPngFile(JComponent jComponent, String string) {
        String string2 = Settings.getInstance().getProperty(string, null);
        File file = null;
        file = StringUtil.isNonBlank(string2) ? new File(string2) : Settings.getInstance().getConfigDir();
        WbFileChooser wbFileChooser = new WbFileChooser(file);
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter(ResourceMgr.getString("TxtFileFilterIcons"), CollectionUtil.arrayList("png"), true);
        wbFileChooser.setMultiSelectionEnabled(false);
        wbFileChooser.setFileSelectionMode(0);
        wbFileChooser.removeChoosableFileFilter(wbFileChooser.getAcceptAllFileFilter());
        wbFileChooser.addChoosableFileFilter(extensionFileFilter);
        wbFileChooser.setFileFilter(extensionFileFilter);
        int n = wbFileChooser.showOpenDialog(SwingUtilities.getWindowAncestor(jComponent));
        if (n == 0) {
            Object object;
            WbFile wbFile = new WbFile(wbFileChooser.getSelectedFile());
            if (!ImageUtil.isPng(wbFile)) {
                object = ResourceMgr.getFormattedString("ErrInvalidIcon", wbFile.getName());
                WbSwingUtilities.showErrorMessage(jComponent, (String)object);
            }
            object = new WbFile(wbFileChooser.getCurrentDirectory());
            Settings.getInstance().setProperty(string, ((WbFile)object).getFullPath());
            return wbFile;
        }
        return null;
    }
}

