/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import workbench.gui.WbSwingUtilities;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.BrowserLauncher;
import workbench.util.EventNotifier;
import workbench.util.ExceptionUtil;
import workbench.util.NotifierEvent;
import workbench.util.UpdateVersion;
import workbench.util.VersionNumber;
import workbench.util.WbVersionReader;

public class UpdateCheck
implements ActionListener {
    private static final String TYPE_WB_VERSION = "version_check";
    private static final String TYPE_JAVA_VERSION = "java_check";
    public static final boolean DEBUG = Boolean.getBoolean("workbench.debug.versioncheck");
    private WbVersionReader versionReader;

    public void startUpdateCheck() {
        Date date;
        if (DEBUG) {
            this.startRead();
            return;
        }
        int n = Settings.getInstance().getUpdateCheckInterval();
        if (this.needCheck(n, new Date(), date = Settings.getInstance().getLastUpdateCheck())) {
            this.startRead();
        } else {
            this.checkJavaVersion();
        }
    }

    private void checkJavaVersion() {
        if (!Settings.getInstance().checkJavaVersion()) {
            return;
        }
        if (ResourceMgr.getBuildNumber().getMajorVersion() == 999) {
            return;
        }
        VersionNumber versionNumber = new VersionNumber(11, 0);
        VersionNumber versionNumber2 = VersionNumber.getJavaVersion();
        if (!versionNumber2.isNewerOrEqual(versionNumber)) {
            NotifierEvent notifierEvent = new NotifierEvent("alert", ResourceMgr.getString("MsgOldJava"), this);
            notifierEvent.setTooltip(ResourceMgr.getString("MsgOldJavaDetail"));
            notifierEvent.setType(TYPE_JAVA_VERSION);
            EventNotifier.getInstance().displayNotification(notifierEvent);
        }
    }

    boolean needCheck(int n, Date date, Date date2) {
        if (n < 1) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        long l = Long.MIN_VALUE;
        if (date2 != null) {
            calendar.setLenient(true);
            calendar.setTime(date2);
            calendar.set(11, 0);
            calendar.clear(12);
            calendar.clear(13);
            calendar.clear(14);
            calendar.add(5, n);
            l = calendar.getTimeInMillis();
        }
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeInMillis(date.getTime());
        calendar2.set(11, 0);
        calendar2.clear(12);
        calendar2.clear(13);
        calendar2.clear(14);
        long l2 = calendar2.getTimeInMillis();
        return l <= l2;
    }

    public void startRead() {
        LogMgr.logDebug(new CallerInfo(){}, "Checking versions...");
        this.versionReader = new WbVersionReader("automatic", this);
        this.versionReader.startCheckThread();
    }

    private void showNotification() {
        CallerInfo callerInfo = new CallerInfo(){};
        try {
            LogMgr.logDebug(callerInfo, "Current stable version: " + this.versionReader.getStableBuildNumber());
            LogMgr.logDebug(callerInfo, "Current development version: " + this.versionReader.getDevBuildNumber());
            UpdateVersion updateVersion = this.versionReader.getAvailableUpdate();
            NotifierEvent notifierEvent = null;
            if (DEBUG || updateVersion == UpdateVersion.stable) {
                LogMgr.logInfo(callerInfo, "New stable version available");
                notifierEvent = new NotifierEvent("updates", ResourceMgr.getString("LblVersionNewStableAvailable"), this);
            } else if (updateVersion == UpdateVersion.devBuild) {
                LogMgr.logInfo(callerInfo, "New dev build available");
                notifierEvent = new NotifierEvent("updates", ResourceMgr.getString("LblVersionNewDevAvailable"), this);
            } else {
                LogMgr.logInfo(callerInfo, "No updates found");
            }
            if (this.versionReader.success()) {
                try {
                    Settings.getInstance().setLastUpdateCheck();
                }
                catch (Exception exception) {
                    LogMgr.logError(callerInfo, "Error when updating last update date", exception);
                }
            }
            if (notifierEvent != null) {
                notifierEvent.setType(TYPE_WB_VERSION);
                EventNotifier.getInstance().displayNotification(notifierEvent);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(callerInfo, "Could not check for updates", exception);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.versionReader) {
            this.showNotification();
            return;
        }
        String string = actionEvent.getActionCommand();
        try {
            if (TYPE_WB_VERSION.equals(string)) {
                BrowserLauncher.openURL("https://www.sql-workbench.eu");
            } else if (TYPE_JAVA_VERSION.equals(string)) {
                BrowserLauncher.openURL("https://adoptopenjdk.net");
            }
            EventNotifier.getInstance().removeNotification();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not open browser", exception);
            WbSwingUtilities.showMessage(null, "Could not open browser (" + ExceptionUtil.getDisplay(exception) + ")");
        }
    }
}

