/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import workbench.db.DBID;
import workbench.interfaces.WbPluginProcedureActionProvider;
import workbench.interfaces.WbPluginProvider;
import workbench.interfaces.WbProcedurePanelAction;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class WbPluginUtil {
    private static List<WbPluginProvider> PLUGIN_PROVIDERS;

    private WbPluginUtil() {
    }

    private static <T> Stream<T> filterByProviderInterface(Class<T> clazz) {
        return PLUGIN_PROVIDERS.stream().filter(clazz::isInstance).map(clazz::cast);
    }

    public static List<WbProcedurePanelAction> getPluginProcedurePanelActions(DBID dBID) {
        Locale locale = Settings.getInstance().getLanguage();
        return WbPluginUtil.filterByProviderInterface(WbPluginProcedureActionProvider.class).map(wbPluginProcedureActionProvider -> wbPluginProcedureActionProvider.getProcedurePanelActions(dBID)).filter(Objects::nonNull).flatMap(Collection::stream).filter(wbProcedurePanelAction -> {
            boolean bl = true;
            String string = null;
            if (wbProcedurePanelAction == null) {
                LogMgr.logWarning(new CallerInfo(){}, "Null is not a valid action");
                bl = false;
            } else {
                string = wbProcedurePanelAction.getLabel(locale);
            }
            if (StringUtil.isBlank(string)) {
                LogMgr.logWarning(new CallerInfo(){}, "No Label for action " + wbProcedurePanelAction + " defined");
                bl = false;
            }
            return bl;
        }).collect(Collectors.toList());
    }

    static {
        ServiceLoader<WbPluginProvider> serviceLoader = ServiceLoader.load(WbPluginProvider.class);
        PLUGIN_PROVIDERS = StreamSupport.stream(serviceLoader.spliterator(), false).collect(Collectors.toList());
    }
}

