/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.swing.Timer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.FileUtil;
import workbench.util.StringUtil;
import workbench.util.UpdateCheck;
import workbench.util.UpdateVersion;
import workbench.util.VersionNumber;
import workbench.util.WbThread;

public class WbVersionReader
implements ActionListener {
    private VersionNumber currentDevBuildNumber;
    private String currentDevBuildDate;
    private VersionNumber currentStableBuildNumber;
    private String currentStableBuildDate;
    private final String userAgent;
    private boolean success = false;
    private Timer timeout;
    private ActionListener client;
    private WbThread readThread;

    WbVersionReader(VersionNumber versionNumber, VersionNumber versionNumber2) {
        this.currentDevBuildNumber = versionNumber;
        this.currentStableBuildNumber = versionNumber2;
        this.userAgent = "VersionTest";
    }

    public WbVersionReader(ActionListener actionListener) {
        this("manual", actionListener);
    }

    public WbVersionReader(String string, ActionListener actionListener) {
        this.userAgent = "WbUpdateCheck, " + ResourceMgr.getBuildNumber().toString() + ", " + string + ", " + Settings.getInstance().getLanguage().getLanguage() + ", " + System.getProperty("os.name");
        this.client = actionListener;
    }

    public void startCheckThread() {
        this.timeout = new Timer(60000, this);
        this.timeout.start();
        this.readThread = new WbThread("VersionReaderThread"){

            @Override
            public void run() {
                WbVersionReader.this.readBuildInfo();
            }
        };
        this.readThread.start();
    }

    public boolean success() {
        return this.success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBuildInfo() {
        Serializable serializable;
        long l = System.currentTimeMillis();
        InputStream inputStream = null;
        try {
            serializable = new URL("https://www.sql-workbench.eu/release.property");
            URLConnection uRLConnection = serializable.openConnection();
            uRLConnection.setRequestProperty("User-Agent", this.userAgent);
            String string = System.getProperty("java.version");
            String string2 = System.getProperty("sun.arch.data.model");
            if (StringUtil.isNonBlank(string2)) {
                string = string + " (" + string2 + "bit)";
            }
            LogMgr.logDebug(new CallerInfo(){}, "Using referer: " + string);
            uRLConnection.setRequestProperty("Referer", string);
            inputStream = uRLConnection.getInputStream();
            Properties properties = new Properties();
            properties.load(inputStream);
            this.currentDevBuildNumber = new VersionNumber(properties.getProperty("dev.build.number", null));
            this.currentDevBuildDate = properties.getProperty("dev.build.date", null);
            this.currentStableBuildNumber = new VersionNumber(properties.getProperty("release.build.number", null));
            this.currentStableBuildDate = properties.getProperty("release.build.date", null);
            this.success = true;
            long l2 = System.currentTimeMillis();
            LogMgr.logDebug(new CallerInfo(){}, "Retrieving version information took " + (l2 - l) + "ms");
        }
        catch (Exception exception) {
            try {
                LogMgr.logWarning(new CallerInfo(){}, "Could not read version information", exception);
                this.success = false;
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietely(inputStream);
                if (this.timeout != null) {
                    this.timeout.stop();
                    this.timeout = null;
                }
                if (this.client != null) {
                    ActionEvent actionEvent = new ActionEvent(this, 1, this.success ? "versionChecked" : "error");
                    this.client.actionPerformed(actionEvent);
                }
                throw throwable;
            }
            FileUtil.closeQuietely(inputStream);
            if (this.timeout != null) {
                this.timeout.stop();
                this.timeout = null;
            }
            if (this.client != null) {
                ActionEvent actionEvent = new ActionEvent(this, 1, this.success ? "versionChecked" : "error");
                this.client.actionPerformed(actionEvent);
            }
        }
        FileUtil.closeQuietely(inputStream);
        if (this.timeout != null) {
            this.timeout.stop();
            this.timeout = null;
        }
        if (this.client != null) {
            serializable = new ActionEvent(this, 1, this.success ? "versionChecked" : "error");
            this.client.actionPerformed((ActionEvent)serializable);
        }
    }

    public UpdateVersion getAvailableUpdate() {
        return this.getAvailableUpdate(ResourceMgr.getBuildNumber());
    }

    public UpdateVersion getAvailableUpdate(VersionNumber versionNumber) {
        if (UpdateCheck.DEBUG) {
            return UpdateVersion.stable;
        }
        if (this.currentDevBuildNumber != null && this.currentDevBuildNumber.isNewerThan(versionNumber)) {
            return UpdateVersion.devBuild;
        }
        if (this.currentStableBuildNumber != null && this.currentStableBuildNumber.isNewerThan(versionNumber)) {
            return UpdateVersion.stable;
        }
        return UpdateVersion.none;
    }

    public VersionNumber getDevBuildNumber() {
        return this.currentDevBuildNumber;
    }

    public String getDevBuildDate() {
        return this.currentDevBuildDate;
    }

    public VersionNumber getStableBuildNumber() {
        return this.currentStableBuildNumber;
    }

    public String getStableBuildDate() {
        return this.currentStableBuildDate;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.timeout) {
            if (this.readThread != null) {
                this.readThread.interrupt();
            }
            this.success = false;
        }
    }
}

