/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.multifile.app.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.exception.InvalidSourceException;
import org.gvsig.fmap.dal.coverage.exception.RmfSerializerException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.coverage.store.props.Transparency;
import org.gvsig.fmap.dal.coverage.util.ProviderServices;
import org.gvsig.fmap.dal.raster.spi.CoverageStoreProvider;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.spi.DataStoreProvider;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.gui.beans.swing.JFileChooser;
import org.gvsig.gui.beans.table.exceptions.NotInitializeException;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.fmap.layers.DefaultFLyrRaster;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.mainplugin.RasterMainPluginUtils;
import org.gvsig.raster.mainplugin.config.Configuration;
import org.gvsig.raster.multifile.app.panel.AbstractBandSelectorListener;
import org.gvsig.raster.multifile.app.panel.BandSelectorPanel;
import org.gvsig.raster.multifile.app.panel.LayerNameDialog;
import org.gvsig.raster.multifile.io.MultiFileDataParameters;
import org.gvsig.raster.multifile.io.MultiFileProvider;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.swing.basepanel.ButtonsPanelEvent;

public class BandSelectorPropertiesListener
extends AbstractBandSelectorListener {
    private JFileChooser fileChooser = null;
    private FLyrRaster fLayer = null;
    private List<File> fileList = null;

    public BandSelectorPropertiesListener(BandSelectorPanel bs) {
        super(bs);
    }

    public void init(FLyrRaster lyr) {
        this.fLayer = lyr;
    }

    @Override
    public RasterDataStore getResult() {
        return this.fLayer.getDataStore();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean autoRefreshView;
        String vBands;
        super.actionPerformed(e);
        if (e.getSource().equals(this.bandSetupPanel.getNumBandSelectorCombo()) && (vBands = (String)this.bandSetupPanel.getNumBandSelectorCombo().getSelectedItem()) != null) {
            if (vBands.compareTo("3") == 0) {
                this.bandSetupPanel.resetMode(3);
            }
            if (vBands.compareTo("2") == 0) {
                this.bandSetupPanel.resetMode(2);
            }
            if (vBands.compareTo("1") == 0) {
                this.bandSetupPanel.resetMode(1);
            }
        }
        if (e.getSource().equals(this.bandSetupPanel.getSaveButton())) {
            int numBandToAlpha;
            int numBandToBlue;
            int numBandToGreen;
            int numBandToRed = this.bandSetupPanel.getColorInterpretationByColorBandBand(1);
            if (!this.isCorrectAssignedBand(numBandToRed, numBandToGreen = this.bandSetupPanel.getColorInterpretationByColorBandBand(2), numBandToBlue = this.bandSetupPanel.getColorInterpretationByColorBandBand(4), numBandToAlpha = this.bandSetupPanel.getColorInterpretationByColorBandBand(8))) {
                RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"combinacion_no_asignable"), (Object)this.bandSetupPanel);
                return;
            }
            RasterSwingLibrary.messageBoxYesOrNot((String)Messages.getText((String)"color_interpretation_continue"), (Object)this);
            RasterDataStore dataSource = this.fLayer.getDataStore();
            if (dataSource == null) {
                RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"error_carga_capa"), (Object)this.bandSetupPanel);
                return;
            }
            try {
                int iBand;
                String[] bands = new String[this.bandSetupPanel.getARGBTable().getRowCount()];
                ColorInterpretation ci = RasterLocator.getManager().getDataStructFactory().createColorInterpretation(bands);
                if (numBandToRed == numBandToGreen && numBandToRed == numBandToBlue && numBandToRed >= 0) {
                    for (iBand = 0; iBand < this.bandSetupPanel.getARGBTable().getRowCount(); ++iBand) {
                        ci.setColorInterpValue(iBand, "Undefined");
                    }
                    ci.setColorInterpValue(0, "Gray");
                    ci.setColorInterpValue(numBandToAlpha, "Alpha");
                } else {
                    for (iBand = 0; iBand < this.bandSetupPanel.getARGBTable().getRowCount(); ++iBand) {
                        ci.setColorInterpValue(iBand, this.bandSetupPanel.getColorInterpretationByBand(iBand));
                    }
                }
                String fileName = this.fLayer.getDataStore().getName();
                dataSource.setColorInterpretation(ci);
                RasterLocator.getManager().getProviderServices().saveObjectToRmfFile(fileName, (Object)ci);
            }
            catch (RmfSerializerException exc) {
                RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"error_salvando_rmf"), (Object)this.bandSetupPanel, (Exception)((Object)exc));
            }
            catch (NotInitializeException exc) {
                RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"table_not_initialize"), (Object)this.bandSetupPanel, (Exception)((Object)exc));
            }
        }
        if (!(autoRefreshView = Configuration.getValue((String)"general_auto_preview", (Boolean)Boolean.TRUE).booleanValue())) {
            return;
        }
        this.bandSetupPanel.onlyApply();
    }

    @Override
    public void addFileBand() {
        this.fileChooser = this.createJFileChooser();
        int result = this.fileChooser.showOpenDialog((Component)((Object)this.bandSetupPanel));
        if (result == 0) {
            int i;
            RasterDataStore dataStore = this.fLayer.getDataStore();
            File[] files = this.fileChooser.getSelectedFiles();
            JFileChooser.setLastPath((String)"OPEN_LAYER_FILE_CHOOSER_ID", (File)files[0]);
            this.fileList = new ArrayList<File>();
            for (i = 0; i < files.length; ++i) {
                URI[] uris = dataStore.getURIByProvider();
                boolean exists = false;
                for (int j = 0; j < uris.length; ++j) {
                    if (!new File(uris[j]).getAbsolutePath().endsWith(files[i].getName())) continue;
                    RasterSwingLibrary.messageBoxError((String)(Messages.getText((String)"fichero_existe") + ": " + files[i].getAbsolutePath()), (Object)this.bandSetupPanel);
                    exists = true;
                    break;
                }
                if (exists) continue;
                this.fileList.add(files[i]);
            }
            if (!this.checkStoresCompatibility(this.fLayer.getDataStore(), this.fileList)) {
                return;
            }
            if (dataStore.isMultiFile()) {
                for (i = 0; i < this.fileList.size(); ++i) {
                    try {
                        dataStore.addFile(this.fileList.get(i));
                        continue;
                    }
                    catch (InvalidSourceException e) {
                        RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"addband_error"), (Object)this.bandSetupPanel, (Exception)((Object)e));
                    }
                }
                dataStore.setProvider(dataStore.getProvider());
                try {
                    this.bandSetupPanel.addFiles(dataStore);
                }
                catch (NotInitializeException e) {
                    RasterSwingLibrary.messageBoxError((String)"table_not_initialize", (Object)this, (Exception)((Object)e));
                }
            } else {
                WindowInfo wi = PluginServices.getMDIManager().getActiveWindow().getWindowInfo();
                LayerNameDialog dialog = new LayerNameDialog(new Point2D.Double(wi.getX(), wi.getY()), 300, 80, this);
                RasterMainPluginUtils.addWindow((IWindow)dialog);
            }
        }
    }

    @Override
    public void delFileBand() {
        Object[] objects = this.bandSetupPanel.getFileList().getJList().getSelectedValues();
        RasterDataStore dataStore = this.fLayer.getDataStore();
        for (int i = objects.length - 1; i >= 0; --i) {
            if (this.bandSetupPanel.getFileList().getNFiles() <= 1) continue;
            String pathName = objects[i].toString();
            dataStore.removeFile(new File(pathName));
            String file = pathName.substring(pathName.lastIndexOf(File.separator) + 1);
            file = file.substring(file.lastIndexOf("\\") + 1);
            this.bandSetupPanel.removeFile(file);
        }
        this.setNewBandsPositionInRendering();
    }

    public void actionButtonPressed(ButtonsPanelEvent e) {
        String layerName = (String)e.getSource();
        RasterDataStore dataStore = this.fLayer.getDataStore();
        RasterDataParameters paramFirstFile = (RasterDataParameters)dataStore.getParameters();
        File firstFile = new File(paramFirstFile.getURI());
        String path = FilenameUtils.getFullPath((String)firstFile.getAbsolutePath());
        ProviderServices provServ = RasterLocator.getManager().getProviderServices();
        DataManagerProviderServices dataManager = (DataManagerProviderServices)DALLocator.getDataManager();
        try {
            MultiFileProvider provMultifile = this.createMultiFileProvider(layerName, path);
            MultiFileDataParameters newParamsMultifile = (MultiFileDataParameters)provMultifile.getDataParameters();
            newParamsMultifile.addProvider(dataStore);
            for (int i = 0; i < this.fileList.size(); ++i) {
                ArrayList storeParametersList = provServ.createParametersList(this.fileList.get(i));
                for (int j = 0; j < storeParametersList.size(); ++j) {
                    DataStoreProvider newFileProv = dataManager.createProvider((DataStoreProviderServices)dataStore, (DataStoreParameters)storeParametersList.get(j));
                    newParamsMultifile.addProviderNotTiled(newFileProv);
                }
            }
            ((DefaultFLyrRaster)this.fLayer).setName(layerName);
            dataStore.setProvider((CoverageStoreProvider)provMultifile);
            try {
                this.bandSetupPanel.addFiles(dataStore);
            }
            catch (NotInitializeException ex) {
                RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"table_not_initialize"), (Object)this, (Exception)((Object)ex));
            }
            ArrayList<File> uriList = new ArrayList<File>();
            uriList.add(firstFile);
            for (int i = 0; i < this.fileList.size(); ++i) {
                uriList.add(this.fileList.get(i));
            }
            this.saveMultiFileLayer(layerName, path, uriList);
        }
        catch (Exception exc) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"addband_error"), (Object)this.bandSetupPanel, (Exception)exc);
        }
    }

    @Override
    public void apply() {
        if (this.enabled) {
            this.setNewBandsPositionInRendering();
        }
    }

    @Override
    public void setNewBandsPositionInRendering() {
        if (this.fLayer != null && this.fLayer.getRender() != null) {
            this.fLayer.getRender().setRenderColorInterpretation(this.bandSetupPanel.getSelectedColorInterpretation());
            int alphaBand = this.bandSetupPanel.getColorInterpretationByColorBandBand(8);
            Transparency gt = this.fLayer.getRender().getRenderingTransparency();
            if (gt != null) {
                gt.setTransparencyBand(alphaBand);
            }
            this.fLayer.getMapContext().invalidate();
        }
    }
}

