/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dxf.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gvsig.dxf.io.DataSource;
import org.gvsig.dxf.io.FileFolder;

public class ZipFileFolder
extends FileFolder {
    String zName = null;
    public ZipFile file = null;

    public ZipFileFolder() {
    }

    public ZipFileFolder(String fName) throws IOException {
        fName = DataSource.normalize(fName);
        this.zName = ZipFileFolder.isUrl(fName) ? this.getZName(fName) : fName;
        this.file = new ZipFile(this.zName);
    }

    public static boolean isUrl(String name) {
        String str = name.substring(0, 3);
        str.toLowerCase();
        return str.compareTo("zip") == 0;
    }

    private String getZName(String urlName) {
        return urlName.substring(6, urlName.indexOf("?"));
    }

    private String getFName(String urlName) {
        return urlName.substring(urlName.indexOf("?") + 1);
    }

    public ZipEntry getZipEntry(String fName) throws IOException {
        Object is = null;
        if (ZipFileFolder.isUrl(fName)) {
            fName = this.getFName(fName);
        }
        return this.file.getEntry(fName);
    }

    public InputStream getInputStream(String fName) throws IOException {
        return this.file.getInputStream(this.getZipEntry(fName));
    }

    public InputStream getInputStream(ZipEntry ze) throws IOException {
        return this.file.getInputStream(ze);
    }

    @Override
    public int count() {
        return this.file.size();
    }

    public Enumeration entries() {
        return this.file.entries();
    }
}

