/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.app.extension;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.export.ExportLocator;
import org.gvsig.export.app.extension.ExportPreferencesExtension;
import org.gvsig.export.spi.ExportServiceFactory;
import org.gvsig.export.spi.ExportServiceManager;
import org.gvsig.tools.dynobject.DynObject;

public class ExportPreferences {
    private DynObject preferences;
    public static final String PREFERENCE_ENABLED_SERVICES = "enabledProviders";
    public static final String PREFERENCE_DISABLED_SERVICES = "disabledProviders";

    public ExportPreferences() {
        this.getPreferences();
    }

    public boolean exits(String factoryName) {
        Map<String, Boolean> enabledsState = this.getEnabledState();
        return enabledsState.containsKey(factoryName);
    }

    public boolean isEnabled(String factoryName) {
        Map<String, Boolean> enabledsState = this.getEnabledState();
        return enabledsState.get(factoryName);
    }

    public void setEnabled(String factoryName, boolean enabled) {
        Map<String, Boolean> enabledsState = this.getEnabledState();
        enabledsState.put(factoryName, enabled);
        this.putEnabledState(enabledsState);
    }

    private DynObject getPreferences() {
        if (this.preferences == null) {
            PluginsManager pluginManager = PluginsLocator.getManager();
            this.preferences = pluginManager.getPlugin(ExportPreferencesExtension.class).getPluginProperties();
        }
        return this.preferences;
    }

    private Map<String, Boolean> getEnabledState() {
        Set disableds;
        HashMap<String, Boolean> enabledsState = new HashMap<String, Boolean>();
        Set enableds = (Set)this.getPreferences().getDynValue(PREFERENCE_ENABLED_SERVICES);
        if (enableds == null) {
            ExportServiceManager manager = ExportLocator.getServiceManager();
            for (ExportServiceFactory factory : manager.getAllServiceFactories()) {
                enabledsState.put(factory.getName(), true);
            }
        } else {
            for (String enabled : enableds) {
                enabledsState.put(enabled, true);
            }
        }
        if ((disableds = (Set)this.getPreferences().getDynValue(PREFERENCE_DISABLED_SERVICES)) != null) {
            for (String disabled : disableds) {
                enabledsState.put(disabled, false);
            }
        }
        return enabledsState;
    }

    private void putEnabledState(Map<String, Boolean> enabledsState) {
        HashSet<String> disableds;
        HashSet<String> enableds = (HashSet<String>)this.getPreferences().getDynValue(PREFERENCE_ENABLED_SERVICES);
        if (enableds == null) {
            enableds = new HashSet<String>();
            this.getPreferences().setDynValue(PREFERENCE_ENABLED_SERVICES, enableds);
        }
        if ((disableds = (HashSet<String>)this.getPreferences().getDynValue(PREFERENCE_DISABLED_SERVICES)) == null) {
            disableds = new HashSet<String>();
            this.getPreferences().setDynValue(PREFERENCE_DISABLED_SERVICES, disableds);
        }
        for (Map.Entry<String, Boolean> entry : enabledsState.entrySet()) {
            if (entry.getValue().booleanValue()) {
                enableds.add(entry.getKey());
                disableds.remove(entry.getKey());
                continue;
            }
            enableds.remove(entry.getKey());
            disableds.add(entry.getKey());
        }
        this.getPreferences().setDynValue(PREFERENCE_ENABLED_SERVICES, enableds);
        this.getPreferences().setDynValue(PREFERENCE_DISABLED_SERVICES, disableds);
    }
}

