/*
 * Decompiled with CFR 0.152.
 */
package org.amic.sql.parser;

import java.util.Vector;
import org.amic.sql.parser.SqlParserListener;
import org.amic.util.parser.ExpressionParser;
import org.amic.util.parser.ParserException;
import org.amic.util.parser.QuotedParser;
import org.amic.util.string.StringEx;

public class SqlParser {
    public final int SQL_UNKNOW = 0;
    public final int SQL_SELECT = 1;
    public final int SQL_INSERT = 2;
    public final int SQL_UPDATE = 3;
    public final int SQL_DELETE = 4;
    private String sql;
    private String tab;
    private StringEx strParser;
    private int startPos = 0;
    private int type = 0;
    private int level;
    private Vector fields;
    private Vector tables;
    private Vector conditions;
    private Vector orders;
    private Vector groups;
    private SqlParserListener listener;

    public SqlParser(String sql) {
        this(sql, 0, null);
    }

    public SqlParser(String sql, int level) {
        this(sql, level, null);
    }

    public SqlParser(String sql, SqlParserListener listener) {
        this(sql, 0, listener);
    }

    public SqlParser(String sql, int level, SqlParserListener listener) {
        this.sql = sql.trim();
        this.level = level;
        this.listener = listener;
        this.tab = "";
        int i = 0;
        while (i < level) {
            this.tab = this.tab + "\t";
            ++i;
        }
    }

    public void parse() throws ParserException {
        this.doParse();
    }

    public Vector getFields() {
        return this.fields;
    }

    public Vector getTables() {
        return this.tables;
    }

    public String getTableAlias(String table) {
        int pos = table.lastIndexOf(32);
        if (pos == -1) {
            return table;
        }
        return table.substring(pos).trim();
    }

    public String getTableName(String table) {
        int pos = table.indexOf(32);
        if (pos == -1) {
            return table;
        }
        return table.substring(0, pos).trim();
    }

    public Vector getConditions() {
        return this.conditions;
    }

    public Vector getGroupBy() {
        return this.groups;
    }

    public Vector getOrderBy() {
        return this.orders;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.tab + "SELECT ");
        int i = 0;
        while (i < this.getFields().size()) {
            buff.append(this.getFields().elementAt(i));
            if (i != this.getFields().size() - 1) {
                buff.append(", ");
            }
            ++i;
        }
        if (this.getTables().size() > 0) {
            buff.append("\n" + this.tab + "FROM ");
            int i2 = 0;
            while (i2 < this.getTables().size()) {
                buff.append(this.getTables().elementAt(i2));
                if (i2 != this.getTables().size() - 1) {
                    buff.append(", ");
                }
                ++i2;
            }
        }
        int cond = this.getConditions().size();
        String sep = "\n" + this.tab + "WHERE ";
        if (cond > 0) {
            int i3 = 0;
            while (i3 < this.getConditions().size()) {
                String temp = ((String)this.getConditions().elementAt(i3)).trim();
                if (temp.length() > 0) {
                    buff.append(sep);
                    buff.append(temp);
                    sep = "\n" + this.tab;
                }
                ++i3;
            }
        }
        if (this.getGroupBy().size() > 0) {
            buff.append("\n" + this.tab + "GROUP BY ");
            int i4 = 0;
            while (i4 < this.getGroupBy().size()) {
                buff.append(this.getGroupBy().elementAt(i4));
                if (i4 != this.getGroupBy().size() - 1) {
                    buff.append(", ");
                }
                ++i4;
            }
        }
        if (this.getOrderBy().size() > 0) {
            buff.append("\n" + this.tab + "ORDER BY ");
            int i5 = 0;
            while (i5 < this.getOrderBy().size()) {
                buff.append(this.getOrderBy().elementAt(i5));
                if (i5 != this.getOrderBy().size() - 1) {
                    buff.append(", ");
                }
                ++i5;
            }
        }
        return buff.toString();
    }

    public String getTab() {
        return this.tab;
    }

    private void doParse() throws ParserException {
        this.sql.replace('\n', ' ');
        this.sql.replace('\t', ' ');
        this.sql.replace('\r', ' ');
        this.typeToken();
        if (this.type == 1) {
            this.strParser = new StringEx(this.sql);
            this.fieldsToken();
            this.tablesToken();
            this.conditionsToken();
            this.groupByToken();
            this.orderByToken();
            this.processNested();
            if (this.listener != null) {
                this.listener.sqlParsed(this);
            }
        } else {
            throw new ParserException("Statement parser not available.");
        }
    }

    private void processNested() throws ParserException {
        int i = 0;
        while (i < this.fields.size()) {
            this.fields.setElementAt(this.checkSelect((String)this.fields.elementAt(i)), i);
            ++i;
        }
        i = 0;
        while (i < this.tables.size()) {
            this.tables.setElementAt(this.checkSelect((String)this.tables.elementAt(i)), i);
            ++i;
        }
        i = 0;
        while (i < this.conditions.size()) {
            this.conditions.setElementAt(this.checkSelect((String)this.conditions.elementAt(i)), i);
            ++i;
        }
        i = 0;
        while (i < this.groups.size()) {
            this.groups.setElementAt(this.checkSelect((String)this.groups.elementAt(i)), i);
            ++i;
        }
        i = 0;
        while (i < this.orders.size()) {
            this.orders.setElementAt(this.checkSelect((String)this.orders.elementAt(i)), i);
            ++i;
        }
    }

    private String checkSelect(String value) throws ParserException {
        int start = value.toLowerCase().indexOf("select ");
        if (start == -1) {
            return value;
        }
        StringEx se = new StringEx(value);
        start = se.getInitialLimit('(', ')', start);
        int end = se.getFinalLimit('(', ')', start + 1);
        if (start < 0 || end < 0) {
            throw new ParserException("Nested SELECT not correctly enclosed.\n" + value);
        }
        if (start < end) {
            String temp = value.substring(start + 1, end - 1).trim();
            SqlParser p = new SqlParser(temp, this.level + 1, this.listener);
            p.parse();
            return value.substring(0, start + 1) + "\n" + p.toString() + "\n" + this.tab + value.substring(end - 1);
        }
        throw new ParserException("Nested SELECT not correctly enclosed.\n" + value);
    }

    private void typeToken() {
        String temp = this.sql.toLowerCase().substring(0, this.sql.indexOf(" ")).trim();
        this.startPos = 6;
        this.type = temp.startsWith("select") ? 1 : (temp.startsWith("insert") ? 2 : (temp.startsWith("update") ? 3 : (temp.startsWith("delete") ? 4 : 0)));
    }

    private void fieldsToken() throws ParserException {
        this.fields = new Vector();
        String temp = "";
        int endPos = this.strParser.indexOfSQ(new String[]{" from ", " where ", "group by", "order by"}, this.startPos);
        temp = endPos >= this.startPos ? this.sql.substring(this.startPos, endPos) : this.sql.substring(this.startPos);
        this.startPos += temp.length() + this.strParser.getOccurrence().length();
        QuotedParser parser = new QuotedParser(temp, ',');
        while (parser.hasMoreElements()) {
            this.fields.add(parser.nextToken().trim());
        }
    }

    private void tablesToken() throws ParserException {
        this.tables = new Vector();
        if (!this.strParser.getOccurrence().equalsIgnoreCase(" from ")) {
            return;
        }
        String temp = "";
        int endPos = this.strParser.indexOfSQ(new String[]{" where ", "group by", "order by"}, this.startPos);
        temp = endPos >= this.startPos ? this.sql.substring(this.startPos, endPos) : this.sql.substring(this.startPos);
        this.startPos += temp.length() + this.strParser.getOccurrence().length();
        QuotedParser parser = new QuotedParser(temp, ',');
        while (parser.hasMoreElements()) {
            this.tables.add(parser.nextToken().trim());
        }
    }

    private void conditionsToken() throws ParserException {
        this.conditions = new Vector();
        if (!this.strParser.getOccurrence().equalsIgnoreCase(" where ")) {
            return;
        }
        String temp = "";
        int end = this.strParser.indexOfSQ(new String[]{"group by", "order by"}, this.startPos);
        temp = end >= this.startPos ? this.sql.substring(this.startPos, end) : this.sql.substring(this.startPos);
        this.startPos += temp.length() + this.strParser.getOccurrence().length();
        ExpressionParser parser = new ExpressionParser(temp);
        while (parser.hasMoreElements()) {
            this.conditions.add(parser.nextToken());
        }
    }

    private void groupByToken() throws ParserException {
        this.groups = new Vector();
        if (!this.strParser.getOccurrence().equalsIgnoreCase("group by")) {
            return;
        }
        String temp = "";
        int end = this.strParser.indexOfSQ(new String[]{"order by"}, this.startPos);
        temp = end >= this.startPos ? this.sql.substring(this.startPos, end) : this.sql.substring(this.startPos);
        this.startPos += temp.length() + this.strParser.getOccurrence().length();
        QuotedParser parser = new QuotedParser(temp, ',');
        while (parser.hasMoreElements()) {
            this.groups.add(parser.nextToken());
        }
    }

    private void orderByToken() throws ParserException {
        this.orders = new Vector();
        if (!this.strParser.getOccurrence().equalsIgnoreCase("order by")) {
            return;
        }
        if (this.startPos < this.sql.length()) {
            String temp = this.sql.substring(this.startPos);
            this.startPos = temp.length() + 1;
            QuotedParser parser = new QuotedParser(temp, ',');
            while (parser.hasMoreElements()) {
                this.orders.add(parser.nextToken());
            }
        }
    }
}

